<?php
/*
 * $Id: class.htmlTickets.inc.php,v 1.3.2.2.2.1 2002/12/03 01:48:28 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('tck');

class htmlTickets
{
	function GetActionCombo($include, $jcn, $seq)
	{
		global $dcl_info;

		$cmbText = '<select name="menuAction">';
		$options = array();
		if (ereg('d', $include))
			$options['boTickets.view'] = STR_CMMN_VIEW;
		if ($GLOBALS['SEC'] >= $dcl_info['DCL_HAVE_WO'] && ereg('t', $include))
			$options['boTicketresolutions.add'] = STR_TCK_OPTADDRESOLUTION;
		if ($GLOBALS['SEC'] >= $dcl_info['DCL_ASSIGN_WO'] && ereg('a', $include))
			$options['boTickets.reassign'] = STR_TCK_OPTREASSIGN;
		if ($GLOBALS['SEC'] >= $dcl_info['DCL_MOD_WO'] && ereg('e', $include))
			$options['boTickets.modify'] = STR_TCK_OPTMODIFY;
		if ($GLOBALS['SEC'] >= $dcl_info['DCL_DEL_WO'] && ereg('x', $include))
			$options['boTickets.delete'] = STR_TCK_OPTDELETE;
		if ($GLOBALS['SEC'] >= $dcl_info['DCL_MOD_WO'] && ereg('c', $include))
			$options['boTickets.copyToWO'] = STR_TCK_OPTCOPYTOWO;
		if ($dcl_info['DCL_MAX_UPLOAD_FILE_SIZE'] > 0 && ereg('f', $include))
			$options['boTickets.upload'] = STR_TCK_OPTUPLOADFILE;
		if (ereg('w', $include))
			$options['boWatches.add'] = STR_TCK_OPTWATCH;

		asort($options);
		reset($options);
		while (list($value, $text) = each($options))
			$cmbText .= sprintf('<option value="%s">%s</option>', $value, $text);

		$cmbText .= '</select>';
		return $cmbText;
	}

	function PrintReassignForm($obj)
	{
		global $dcl_info;

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ASSIGN_WO']))
			return PrintPermissionDenied();

		$objProduct = CreateObject('dcl.dbProducts');
		$objHTMLPersonnel = CreateObject('dcl.htmlPersonnel');
		$objHTMLPriorities = CreateObject('dcl.htmlPriorities');
		$objHTMLSeverities = CreateObject('dcl.htmlSeverities');

		$objProduct->Connect();
		$objProduct->Query('SELECT tcksetid FROM products WHERE id=' . $obj->product);
		$objProduct->next_record();
		$setid = $objProduct->f(0);

		$Template = CreateTemplate(array('hForm' => 'htmlTicketReassignForm.tpl'));

		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('TXT_TITLE', sprintf(STR_TCK_REASSIGNTICKET, $obj->ticketid));
		$Template->set_var('TXT_RESPONSIBLE', STR_TCK_RESPONSIBLE);
		$Template->set_var('TXT_PRIORITY', STR_TCK_PRIORITY);
		$Template->set_var('TXT_TYPE', STR_TCK_TYPE);
		$Template->set_var('BTN_SAVE', STR_CMMN_SAVE);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);
		$Template->set_var('VAL_FORMACTION', menuLink());

		$Template->set_var('VAL_TICKETID', $obj->ticketid);
		$Template->set_var('CMB_RESPONSIBLE', $objHTMLPersonnel->GetCombo($obj->responsible, 'responsible', 'lastfirst', 0, true, $dcl_info['DCL_HAVE_WO']));
		$Template->set_var('CMB_PRIORITY', $objHTMLPriorities->GetCombo($obj->priority, 'priority', 'name', 0, false, $setid));
		$Template->set_var('CMB_TYPE', $objHTMLSeverities->GetCombo($obj->type, 'type', 'name', 0, false, $setid));

		$Template->pparse('out', 'hForm');
	}

	function ShowUploadFileForm($obj)
	{
		global $dcl_info;

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_WO']))
			return PrintPermissionDenied();

		$Template = CreateTemplate(array('hForm' => 'htmlTicketAddAttachment.tpl'));

		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_FORMACTION', menuLink());
		$Template->set_var('TXT_TITLE', STR_TCK_UPLOADATTACHMENT);
		$Template->set_var('VAL_MAXUPLOADFILESIZE', $dcl_info['DCL_MAX_UPLOAD_FILE_SIZE']);
		$Template->set_var('VAL_TICKETID', $obj->ticketid);
		$Template->set_var('TXT_ATTACHFILE', STR_TCK_ATTACHFILE);
		$Template->set_var('BTN_SAVE', STR_CMMN_SAVE);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);

		$Template->pparse('out', 'hForm');
	}

	function ShowDeleteAttachmentYesNo($ticketid, $filename)
	{
		global $dcl_info;

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_HAVE_WO']))
			return PrintPermissionDenied();

		$Template = CreateTemplate(array('hForm' => 'htmlTicketDelAttachment.tpl'));

		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_FORMACTION', menuLink());
		$Template->set_var('TXT_TITLE', STR_TCK_DELETEATTACHMENT);
		$Template->set_var('VAL_TICKETID', $ticketid);
		$Template->set_var('VAL_FILENAME', htmlspecialchars($filename));
		$Template->set_var('TXT_CONFIRMDELETE', sprintf(STR_TCK_CONFIRMDELATT, htmlspecialchars($filename)));
		$Template->set_var('BTN_YES', STR_CMMN_YES);
		$Template->set_var('BTN_NO', STR_CMMN_NO);

		$Template->pparse('out', 'hForm');
	}

	function DisplayGraphForm()
	{
		global $dcl_info;

		$Template = CreateTemplate(array('hForm' => 'htmlTicketGraph.tpl'));

		$Template->set_var('VAL_JSDATEFORMAT', GetJSDateFormat());
		$Template->set_var('VAL_FORMACTION', menuLink());
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('TXT_TITLE', STR_TCK_ACTIVITYGRAPH);
		$Template->set_var('TXT_SHOWGRAPHFOR', STR_TCK_SHOWGRAPHFOR);

		$Template->set_var('CMB_DAYS', '<select name="days"><option value="7">7 ' . STR_TCK_DAYS . '</option><option value="14">14 ' . STR_TCK_DAYS . '</option></select>');
		$Template->set_var('TXT_ENDINGON', STR_TCK_ENDINGON);
		$Template->set_var('VAL_TODAY', date($dcl_info['DCL_DATE_FORMAT']));
		$Template->set_var('VAL_MENUACTION', 'boTickets.showgraph');
		$Template->set_var('BTN_OK', STR_CMMN_GO);

		$Template->pparse('out', 'hForm');
	}

	function my($rowlimit = 5)
	{
		global $dcl_info;

		$obj = CreateObject('dcl.dbTickets');
		$obj->Connect();

		$objP = CreateObject('dcl.dbProducts');
		$objP->Connect($obj->conn);

		$objA = CreateObject('dcl.dbAccounts');
		$objA->Connect($obj->conn);

		$query = sprintf('SELECT a.ticketid,a.summary FROM tickets a, priorities b, severities c, statuses d WHERE a.responsible=%d',
				$GLOBALS['DCLID']);

		$query .= ' AND a.priority=b.id AND a.type=c.id AND a.status=d.id AND d.dcl_status_type != 2';
		$query .= ' ORDER BY b.weight,c.weight,a.ticketid ';

		if ($rowlimit > 0)
			$obj->LimitQuery($query, 0, $rowlimit);
		else
			$obj->Query($query);

		if ($rowlimit == 0)
		{
			print('<center>');
			BeginChocoTable(false, '50%');
		}
		else
			BeginChocoTable(false);

		print('<tr><th><a class="alightu" href="' . menuLink('', 'menuAction=htmlTickets.show&filterReportto=' . $GLOBALS['DCLID']) . '">');
		print(STR_TCK_MYTICKETS);
		print('</a>');

		if ($rowlimit > 0)
			PrintWithChocoFont('&nbsp;&nbsp;(' . sprintf(STR_CMMN_TOPNUM, $rowlimit) . ')');

		print('</th></tr>');

		if ($obj->next_record())
		{
			$i = 0;
			do
			{
				if ($i++ % 2 == 0)
					print('<TR><TD BGCOLOR="#FFFFFF">');
				else
					print('<TR><TD BGCOLOR="' . $dcl_info['DCL_COLOR_LIGHT'] . '">');

				printf('<A CLASS="adark" HREF="%s">(%d) %s</A>',
					menuLink('', 'menuAction=boTickets.view&ticketid=' . $obj->f('ticketid')),
					$obj->f('ticketid'),
					htmlspecialchars($obj->f('summary')));
				print('</TD></TR>');
			}
			while ($obj->next_record());
		}
		else
		{
			print('<TR><TD BGCOLOR="#FFFFFF">');
			print(STR_TCK_NOOPENTICKETS);
			print('</TD></TR>');
		}

		print('</TD></TR></TABLE>');
	}

	function RenderOptions(&$aRecord)
	{
		$str = '<td>';
		$str .= '<a class="adark" href="' . menuLink('', 'menuAction=boTickets.view&ticketid=' . $aRecord['ticketid']) . '">' . STR_CMMN_VIEW . '</a>';
		//$str .= '&nbsp;|&nbsp;';
		$str .= '</td>';
		echo $str;
	}

	function RenderFilter(&$sPagerFormElements)
	{
		$filterStatus = IsSet($GLOBALS['filterStatus']) ? $GLOBALS['filterStatus'] : -1;
		$filterReportto = IsSet($GLOBALS['filterReportto']) ? $GLOBALS['filterReportto'] : 0;
		$filterProduct = IsSet($GLOBALS['filterProduct']) ? $GLOBALS['filterProduct'] : 0;

		echo '<form method="post" action="' . menuLink('') . '">';
		echo $sPagerFormElements;
		echo '<br><b>', STR_TCK_STATUS, ':</b>';

		$o = CreateObject('dcl.htmlSelect');
		$o->vDefault = $filterStatus;
		$o->sName = 'filterStatus';
		$o->iSize = 0;
		$o->sZeroOption = STR_CMMN_SELECTONE;

		$oStatus = CreateObject('dcl.dbStatuses');
		$oStatus->Connect();
		$oStatus->Query('SELECT id, name FROM statuses ORDER BY name');
		$o->aOptions = $oStatus->FetchAllRows();
		$i = count($o->aOptions);
		$o->aOptions[$i++] = array('-1', STR_CMMN_HIDECLOSEDTYPES);
		$o->aOptions[$i++] = array('-2', STR_CMMN_ONLYCLOSEDTYPES);
		echo $o->GetHTML();

		echo '&nbsp;<b>', STR_TCK_RESPONSIBLE, ':</b>';
		$oReport = CreateObject('dcl.htmlPersonnel');
		$oReport->createCombo($filterReportto, 'filterReportto', 'short', 0, false);

		echo '&nbsp;<b>', STR_TCK_PRODUCT, ':</b>';
		$oProduct = CreateObject('dcl.htmlProducts');
		$oProduct->createCombo($filterProduct, 'filterProduct', 'name', 0, false);

		echo '&nbsp;<input type="submit" value="Filter">';
		echo '</form>';
	}

	function show()
	{
		global $dcl_info;

		commonHeader();

		$oView = CreateObject('dcl.boView');
		if (IsSet($GLOBALS['btnNav']) && IsSet($GLOBALS['startrow']) && IsSet($GLOBALS['numrows']))
		{
			if ($GLOBALS['btnNav'] == '<<')
			{
				$oView->startrow = $GLOBALS['startrow'] - $GLOBALS['numrows'];
				if ($oView->startrow < 0)
					$objView->startrow = 0;
				$oView->numrows = $GLOBALS['numrows'];
			}
			else
			{
				$oView->startrow = $GLOBALS['startrow'] + $GLOBALS['numrows'];
				$oView->numrows = $GLOBALS['numrows'];
			}
		}
		else
		{
			$oView->numrows = 15;
			$oView->startrow = 0;
		}

		$oView->table = 'tickets';
		$oView->style = 'report';
		$oView->title = STR_TCK_BROWSETCK;
		$oView->AddDef('columns', '', array('ticketid', 'products.name', 'statuses.name', 'priorities.name', 'severities.name', 'responsible.short', 'summary'));
		$oView->AddDef('order', '', array('priorities.weight', 'severities.weight', 'ticketid'));

		$oView->AddDef('columnhdrs', '', array(
				STR_TCK_TICKET,
				STR_TCK_PRODUCT,
				STR_TCK_STATUS,
				STR_TCK_PRIORITY,
				STR_TCK_TYPE,
				STR_TCK_RESPONSIBLE,
				STR_TCK_SUMMARY));

		$filterStatus = '-1';
		$filterReportto = '0';
		$filterProduct = '0';
		if (IsSet($GLOBALS['filterStatus']))
			$filterStatus = $GLOBALS['filterStatus'];
		if (IsSet($GLOBALS['filterReportto']))
			$filterReportto = $GLOBALS['filterReportto'];
		if (IsSet($GLOBALS['filterProduct']))
			$filterProduct = $GLOBALS['filterProduct'];

		if ($filterStatus != '0')
		{
			if ($filterStatus == '-1')
				$oView->AddDef('filternot', 'statuses.dcl_status_type', '2');
			else if ($filterStatus == '-2')
				$oView->AddDef('filter', 'statuses.dcl_status_type', '2');
			else
				$oView->AddDef('filter', 'status', $filterStatus);
		}

		if ($filterReportto != '0')
			$oView->AddDef('filter', 'responsible', $filterReportto);

		if ($filterProduct != '0')
			$oView->AddDef('filter', 'product', $filterProduct);

		$oHtml = CreateObject('dcl.htmlView');
		$oHtml->oCallback = $this;
		$oHtml->sCallback = 'RenderOptions';
		$oHtml->sFilterCallback = 'RenderFilter';
		$oHtml->sColumnTitle = STR_CMMN_OPTIONS;
		$oHtml->sPagingMenuAction = 'htmlTickets.show';
		$oHtml->bColumnSort = false;
		$oHtml->bShowPager = false;
		$oHtml->Render($oView);
	}
}
?>
