<?php
/*
 * $Id: class.htmlWorkorders.inc.php,v 1.4.2.2.2.3 2002/12/03 01:48:28 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('wo');

class htmlWorkorders
{
	function PopulateActionLinks($include, $enclose, $jcn, $seq, $dark, &$linkArray, &$rolloverArray)
	{
		global $dcl_info;

		if (ereg('d', $include))
		{
			$linkName = 'D';

			$linkArray[$linkName] = menuLink('', "menuAction=boWorkorders.viewjcn&jcn=$jcn&seq=$seq");
			$rolloverArray[$linkName] = STR_WO_VIEWWO;
		}
		if ($GLOBALS['SEC'] >= $dcl_info['DCL_HAVE_WO'] && ereg('t', $include))
		{
			$linkName = 'T';

			$linkArray[$linkName] = menuLink('', "menuAction=boTimecards.add&jcn=$jcn&seq=$seq");
			$rolloverArray[$linkName] = STR_WO_ADDTC;
		}
		if ($GLOBALS['SEC'] >= $dcl_info['DCL_ASSIGN_WO'] && ereg('a', $include))
		{
			$linkName = 'A';

			$linkArray[$linkName] = menuLink('', "menuAction=boWorkorders.reassign&jcn=$jcn&seq=$seq");
			$rolloverArray[$linkName] = STR_WO_REASSIGN;
		}
		if ($GLOBALS['SEC'] >= $dcl_info['DCL_MOD_WO'] && ereg('e', $include))
		{
			$linkName = 'M';

			$linkArray[$linkName] = menuLink('', "menuAction=boWorkorders.modifyjcn&jcn=$jcn&seq=$seq");
			$rolloverArray[$linkName] = STR_WO_MODIFY;
		}
		if ($GLOBALS['SEC'] >= $dcl_info['DCL_ADD_WO'] && ereg('s', $include))
		{
			$linkName = 'S';

			$linkArray[$linkName] = menuLink('', "menuAction=boWorkorders.newseq&jcn=$jcn&seq=$seq");
			$rolloverArray[$linkName] = STR_WO_NEWSEQ;
		}
		if ($GLOBALS['SEC'] >= $dcl_info['DCL_ASSIGN_WO'] && ereg('p', $include))
		{
			$linkName = 'P';

			$linkArray[$linkName] = menuLink('', "menuAction=boProjects.addtoproject&jcn=$jcn&seq=$seq");
			$rolloverArray[$linkName] = STR_WO_ADDPRJ;
		}
		if ($GLOBALS['SEC'] >= $dcl_info['DCL_DEL_WO'] && ereg('x', $include))
		{
			$linkName = 'X';

			$linkArray[$linkName] = menuLink('', "menuAction=boWorkorders.delete&jcn=$jcn&seq=$seq");

			$rolloverArray[$linkName] = STR_WO_DELETE; 
		}
		if ($GLOBALS['SEC'] >= $dcl_info['DCL_ASSIGN_WO'] && ereg('u', $include))
		{
			$linkName = 'U';

			$linkArray[$linkName] = menuLink('', "menuAction=boProjects.unmap&jcn=$jcn&seq=$seq");
			$rolloverArray[$linkName] = STR_WO_UNMAP;
		}
		if ($dcl_info['DCL_MAX_UPLOAD_FILE_SIZE'] > 0 && ereg('f', $include))
		{
			$linkName = 'F';

			$linkArray[$linkName] = menuLink('', "menuAction=boWorkorders.upload&jcn=$jcn&seq=$seq");
			$rolloverArray[$linkName] = STR_WO_UPLOAD;
		}
		if (ereg('w', $include))
		{
			$linkName = 'W';

			$linkArray[$linkName] = menuLink('', "menuAction=boWatches.add&typeid=3&whatid1=$jcn&whatid2=$seq");
			$rolloverArray[$linkName] = STR_WO_WATCHES;
		}
	}

	function GetActionLinks($include, $enclose, $jcn, $seq, $dark)
	{
		$linkArray = array();
		$rolloverArray = array();
		$this->PopulateActionLinks($include, $enclose, $jcn, $seq, $dark, $linkArray, $rolloverArray);

		return GetLinkSet($linkArray, $rolloverArray, $enclose, $dark);
	}

	function PrintActionLinks($include, $enclose, $jcn, $seq, $dark)
	{
		$linkArray = array();
		$rolloverArray = array();
		$this->PopulateActionLinks($include, $enclose, $jcn, $seq, $dark, $linkArray, $rolloverArray);

		PrintLinkSet($linkArray, $rolloverArray, $enclose, $dark);
	}

	function GetActionCombo($include, $jcn, $seq)
	{
		global $dcl_info;

		$cmbText = '<select name="menuAction">';
		$options = array();
		if (ereg('d', $include))
			$options['boWorkorders.viewjcn'] = STR_WO_VIEWWO;

		if ($GLOBALS['SEC'] >= $dcl_info['DCL_HAVE_WO'] && ereg('t', $include))
			$options['boTimecards.add'] = STR_WO_ADDTC;

		if ($GLOBALS['SEC'] >= $dcl_info['DCL_ASSIGN_WO'] && ereg('a', $include))
			$options['boWorkorders.reassign'] = STR_WO_REASSIGN;

		if ($GLOBALS['SEC'] >= $dcl_info['DCL_MOD_WO'] && ereg('e', $include))
			$options['boWorkorders.modifyjcn'] = STR_WO_MODIFY;

		if ($GLOBALS['SEC'] >= $dcl_info['DCL_ADD_WO'] && ereg('s', $include))
			$options['boWorkorders.newseq'] = STR_WO_NEWSEQ;

		if ($GLOBALS['SEC'] >= $dcl_info['DCL_ASSIGN_WO'] && ereg('p', $include))
			$options['boProjects.addtoproject'] = STR_WO_ADDPRJ;

		if ($GLOBALS['SEC'] >= $dcl_info['DCL_DEL_WO'] && ereg('x', $include))
			$options['boWorkorders.delete'] = STR_WO_DELETE;

		if ($GLOBALS['SEC'] >= $dcl_info['DCL_ASSIGN_WO'] && ereg('u', $include))
			$options['boProjects.unmap'] = STR_WO_UNMAP;

		if ($dcl_info['DCL_MAX_UPLOAD_FILE_SIZE'] > 0 && ereg('f', $include))
			$options['boWorkorders.upload'] = STR_WO_UPLOAD;

		if (ereg('w', $include))
			$options['boWatches.add'] = STR_WO_WATCHES;

		asort($options);
		reset($options);
		while (list($value, $text) = each($options))
			$cmbText .= sprintf('<option value="%s">%s</option>', $value, $text);

		$cmbText .= '</select>';
		return $cmbText;
	}

	function PrintReassignForm()
	{
		global $dcl_info;

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ASSIGN_WO']))
			return PrintPermissionDenied();

		$bIsBatch = is_array($GLOBALS['selected']) && count($GLOBALS['selected']) > 1;

		$objWO = CreateObject('dcl.dbWorkorders');
		$objProduct = CreateObject('dcl.dbProducts');
		$objHTMLPersonnel = CreateObject('dcl.htmlPersonnel');
		$objHTMLPriorities = CreateObject('dcl.htmlPriorities');
		$objHTMLSeverities = CreateObject('dcl.htmlSeverities');

		$objWO->Connect();
		$objProduct->Connect();
		if ($bIsBatch)
		{
			$Template = CreateTemplate(array('hForm' => 'htmlWorkOrderBatchAssign.tpl'));
		}
		else
		{
			$Template = CreateTemplate(array('hForm' => 'htmlWorkOrderReassign.tpl'));

			if ($objWO->Load($GLOBALS['jcn'], $GLOBALS['seq']) == -1)
			{
				printf(STR_WO_NOTFOUNDERR, $jcn, $seq);
				return;
			}

			$objProduct->Query('SELECT wosetid FROM products WHERE id=' . $objWO->product);
			$objProduct->next_record();
			$setid = $objProduct->f(0);
		}

		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_JSDATEFORMAT', GetJSDateFormat());
		$Template->set_var('BTN_SAVE', STR_CMMN_SAVE);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);

		$Template->set_var('TXT_RESPONSIBLE', STR_WO_RESPONSIBLE);
		$Template->set_var('TXT_DEADLINE', STR_WO_DEADLINE);
		$Template->set_var('TXT_ESTSTART', STR_WO_ESTSTART);
		$Template->set_var('TXT_ESTEND', STR_WO_ESTEND);
		$Template->set_var('TXT_ESTHOURS', STR_WO_ESTHOURS);
		$Template->set_var('TXT_ETCHOURS', STR_WO_ETCHOURS);
		$Template->set_var('TXT_PRIORITY', STR_WO_PRIORITY);
		$Template->set_var('TXT_SEVERITY', STR_WO_SEVERITY);

		$hiddenvars = '';
		if ($bIsBatch)
		{
			reset($GLOBALS['selected']);
			while (list($key, $val) = each($GLOBALS['selected']))
				$hiddenvars .= GetHiddenVar('selected[]', $val);
				
			$hiddenvars .= GetHiddenVar('menuAction', 'boWorkorders.dbbatchassign');

			$Template->set_var('TXT_TITLE', 'Batch Assign*');
			$Template->set_var('VAL_FORMACTION', menuLink());

			$Template->set_var('CMB_RESPONSIBLE', $objHTMLPersonnel->GetCombo($GLOBALS['DCLID'], 'responsible', 'lastfirst', 0, true, $dcl_info['DCL_HAVE_WO']));
			$Template->set_var('CMB_PRIORITY', $objHTMLPriorities->GetCombo(0, 'priority', 'name', 0, false));
			$Template->set_var('CMB_SEVERITY', $objHTMLSeverities->GetCombo(0, 'severity', 'name', 0, false));
		}
		else
		{
			$Template->set_var('TXT_TITLE', STR_WO_REASSIGNTITLE . ' ' . $objWO->jcn . '-' . $objWO->seq);
			$Template->set_var('VAL_FORMACTION', menuLink());

			$hiddenvars .= GetHiddenVar('menuAction', 'boWorkorders.dbreassign');
			$hiddenvars .= GetHiddenVar('jcn', $objWO->jcn);
			$hiddenvars .= GetHiddenVar('seq', $objWO->seq);

			$Template->set_var('VAL_DEADLINEON', $objWO->deadlineon);
			$Template->set_var('VAL_ESTSTARTON', $objWO->eststarton);
			$Template->set_var('VAL_ESTENDON', $objWO->estendon);
			$Template->set_var('VAL_ESTHOURS', $objWO->esthours);
			$Template->set_var('VAL_ETCHOURS', $objWO->etchours);

			$Template->set_var('CMB_RESPONSIBLE', $objHTMLPersonnel->GetCombo($objWO->responsible, 'responsible', 'lastfirst', 0, true, $dcl_info['DCL_HAVE_WO']));
			$Template->set_var('CMB_PRIORITY', $objHTMLPriorities->GetCombo($objWO->priority, 'priority', 'name', 0, false, $setid));
			$Template->set_var('CMB_SEVERITY', $objHTMLSeverities->GetCombo($objWO->severity, 'severity', 'name', 0, false, $setid));
		}

		if (IsSet($GLOBALS['return_to']))
		{
			$hiddenvars .= GetHiddenVar('return_to', $GLOBALS['return_to']);
			// FIXME: specific to projects
			if (IsSet($GLOBALS['project']))
				$hiddenvars .= GetHiddenVar('project', $GLOBALS['project']);
		}

		$Template->set_var('HIDDENVARS', $hiddenvars);
		$Template->pparse('out', 'hForm');
	}

	function ShowUploadFileForm($jcn, $seq)
	{
		global $dcl_info;

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_WO']))
			return PrintPermissionDenied();

		$Template = CreateTemplate(array('hForm' => 'htmlWorkOrderAddAttachment.tpl'));
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('TXT_TITLE', STR_WO_UPLOADTITLE);
		$Template->set_var('TXT_FILE', STR_WO_ATTACHFILE);
		$Template->set_var('VAL_MAXUPLOADFILESIZE', $dcl_info['DCL_MAX_UPLOAD_FILE_SIZE']);
		$Template->set_var('VAL_FORMACTION', menuLink());
		$Template->set_var('VAL_JCN', $jcn);
		$Template->set_var('VAL_SEQ', $seq);
		$Template->set_var('BTN_SAVE', STR_CMMN_SAVE);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);

		$Template->pparse('out', 'hForm');
	}

	function ShowDeleteAttachmentYesNo($jcn, $seq, $filename)
	{
		global $dcl_info;

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_HAVE_WO']))
			return PrintPermissionDenied();

		$Template = CreateTemplate(array('hForm' => 'htmlWorkOrderDelAttachment.tpl'));
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('TXT_TITLE', STR_WO_DELETEATTACHMENTTITLE);
		$Template->set_var('VAL_JCN', $jcn);
		$Template->set_var('VAL_SEQ', $seq);
		$Template->set_var('VAL_FILENAME', htmlspecialchars($filename));
		$Template->set_var('VAL_FORMACTION', menuLink());
		$Template->set_var('TXT_DELATTCONFIRM', sprintf(STR_WO_DELATTCONFIRM, htmlspecialchars($filename)));
		$Template->set_var('BTN_YES', STR_CMMN_YES);
		$Template->set_var('BTN_NO', STR_CMMN_NO);

		$Template->pparse('out', 'hForm');
	}

       // THANKS: Urmet Janes
	function ShowCSVUploadDialog() 
	{
		global $dcl_info;

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_WO']))
			return PrintPermissionDenied();

		$Template = CreateTemplate(array('hForm' => 'htmlWorkOrderCSVUpload.tpl'));
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('TXT_TITLE', STR_WO_CSVTITLE . '&nbsp;' . GetHelpLink());
		$Template->set_var('TXT_CSVFILE', STR_WO_CSVFILE);
		$Template->set_var('VAL_MAXUPLOADFILESIZE', $dcl_info['DCL_MAX_UPLOAD_FILE_SIZE']);
		$Template->set_var('VAL_FORMACTION', menuLink());
		$Template->set_var('BTN_SAVE', STR_CMMN_SAVE);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);

		$Template->pparse('out', 'hForm');
	}

	function DisplayGraphForm()
	{
		global $dcl_info;

		$Template = CreateTemplate(array('hForm' => 'htmlTicketGraph.tpl'));

		$Template->set_var('VAL_JSDATEFORMAT', GetJSDateFormat());
		$Template->set_var('VAL_FORMACTION', menuLink());
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('TXT_TITLE', STR_WO_ACTIVITYGRAPH);
		$Template->set_var('TXT_SHOWGRAPHFOR', STR_WO_SHOWGRAPHFOR);

		$Template->set_var('CMB_DAYS', '<select name="days"><option value="7">7 ' . STR_WO_DAYS . '</option><option value="14">14 ' . STR_WO_DAYS . '</option></select>');
		$Template->set_var('TXT_ENDINGON', STR_WO_ENDINGON);
		$Template->set_var('VAL_TODAY', date($dcl_info['DCL_DATE_FORMAT']));
		$Template->set_var('VAL_MENUACTION', 'boWorkorders.showgraph');
		$Template->set_var('BTN_OK', STR_CMMN_GO);

		$Template->pparse('out', 'hForm');
	}

	function my($rowlimit = 5)
	{
		$obj = CreateObject('dcl.dbWorkorders');
		$obj->Connect();

		$this->showmy($obj, 'responsible', STR_WO_MYWO, STR_WO_NOOPEN, $rowlimit);
		$this->showmy($obj, 'createby', STR_WO_MYSUBMISSIONS, STR_WO_NOSUBMISSIONS, $rowlimit);
	}

	function showmy($obj, $forField, $title, $noneMsg, $rowlimit)
	{
		global $dcl_info;

		if (!is_object($obj))
		{
			// Inconsistent formatting, ain't it?
			print('[htmlWorkorders::showmy] ' . STR_WO_OBJECTNOTPASSED);
			return;
		}

		if ($rowlimit == 0)
		{
			$objView = CreateObject('dcl.boView');
			$objView->title = $title;
			$objView->style = 'report';
			$objView->AddDef('columns', '', array('jcn', 'seq', 'priorities.name', 'severities.name', 'responsible.short', 'deadlineon', 'summary'));
			$objView->AddDef('columnhdrs', '', array(
					STR_WO_JCN,
					STR_WO_SEQ,
					STR_WO_PRIORITY,
					STR_WO_SEVERITY,
					STR_WO_RESPONSIBLE,
					STR_WO_DEADLINE,
					STR_WO_SUMMARY));

			$objView->AddDef('filter', $forField, $GLOBALS['DCLID']);
			$objView->AddDef('filternot', 'statuses.dcl_status_type', '2');
			if ($forField == 'createby')
				$objView->AddDef('filternot', 'responsible', $GLOBALS['DCLID']);
			$objView->AddDef('order', '', array('priorities.weight', 'severities.weight', 'deadlineon', 'eststarton', 'jcn', 'seq'));

			$objHV = CreateObject('dcl.htmlView');
			$objHV->Render($objView);
			return;
		}

		$query = sprintf('SELECT a.jcn,a.seq,a.summary,a.deadlineon,a.eststarton,a.starton ' .
				'FROM workorders a, priorities b, severities c, statuses d '.
				'WHERE a.%s=%d AND a.status=d.id AND d.dcl_status_type!=2 ',
				$forField, $GLOBALS['DCLID']);

		$query .= ' AND a.priority=b.id AND a.severity=c.id';

		// Already showed the wo set we are responsible for...
		if ($forField == 'createby')
			$query .= sprintf(' AND a.responsible!=%d', $GLOBALS['DCLID']);

		$query .= ' ORDER BY b.weight,c.weight,a.deadlineon,a.eststarton,a.jcn,a.seq ';

		if ($rowlimit > 0)
			$obj->LimitQuery($query, 0, $rowlimit);
		else
			$obj->Query($query);

		BeginChocoTable(false);
		
		if ($forField == 'responsible')
			print('<tr><th><a class="alightu" href="' . menuLink('', 'menuAction=htmlWorkorders.show&filterReportto=' . $GLOBALS['DCLID']) . '">');
		else
			print("<tr><th><a class=\"alightu\" href=\"" . menuLink('', "menuAction=boWorkorders.showmy&which=$forField") . "\">");

		print($title);
		print('</a>');

		$objToday = new DCLDate;
		$objToday->SetFromDisplay(date($dcl_info['DCL_DATE_FORMAT']));
		$objDeadline = new DCLDate;
		$objStart = new DCLDate;
		$objEstStart = new DCLDate;

		PrintWithChocoFont('&nbsp;&nbsp;(' . sprintf(STR_CMMN_TOPNUM, $rowlimit) . ')');

		print('</th></tr>');

		if ($obj->next_record())
		{
			$i = 0;
			do
			{
				$objDeadline->SetFromDB($obj->f('deadlineon'));
				$objEstStart->SetFromDB($obj->f('eststarton'));
				if (!$obj->IsFieldNull('starton'))
					$objStart->SetFromDB($obj->f('starton'));
				else
					$objStart->time = 0;

				if ($i++ % 2 == 0)
					print('<tr><td bgcolor="#FFFFFF">');
				else
					print('<tr><td bgcolor="' . $dcl_info['DCL_COLOR_LIGHT'] . '">');

				// Print schedule status marker as appropriate
				$statusColor = '';
				if ($objToday->time > $objDeadline->time || ($objToday->time > $objEstStart->time && $objStart->time == 0))
					$statusColor = '#FF0000';
				elseif ($objToday->time == $objDeadline->time || $objToday->time == $objEstStart->time)
					$statusColor = '#FFCE00';
				elseif ($objToday->time >= ($objDeadline->time - 7 * 86400) || $objToday->time >= ($objEstStart->time - 7 * 86400))
					$statusColor = '#00CE00';

				if ($statusColor != '')
				{
					printf('<font style="color: %s;">', $statusColor);
					print('<b>!</b>&nbsp;');
					EndFont();
				}

				$sMenuAction = menuLink('', 'menuAction=boWorkorders.viewjcn&jcn=' . $obj->f('jcn') . '&seq=' . $obj->f('seq'));
				printf('<a class="adark" href="%s">(%d-%d) %s</a>',
					$sMenuAction,
					$obj->f('jcn'),
					$obj->f('seq'),
					htmlspecialchars($obj->f('summary')));

				print('</td></tr>');
			}
			while ($obj->next_record());
		}
		else
		{
			print('<tr><td bgcolor="#FFFFFF">');
			print($noneMsg);
			print('</td></tr>');
		}

		print('</td></tr></table>');
	}

	function RenderOptions(&$aRecord)
	{
		$str = '<td>';
		$str .= '<a class="adark" href="' . menuLink('', 'menuAction=boWorkorders.viewjcn&jcn=' . $aRecord['jcn'] . '&seq=' . $aRecord['seq']) . '">' . STR_CMMN_VIEW . '</a>';
		//$str .= '&nbsp;|&nbsp;';
		$str .= '</td>';
		echo $str;
	}

	function RenderFilter(&$sPagerFormElements)
	{
		$filterStatus = IsSet($GLOBALS['filterStatus']) ? $GLOBALS['filterStatus'] : -1;
		$filterReportto = IsSet($GLOBALS['filterReportto']) ? $GLOBALS['filterReportto'] : 0;
		$filterProduct = IsSet($GLOBALS['filterProduct']) ? $GLOBALS['filterProduct'] : 0;

		echo '<form method="post" action="' . menuLink('') . '">';
		echo $sPagerFormElements;
		echo '<br><b>', STR_WO_STATUS, ':</b>';

		$o = CreateObject('dcl.htmlSelect');
		$o->vDefault = $filterStatus;
		$o->sName = 'filterStatus';
		$o->iSize = 0;
		$o->sZeroOption = STR_CMMN_SELECTONE;

		$oStatus = CreateObject('dcl.dbStatuses');
		$oStatus->Connect();
		$oStatus->Query('SELECT id, name FROM statuses ORDER BY name');
		$o->aOptions = $oStatus->FetchAllRows();
		$i = count($o->aOptions);
		$o->aOptions[$i++] = array('-1', STR_CMMN_HIDECLOSEDTYPES);
		$o->aOptions[$i++] = array('-2', STR_CMMN_ONLYCLOSEDTYPES);
		echo $o->GetHTML();

		echo '&nbsp;<b>', STR_WO_RESPONSIBLE, ':</b>';
		$oReport = CreateObject('dcl.htmlPersonnel');
		$oReport->createCombo($filterReportto, 'filterReportto', 'short', 0, false);

		echo '&nbsp;<b>', STR_WO_PRODUCT, ':</b>';
		$oProduct = CreateObject('dcl.htmlProducts');
		$oProduct->createCombo($filterProduct, 'filterProduct', 'name', 0, false);

		echo '&nbsp;<input type="submit" value="Filter">';
		echo '</form>';
	}

	function show()
	{
		global $dcl_info;

		commonHeader();

		$oView = CreateObject('dcl.boView');
		if (IsSet($GLOBALS['btnNav']) && IsSet($GLOBALS['startrow']) && IsSet($GLOBALS['numrows']))
		{
			if ($GLOBALS['btnNav'] == '<<')
			{
				$oView->startrow = $GLOBALS['startrow'] - $GLOBALS['numrows'];
				if ($oView->startrow < 0)
					$objView->startrow = 0;
				$oView->numrows = $GLOBALS['numrows'];
			}
			else
			{
				$oView->startrow = $GLOBALS['startrow'] + $GLOBALS['numrows'];
				$oView->numrows = $GLOBALS['numrows'];
			}
		}
		else
		{
			$oView->numrows = 15;
			$oView->startrow = 0;
		}

		$oView->style = 'report';
		$oView->title = STR_WO_BROWSEWO;
		$oView->AddDef('columns', '', array('jcn', 'seq', 'products.name', 'statuses.name', 'priorities.name', 'severities.name', 'responsible.short', 'deadlineon', 'summary'));
		$oView->AddDef('order', '', array('priorities.weight', 'severities.weight', 'deadlineon', 'eststarton', 'jcn', 'seq'));

		$oView->AddDef('columnhdrs', '', array(
				STR_WO_JCN,
				STR_WO_SEQ,
				STR_WO_PRODUCT,
				STR_WO_STATUS,
				STR_WO_PRIORITY,
				STR_WO_SEVERITY,
				STR_WO_RESPONSIBLE,
				STR_WO_DEADLINE,
				STR_WO_SUMMARY));

		$filterStatus = '-1';
		$filterReportto = '0';
		$filterProduct = '0';
		if (IsSet($GLOBALS['filterStatus']))
			$filterStatus = $GLOBALS['filterStatus'];
		if (IsSet($GLOBALS['filterReportto']))
			$filterReportto = $GLOBALS['filterReportto'];
		if (IsSet($GLOBALS['filterProduct']))
			$filterProduct = $GLOBALS['filterProduct'];

		if ($filterStatus != '0')
		{
			if ($filterStatus == '-1')
				$oView->AddDef('filternot', 'statuses.dcl_status_type', '2');
			else if ($filterStatus == '-2')
				$oView->AddDef('filter', 'statuses.dcl_status_type', '2');
			else
				$oView->AddDef('filter', 'status', $filterStatus);
		}

		if ($filterReportto != '0')
			$oView->AddDef('filter', 'responsible', $filterReportto);

		if ($filterProduct != '0')
			$oView->AddDef('filter', 'product', $filterProduct);

		$oHtml = CreateObject('dcl.htmlView');
		$oHtml->oCallback = $this;
		$oHtml->sCallback = 'RenderOptions';
		$oHtml->sFilterCallback = 'RenderFilter';
		$oHtml->sColumnTitle = STR_CMMN_OPTIONS;
		$oHtml->sPagingMenuAction = 'htmlWorkorders.show';
		$oHtml->bColumnSort = false;
		$oHtml->bShowPager = false;
		$oHtml->Render($oView);
	}
}
?>
