<?php
/*
 * $Id: class.htmlViews.inc.php,v 1.4.4.6 2003/11/11 05:50:04 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('vw');

class htmlViews
{
	function createCombo($default = 0, $cbName = 'viewid', $size = 0, $includePublic = true, $forTable = '')
	{
		echo $this->GetCombo($default, $cbName, $size, $includePublic, $forTable);
	}

	function GetCombo($default = 0, $cbName = 'viewid', $size = 0, $includePublic = true, $forTable = '')
	{
		$objDB = CreateObject('dcl.dbViews');
		$objDB->Connect();
		$objDB->cacheEnabled = false;

		$query = 'SELECT viewid,name FROM views WHERE ';

		if ($includePublic)
			$query .= '(whoid=' . $GLOBALS['DCLID'] . ' OR ispublic=\'Y\')';
		else
			$query .= 'whoid=' . $GLOBALS['DCLID'];

		if ($forTable != '')
			$query .= " AND tablename='$forTable'";

		$query .= ' ORDER BY name';
		$objDB->Query($query);

		$retVal = '<select name="' . $cbName;
		if ($size > 0)
			$retVal .= '[]" multiple size="' . $size;
		
		$retVal .= '">';
		
		if ($size == 0)
			$retVal .= '<option value="0">' . STR_CMMN_SELECTONE . '</option>';

		while ($objDB->next_record())
		{
			$retVal .= sprintf('<option value="%s"%s>%s</option>', 
								$objDB->f(0),
								$objDB->f(0) == $default ? ' selected' : '',
								$objDB->f(1));
		}

		$retVal .= '</select>';
		
		return $retVal;
	}

	function PrintAll($orderBy = 'name')
	{
		commonHeader();

		$objDB = CreateObject('dcl.dbViews');
		$objDB->Connect();

		$objDB->Query('SELECT viewid,whoid,ispublic,name,tablename FROM views WHERE whoid=' . $GLOBALS['DCLID'] . " OR ispublic='Y' ORDER BY $orderBy");
		$allRecs = $objDB->FetchAllRows();

		if (count($allRecs) > 0)
		{
			$allName = array(
					0 => STR_VW_ID,
					1 => STR_VW_OWNER, 
					2 => STR_VW_PUBLIC,
					3 => STR_VW_NAME,
					4 => STR_VW_TABLE);

			if (count($allRecs) > 0)
			{
				$objDBP = CreateObject('dcl.dbPersonnel');
				$objDBP->Connect($objDB->conn);

				$allName[] = 'Options';
				for ($i = 0; $i < count($allRecs); $i++)
				{
					$allRecs[$i][3] = sprintf('<a class="adark" href="%s">%s</a>',
							menuLink('', sprintf('menuAction=boViews.exec&viewid=%d', $allRecs[$i][0])),
							$allRecs[$i][3]);

					$options = '';
					if ($allRecs[$i][4] == 'workorders' )
						$options .= '<a class="adark" href="' . menuLink('', 'menuAction=htmlWOSearches.ShowView&id=' . $allRecs[$i][0]) . '">' . 'Setup' . '</a>';
					else if ($allRecs[$i][4] == 'tickets' )
						$options .= '<a class="adark" href="' . menuLink('', 'menuAction=htmlTicketSearches.ShowView&id=' . $allRecs[$i][0]) . '">' . 'Setup' . '</a>';

					if ($allRecs[$i][1] == $GLOBALS['DCLID'])
					{
						if ($options != '')
							$options .= '&nbsp;|&nbsp;';

						$options .= '<a class="adark" href="' . menuLink('', 'menuAction=boViews.delete&id=' . $allRecs[$i][0]) . '">' . STR_CMMN_DELETE . '</a>';
					}

					if ($options == '')
						$options = '&nbsp;';

					$objDBP->Load($allRecs[$i][1]);
					$allRecs[$i][1] = $objDBP->short;
					$allRecs[$i][] = $options;
				}
			}
			PrintArrayAsChocoTable($allName, $allRecs, sprintf(STR_VW_TITLE, $orderBy), '', '');
		}
		else
		{
			print('<center>');
			PrintWithChocoFont(STR_VW_NOVIEWS);
			print('</center>');
		}
	}

	function ShowEntryForm()
	{
		global $dcl_info;

		$Template = CreateTemplate(array('hForm' => 'htmlViewForm.tpl'));
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);

		$Template->set_var('TXT_TITLE', STR_VW_ADDVIEW);
		$Template->set_var('TXT_PUBLIC', STR_VW_PUBLIC);
		$Template->set_var('TXT_NAME', STR_VW_NAME);
		$Template->set_var('BTN_SAVE', STR_CMMN_SAVE);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);
		$Template->set_var('TXT_HIGHLIGHTEDNOTE', STR_CMMN_HIGHLIGHTEDNOTE);
		$Template->set_var('VAL_FORMACTION', menuLink());
		$Template->set_var('BTN_CANCEL', STR_CMMN_CANCEL);

		$Template->set_var('VAL_DCLID', $GLOBALS['DCLID']);
		$Template->set_var('VAL_TABLENAME', $GLOBALS['vt']);

		// Add the URL pieces
		$viewUrl = '';
		$objView = CreateObject("dcl.boView");
		$o = CreateObject('dcl.dbPersonnel');
		while (list($key, $val) = each($objView->urlpieces))
		{
			if (IsSet($GLOBALS[$val]))
				$viewUrl .= sprintf('<input type="hidden" name="%s" value="%s">', $val, htmlspecialchars($o->GPCStripSlashes($GLOBALS[$val])));
		}

		$Template->set_var('VAL_VIEWURL', $viewUrl);
		$Template->set_var('CMB_ISPUBLIC', GetYesNoCombo("N", "ispublic", 0, false));

		$Template->pparse('out', 'hForm');
	}
}
?>
