CREATE TABLE tickets (
	ticketid numeric(11,0) IDENTITY NOT NULL,
	product int NOT NULL,
	account int,
	createdby int NOT NULL,
	createdon varchar(14)  NOT NULL,
	responsible int NOT NULL,
	closedby int,
	closedon varchar(14),
	status int NOT NULL,
	statuson varchar(14) NOT NULL,
	lastactionon varchar(14),
	priority int NOT NULL,
	type int NOT NULL,
	contact varchar(80),
	contactphone varchar(20),
	issue text NOT NULL,
	version varchar(20),
	summary varchar(100),
	seconds int not null default '0',
	contactemail varchar(100),
	PRIMARY KEY (ticketid)
)
GO

CREATE TABLE ticketresolutions (
	resid numeric(11,0) IDENTITY NOT NULL,
	ticketid int NOT NULL,
	loggedby int NOT NULL,
	loggedon varchar(14)  NOT NULL,
	status int NOT NULL,
	resolution text NOT NULL,
	startedon varchar(14) NOT NULL,
	PRIMARY KEY (resid)
)
GO

CREATE TABLE faq (
	faqid numeric(11,0) IDENTITY NOT NULL,
	name varchar(80) NOT NULL,
	createby int,
	createon varchar(14)  NOT NULL,
	modifyby int,
	modifyon varchar(14),
	active char(1) DEFAULT 'Y' NOT NULL,
	description text,
	PRIMARY KEY (faqid)
)
GO

CREATE TABLE faqtopics (
	topicid numeric(11,0) IDENTITY NOT NULL,
	seq int NOT NULL,
	faqid int NOT NULL,
	name varchar(80) NOT NULL,
	description text NOT NULL,
	createby int,
	createon varchar(14)  NOT NULL,
	modifyby int,
	modifyon varchar(14),
	active char(1) DEFAULT 'Y' NOT NULL,
	PRIMARY KEY (topicid)
)
GO

CREATE TABLE faqquestions (
	questionid numeric(11,0) IDENTITY NOT NULL,
	seq int NOT NULL,
	topicid int NOT NULL,
	questiontext text NOT NULL,
	createby int,
	createon varchar(14)  NOT NULL,
	modifyby int,
	modifyon varchar(14),
	active char(1) DEFAULT 'Y' NOT NULL,
	PRIMARY KEY (questionid)
)
GO

CREATE TABLE faqanswers (
	answerid numeric(11,0) IDENTITY NOT NULL,
	questionid int NOT NULL,
	answertext text NOT NULL,
	createby int NOT NULL,
	createon varchar(14)  NOT NULL,
	modifyby int,
	modifyon varchar(14),
	active char(1) DEFAULT 'Y' NOT NULL,
	PRIMARY KEY (answerid)
)
GO

alter table products add ticketsto int not null default('0')
GO
update products set ticketsto=reportto
GO

alter table projects add parentprojectid int default('0') not null
GO
update projects set parentprojectid=0
GO

CREATE TABLE views (
	viewid numeric(11,0) IDENTITY NOT NULL,
	whoid int NOT NULL,
	name varchar(100) NOT NULL,
	ispublic char(1) DEFAULT 'N' NOT NULL,
	viewurl text NOT NULL,
	tablename varchar(30) not null,
	PRIMARY KEY(viewid)
)
GO


CREATE TABLE attributesets (
	id numeric(11,0) IDENTITY NOT NULL,
	short varchar(20) NOT NULL,
	name varchar(100) NOT NULL,
	active char(1) NOT NULL DEFAULT 'Y'
)
GO

INSERT INTO attributesets(short,name,active) VALUES ('WO', 'Work Orders', 'Y')
GO
INSERT INTO attributesets(short,name,active) VALUES ('TCK', 'Tickets', 'Y')
GO

CREATE TABLE attributesetsmap (
	setid int NOT NULL,
	typeid int NOT NULL,
	keyid int NOT NULL,
	weight int NOT NULL
)
GO

INSERT INTO attributesetsmap SELECT 1, 1, id, 1 FROM actions
GO
INSERT INTO attributesetsmap SELECT 1, 2, id, weight FROM priorities
GO
INSERT INTO attributesetsmap SELECT 1, 3, id, weight FROM severities
GO
INSERT INTO attributesetsmap SELECT 1, 4, id, 1 FROM statuses
GO

INSERT INTO attributesetsmap SELECT 2, 1, id, 1 FROM actions
GO
INSERT INTO attributesetsmap SELECT 2, 2, id, weight FROM priorities
GO
INSERT INTO attributesetsmap SELECT 2, 3, id, weight FROM severities
GO
INSERT INTO attributesetsmap SELECT 2, 4, id, 1 FROM statuses
GO

alter table products add wosetid int not null default '0'
GO
alter table products add tcksetid int not null default '0'
GO

update products set wosetid=1
GO
update products set tcksetid=2
GO
