/*!

\if MANPAGES
\page dcmmkdir Create a DICOMDIR file
\else
\page dcmmkdir dcmmkdir: Create a DICOMDIR file
\endif

\section synopsis SYNOPSIS

\verbatim
dcmmkdir [options] dcmfile-in...
\endverbatim

\section description DESCRIPTION

The \b dcmmkdir utility creates a DICOMDIR file from the specified referenced
DICOM files according to the DICOM Part 11 Media Storage Application Profiles.

Currently the following profiles are supported (others might be added later):

\li General Purpose CD-R Interchange (STD-GEN-CD)
\li General Purpose Interchange on DVD-RAM Media (STD-GEN-DVD-RAM)
\li General Purpose DVD with Compression Interchange (STD-GEN-DVD-JPEG/J2K)
\li General Purpose MIME Interchange (STD-GEN-MIME)
\li General Purpose USB and Flash Memory with Compression Interchange
    (STD-GEN-USB/MMC/CF/SD-JPEG/J2K)
\li DVD Interchange with MPEG2 MP\@ML (STD-DVD-MPEG2-MPML)
\li Basic Cardiac X-Ray Angiographic Studies on CD-R Media (STD-XABC-CD)
\li 1024 X-Ray Angiographic Studies on CD-R Media (STD-XA1K-CD)
\li 1024 X-Ray Angiographic Studies on DVD Media (STD-XA1K-DVD)
\li Dental Radiograph Interchange (STD-DEN-CD)
\li CT/MR Studies on various Media (STD-CTMR-xxxx)
\li Ultrasound Single Frame for Image Display (STD-US-ID-SF-xxxx)
\li Ultrasound Single Frame with Spatial Calibration (STD-US-SC-SF-xxxx)
\li Ultrasound Single Frame with Combined Calibration (STD-US-CC-SF-xxxx)
\li Ultrasound Single & Multi-Frame for Image Display (STD-US-ID-MF-xxxx)
\li Ultrasound Single & Multi-Frame with Spatial Calibration
    (STD-US-SC-MF-xxxx)
\li Ultrasound Single & Multi-Frame with Combined Calibration
    (STD-US-CC-MF-xxxx)
\li 12-lead ECG Interchange on Diskette (STD-WVFM-ECG-FD)
\li Hemodynamic Waveform Interchange on Diskette (STD-WVFM-HD-FD)

This tool extends \b dcmgpdir which can only create General Purpose DICOMDIR
files.  The default behaviour of \b dcmmkdir (with \e --general-purpose) is
equivalent to that of \b dcmgpdir.

\section parameters PARAMETERS

\verbatim
dcmfile-in  referenced DICOM file
\endverbatim

\section options OPTIONS
\subsection general_options general options
\verbatim
  -h    --help
          print this help text and exit

        --version
          print version information and exit

  -v    --verbose
          verbose mode, print processing details

  -q    --quiet
          quiet mode, print no warnings and errors

  -d    --debug
          debug mode, print debug information
\endverbatim

\subsection input_options input options
\verbatim
DICOMDIR identifiers:

  +D    --output-file  [f]ilename : string
          generate specific DICOMDIR file
          (default: DICOMDIR in current directory)

  +F    --fileset-id  [i]d : string (default: DCMTK_MEDIA_DEMO)
          use specific file set ID

  +R    --descriptor  [f]ilename : string
          add a file set descriptor file ID
          (e.g. README, default: no descriptor)

  +C    --char-set  [c]har-set : string
          add a specific character set for descriptor
          (default: "ISO_IR 100" if descriptor present)

type 1 attributes:

  -I    --strict
          exit with error if DICOMDIR type 1 attributes
          are missing in DICOM file (default)

  +I    --invent
          invent DICOMDIR type 1 attributes
          if missing in DICOM file

reading:

  +id   --input-directory  [d]irectory : string
          read referenced DICOM files from directory d
          (default for --recurse: current directory)

  -m    --keep-filenames
          expect filenames to be in DICOM format (default)

  +m    --map-filenames
          map to DICOM filenames (lowercase->uppercase,
          and remove trailing period)

  -r    --no-recurse
          do not recurse within directories (default)

  +r    --recurse
          recurse within filesystem directories

  +p    --pattern  [p]attern : string (only with --recurse)
          pattern for filename matching (wildcards)

          # possibly not available on all systems

checking:

  -W    --no-consistency-check
          do not check files for consistency

  +W    --warn-inconsist-files
          warn about inconsistent files (default)

  -a    --abort-inconsist-file
          abort on first inconsistent file

  +Ipi  --invent-patient-id
          invent new PatientID in case of inconsistent
          PatientsName attributes

  -Nec  --no-encoding-check
          do not reject images with non-standard
          pixel encoding (just warn)

  -Nrc  --no-resolution-check
          do not reject images with non-standard
          spatial resolution (just warn)

  -Nxc  --no-xfer-check
          do not reject images with non-standard
          transfer syntax (just warn)

icon images:

  +X    --add-icon-image
          add monochrome icon image on IMAGE level
          (default for cardiac profiles)

  -Xs   --icon-image-size  [s]ize : integer (1..128)
          width and height of the icon image (in pixel)
          (fixed: 128 for XA, 64 for CT/MR profile)

  -Xi   --icon-file-prefix  [p]refix : string
          use PGM image 'prefix'+'dcmfile-in' as icon
          (default: create icon from DICOM image)

  -Xd   --default-icon  [f]ilename : string
          use specified PGM image if icon cannot be
          created automatically (default: black image)
\endverbatim

\subsection output_options output options
\verbatim
profiles:

  -Pgp  --general-purpose
          General Purpose Interchange on CD-R or
          DVD-RAM Media (STD-GEN-CD/DVD-RAM, default)

  -Pdv  --general-purpose-dvd
          General Purpose DVD with Compression Interchange
          (STD-GEN-DVD-JPEG/J2K)

  -Pmi  --general-purpose-mime
          General Purpose MIME Interchange (STD-GEN-MIME)

  -Pfl  --usb-and-flash
          General Purpose USB/Flash Memory with Compression
          Interchange (STD-GEN-USB/MMC/CF/SD-JPEG/J2K)

  -Pmp  --mpeg2-mpml-dvd
          DVD Interchange with MPEG2 Main Profile @ Main
          Level (STD-DVD-MPEG2-MPML)

  -Pbc  --basic-cardiac
          Basic Cardiac X-Ray Angiographic Studies on
          CD-R Media (STD-XABC-CD)

  -Pxa  --xray-angiographic
          1024 X-Ray Angiographic Studies on CD-R Media
          (STD-XA1K-CD)

  -Pxd  --xray-angiographic-dvd
          1024 X-Ray Angiographic Studies on DVD Media
          (STD-XA1K-DVD)

  -Pde  --dental-radiograph
          Dental Radiograph Interchange (STD-DEN-CD)

  -Pcm  --ct-and-mr
          CT/MR Studies (STD-CTMR-xxxx)

  -Pus  --ultrasound-id-sf
          Ultrasound Single Frame for Image Display
          (STD-US-ID-SF-xxxx)

        --ultrasound-sc-sf
          Ultrasound Single Frame with Spatial
          Calibration (STD-US-SC-SF-xxxx)

        --ultrasound-cc-sf
          Ultrasound Single Frame with Combined
          Calibration (STD-US-CC-SF-xxxx)

  -Pum  --ultrasound-id-mf
          Ultrasound Single & Multi-Frame for Image
          Display (STD-US-ID-MF-xxxx)

        --ultrasound-sc-mf
          Ultrasound Single & Multi-Frame with Spatial
          Calibration (STD-UD-SC-MF-xxxx)

        --ultrasound-cc-mf
          Ultrasound Single & Multi-Frame with Combined
          Calibration (STD-UD-CC-MF-xxxx)

  -Pec  --12-lead-ecg
          12-lead ECG Interchange on Diskette
          (STD-WVFM-ECG-FD)

  -Phd  --hemodynamic-waveform
          Hemodynamic Waveform Interchange on Diskette
          (STD-WVFM-HD-FD)

writing:

  -A    --replace
          replace existing DICOMDIR (default)

  +A    --append
          append to existing DICOMDIR

  -w    --discard
          do not write out DICOMDIR

  -nb   --no-backup
          do not create a backup of existing DICOMDIR

post-1993 value representations:

  +u    --enable-new-vr
          enable support for new VRs (UN/UT) (default)

  -u    --disable-new-vr
          disable support for new VRs, convert to OB

group length encoding:

  -g    --group-length-remove
          write without group length elements (default)

  +g    --group-length-create
          write with group length elements

length encoding in sequences and items:

  +e    --length-explicit
          write with explicit lengths (default)

  -e    --length-undefined
          write with undefined lengths
\endverbatim

\section notes NOTES

All files specified on the command line (or discovered by recursivly examining
the contents of directories with the \e +r option) are first evaluated for
their compatibility with the specified Media Storage Application Profile (Part
11).  Only appropriate files encoded using one of the allowed Transfer Syntaxes
will be accepted.  Files having invalid filenames will be rejected (the rules
can be relaxed via the \e +m option).  Files missing required attributes will
be rejected (the \e +I option can relax this behaviour).

A DICOMDIR file will only be constructed if all files have passed initial
tests.

The support for icon images is currently restricted to monochrome images.  This
will probably change in the future.  Till then color images are automatically
converted to grayscale mode.  The icon size is 128*128 pixels for the cardiac
profiles (as required by the DICOM standard) and 64*64 for all others.

\section command_line COMMAND LINE

All command line tools use the following notation for parameters: square
brackets enclose optional values (0-1), three trailing dots indicate that
multiple values are allowed (1-n), a combination of both means 0 to n values.

Command line options are distinguished from parameters by a leading '+' or '-'
sign, respectively.  Usually, order and position of command line options are
arbitrary (i.e. they can appear anywhere).  However, if options are mutually
exclusive the rightmost appearance is used.  This behaviour conforms to the
standard evaluation rules of common Unix shells.

In addition, one or more command files can be specified using an '@' sign as a
prefix to the filename (e.g. <em>\@command.txt</em>).  Such a command argument
is replaced by the content of the corresponding text file (multiple
whitespaces are treated as a single separator) prior to any further
evaluation.  Please note that a command file cannot contain another command
file.  This simple but effective approach allows to summarize common
combinations of options/parameters and avoids longish and confusing command
lines (an example is provided in file <em>share/data/dumppat.txt</em>).

\section environment ENVIRONMENT

The \b dcmmkdir utility will attempt to load DICOM data dictionaries specified
in the \e DCMDICTPATH environment variable.  By default, i.e. if the
\e DCMDICTPATH environment variable is not set, the file
<em>\<PREFIX\>/lib/dicom.dic</em> will be loaded unless the dictionary is built
into the application (default for Windows).

The default behaviour should be preferred and the \e DCMDICTPATH environment
variable only used when alternative data dictionaries are required.  The
\e DCMDICTPATH environment variable has the same format as the Unix shell
\e PATH variable in that a colon (":") separates entries.  The data dictionary
code will attempt to load each file specified in the \e DCMDICTPATH
environment variable.  It is an error if no data dictionary can be loaded.

\section see_also SEE ALSO

<b>dcmgpdir</b>(1)

\section copyright COPYRIGHT

Copyright (C) 2001-2005 by Kuratorium OFFIS e.V., Escherweg 2, 26121 Oldenburg,
Germany.

*/