/*!

\if MANPAGES
\page dcmqridx Register a DICOM image file in an image database index file
\else
\page dcmqridx dcmqridx: Register a DICOM image file in an image database index file
\endif

\section synopsis SYNOPSIS

\verbatim
dcmqridx [options] index-out [dcmimg-in...]
\endverbatim

\section description DESCRIPTION

The \b dcmqridx ulility registers DICOM image files in the database index file
used by the \b dcmqrscp and \b dcmqrti applications.  No image files are copied.
\b dcmqridx can also list the contents of the database index file.

\section parameters PARAMETERS
\verbatim
index-out  storage area for the index file (directory)

dcmimg-in  DICOM image file to be registered in the index file
\endverbatim

\section options OPTIONS
\verbatim
  -h  --help
        print this help text and exit

      --version
        print version information and exit

  -v  --verbose
        verbose mode, print processing details

  -d  --debug
        debug mode, print debug information

  -p  --print
        list contents of database index file

  -n  --not-new
        set instance reviewed status to 'not new'
\endverbatim

\section notes NOTES

\b dcmqridx attempts to add a reference to the database index file for each
image-file provided on the command line.

\b dcmqridx disables the database back-end quota system so that no image files
will be deleted.

\section command_line COMMAND LINE

All command line tools use the following notation for parameters: square
brackets enclose optional values (0-1), three trailing dots indicate that
multiple values are allowed (1-n), a combination of both means 0 to n values.

Command line options are distinguished from parameters by a leading '+' or '-'
sign, respectively.  Usually, order and position of command line options are
arbitrary (i.e. they can appear anywhere).  However, if options are mutually
exclusive the rightmost appearance is used.  This behaviour conforms to the
standard evaluation rules of common Unix shells.

In addition, one or more command files can be specified using an '@' sign as a
prefix to the filename (e.g. <em>\@command.txt</em>).  Such a command argument
is replaced by the content of the corresponding text file (multiple
whitespaces are treated as a single separator) prior to any further
evaluation.  Please note that a command file cannot contain another command
file.  This simple but effective approach allows to summarize common
combinations of options/parameters and avoids longish and confusing command
lines (an example is provided in file <em>share/data/dumppat.txt</em>).

\section environment ENVIRONMENT

The \b dcmqridx utility will attempt to load DICOM data dictionaries specified
in the \e DCMDICTPATH environment variable.  By default, i.e. if the
\e DCMDICTPATH environment variable is not set, the file
<em>\<PREFIX\>/lib/dicom.dic</em> will be loaded unless the dictionary is built
into the application (default for Windows).

The default behaviour should be preferred and the \e DCMDICTPATH environment
variable only used when alternative data dictionaries are required.  The
\e DCMDICTPATH environment variable has the same format as the Unix shell
\e PATH variable in that a colon (":") separates entries.  The data dictionary
code will attempt to load each file specified in the \e DCMDICTPATH
environment variable.  It is an error if no data dictionary can be loaded.

\section see_also SEE ALSO

<b>dcmqrscp</b>(1), <b>dcmqrti</b>(1)

\section copyright COPYRIGHT

Copyright (C) 1993-2005 by Kuratorium OFFIS e.V., Escherweg 2, 26121 Oldenburg,
Germany.

*/