/*!

\if MANPAGES
\page dcmqrti The Terminal Initiator Telnet Client Program
\else
\page dcmqrti dcmqrti: The Terminal Initiator Telnet Client Program
\endif

\section synopsis SYNOPSIS

\verbatim
dcmqrti [options] peer...
\endverbatim

\section description DESCRIPTION

The \b dcmqrti program (telnet initiator) is an interactive character based
program intended to be used for examining the dcmqrscp image databases and
sending images contained within these databases to Vendor nodes.  During a
DICOM Demonstration the \b dcmqrti program can be activated by a Vendor by
logging onto the computer running the \b dcmqrscp program.  Each vendor will
have their own login account and the \b dcmqrti program will be started
instead of a normal shell when they login.

The \b dcmqrti program takes one main argument, the hostname or vendor
symbolic name (from the VendorTable in the configuration file) of a Vendor.
It then searches in the configuration file for all AE titles associated with
this hostname or vendor name, and all storage areas accessable to these AE
titles.  Thus only the accessable databases and peer applications discovered
in the configuration file are available as choices within the \b dcmqrti user
interface.

\section parameters PARAMETERS

\verbatim
peer  peer host name or symbolic name from cfg file
\endverbatim

\section options OPTIONS

\subsection general_options general options
\verbatim
  -h    --help
          print this help text and exit

        --version
          print version information and exit

  -v    --verbose
          verbose mode, print processing details

  -d    --debug
          debug mode, print debug information

  -c    --config  [f]ilename: string
          use configuration file f (default: dcmqrscp.cfg)
\endverbatim

\subsection network_options network options
\verbatim
  -to   --timeout  [s]econds: integer (default: unlimited)
          timeout for connection requests

  -ta   --acse-timeout  [s]econds: integer (default: 30)
          timeout for ACSE messages

  -td   --dimse-timeout  [s]econds: integer (default: unlimited)
          timeout for DIMSE messages

  -xi   --propose-implicit
          propose implicit VR little endian TS only

  -aet  --aetitle  aetitle: string
          set my AE title (default: TELNET_INITIATOR)

  -pdu  --max-pdu  [n]umber of bytes: integer [4096..131072]
          set max receive pdu to n bytes
          (default: use value from configuration file)
\endverbatim

\subsection other_options other options
\verbatim
  -u    --disable-new-vr
          disable support for new VRs, convert to OB

  -rmt  --remote  [t]itle: string
          connect to remote database defined in cfg file
\endverbatim

\section NOTES

\subsection commands Commands

All commands can be abbreviated.  An abbreviation is allowed if it does not
conflict with another command.

\subsubsection help_command "help" Command

The "help" command gives a summary of all available commands. Its output is
shown underneath.  In order to separate the examples from surrounding text,
all examples are bracketted by dashed lines.  These lines do not appear when
running the program.

\verbatim
------------------------------------------------------------
Command Summary:
help                list this summary
?                   short help
title [#]           list [set] current peer AE title
database [#]        list [set] current database
study [#]           list [set] current study
series [#]          list [set] current series
image [#]           list [set] current image
display [#]         display current [specific] image
send study [#]      send current [specific] study
send series [#]     send current [specific] series
send image [#]      send current [specific] image
echo [#]            verify connectivity [# times]
quit                quit program
exit                synonym for quit
------------------------------------------------------------
\endverbatim

\subsubsection title_command "title" Command

The "title" command without an argument allows the user to list the known
remote Application Entities (AE).  An example output might look like:

\verbatim
------------------------------------------------------------
Peer AE Titles:
     Peer AE          HostName:PortNumber
* 0) ACME1            (swallow:2001)
  1) ACME2            (swallow:2002)
  2) UNITED1          (kolibri:2001)
  3) UNITED2          (kolibri:2002)
------------------------------------------------------------
\endverbatim

The current peer AE is marked with an asterisk (*).  Each peer AE has an index
(second column) which can be used as an argument to the "title" command in
order to set the current peer AE.  The third column gives the AE title of the
peer AE.  The fourth column shows the hostname and TCP/IP port number of the
peer AE.

When invoked with an argument index, the "title" command will set the current
peer AE.  The \b ti program will attempt to initate an association to the
current peer AE when asked to send a study/series/image or to send an echo.

\subsubsection database_command "database" Command

The "database" command without an argument allows the user to list the know
local databases (these correspond to dcmqrscp's Application Entity Titles).
An example output might look like:

\verbatim
------------------------------------------------------------
Database Titles:
     Database
* 0) COMMON
  1) ACME_QUERY
  2) ACME_STORE
  3) UNITED_QUERY
------------------------------------------------------------
\endverbatim

The current database is marked with an asterisk (*).  Each database has an
index (second column) which can be used as an argument to the "database"
command in order to set the current database.  The third column shows the name
of the database (i.e. the dcmqrscp Application Entity title for the particular
storage area).

When invoked with an argument index, the "database" command will set the
current database.  The current database is used as the basis for further
database specific actions.

\subsubsection study_command "study" Command

The "study" command with no argument lists the studies in the current
database.  An example output might look like:

\verbatim
------------------------------------------------------------
      Patient                        PatientID    StudyID
*  0) JACKSON^ANDREW^^^              M4997106     20001
   1) GRANT^MARY^^^                  F4997108     20002
   2) ARTHUR^CHESTER^^^              M4997107     20003
   3) JEFFERSON^THOMAS^^^            M4997096     9465
   4) MADISON^DOLLY^^^               F4997097     9443

4 Studies in Database: COMMON
------------------------------------------------------------
\endverbatim

The current study is marked with an asterisk (*).  Each study has an index
(second column) which can be used as an argument to the "study" command in
order to set the current study.  The third column shows the patient name, the
fourth column the patient ID and the fifth column the study ID.

When invoked with an argument index, the "study" command will set the current
study.  The current study is used as the basis for further study specific
actions.

\subsubsection series_command "series" Command

The "series" command with no argument lists the series in the current study.
An example output might look like:

\verbatim
------------------------------------------------------------
      Series Modality SeriesInstanceUID
*  0) 1      MR       1.2.840.113654.2.3.1993.201
   1) 2      MR       1.2.840.113654.2.3.1993.202
   2) 3      MR       1.2.840.113654.2.3.1993.203
   3) 4      MR       1.2.840.113654.2.3.1993.204
   4) 5      MR       1.2.840.113654.2.3.1993.205

5 Series in StudyID 05381,
  Patient: MONROE^JAMES^^^ (Database: COMMON)
------------------------------------------------------------
\endverbatim

The current series is marked with an asterisk (*).  Each series has an index
(second column) which can be used as an argument to the "series" command in
order to set the current series.  The third column shows the series number,
the fourth column the series modality, and the fifth column the series
instance UID.

When invoked with an argument index, the "series" command will set the current
series.  The current series is used as the basis for further series specific
actions.

\subsubsection image_command "image" Command

The "image" command with no argument lists the images in the current series.
An example output might look like:

\verbatim
------------------------------------------------------------
      Image ImageInstanceUID
*  0) 1     1.2.840.113654.2.3.1993.9.123.6.2674
   1) 2     1.2.840.113654.2.3.1993.9.123.6.2675
   2) 3     1.2.840.113654.2.3.1993.9.123.6.2676
   3) 4     1.2.840.113654.2.3.1993.9.123.6.2677
   4) 5     1.2.840.113654.2.3.1993.9.123.6.2678
   5) 6     1.2.840.113654.2.3.1993.9.123.6.2679
   6) 7     1.2.840.113654.2.3.1993.9.123.6.2680
   7) 8     1.2.840.113654.2.3.1993.9.123.6.2681
   8) 9     1.2.840.113654.2.3.1993.9.123.6.2682
   9) 10    1.2.840.113654.2.3.1993.9.123.6.2683
  10) 11    1.2.840.113654.2.3.1993.9.123.6.2684
  11) 12    1.2.840.113654.2.3.1993.9.123.6.2685
  12) 13    1.2.840.113654.2.3.1993.9.123.6.2686

13 Images in MR Series, StudyID 05381,
  Patient: MONROE^JAMES^^^ (Database: COMMON)
------------------------------------------------------------
\endverbatim

The current image is marked with an asterisk (*).  Each image has an index
(second column) which can be used as an argument to the "image" command in
order to set the current image.  The third column shows the image number, and
the fourth column the image instance UID (SOP Instance UID).

When invoked with an argument index, the "image" command will set the current
image.  The current image is used as the basis for further image specific
actions.

\subsubsection display_command "display" Command

The display command serves no purpose in the current version of DCMTK. It was
used in prior releases to request the CTN Display Program to display an image.

\subsubsection send_command "send" Command

The "send" command allows a complete study/series or individual image to be
stored on a remote AE.  When this command is invoked, the \b dcmqrti program
will operate as a SCU of the DICOM Storage Service Class and attempt to
initiate an association with the current peer AE (defined via the "title"
command).  Presentation contexts for all relevant Storage SOP Classes will be
proposed.  An attempt will be made to store all specified images.  If no
association could be negotiated an error message will be printed.  If an
storage operation fails or if no appropriate presentation context is available
and error message will be printed.

\verbatim
The "send" command exists in three forms:

        send study [#]
        send series [#]
        send image [#]
\endverbatim

The "study" keyword means send all images in the current study. When invoked
with an argument index, the specified study in the current database will be
stored.  The "series" keyword means send all images in the current series.
When invoked with an argument index, the specified series in the current study
will be stored.  The "image" keyword means send the current image.  When
invoked with an argument index, the specified image in the current series will
be stored.

When an image is stored, a message will be printed of the form:
\verbatim
------------------------------------------------------------
New Association Started (swallow:2001,ACME1)
[MsgID 1] Store,
  PatientsName: JACKSON^ANDREW^^^, StudyID: 20001,
  Series: 2, Modality: CR, Image: 1,
  Image UID: 1.2.840.113654.2.3.1993.9.123.6.1834
  0%________25%_________50%__________75%________100%
  --------------------------------------------------
[MsgID 1] Complete [Status: Success]
Released Association (swallow:2001,ACME1)
------------------------------------------------------------
\endverbatim

\subsubsection echo_command "echo" Command

The "echo" command allows the user to verify connectivity with the current
peer AE (defined via the "title" command).  When invoked, the \b dcmqrti
program acts as an SCU of the Verification Service Class.

When invoked without an argument, only one C-ECHO message is generated.  When
invoked with an argument, the specified number of C-ECHO messages will be
sent.  A message will be printed of the form:

\verbatim
------------------------------------------------------------
New Association Started (localhost:2001,CMOVE)
[MsgID 1] Echo, Complete [Status: Success]
Released Association (localhost:2001,CMOVE)
------------------------------------------------------------
\endverbatim

\subsubsection quit_exit_commands "quit", "exit" Commands

The "quit" and "exit" commands have the same effect.  They terminate the
\b dcmqrti program.

\subsection dicom_conformance DICOM Conformance

The \b dcmqrti application supports the same set of SOP Classes as an SCU as
the \b dcmqrscp application - see dcmqrscp documentation.

The \b dcmqrti application will propose presentation contexts for all of the
abovementioned supported SOP Classes using the transfer syntaxes:

\verbatim
LittleEndianImplicitTransferSyntax  1.2.840.10008.1.2
LittleEndianExplicitTransferSyntax  1.2.840.10008.1.2.1
BigEndianExplicitTransferSyntax     1.2.840.10008.1.2.2
\endverbatim

The \b dcmqrti application does not support extended negotiation.

\subsection configuration Configuration

The \b dcmqrti program uses the same configuration file as the \b dcmqrscp
program.  See the documentation on configuration for more information
(<em>dcmqrcnf.txt</em> and the example configuration file
<em>dcmqrscp.cfg</em>).

\section command_line COMMAND LINE

All command line tools use the following notation for parameters: square
brackets enclose optional values (0-1), three trailing dots indicate that
multiple values are allowed (1-n), a combination of both means 0 to n values.

Command line options are distinguished from parameters by a leading '+' or '-'
sign, respectively.  Usually, order and position of command line options are
arbitrary (i.e. they can appear anywhere).  However, if options are mutually
exclusive the rightmost appearance is used.  This behaviour conforms to the
standard evaluation rules of common Unix shells.

In addition, one or more command files can be specified using an '@' sign as a
prefix to the filename (e.g. <em>\@command.txt</em>).  Such a command argument
is replaced by the content of the corresponding text file (multiple
whitespaces are treated as a single separator) prior to any further
evaluation.  Please note that a command file cannot contain another command
file.  This simple but effective approach allows to summarize common
combinations of options/parameters and avoids longish and confusing command
lines (an example is provided in file <em>share/data/dumppat.txt</em>).

\section environment ENVIRONMENT

The \b dcmqrti utility will attempt to load DICOM data dictionaries specified
in the \e DCMDICTPATH environment variable.  By default, i.e. if the
\e DCMDICTPATH environment variable is not set, the file
<em>\<PREFIX\>/lib/dicom.dic</em> will be loaded unless the dictionary is built
into the application (default for Windows).

The default behaviour should be preferred and the \e DCMDICTPATH environment
variable only used when alternative data dictionaries are required.  The
\e DCMDICTPATH environment variable has the same format as the Unix shell
\e PATH variable in that a colon (":") separates entries.  The data dictionary
code will attempt to load each file specified in the \e DCMDICTPATH
environment variable.  It is an error if no data dictionary can be loaded.

\section files FILES

<em>share/doc/dcmqrcnf.txt</em> - configuration information
\n<em>share/doc/dcmqrset.txt</em> - setup information
\n<em>etc/dcmqrscp.cfg</em> - example configuration file

\section see_also SEE ALSO

<b>dcmqrscp</b>(1)

\section copyright COPYRIGHT

Copyright (C) 1993-2005 by Kuratorium OFFIS e.V., Escherweg 2, 26121 Oldenburg,
Germany.

*/