/*!

\if MANPAGES
\page xml2dsr Convert DICOM SR file and data set to XML
\else
\page xml2dsr xml2dsr: Convert DICOM SR file and data set to XML
\endif

\section synopsis SYNOPSIS

\verbatim
xml2dsr [options] xmlfile-in dsrfile-out
\endverbatim

\section description DESCRIPTION

The \b xml2dsr utility converts the contents of an XML (Extensible Markup
Language) document to DICOM Structured Reporting (SR) format (file format
or raw data set).  The XML Schema <em>dsr2xml.xsd</em> does not yet follow
any standard format.  However, the \b xml2dsr application might be enhanced
in this aspect in the future (e. g. by supporting HL7/CDA - Clinical
Document Architecture).

An appropriate XML file can be created using the \b dsr2xml tool (option
\e +Xn recommended to add XML namespace declaration to the root element).

\section parameters PARAMETERS

\verbatim
xmlfile-in   XML input filename to be converted (stdin: "-")

dsrfile-out  DICOM SR output filename
\endverbatim

\section options OPTIONS

\subsection general_options general options
\verbatim
  -h   --help
         print this help text and exit

       --version
         print version information and exit

       --arguments
         print expanded command line arguments

  -q   --quiet
         quiet mode, print no warnings and errors

  -v   --verbose
         verbose mode, print processing details

  -d   --debug
         debug mode, print debug information

  -ll  --log-level  [l]evel: string constant
         (fatal, error, warn, info, debug, trace)
         use level l for the logger

  -lc  --log-config  [f]ilename: string
         use config file f for the logger
\endverbatim

\subsection input_options input options
\verbatim
encoding:

  +Ee  --template-envelope
         template element encloses content items
\endverbatim

\subsection processing_options processing options
\verbatim
validation:

  +Vs  --validate-schema
         validate XML document against Schema
         (not with --template-envelope)

  +Vn  --check-namespace
         check XML namespace in document root

unique identifiers:

  +Ug  --generate-new-uids
         generate new Study/Series/SOP Instance UID

  -Uo  --dont-overwrite-uids
         do not overwrite existing UIDs (default)

  +Uo  --overwrite-uids
         overwrite existing UIDs
\endverbatim

\subsection output_options output options
\verbatim
output file format:

  +F   --write-file
         write file format (default)

  -F   --write-dataset
         write data set without file meta information

output transfer syntax:

  +t=  --write-xfer-same
         write with same TS as input (default)

  +te  --write-xfer-little
         write with explicit VR little endian TS

  +tb  --write-xfer-big
         write with explicit VR big endian TS

  +ti  --write-xfer-implicit
         write with implicit VR little endian TS

  +td  --write-xfer-deflated
         write with deflated explicit VR little endian TS

post-1993 value representations:

  +u   --enable-new-vr
         enable support for new VRs (UN/UT) (default)

  -u   --disable-new-vr
         disable support for new VRs, convert to OB

group length encoding:

  +g=  --group-length-recalc
         recalculate group lengths if present (default)

  +g   --group-length-create
         always write with group length elements

  -g   --group-length-remove
         always write without group length elements

length encoding in sequences and items:

  +e   --length-explicit
         write with explicit lengths (default)

  -e   --length-undefined
         write with undefined lengths

data set trailing padding (not with --write-dataset):

  -p=  --padding-retain
         do not change padding (default if not --write-dataset)

  -p   --padding-off
         no padding (implicit if --write-dataset)

  +p   --padding-create  [f]ile-pad [i]tem-pad: integer
         align file on multiple of f bytes
         and items on multiple of i bytes

deflate compression level (only with --write-xfer-deflated):

  +cl  --compression-level  [l]evel: integer (default: 6)
         0=uncompressed, 1=fastest, 9=best compression
\endverbatim

\section notes NOTES

\subsection dicom_conformance DICOM Conformance

The \b xml2dsr utility supports the following SOP Classes:

\verbatim
SpectaclePrescriptionReportStorage          1.2.840.10008.5.1.4.1.1.78.6
MacularGridThicknessAndVolumeReportStorage  1.2.840.10008.5.1.4.1.1.79.1
BasicTextSRStorage                          1.2.840.10008.5.1.4.1.1.88.11
EnhancedSRStorage                           1.2.840.10008.5.1.4.1.1.88.22
ComprehensiveSRStorage                      1.2.840.10008.5.1.4.1.1.88.33
ProcedureLogStorage                         1.2.840.10008.5.1.4.1.1.88.40
MammographyCADSRStorage                     1.2.840.10008.5.1.4.1.1.88.50
KeyObjectSelectionDocumentStorage           1.2.840.10008.5.1.4.1.1.88.59
ChestCADSRStorage                           1.2.840.10008.5.1.4.1.1.88.65
XRayRadiationDoseSRStorage                  1.2.840.10008.5.1.4.1.1.88.67
ColonCADSRStorage                           1.2.840.10008.5.1.4.1.1.88.69
ImplantationPlanSRDocumentStorage           1.2.840.10008.5.1.4.1.1.88.70
\endverbatim

Please note that currently only mandatory and some optional attributes are
supported.

\section logging LOGGING

The level of logging output of the various command line tools and underlying
libraries can be specified by the user.  By default, only errors and warnings
are written to the standard error stream.  Using option \e --verbose also
informational messages like processing details are reported.  Option
\e --debug can be used to get more details on the internal activity, e.g. for
debugging purposes.  Other logging levels can be selected using option
\e --log-level.  In \e --quiet mode only fatal errors are reported.  In such
very severe error events, the application will usually terminate.  For more
details on the different logging levels, see documentation of module "oflog".

In case the logging output should be written to file (optionally with logfile
rotation), to syslog (Unix) or the event log (Windows) option \e --log-config
can be used.  This configuration file also allows for directing only certain
messages to a particular output stream and for filtering certain messages
based on the module or application where they are generated.  An example
configuration file is provided in <em>\<etcdir\>/logger.cfg</em>).

\section command_line COMMAND LINE

All command line tools use the following notation for parameters: square
brackets enclose optional values (0-1), three trailing dots indicate that
multiple values are allowed (1-n), a combination of both means 0 to n values.

Command line options are distinguished from parameters by a leading '+' or '-'
sign, respectively.  Usually, order and position of command line options are
arbitrary (i.e. they can appear anywhere).  However, if options are mutually
exclusive the rightmost appearance is used.  This behaviour conforms to the
standard evaluation rules of common Unix shells.

In addition, one or more command files can be specified using an '@' sign as a
prefix to the filename (e.g. <em>\@command.txt</em>).  Such a command argument
is replaced by the content of the corresponding text file (multiple
whitespaces are treated as a single separator unless they appear between two
quotation marks) prior to any further evaluation.  Please note that a command
file cannot contain another command file.  This simple but effective approach
allows to summarize common combinations of options/parameters and avoids
longish and confusing command lines (an example is provided in file
<em>\<datadir\>/dumppat.txt</em>).

\section environment ENVIRONMENT

The \b xml2dsr utility will attempt to load DICOM data dictionaries specified
in the \e DCMDICTPATH environment variable.  By default, i.e. if the
\e DCMDICTPATH environment variable is not set, the file
<em>\<datadir\>/dicom.dic</em> will be loaded unless the dictionary is built
into the application (default for Windows).

The default behaviour should be preferred and the \e DCMDICTPATH environment
variable only used when alternative data dictionaries are required.  The
\e DCMDICTPATH environment variable has the same format as the Unix shell
\e PATH variable in that a colon (":") separates entries.  On Windows systems,
a semicolon (";") is used as a separator.  The data dictionary code will
attempt to load each file specified in the \e DCMDICTPATH environment variable.
It is an error if no data dictionary can be loaded.

\section files FILES

<em>\<datadir\>/dsr2xml.xsd</em> - XML Schema file

\section see_also SEE ALSO

<b>dsr2xml</b>(1)

\section copyright COPYRIGHT

Copyright (C) 2003-2010 by OFFIS e.V., Escherweg 2, 26121 Oldenburg, Germany.

*/
