/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * md_db.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: md_db.h,v 1.4 2003/12/28 08:12:38 uid68112 Exp $
*/

#ifndef __MD_DB_H__
#define __MD_DB_H__

#ifdef WITH_GCRYPT
#include <gcrypt.h>
#ifndef MD4_DIGEST_LENGTH
#define MD4_DIGEST_LENGTH 16
#endif
#else
#include <openssl/md4.h>
#endif

#define RECORD_BUSY 0x8000000

/* for CONST and VAR data */
#define HAS_A_BUSY_FLAG(x)  (((x)&RECORD_BUSY)!=0)

/* only for MDDB_CONST data */
#define IS_A_BUSY_RECORD(x)	HAS_A_BUSY_FLAG(x->flags)

/* only for VAR data */
#define TRUE_SIZE(x)		((x)&0x00FFFFFF)

/***************************************************/
/* structure of a record of the constant data file */
/***************************************************/
typedef struct
{
	guint32 flags;		/* misc flags */
	guint64 filesize;	/* size of the file */
	guint8 global_crc[MD4_DIGEST_LENGTH];	/* ed2k CRC of the file */
	off_t fname_offset;	/* offset in var data file of the record containing the filename */
	off_t l0_crc_offset;/* offset in var data file of the record containing the L0 CRC */
} MDDB_CONST_DATA;

/**********************************************/
/* structure of a record in the var data file */
/**********************************************/
/* 1 guint32: size of data                   */
/*    if MSB (0x80000000) is set, the record */
/*    is busy. The MSByte is reserved        */
/* n guint8: the data                        */
/*********************************************/

/* -------------------------------------------------------------------------- */
/************************/
/* initialize the MD db */
/***************************/
/* output: 0=ok, !=0=error */
/***************************/
int init_md_db(const char *db_file_name);

/*******************************/
/* add a MD entry to the MD db */
/***************************************************************/
/* g_crc is the file global CRC (MD_BLOC_SIZE bytes)           */
/* l_crc is the set of partial CRC (nb_seg*MD_BLOC_SIZE bytes) */
/***************************************************************/
/* output: 0=already in db, 1=added, -1=error */
/**********************************************/
int md4_add(const guint8 *g_crc, const guint32 file_length, const guint8 *l_crc, const guint32 nb_seg, const char *filename);

typedef struct
{
	guint64 filesize;
	guint8 global_crc[MD4_DIGEST_LENGTH];
	char *filename;
	guint32 nb_seg;
	guint8 *partial_crc;	/* = nb_seg*MD4_DIGEST_LENGTH */
} MD_INFO;

/************************************************************************/
/* search and return info on a MD entry having the provided information */
/************************************************************************/
MD_INFO *get_md4(const guint8 *g_crc, const guint32 file_length);

/**************************************************************/
/* free a MD_INFO structure returned by the previous function */
/**************************************************************/
void free_md_info(MD_INFO *nfo);

/*************************************************************/
/* search if a filename:file_length is already inside the db */
/*************************************************************/
gboolean md4_is_inside(const guint32 file_length, const char *filename);

#endif
