/* DCTC - a Direct Connect text clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * userinfo.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: userinfo.h,v 1.3 2003/12/28 08:12:38 uid68112 Exp $
*/

#ifndef __USERINFO_H__
#define __USERINFO_H__

#include "userinfoT.h"

/****************************************************************************************************************/
/* these functions handles management of user informations stored in the file $HOME/.dctc/running/xxxx-userinfo */
/****************************************************************************************************************/
void uinfo_create(const char *filename);
void uinfo_update_user_info(const char *nickname, const char *usize, const char *utype, const unsigned char uflag, const char *uemail, const char *udesc, const int is_op, const int is_online);
void uinfo_reset_user_info(const char *nickname, gboolean is_op, gboolean is_online);
void uinfo_delete_user_info(const char *nickname);
void uinfo_delete(void);
void uinfo_delete_users(void);

#endif
