/* -*- Mode: C++; c-file-style: "stroustrup"; indent-tabs-mode: nil -*- */
/*
 * Validate.h
 *   Header file for the Validate class.
 *
 * $Id: Validate.h,v 1.11 2002/03/30 22:21:17 benoit Exp $
 *
 * Copyright (c) 2000 Remi Lefebvre <remi@dhis.net>
 *                and Luca Filipozzi <lfilipoz@dhis.net>
 *                and Benoit Joly <benoit@dhis.net>
 *
 * Licensed under the GPLv2
 */

#ifndef VALIDATE_H
#define VALIDATE_H

#include <sys/types.h>
#include <regexx.hh>

#include <fstream>

#include "DdtManager.h"

using namespace regexx;

class Validate
{
public:
    Validate(const char *bannedHostFileName, const char *reservedHostFileName);
    ~Validate ();

    // FIXME: no check to prevent stealing subdomains
      
    bool isThirdLevelDomain(const char *domain);
    bool isValidDomain(const char *domain, const char *baseDomain);
    bool isValidDomain(const char *domain);
    bool isBannedDomain(const char *domain);
    bool isReservedDomain(const char *domain);
    bool email(const char *email, const char *baseDomain);
    bool name(const char *name);
    bool ip(const char *ip);
          
    // check validity of a record request
    bool recordAdd (DdtManager *manager, int id, const char *dname, 
                    DnsRecordType type, const char *data, 
                    const char *baseDomain);
protected:
    Validate () { /* intentionally empty */ };

private:
    Regexx *rxx;
    char *bannedHostFileName;
    char *reservedHostFileName;
};
#endif // VALIDATE_H
