/* -*- Mode: C++; c-file-style: "stroustrup"; indent-tabs-mode: nil -*- */
/*
 * Thread.cc
 *
 * $Id: Thread.cc,v 1.4 2003/04/24 04:44:56 benoit Exp $
 *
 * Copyright (c) 2000 Benoit Joly <benoit@dhis.net>
 *
 * DDT comes with ABSOLUTELY NO WARRANTY and is licenced under the
 * GNU General Public License (version 2 or later). This license
 * can be retrieved from http://www.gnu.org/copyleft/gnu.html.
 *
 */

#include <pthread.h>
#include <time.h>
#include <iostream>

#include "Thread.h"
#include "Exception.h"

Thread::Thread () : a_arguments (NULL), a_thread (0), a_isAlive (false)
{

}

Thread::Thread (void *i_arguments) : a_arguments(i_arguments), a_thread (0),
                                     a_isAlive (false)
{

}

Thread::~Thread ()
{
    if (a_isAlive == true)
    {
        cancel();
    }
}

void Thread::start ()
{
    // Create a system thread,
    if (pthread_create (&a_thread, NULL, dispatchStart, this) == 0)
    {
        a_isAlive = true;
    }
    else
    {
        throw DdtException ("Cannot create thread.");
    }
}

void Thread::join (Thread *i_thread)
{
    pthread_join (((int) i_thread->getThreadID ()), NULL);
}

void Thread::detach (Thread *i_thread)
{
    pthread_detach ((int)(i_thread->getThreadID ()));
}

void Thread::cancel ()
{
    a_protectCancel.lock ();
    pthread_cancel ((int)(getThreadID ()));
    pthread_join (this->a_thread, NULL);
    a_protectCancel.unlock ();
}

int Thread::getThreadID ()
{
    return (int) (this->a_thread);
}

void *Thread::run (void *i_arg)
{
    return NULL;
}

void Thread::setIsAlive (bool i_isAlive)
{
    a_isAlive = i_isAlive;
}

bool Thread::isAlive ()
{
    return a_isAlive;
}

void Thread::cleanUpDispatch (void *obj)
{
    ((Thread *)obj)->cleanUp ();
    return;
}


void *Thread::dispatchStart (void *obj)
{ 
    pthread_cleanup_push (cleanUpDispatch, obj);
    
    ((Thread *)obj)->run(((Thread *)obj)->a_arguments);
    
    ((Thread *)obj)->setIsAlive(false);
    pthread_cleanup_pop (1);
    pthread_exit (NULL);
    return NULL;    
}


void Thread::sleepInSecond (double i_second)
{
    timespec l_time;

    l_time.tv_sec = 0;
    l_time.tv_nsec = 0;
    
    if (i_second >= 1)
    {
        l_time.tv_sec = (time_t) i_second;
    }
    
    if ((i_second - (long) i_second) > 0)
    {
        l_time.tv_nsec = (long) (((i_second - (long) i_second))  * 1000000000);
    }

    nanosleep ((const timespec *) &l_time, NULL);
}

/*
void Thread::cleanUp () {}
*/
