package com.tildemh.debbug;

import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.Vector;

/**
 * Contains bug listings for a particular package, source package, pseudo
 * package, or maintainer.
 *
 * <p>Note: Listings are now supposed to be singly instantiable. Do not try to
 * create two similar listings. Instead, obtain listings using the BTS class. If
 * you don't, all sorts of problems might happen.
 * 
 * <p>Note: this class was formerly called Package, but renamed due to name
 * conflict. Many places will refer to it as Package.
 *
 * <p>This is released under the terms of the GNU Lesser General Public License
 * (LGPL). See the COPYING file for details.
 *
 * @version $Id: Listing.java,v 1.38 2004/06/29 12:04:46 mh Exp $
 * @author &copy; Mark Howard &lt;mh@debian.org&gt; 2002
 */
public class Listing extends ListingStub implements java.io.Serializable {


	public Listing(){
	listeners = new Vector ();
	}
	private static final boolean DEBUG = false;

	private Long lastSync = new Long (-1);	// Date when record last checked.

	// Bugs in this listing with dates
	private Hashtable bugs;

	// count variables
		private volatile int countAll = 0; private volatile int countUnreadAll = 0;
		private volatile int countRC = 0; private volatile int countUnreadRC = 0;
		private volatile int countIN = 0; private volatile int countUnreadIN = 0;
		private volatile int countMW = 0; private volatile int countUnreadMW = 0;
		private volatile int countFP = 0; private volatile int countUnreadFP = 0;

	private boolean complete = false;
	// false if list has never been fully constructed from the website

	 public boolean getComplete () { return complete; }

	/**
	 * Constructs a new listing WARNING: Do not do this! it will mess things up.
	 * Use the BTS class to obtain listings.
	 */
	public static Listing makeListing (ListingStub stub) {
		return new Listing (stub.getType (), stub.getName ());
	}

	private Listing (ListingType type, String name) {
		super (type, name);
		Cache.getInstance ().store (this);
	}

	public synchronized Hashtable getBugs () {
		return bugs;
	}


	// get counts
		public synchronized int getAllUnreadCount () { return countUnreadAll; }
		public synchronized int getRCUnreadCount () { return countUnreadRC; }
		public synchronized int getINUnreadCount () { return countUnreadIN; }
		public synchronized int getMWUnreadCount () { return countUnreadMW; }
		public synchronized int getFPUnreadCount () { return countUnreadFP; }
		public synchronized int getAllCount () { return countAll; }
		public synchronized int getRCCount () { return countRC; }
		public synchronized int getINCount () { return countIN; }
		public synchronized int getMWCount () { return countMW; }
		public synchronized int getFPCount () { return countFP; }

	/** List of objects interested in events from this listing */
	private transient Vector listeners = new Vector ();

	/**
	 * Give us a way to locate a specific listener in a Vector.
	* @param list The Vector of listeners to search.
	* @param listener The object that is to be located in the Vector.
	* @return Returns the index of the listener in the Vector, or -1 if
	*                 the listener is not contained in the Vector.
	 */
	protected static int findListener (Vector list, Object listener) {
		if (null == list || null == listener)
			return -1;
		return list.indexOf (listener);
	}
	/**
	 * Register an object to receive notification of events on this object
	 */
	public synchronized void addListener (ListingListener listener) {
		if (DEBUG)
			System.out.println ("^^^Listing: Adding listener " + listing +
								"  old count = " +
								((listeners ==
								  null) ? "null" : listeners.size () +
								 ""));
		// Don't add the listener a second time if it is in the Vector.
		int i = findListener (listeners, listener);
		if (listeners == null)
			listeners = new Vector ();
		if (i == -1) {
			listeners.addElement (listener);
		}
		if (DEBUG)
			System.out.println ("^^^ListingListener added. New count: " +
								listeners.size ());
	}

	/**
	 * Unregister an object that was receiving event notification.
	 * 
	 * @param listener The object that is to no longer receive
	 */
	public synchronized void removeListener (ListingListener listener) {
		if (DEBUG)
			System.out.println ("^^^Listing: Removing listener " +
								listing);
		int i = findListener (listeners, listener);
		if (DEBUG)
			System.out.println ("^^^Listing: Removing listener " + i);
		if (i > -1)
			listeners.remove (i);
	}

	private boolean interrupted () {
		if (!Thread.interrupted ())
			return false;
		for (int i = listeners.size (); i > 0; i--)
			((ListingListener) listeners.elementAt (i - 1)).
				listingException (this, new InterruptedException ());
		return true;
	}

	/**
	 * Thread which is updating the listing
	 */
	private volatile transient Thread updatingThread = null;

	/**
	 * Downloads an updated version of the listing from the server and downloads
	 * any bug reports which are of a newer version on the server.
	 * <p>To obtain progress information about this update, attach a {@link
	 * ListingListener} to this object.
	 */
	public void update () {
		if (DEBUG)
			System.out.println (System.currentTimeMillis () +
								" downloading listing");

		if (Thread.currentThread() == BTS.GUITHREAD ){
			throw new RuntimeException("Trying to update in main thread");
		}
					
		// Exit if another thread is currently updating this listing
		if (updatingThread != null
			&& updatingThread != Thread.currentThread ()) {
			if (DEBUG)
				System.out.
					println
					("Another thread is already downloading the listing - exiting");
			return;
		}
		updatingThread = Thread.currentThread ();

		if (interrupted ()) {
			updatingThread = null;
			return;
		}
		for (int i = listeners.size (); i > 0; i--)
			((ListingListener) listeners.elementAt (i - 1)).
				listingUpdateStart (this);

		if (interrupted ()) {
			updatingThread = null;
			return;
		}
		if (DEBUG)
			System.out.println ("type.makeURL " + listing);
		if (DEBUG)
			System.out.println (type.toString ());
		String sourcePage = type.makeURL (listing);
		if (DEBUG)
			System.out.println ("DEBUG: downloading listing: " +
								sourcePage);
		if (interrupted ()) {
			updatingThread = null;
			return;
		}

		URL url = null;
		StringBuffer htmlPage = new StringBuffer ();
		try {
			url = new URL (sourcePage);
			if (interrupted ()) {
				updatingThread = null;
				return;
			}

			InputStream in = url.openStream ();
			if (interrupted ()) {
				updatingThread = null;
				return;
			}

			int ch = 0;
			long count = 0;
			while ((ch = in.read ()) != -1) {
				count--;
				if (interrupted ()) {
					updatingThread = null;
					return;
				}
				htmlPage.append ((char) ch);
				if (count <= 0) {
					count = 100;
					for (int i = listeners.size (); i > 0; i--)
						((ListingListener) listeners.elementAt (i - 1)).
							downloadingListing (this);
				}
			}
			if (DEBUG)
				System.out.println (System.currentTimeMillis () +
									"Listing downloaded");

			for (int i = listeners.size (); i > 0; i--)
				((ListingListener) listeners.elementAt (i - 1)).
					interpretingListing (this);
			if (interrupted ()) {
				updatingThread = null;
				return;
			}


		}
		catch (java.net.UnknownHostException e) {
			for (int i = listeners.size (); i > 0; i--)
				((ListingListener) listeners.elementAt (i - 1)).
					listingException (this, e);
			return;
		} catch (Exception e) {
			for (int i = listeners.size (); i > 0; i--)
				((ListingListener) listeners.elementAt (i - 1)).
					listingException (this, e);
			return;
		}
		String source = htmlPage.toString ();
		String pageHeader = "<NUMBER>, <LAST MODIFIED>, ";
		if (interrupted ()) {
			updatingThread = null;
			return;
		}

		if (DEBUG)
			System.out.println (System.currentTimeMillis () +
								" make listing");
		if (source.indexOf ("Error") >= 0) {
			for (int i = listeners.size (); i > 0; i--)
				((ListingListener) listeners.elementAt (i - 1)).
					listingException (this, new ListingNotFound ());
			return;
		}
		if (interrupted ()) {
			updatingThread = null;
			return;
		}

		Hashtable newBugList = new Hashtable ();

		StringTokenizer st = new StringTokenizer (source, "\n");
		if (!st.hasMoreTokens ()) {
			(new Exception ()).printStackTrace ();
			for (int i = listeners.size (); i > 0; i--)
				((ListingListener) listeners.elementAt (i - 1)).
					listingException (this,
									  new
									  ListingNotFound ("Empty web page!"));
			return;
		} else {
			String next = st.nextToken ();
			if (!next.equals (pageHeader)) {
				(new Exception ()).printStackTrace ();
				for (int i = listeners.size (); i > 0; i--)
					((ListingListener) listeners.elementAt (i - 1)).
						listingException (this,
										  new ListingNotFound ("Expected "
															   +
															   pageHeader +
															   ", found \""
															   + next +
															   "\"."));
				return;
			}
		}
		if (interrupted ()) {
			updatingThread = null;
			return;
		}

		parsePage( st, newBugList );
		
		addBugs( newBugList );

		if (DEBUG)
			System.out.println (System.currentTimeMillis () +
								" done making listing");
		complete = true;
		Cache.getInstance ().store (this);

		for (int i = listeners.size (); i > 0; i--)
			((ListingListener) listeners.elementAt (i - 1)).
				listingUpdateDone (this);
		updatingThread = null;
	}

	private void parsePage( StringTokenizer st, Hashtable newBugList ){
		long notify = System.currentTimeMillis ();
		while (st.hasMoreTokens ()) {
			if (interrupted ()) {
				updatingThread = null;
				return;
			}

			if (System.currentTimeMillis () - notify > 50) {
				for (int i = listeners.size (); i > 0; i--)
					((ListingListener) listeners.elementAt (i - 1)).
						interpretingListing (this);
				notify = System.currentTimeMillis ();
			}
			String s = st.nextToken ();
			int firstComma = s.indexOf (", ");
			String bug = s.substring (0, firstComma);
			String lastMod = s.substring (firstComma + 2,
										  s.indexOf (",",
													 firstComma + 2));
			if (DEBUG)
				System.out.println ("Adding bug (" + bug + "," + lastMod +
									")");
			try {
				if (interrupted ()) {
					updatingThread = null;
					return;
				}
				newBugList.put (new Integer (bug), new Long (lastMod));
			}
			catch (NumberFormatException e) {
				(new Exception ()).printStackTrace ();
				for (int i = listeners.size (); i > 0; i--)
					((ListingListener) listeners.elementAt (i - 1)).
						listingException (this,
										  new
										  ListingNotFound
										  ("Error parsing listing - unable to parse bug ("
										   + bug + "," + lastMod + ")"));
			}
		}
		
	}

	private void addBugs( Hashtable newBugList ){

		if (interrupted ()) {
			updatingThread = null;
			return;
		}
		// note deletions, changes and additions
		LinkedList changedBugs = new LinkedList ();
		LinkedList addedBugs = new LinkedList ();
		Object[]oldBugs =
			(bugs != null) ? bugs.keySet ().toArray () : new Object[0];
		for (int i = 0; i < oldBugs.length; i++) {
			if (interrupted ()) {
				updatingThread = null;
				return;
			}
			if (!newBugList.containsKey (oldBugs[i])) {
				for (int ij = listeners.size (); ij > 0; ij--)
					((ListingListener) listeners.elementAt (ij - 1)).
						bugRemoved (this, (Integer) oldBugs[i]);
				Bug bug = BTS.getInstance ().getBug ((Integer) oldBugs[i]);
				removeBug (bug);
				if (interrupted ()) {
					updatingThread = null;
					return;
				}
			} else if (((Long) newBugList.get (oldBugs[i])).
					   compareTo (bugs.get (oldBugs[i])) > 0) {
				changedBugs.add (oldBugs[i]);
			} else {
				// bug has not changed - note that in the bug.
				Bug bug = BTS.getInstance ().getBug ((Integer) oldBugs[i]);
				bug.setUpdated ();
				Cache.getInstance ().store (bug);
			}
		}
		Object[]newBugs = newBugList.keySet ().toArray ();
		for (int i = 0; i < newBugs.length; i++) {
			if (interrupted ()) {
				updatingThread = null;
				return;
			}
			if (bugs == null || !bugs.containsKey (newBugs[i])) {
				if (DEBUG)
					System.out.println ("Adding added bug");
				addedBugs.add (newBugs[i]);
			}
		}

		// fetch modified and new reports.
		int total = changedBugs.size () + addedBugs.size ();
		if (DEBUG)
			System.out.println ("Total=" + total);
		int done = 0;
		while ((changedBugs.size () > 0) || (addedBugs.size () > 0)) {
			if (interrupted ()) {
				updatingThread = null;
				return;
			}
			if (DEBUG)
				System.out.println ("While loop");
			done++;
			Integer bugnumber;
			if (changedBugs.size () > 0) {
				bugnumber = (Integer) changedBugs.removeFirst ();
				for (int i = listeners.size (); i > 0; i--)
					((ListingListener) listeners.elementAt (i - 1)).
						downloadingListingBug (this, bugnumber, done,
											   total);
				Bug bug = BTS.getInstance ().getBug (bugnumber);
				bug.addListing ((ListingStub) this);	// should be there 
				// already. do this just in case
				try {
					if (DEBUG)
						System.out.
							println ("Incomplete bug - downloading 1");
					if (interrupted ()) {
						updatingThread = null;
						return;
					}
					bug.update ();
				}
				catch (Exception e) {
					// TODO
					e.printStackTrace ();
					if (!listingException (e)) {
						updatingThread = null;
						return;
						// todo
					}
				}
			} else {
				// we're dealing with an added bug
				if (interrupted ()) {
					updatingThread = null;
					return;
				}
				bugnumber = (Integer) addedBugs.removeFirst ();
				for (int i = listeners.size (); i > 0; i--)
					((ListingListener) listeners.elementAt (i - 1)).
						downloadingListingBug (this, bugnumber, done,
											   total);
				Bug bug = BTS.getInstance ().getBug (bugnumber);
				if (bug.getComplete () == false)
					try {
					if (interrupted ()) {
						updatingThread = null;
						return;
					}
					if (DEBUG)
						System.out.
							println ("Incomplete bug - downloading 2");
					bug.update ();
					}
				catch (Exception e) {
					// TODO
					e.printStackTrace ();
					newBugList.remove (bugnumber);
					if (DEBUG)
						System.err.println ("ERROR updating bug #" +
											bugnumber);
					if (!listingException (e)) {
						// TODO
						e.printStackTrace ();
						updatingThread = null;
						return;
					}
				}
				bug.addListing ((ListingStub) this);

				addCount( bug.getStatus(), bug.getSeverity(), bug.getTagFixed () || bug.getTagPending () );

				for (int i = listeners.size (); i > 0; i--)
					((ListingListener) listeners.elementAt (i - 1)).
						bugAdded (this, bug);
				for (int i = listeners.size (); i > 0; i--)
					((ListingListener) listeners.elementAt (i - 1)).
						bugCountsChanged (this);
			}
		}

		bugs = newBugList;

		// Catch case when there are no bugs in the report - otherwise
		// watched
		// list would still show ?
		for (int i = listeners.size (); i > 0; i--)
			((ListingListener) listeners.elementAt (i - 1)).
				bugCountsChanged (this);

		return;
	}

	private void removeBug (Bug bug) {
		bug.removeListing ((ListingStub) this);
		
		removeCount( bug.getStatus(), bug.getSeverity(), bug.getTagFixed () || bug.getTagPending () );

		for (int i = listeners.size (); i > 0; i--)
			((ListingListener) listeners.elementAt (i - 1)).
				bugCountsChanged (this);
	}


	/**
	 * Loads all the reports into memory setting listeners and calls bugAdded
	 * events for each
	 */
	public void loadReports () {
		Object[]bugNumber = bugs.keySet ().toArray ();
		
		if (Thread.currentThread() == BTS.GUITHREAD ){
			throw new RuntimeException("Trying to update in main thread");
		}

		for (int i = 0; i < bugNumber.length; i++) {
			Bug bug = BTS.getInstance ().getBug ((Integer) bugNumber[i]);
			for (int j = listeners.size (); j > 0; j--)
				((ListingListener) listeners.elementAt (j - 1)).
					loadingListingBug (this, (Integer) bugNumber[i], i,
										   bugNumber.length);
			if (!bug.getComplete ()) {
				try {
					bug.update ();
				}
				catch (Exception e) {
					e.printStackTrace ();
					// TODO
					continue;
				}
			}
			for (int ij = listeners.size (); ij > 0; ij--)
				((ListingListener) listeners.elementAt (ij - 1)).
					bugAdded (this, bug);
		}
		for (int ij = listeners.size (); ij > 0; ij--)
			((ListingListener) listeners.elementAt (ij - 1)).
				loadReportsDone (this);
	}

	/**
	 * returns true if exe should continue, false otherwise.
	 */
	private boolean listingException (Exception e) {
		for (int i = listeners.size (); i > 0; i--) {
			if (!((ListingListener) listeners.elementAt (i - 1)).
				listingException (this, e)) {
				return false;
			}
		}
		return true;
	}


	// /// Handling BugListener events

	/**
	 * Called whenever the read/unread status of <code>bug</code> changes.
	 */
	public void bugStatusChanged (Bug bug, Status oldStatus) {
		if (bug.getStatus ().equals (oldStatus))
			return;
		// Add bug with new status
			addCount( bug.getStatus(), bug.getSeverity(), bug.getTagFixed () || bug.getTagPending () );

		// Remove bug with old status
			removeCount( oldStatus, bug.getSeverity(), bug.getTagFixed () || bug.getTagPending () );

		Cache.getInstance ().store (this);
		if (listeners == null) throw new RuntimeException("listeners is null!");
		for (int i = listeners.size (); i > 0; i--)
			((ListingListener) listeners.elementAt (i - 1)).
				bugChanged (this, bug);
		for (int i = listeners.size (); i > 0; i--)
			((ListingListener) listeners.elementAt (i - 1)).
				bugCountsChanged (this);
	}

	public void bugSeverityChanged (Bug bug, Severity oldseverity) {
		// Add bug at new severity
			addCount( bug.getStatus(), bug.getSeverity(), bug.getTagFixed () || bug.getTagPending () );

		// Remove bug at old severity
			removeCount( bug.getStatus(), oldseverity, bug.getTagFixed () || bug.getTagPending () );

		Cache.getInstance ().store (this);
		for (int i = listeners.size (); i > 0; i--)
			((ListingListener) listeners.elementAt (i - 1)).
				bugChanged (this, bug);
		for (int i = listeners.size (); i > 0; i--)
			((ListingListener) listeners.elementAt (i - 1)).
				bugCountsChanged (this);
	}

	private void addCount( Status status, Severity severity, boolean fixedOrPending ){
		changeCount( status, severity, fixedOrPending, +1 );
	}
	private void removeCount( Status status, Severity severity, boolean fixedOrPending  ){
		changeCount( status, severity, fixedOrPending, -1 );
	}
	private void changeCount( Status status, Severity severity, boolean fixedOrPending , int change ){
		countAll += change;
		if (severity.equals (Severity.CRITICAL)
			|| severity.equals (Severity.GRAVE)
			|| severity.equals (Severity.SERIOUS))
			countRC += change;
		if (severity.equals (Severity.IMPORTANT)
			|| severity.equals (Severity.NORMAL))
			countIN += change;
		if (severity.equals (Severity.MINOR)
			|| severity.equals (Severity.WISHLIST))
			countMW += change;
		if ( fixedOrPending)
			countFP += change;
		if (! status.equals( Status.READ ) ){
			// status == unread
			countUnreadAll += change;
			if (severity.equals (Severity.CRITICAL)
				|| severity.equals (Severity.GRAVE)
				|| severity.equals (Severity.SERIOUS))
				countUnreadRC += change;
			if (severity.equals (Severity.IMPORTANT)
				|| severity.equals (Severity.NORMAL))
				countUnreadIN += change;
			if (severity.equals (Severity.MINOR)
				|| severity.equals (Severity.WISHLIST))
				countUnreadMW += change;
			if ( fixedOrPending)
				countUnreadFP += change;
		}
	}


	/* Unused events from bugs */
	public boolean bugException (Bug bug, Exception e) { return true; } // do anything here??
	public void retrievingBug (Bug bug) { }
	public void bugDownloaded (Bug bug) { }
	public void bugUpdated (Bug bug) {	} // most probably caused by a listing ??

}
