#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "dependency.h"

dependency::dependency(std::string const &spec)
{
	std::string::size_type end_of_name = spec.find_first_of(" (");
	if(end_of_name == std::string::npos)
		end_of_name = spec.length();

	package = spec.substr(0, end_of_name);

	std::string::const_iterator i = spec.begin() + end_of_name;
	while((i != spec.end()) && *i == ' ')
		++i;
	if(i == spec.end())
	{
		op = dontcare;
		return;
	}
	if(*i != '(')
		throw std::invalid_argument("invalid character in dependency spec; '(' expected");
	++i;
	if(i == spec.end())
		throw std::invalid_argument("");
	
	switch(*i)
	{
	case '=':
		op = equal;
		++i;
		break;
	case '>':
		++i;
		if(i == spec.end())
			throw std::invalid_argument("");
		switch(*i)
		{
		case '>':
			op = greaterthan;
			++i;
			break;
		case '=':
			op = greaterorequal;
			++i;
			break;
		default:
			throw std::invalid_argument("");
		}
		break;
	case '<':
		++i;
		if(i == spec.end())
			throw std::invalid_argument("");
		switch(*i)
		{
		case '<':
			op = lessthan;
			++i;
			break;
		case '=':
			op = lessorequal;
			++i;
			break;
		default:
			throw std::invalid_argument("");
		}
		break;
	default:
		throw std::invalid_argument("");
	}

	while((i != spec.end()) && (*i == ' '))
		++i;

	if(i == spec.end())
		throw std::invalid_argument("");
	
	std::string::const_iterator const version_begin = i;

	while((i != spec.end()) && (*i != ')') && (*i != ' '))
		++i;
	
	if(i == spec.end())
		throw std::invalid_argument("");
	
	ver = version(version_begin, i);

	while((i != spec.end()) && (*i == ' '))
		++i;

	if(i == spec.end())
		throw std::invalid_argument("");

	if(*i != ')')
		throw std::invalid_argument("");
	
	++i;

	while((i != spec.end()) && (*i == ' '))
		++i;

	if(i != spec.end())
		throw std::invalid_argument("");

	return;
}

dependency::dependency(std::string const &package, version_op op, version const &ver) :
	package(package),
	op(op),
	ver(ver)
{
	return;
}
