# debpartial-mirror - partial debian mirror package tool
# (c) 2004 Otavio Salvador <otavio@debian.org>, Henrique Vilela <jacare@ucpel.tche.br>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
# $Id$

import md5
import os
import sys

import Package

class LocalPackages:
    def __init__(self, where):
        print 'Processing local packages ...'
        self.__local_packages = {}
        for root, dirs, files in os.walk(where):
            for f in files:
                p=Package.Package(f.split('_')[0])
                p.setFilename(os.path.join(root, f))

                try:
                    file_to_hash = file(p.getFilename(), 'r')
                except IOError, msg:
                    print msg
                    sys.exit(1)

                md5hash = md5.new()
                md5hash.update(file_to_hash.read())
                file_to_hash.close()
                p.setMD5sum(md5hash.hexdigest())

                if not self.__local_packages.has_key(p.getName()):
                    self.__local_packages[p.getName()] = []
                self.__local_packages[p.getName()].append(p)
    def printAll(self):
        for l in self.__local_packages.itervalues():
            for p in l:
                p.printAll()
    def getLocalPackages(self):
        return self.__local_packages
