# debpartial-mirror - partial debian mirror package tool
# (c) 2004 Otavio Salvador <otavio@debian.org>, Henrique Vilela <jacare@ucpel.tche.br>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
# $Id$

class Package:

    def __init__(self, name):
        self.__name = name
        self.__depends = []
        self.__suggests = []
        self.__recomends = []
        self.__provides = []
        self.__filename = ""
        self.__section = ""
        self.__priority = ""
        self.__md5sum = ""
        self.__version = ""
        self.__files = {}

    def getName(self): return self.__name

    def addFile(self, filename, package_file):
        if not self.__files.has_key(filename):
            self.__files[filename] = package_file

    def getFiles(self):
        return self.__files

    def getDepends(self): return self.__depends
    def getSuggests(self): return self.__suggests
    def getRecomends(self): return self.__recomends
    def getProvides(self): return self.__provides
    def getFilename(self): return self.__filename
    def getSection(self): return self.__section
    def getPriority(self): return self.__priority
    def getMD5Sum(self): return self.__md5sum
    def getVersion(self): return self.__version

    def setFilename(self, filename): self.__filename = filename
    def setSection(self, section): self.__section = section
    def setPriority(self, priority): self.__priority = priority
    def setMD5sum(self, md5sum): self.__md5sum = md5sum
    def setVersion(self, version): self.__version = version
    
    def addDepend(self, d):
        if not isinstance(d, list):
            self.__depends.append(d)
        else:
            for i in d:
                self.__depends.append(i)

    def addSuggest(self, s):
        if not isinstance(s, list):
            self.__suggests.append(s)
        else:
            for i in s:
                self.__suggests.append(i)

    def addRecomend(self, r):
        if not isinstance(r, list):
            self.__recomends.append(r)
        else:
            for i in r:
                self.__recomends.append(i)

    def addProvide(self, r):
        if not isinstance(r, list):
            self.__provides.append(r)
        else:
            for i in r:
                self.__provides.append(i)

    def printAll(self):
        print "    Package:   " + self.__name
        print "    Depends:   " + str(self.__depends)
        print "    Suggests:  " + str(self.__suggests)
        print "    Recomends: " + str(self.__recomends)
        print "    Provides:  " + str(self.__provides)
        print "    Section:   " + self.__section
        print "    Priority:  " + self.__priority
        print "    Filename:  " + self.__filename
        print "    MD5sum:    " + self.__md5sum
        print "    Version:   " + self.__version + "\n"
