/** Stack data type.
 * @author Shaun Jackman <sdj@sfu.ca>
 * @copyright 2004 Shaun Jackman
 */


#include <stdlib.h>
#include "stack.h"
#include "util.h"


/** Clears this stack. */
void
clear_stack( Stack* stack)
{
	stack->max = 1;
	stack->count = 0;
	stack->table = allocate_memory( sizeof *stack->table);
}


/** Destroys this stack. */
void
destroy_stack( Stack* stack)
{
	stack->max = stack->count = 0;
	free( stack->table);
}


/** Allots an element on the stack. */
int*
allot_element( Stack* stack)
{
	if( stack->count >= stack->max) {
		stack->max *= 2;
		stack->table = reallocate_memory( stack->table,
				stack->max * sizeof *stack->table);
	}
	return &stack->table[stack->count++];
}
