# -*- coding: utf-8 -*-
#
# Author: Ingelrest François (Athropos@gmail.com)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

import media

from tools             import consts
from mutagen.oggvorbis import OggVorbis, OggVorbisHeaderError


def readInfo(file):
    """
        Read information from an Ogg Vorbis file
    """
    info = [consts.UNKNOWN_TRACKNUMBER, consts.UNKNOWN_TITLE, consts.UNKNOWN_ARTIST, consts.UNKNOWN_ALBUM, consts.UNKNOWN_LENGTH, file]

    try:
        oggFile = OggVorbis(file)
    except OggVorbisHeaderError:
        return info

    if 'title'       in oggFile: info[media.NFO_TIT] = oggFile['title'][0]
    if 'album'       in oggFile: info[media.NFO_ALB] = oggFile['album'][0]
    if 'artist'      in oggFile: info[media.NFO_ART] = oggFile['artist'][0]
    if 'tracknumber' in oggFile: info[media.NFO_NUM] = int(oggFile['tracknumber'][0])

    info[media.NFO_LEN] = int(oggFile.info.length)

    return info
