# -*- coding: utf-8 -*-
#
# Author: Ingelrest François (Athropos@gmail.com)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

import gtk, gtk.gdk, os.path

from gettext import gettext as _


appVersion   = '0.05.2'
appName      = 'Decibel Audio Player'
appNameShort = 'decibel-audio-player'

urlMain = 'http://decibel.silent-blade.org'
urlHelp = 'http://decibel.silent-blade.org/index.php?n=Main.Help'

dirUsr = os.path.expanduser('~')
dirSrc = os.path.join(os.path.dirname(__file__))
dirRes = os.path.join(dirSrc, '..', '..', 'res')
dirDoc = os.path.join(dirSrc, '..', '..', 'doc')
dirCfg = os.path.join(dirUsr, '.' + appNameShort)
dirPix = os.path.join(dirSrc, '..', '..', 'pix')

dirLocale = os.path.join(dirSrc, '..', '..', 'locale')
if not os.path.isdir(dirLocale) :
    dirLocale = os.path.join(dirSrc, '..', '..', '..', 'locale')


filePrefs    = os.path.join(dirCfg, 'prefs.txt')
fileLicense  = os.path.join(dirDoc, 'LICENCE')
fileImgIcon  = os.path.join(dirPix, 'decibel-audio-player-16.png')
fileImgAbout = os.path.join(dirPix, 'decibel-audio-player-128.png')


# Some constants for track fields
UNKNOWN_TITLE       = _('No title')
UNKNOWN_ALBUM       = _('No album')
UNKNOWN_ARTIST      = _('No artist')
UNKNOWN_LENGTH      = 0
UNKNOWN_TRACKNUMBER = 0


# The stock icons used in this app
tmpLbl       = gtk.Label()
icoDir       = tmpLbl.render_icon(gtk.STOCK_DIRECTORY,   gtk.ICON_SIZE_MENU)
icoPlay      = tmpLbl.render_icon(gtk.STOCK_MEDIA_PLAY,  gtk.ICON_SIZE_MENU)
icoPause     = tmpLbl.render_icon(gtk.STOCK_MEDIA_PAUSE, gtk.ICON_SIZE_MENU)
icoCdrom     = tmpLbl.render_icon(gtk.STOCK_CDROM,       gtk.ICON_SIZE_MENU)
icoMediaDir  = tmpLbl.render_icon(gtk.STOCK_DIRECTORY,   gtk.ICON_SIZE_MENU).copy()  # We need a copy to modify it
icoMediaFile = tmpLbl.render_icon(gtk.STOCK_FILE,        gtk.ICON_SIZE_MENU).copy()  # We need a copy to modify it

icoCdrom.composite(icoMediaFile, 5, 5, 11, 11, 5, 5, 0.6875, 0.6875, gtk.gdk.INTERP_HYPER, 255)
icoCdrom.composite(icoMediaDir,  5, 5, 11, 11, 5, 5, 0.6875, 0.6875, gtk.gdk.INTERP_HYPER, 255)

# Button size
icoBtnPrefs = tmpLbl.render_icon(gtk.STOCK_PREFERENCES, gtk.ICON_SIZE_BUTTON)

# Blank icon
icoNull = gtk.gdk.Pixbuf(gtk.gdk.COLORSPACE_RGB, True, 8, 16, 16)
icoNull.fill(0x00000000)


# Create the configuration directory if needed
if not os.path.isdir(dirCfg) :
    os.mkdir(dirCfg)
