/*
 * A Decibel Demo
 * Copyright (C) 2006 by basyskom GmbH
 *  @author Tobias Hunger <info@basyskom.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <QtCore/QCoreApplication>
#include <QtCore/QDebug>

#include <QtDBus/QDBusConnection>
#include <QtDBus/QDBusMetaType>

#include <Decibel/Types>
#include <Decibel/DBusNames>
#include <Decibel/ContactManager>

#include "mytextchannelhandler.h"

namespace
{
    static const QString application_name("simpleclient");
}

int main(int argc, char ** argv)
{
    QCoreApplication app(argc, argv);
    app.setOrganizationName(Decibel::organisation_name);
    app.setApplicationName(application_name);

    MyTextChannelHandler handler(&app);

    Decibel::registerTypes();

    // register on D-BUS:
    QDBusConnection::sessionBus().registerService(Decibel::organisation_name + '.' +
                                                  application_name);
    QDBusConnection::sessionBus().registerObject(Decibel::channelhandler_path,
                                                 &handler);

    return app.exec();
}

