/*
 * the Decibel Realtime Communication Framework
 * Copyright (C) 2006 by basyskom GmbH
 *  @author Tobias Hunger <info@basyskom.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef _DECIBEL_ERRORS_H_
#define _DECIBEL_ERRORS_H_

namespace Decibel
{
    /** The list of Name Value Pairs given is empty */
    const int ERROR_EMPTY_LIST(-1);
    /** A list of Name Value Pairs describing a account does not give
     * any indication for which protocol this account is valid for. */
    const int ERROR_NO_PROTOCOL(-2);
    /** A value of the Name Value Pair named "protocol" is not a string. */
    const int ERROR_WRONG_VALUE_TYPE_FOR_PROTOCOL(-3);
    /** A list of Name Value Pairs contains duplicate settings. */
    const int ERROR_DUPLICATE_NAME(-4);

    /** A account was given that does not exist in Decibel. */
    const int ERROR_NO_SUCH_ACCOUNT(-5);
    /** A connection was requested using a protocol that is not supported. */
    const int ERROR_PROTOCOL_NOT_SUPPORTED(-6);

    /** The connection manager requested failed to start. */
    const int ERROR_FAILED_TO_START_CONNECTION_MANAGER(-7);

    /** A required parameter for a connection manager was not given.*/
    const int ERROR_REQUIRED_PARAMETER_MISSING(-8);

    /** The connection manager failed to bring up a connection. */
    const int ERROR_FAILED_TO_CREATE_CONNECTION(-9);

    /** A invalid presence type was given. */
    const int ERROR_INVALID_PRESENCE(-10);

    /** Failed to update presence information */
    const int ERROR_FAILED_TO_UPDATE_PRESENCE_INFORMATION(-11);

    /** Connection not found. */
    const int ERROR_NO_SUCH_CONNECTION(-12);
} // namespace

#endif
