/*
 * A Decibel Demo
 * Copyright (C) 2006 by basyskom GmbH
 *  @author Tobias Hunger <info@basyskom.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef DEMO_SIMPLECLIENT_MYTEXTCHANNELHANDLER_H
#define DEMO_SIMPLECLIENT_MYTEXTCHANNELHANDLER_H

#include <Decibel/ChannelHandler>

#include <QtTapioca/TextChannel>

/**
 * @brief The demos' ChannelHandler.
 * @author Tobias Hunger <info@basyskom.de>
 */
class MyTextChannelHandler : public Decibel::ChannelHandler
{
    Q_OBJECT

public:
    /** @brief Constructor. */
    explicit MyTextChannelHandler(QObject * parent = 0);
    /** @brief Destructor. */
    ~MyTextChannelHandler();

    /** @brief A implementation of the ChannelHandler interface's only method. */
    bool handleChannel(QtTapioca::Connection *, QtTapioca::Channel *);

public slots:

    /** @brief Called when a new text message was received on our channel. */
    void onMessageReceived();
    /** @brief Called when our channel is closed. */
    void onCloseChannel();

private:
    /** @brief A pointer to our Connection. */
    QtTapioca::Connection *  m_connection;
    /** @brief A pointer to our Channel. */
    QtTapioca::TextChannel * m_channel;
};

#endif
