/*
 * A Decibel Demo
 * Copyright (C) 2006 by basyskom GmbH
 *  @author Tobias Hunger <info@basyskom.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <QtCore/QStringList>
#include <QtCore/QDebug>
#include <QtCore/QCoreApplication>
#include <QtDBus/QDBusConnection>

#include <Decibel/ProtocolManager>
#include <Decibel/DBusNames>

// Simplistic demo to set the default connection manager for
// the given protocol.
// Usage: $0 protocol cm_name

int main(int argc, char ** argv)
{
    QCoreApplication app(argc, argv);
    Q_ASSERT(argc == 3);

    QString protocol(argv[1]);
    QString cm_name(argv[2]);

    // Connect to session bus:
    if (!QDBusConnection::sessionBus().isConnected())
    {
        qDebug("Cannot connect to the D-BUS session bus.\n"
               "To start it, run:\n"
               "\teval `dbus-launch --auto-syntax`\n");
        return 1;
    }

    // Register custom types:
    Decibel::registerTypes();

    // connect to the Decibel daemon:
    de::basyskom::Decibel::ProtocolManager
    protocol_mgr(Decibel::daemon_service, Decibel::daemon_protocolmanager_path,
                 QDBusConnection::sessionBus(), &app);

    QDBusReply<bool> reply = protocol_mgr.setDefaultConnectionManagerForProtocol(protocol,
                                                                                 cm_name);
    if(!reply.isValid())
    {
            QDBusError error = reply.error();
            qDebug() << "DBus Error while setting default Connection Manager:"
                     << error.type() << ":"
                     << error.message();
            return 3;
    }

    qDebug() << reply.value();

    return 0;
}
