/*
 * the Decibel Realtime Communication Framework
 * Copyright (C) 2006 by basyskom GmbH
 *  @author Tobias Hunger <tobias.hunger@basyskom.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef _DECIBEL_DAEMON_KDE4_CONTACTCONNECTOR_H
#define _DECIBEL_DAEMON_KDE4_CONTACTCONNECTOR_H

#include <contactconnectorbase.h>

#include <QtCore/QList>
#include <QtCore/QVariantMap>

/**
 * @brief This is a implementation of the ContactConnector interface.
 *
 * A simplistic ContactConnector: It reads its data from a QSettings object!
 *
 * @author Tobias Hunger <info@basyskom.de>
 */
class ContactConnector : public ContactConnectorBase
{
public:
    /** @brief Constructor. */
    ContactConnector();

    /** @brief Destructor. */
    ~ContactConnector();

    /** @brief ContactConnector::gotContact(...) */
    bool gotContact(const uint &) const;

    /** @brief ContactConnector::contact(...) */
    QVariantMap contact(const uint &) const;

    /** @brief ContactConnector::findURI(...) */
    unsigned int findURI(const QString &) const;

    /** @brief ContactConnector::getURI(...) */
    QStringList getURIs(const uint & contact_id,
                        const QString & proto) const;

    /** @brief ContactConnector::addContact(...) */
    unsigned int addContact(const QVariantMap &);

    /** @brief ContactConnector::setPresence(...) */
    void setPresence(const uint &,
                     const QtTapioca::ContactBase::Presence,
                     const QString &);

private:
    /** @brief A list of known contacts (as read from our INI file). */
    QList<QVariantMap> m_contacts;
};

#endif
