/*
 * the Decibel Realtime Communication Framework
 * Copyright (C) 2006 by basyskom GmbH
 *  @author Tobias Hunger <info@basyskom.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef TEST_ACCOUNTMANAGER_H
#define TEST_ACCOUNTMANAGER_H

#include <QtTest/QtTest>

#include <QDir>
#include <QDebug>

#include "config.h"

class ProtocolManager;
class ConnectionFacade;

/**
 * @brief Test class for the AccountManager.
 * @author Tobias Hunger <info@basyskom.de>
 */
class AccountManagerTest : public QObject
{
    Q_OBJECT
private slots:
    void init();
    void cleanup();

    void simplePersistenceTest();
    void createQueryUpdateQueryDeleteQuery();
    void listCreateListDeleteList();
    void createSearch();
    void presenceSetup();
    void goOnline();

private:
    ProtocolManager* m_protocolMgr;
    ConnectionFacade* m_connectionFacade;
};

#endif

