/* Operation.c generated by valac, the Vala compiler
 * generated from Operation.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    Déjà Dup
    © 2008,2009 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gconf/gconf-client.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <gnome-keyring.h>
#include <PassphraseSchema.h>
#include <config.h>
#include <libgnomeui/libgnomeui.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <gdk/gdkx.h>
#include <hacks.h>
#include <gdk/gdk.h>


#define DEJA_DUP_TYPE_OPERATION (deja_dup_operation_get_type ())
#define DEJA_DUP_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_OPERATION, DejaDupOperation))
#define DEJA_DUP_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_OPERATION, DejaDupOperationClass))
#define DEJA_DUP_IS_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_OPERATION))
#define DEJA_DUP_IS_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_OPERATION))
#define DEJA_DUP_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_OPERATION, DejaDupOperationClass))

typedef struct _DejaDupOperation DejaDupOperation;
typedef struct _DejaDupOperationClass DejaDupOperationClass;
typedef struct _DejaDupOperationPrivate DejaDupOperationPrivate;

#define DEJA_DUP_TYPE_DUPLICITY (deja_dup_duplicity_get_type ())
#define DEJA_DUP_DUPLICITY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_DUPLICITY, DejaDupDuplicity))
#define DEJA_DUP_DUPLICITY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_DUPLICITY, DejaDupDuplicityClass))
#define DEJA_DUP_IS_DUPLICITY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_DUPLICITY))
#define DEJA_DUP_IS_DUPLICITY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_DUPLICITY))
#define DEJA_DUP_DUPLICITY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_DUPLICITY, DejaDupDuplicityClass))

typedef struct _DejaDupDuplicity DejaDupDuplicity;
typedef struct _DejaDupDuplicityClass DejaDupDuplicityClass;

#define DEJA_DUP_TYPE_BACKEND (deja_dup_backend_get_type ())
#define DEJA_DUP_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackend))
#define DEJA_DUP_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))
#define DEJA_DUP_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))

typedef struct _DejaDupBackend DejaDupBackend;
typedef struct _DejaDupBackendClass DejaDupBackendClass;

#define DEJA_DUP_OPERATION_TYPE_MODE (deja_dup_operation_mode_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free_g_free0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))

struct _DejaDupOperation {
	GObject parent_instance;
	DejaDupOperationPrivate * priv;
	DejaDupDuplicity* dup;
	DejaDupBackend* backend;
	char* passphrase;
};

struct _DejaDupOperationClass {
	GObjectClass parent_class;
	void (*start) (DejaDupOperation* self, GError** error);
	void (*connect_to_dup) (DejaDupOperation* self);
	void (*operation_finished) (DejaDupOperation* self, DejaDupDuplicity* dup, gboolean success, gboolean cancelled);
	GList* (*make_argv) (DejaDupOperation* self, GError** error);
};

typedef enum  {
	DEJA_DUP_OPERATION_MODE_INVALID,
	DEJA_DUP_OPERATION_MODE_BACKUP,
	DEJA_DUP_OPERATION_MODE_RESTORE,
	DEJA_DUP_OPERATION_MODE_STATUS
} DejaDupOperationMode;

struct _DejaDupOperationPrivate {
	GtkWindow* _toplevel;
	guint _uppermost_xid;
	DejaDupOperationMode _mode;
	guint inhibit_cookie;
};


static gpointer deja_dup_operation_parent_class = NULL;

GType deja_dup_operation_get_type (void);
GType deja_dup_duplicity_get_type (void);
GType deja_dup_backend_get_type (void);
GType deja_dup_operation_mode_get_type (void);
#define DEJA_DUP_OPERATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_OPERATION, DejaDupOperationPrivate))
enum  {
	DEJA_DUP_OPERATION_DUMMY_PROPERTY,
	DEJA_DUP_OPERATION_TOPLEVEL,
	DEJA_DUP_OPERATION_UPPERMOST_XID,
	DEJA_DUP_OPERATION_MODE
};
char* deja_dup_operation_mode_to_string (DejaDupOperationMode mode);
void deja_dup_operation_connect_to_dup (DejaDupOperation* self);
static gboolean deja_dup_operation_claim_bus (DejaDupOperation* self, gboolean claimed);
static void deja_dup_operation_set_session_inhibited (DejaDupOperation* self, gboolean inhibit);
GConfClient* deja_dup_get_gconf_client (void);
#define DEJA_DUP_ENCRYPT_KEY "/apps/deja-dup/encrypt"
static void deja_dup_operation_get_passphrase (DejaDupOperation* self);
static void deja_dup_operation_continue_with_passphrase (DejaDupOperation* self, GError** error);
void deja_dup_operation_start (DejaDupOperation* self, GError** error);
static void deja_dup_operation_real_start (DejaDupOperation* self, GError** error);
void deja_dup_duplicity_cancel (DejaDupDuplicity* self);
void deja_dup_operation_cancel (DejaDupOperation* self);
void deja_dup_operation_operation_finished (DejaDupOperation* self, DejaDupDuplicity* dup, gboolean success, gboolean cancelled);
static void _deja_dup_operation_operation_finished_deja_dup_duplicity_done (DejaDupDuplicity* _sender, gboolean success, gboolean cancelled, gpointer self);
static void _lambda0_ (DejaDupDuplicity* d, const char* s, const char* detail, DejaDupOperation* self);
static void __lambda0__deja_dup_duplicity_raise_error (DejaDupDuplicity* _sender, const char* errstr, const char* detail, gpointer self);
static void _lambda1_ (DejaDupDuplicity* d, const char* s, DejaDupOperation* self);
static void __lambda1__deja_dup_duplicity_action_desc_changed (DejaDupDuplicity* _sender, const char* action, gpointer self);
static void _lambda2_ (DejaDupDuplicity* d, GFile* f, DejaDupOperation* self);
static void __lambda2__deja_dup_duplicity_action_file_changed (DejaDupDuplicity* _sender, GFile* file, gpointer self);
static void _lambda3_ (DejaDupDuplicity* d, double p, DejaDupOperation* self);
static void __lambda3__deja_dup_duplicity_progress (DejaDupDuplicity* _sender, double percent, gpointer self);
static void deja_dup_operation_continue_with_envp (DejaDupOperation* self, DejaDupBackend* b, gboolean success, GList* envp, const char* _error_);
static void _deja_dup_operation_continue_with_envp_deja_dup_backend_envp_ready (DejaDupBackend* _sender, gboolean success, GList* envp, const char* _error_, gpointer self);
void deja_dup_backend_ask_password (DejaDupBackend* self);
static void _lambda4_ (DejaDupBackend* b, DejaDupOperation* self);
static void __lambda4__deja_dup_backend_need_password (DejaDupBackend* _sender, gpointer self);
static void deja_dup_operation_real_connect_to_dup (DejaDupOperation* self);
void deja_dup_backend_get_envp (DejaDupBackend* self, GError** error);
GList* deja_dup_operation_make_argv (DejaDupOperation* self, GError** error);
void deja_dup_backend_add_argv (DejaDupBackend* self, DejaDupOperationMode mode, GList** argv);
DejaDupOperationMode deja_dup_operation_get_mode (DejaDupOperation* self);
void deja_dup_duplicity_start (DejaDupDuplicity* self, DejaDupBackend* backend, gboolean encrypted, GList* argv, GList* envp);
static void _g_list_free_g_free (GList* self);
static void deja_dup_operation_real_operation_finished (DejaDupOperation* self, DejaDupDuplicity* dup, gboolean success, gboolean cancelled);
static GList* deja_dup_operation_real_make_argv (DejaDupOperation* self, GError** error);
void deja_dup_operation_ask_passphrase (DejaDupOperation* self, GError** error);
static void deja_dup_operation_found_passphrase (DejaDupOperation* self, GnomeKeyringResult _result_, const char* str);
static void _deja_dup_operation_found_passphrase_gnome_keyring_operation_get_string_callback (GnomeKeyringResult _result_, const char* str, gpointer self);
static void deja_dup_operation_save_password_callback (DejaDupOperation* self, GnomeKeyringResult _result_);
GtkWindow* deja_dup_operation_get_toplevel (DejaDupOperation* self);
static void _deja_dup_operation_save_password_callback_gnome_keyring_operation_done_callback (GnomeKeyringResult _result_, gpointer self);
void deja_dup_operation_ask_backend_password (DejaDupOperation* self, GError** error);
gboolean deja_dup_set_bus_claimed (const char* busname, gboolean claim);
guint deja_dup_operation_get_uppermost_xid (DejaDupOperation* self);
DejaDupOperationMode deja_dup_duplicity_get_mode (DejaDupDuplicity* self);
void _dynamic_Inhibit0 (DBusGProxy* self, const char* param1, guint param2, char* param3, guint param4, guint* param5, GError** error);
void _dynamic_Uninhibit1 (DBusGProxy* self, guint param1, GError** error);
DejaDupOperation* deja_dup_operation_construct (GType object_type);
static void deja_dup_operation_set_toplevel (DejaDupOperation* self, GtkWindow* value);
static void deja_dup_operation_set_uppermost_xid (DejaDupOperation* self, guint value);
static void deja_dup_operation_set_mode (DejaDupOperation* self, DejaDupOperationMode value);
DejaDupDuplicity* deja_dup_duplicity_new (DejaDupOperationMode mode, GtkWindow* win);
DejaDupDuplicity* deja_dup_duplicity_construct (GType object_type, DejaDupOperationMode mode, GtkWindow* win);
DejaDupBackend* deja_dup_backend_get_default (GtkWindow* win, GError** error);
static gboolean _lambda5_ (DejaDupOperation* o, DejaDupOperation* self);
static gboolean __lambda5__deja_dup_operation_passphrase_required (DejaDupOperation* _sender, gpointer self);
static gboolean _lambda6_ (DejaDupOperation* o, DejaDupOperation* self);
static gboolean __lambda6__deja_dup_operation_backend_password_required (DejaDupOperation* _sender, gpointer self);
static GObject * deja_dup_operation_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void deja_dup_operation_finalize (GObject* obj);
static void deja_dup_operation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void deja_dup_operation_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);


static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__VOID (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);


GType deja_dup_operation_mode_get_type (void) {
	static GType deja_dup_operation_mode_type_id = 0;
	if (G_UNLIKELY (deja_dup_operation_mode_type_id == 0)) {
		static const GEnumValue values[] = {{DEJA_DUP_OPERATION_MODE_INVALID, "DEJA_DUP_OPERATION_MODE_INVALID", "invalid"}, {DEJA_DUP_OPERATION_MODE_BACKUP, "DEJA_DUP_OPERATION_MODE_BACKUP", "backup"}, {DEJA_DUP_OPERATION_MODE_RESTORE, "DEJA_DUP_OPERATION_MODE_RESTORE", "restore"}, {DEJA_DUP_OPERATION_MODE_STATUS, "DEJA_DUP_OPERATION_MODE_STATUS", "status"}, {0, NULL, NULL}};
		deja_dup_operation_mode_type_id = g_enum_register_static ("DejaDupOperationMode", values);
	}
	return deja_dup_operation_mode_type_id;
}


char* deja_dup_operation_mode_to_string (DejaDupOperationMode mode) {
	char* result;
	switch (mode) {
		case DEJA_DUP_OPERATION_MODE_BACKUP:
		{
			result = g_strdup (_ ("Backing up..."));
			return result;
		}
		case DEJA_DUP_OPERATION_MODE_RESTORE:
		{
			result = g_strdup (_ ("Restoring..."));
			return result;
		}
		case DEJA_DUP_OPERATION_MODE_STATUS:
		{
			result = g_strdup (_ ("Checking for backups..."));
			return result;
		}
		default:
		{
			result = g_strdup ("");
			return result;
		}
	}
}


static void deja_dup_operation_real_start (DejaDupOperation* self, GError** error) {
	GError * _inner_error_;
	GConfClient* client;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	if (self->backend == NULL) {
		g_signal_emit_by_name (self, "done", FALSE);
		return;
	}
	deja_dup_operation_connect_to_dup (self);
	if (!deja_dup_operation_claim_bus (self, TRUE)) {
		g_signal_emit_by_name (self, "done", FALSE);
		return;
	}
	deja_dup_operation_set_session_inhibited (self, TRUE);
	client = deja_dup_get_gconf_client ();
	_tmp1_ = gconf_client_get_bool (client, DEJA_DUP_ENCRYPT_KEY, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (client);
		return;
	}
	if (_tmp1_) {
		_tmp0_ = self->passphrase == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		deja_dup_operation_get_passphrase (self);
	} else {
		deja_dup_operation_continue_with_passphrase (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (client);
			return;
		}
	}
	_g_object_unref0 (client);
}


void deja_dup_operation_start (DejaDupOperation* self, GError** error) {
	DEJA_DUP_OPERATION_GET_CLASS (self)->start (self, error);
}


void deja_dup_operation_cancel (DejaDupOperation* self) {
	g_return_if_fail (self != NULL);
	deja_dup_duplicity_cancel (self->dup);
}


static void _deja_dup_operation_operation_finished_deja_dup_duplicity_done (DejaDupDuplicity* _sender, gboolean success, gboolean cancelled, gpointer self) {
	deja_dup_operation_operation_finished (self, _sender, success, cancelled);
}


static void _lambda0_ (DejaDupDuplicity* d, const char* s, const char* detail, DejaDupOperation* self) {
	g_return_if_fail (d != NULL);
	g_return_if_fail (s != NULL);
	g_signal_emit_by_name (self, "raise-error", s, detail);
}


static void __lambda0__deja_dup_duplicity_raise_error (DejaDupDuplicity* _sender, const char* errstr, const char* detail, gpointer self) {
	_lambda0_ (_sender, errstr, detail, self);
}


static void _lambda1_ (DejaDupDuplicity* d, const char* s, DejaDupOperation* self) {
	g_return_if_fail (d != NULL);
	g_return_if_fail (s != NULL);
	g_signal_emit_by_name (self, "action-desc-changed", s);
}


static void __lambda1__deja_dup_duplicity_action_desc_changed (DejaDupDuplicity* _sender, const char* action, gpointer self) {
	_lambda1_ (_sender, action, self);
}


static void _lambda2_ (DejaDupDuplicity* d, GFile* f, DejaDupOperation* self) {
	g_return_if_fail (d != NULL);
	g_return_if_fail (f != NULL);
	g_signal_emit_by_name (self, "action-file-changed", f);
}


static void __lambda2__deja_dup_duplicity_action_file_changed (DejaDupDuplicity* _sender, GFile* file, gpointer self) {
	_lambda2_ (_sender, file, self);
}


static void _lambda3_ (DejaDupDuplicity* d, double p, DejaDupOperation* self) {
	g_return_if_fail (d != NULL);
	g_signal_emit_by_name (self, "progress", p);
}


static void __lambda3__deja_dup_duplicity_progress (DejaDupDuplicity* _sender, double percent, gpointer self) {
	_lambda3_ (_sender, percent, self);
}


static void _deja_dup_operation_continue_with_envp_deja_dup_backend_envp_ready (DejaDupBackend* _sender, gboolean success, GList* envp, const char* _error_, gpointer self) {
	deja_dup_operation_continue_with_envp (self, _sender, success, envp, _error_);
}


static void _lambda4_ (DejaDupBackend* b, DejaDupOperation* self) {
	gboolean _tmp0_;
	gboolean can_ask_now;
	g_return_if_fail (b != NULL);
	can_ask_now = (g_signal_emit_by_name (self, "backend-password-required", &_tmp0_), _tmp0_);
	if (can_ask_now) {
		deja_dup_backend_ask_password (self->backend);
	}
}


static void __lambda4__deja_dup_backend_need_password (DejaDupBackend* _sender, gpointer self) {
	_lambda4_ (_sender, self);
}


static void deja_dup_operation_real_connect_to_dup (DejaDupOperation* self) {
	g_return_if_fail (self != NULL);
	g_signal_connect_object (self->dup, "done", (GCallback) _deja_dup_operation_operation_finished_deja_dup_duplicity_done, self, 0);
	g_signal_connect_object (self->dup, "raise-error", (GCallback) __lambda0__deja_dup_duplicity_raise_error, self, 0);
	g_signal_connect_object (self->dup, "action-desc-changed", (GCallback) __lambda1__deja_dup_duplicity_action_desc_changed, self, 0);
	g_signal_connect_object (self->dup, "action-file-changed", (GCallback) __lambda2__deja_dup_duplicity_action_file_changed, self, 0);
	g_signal_connect_object (self->dup, "progress", (GCallback) __lambda3__deja_dup_duplicity_progress, self, 0);
	g_signal_connect_object (self->backend, "envp-ready", (GCallback) _deja_dup_operation_continue_with_envp_deja_dup_backend_envp_ready, self, 0);
	g_signal_connect_object (self->backend, "need-password", (GCallback) __lambda4__deja_dup_backend_need_password, self, 0);
}


void deja_dup_operation_connect_to_dup (DejaDupOperation* self) {
	DEJA_DUP_OPERATION_GET_CLASS (self)->connect_to_dup (self);
}


static void deja_dup_operation_continue_with_passphrase (DejaDupOperation* self, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	deja_dup_backend_get_envp (self->backend, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static void _g_list_free_g_free (GList* self) {
	g_list_foreach (self, (GFunc) g_free, NULL);
	g_list_free (self);
}


static void deja_dup_operation_continue_with_envp (DejaDupOperation* self, DejaDupBackend* b, gboolean success, GList* envp, const char* _error_) {
	GError * _inner_error_;
	gboolean _tmp0_ = FALSE;
	gboolean encrypted;
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	_inner_error_ = NULL;
	if (!success) {
		if (_error_ != NULL) {
			g_signal_emit_by_name (self, "raise-error", _error_, NULL);
		}
		g_signal_emit_by_name (self, "done", FALSE);
		return;
	}
	if (self->passphrase != NULL) {
		_tmp0_ = _vala_strcmp0 (self->passphrase, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	encrypted = _tmp0_;
	if (encrypted) {
		envp = g_list_append (envp, g_strdup_printf ("PASSPHRASE=%s", self->passphrase));
	} else {
		envp = g_list_append (envp, g_strdup ("PASSPHRASE="));
	}
	{
		GList* argv;
		argv = deja_dup_operation_make_argv (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch43_g_error;
			goto __finally43;
		}
		deja_dup_backend_add_argv (self->backend, self->priv->_mode, &argv);
		deja_dup_duplicity_start (self->dup, self->backend, encrypted, argv, envp);
		__g_list_free_g_free0 (argv);
	}
	goto __finally43;
	__catch43_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_signal_emit_by_name (self, "raise-error", e->message, NULL);
			g_signal_emit_by_name (self, "done", FALSE);
			_g_error_free0 (e);
			return;
		}
	}
	__finally43:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void deja_dup_operation_real_operation_finished (DejaDupOperation* self, DejaDupDuplicity* dup, gboolean success, gboolean cancelled) {
	GError * _inner_error_;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dup != NULL);
	_inner_error_ = NULL;
	deja_dup_operation_set_session_inhibited (self, FALSE);
	deja_dup_operation_claim_bus (self, FALSE);
	if (success) {
		_tmp0_ = _vala_strcmp0 (self->passphrase, "") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		{
			GConfClient* client;
			client = _g_object_ref0 (gconf_client_get_default ());
			gconf_client_set_bool (client, DEJA_DUP_ENCRYPT_KEY, FALSE, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (client);
				goto __catch44_g_error;
				goto __finally44;
			}
			_g_object_unref0 (client);
		}
		goto __finally44;
		__catch44_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("Operation.vala:166: %s\n", e->message);
				_g_error_free0 (e);
			}
		}
		__finally44:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_signal_emit_by_name (self, "done", success);
}


void deja_dup_operation_operation_finished (DejaDupOperation* self, DejaDupDuplicity* dup, gboolean success, gboolean cancelled) {
	DEJA_DUP_OPERATION_GET_CLASS (self)->operation_finished (self, dup, success, cancelled);
}


static GList* deja_dup_operation_real_make_argv (DejaDupOperation* self, GError** error) {
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = NULL;
	return result;
}


GList* deja_dup_operation_make_argv (DejaDupOperation* self, GError** error) {
	return DEJA_DUP_OPERATION_GET_CLASS (self)->make_argv (self, error);
}


static void deja_dup_operation_found_passphrase (DejaDupOperation* self, GnomeKeyringResult _result_, const char* str) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	if (_result_ == GNOME_KEYRING_RESULT_OK) {
		char* _tmp0_;
		self->passphrase = (_tmp0_ = g_strdup (str), _g_free0 (self->passphrase), _tmp0_);
	}
	{
		if (self->passphrase != NULL) {
			deja_dup_operation_continue_with_passphrase (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch45_g_error;
				goto __finally45;
			}
		} else {
			gboolean _tmp1_;
			gboolean can_ask_now;
			can_ask_now = (g_signal_emit_by_name (self, "passphrase-required", &_tmp1_), _tmp1_);
			if (can_ask_now) {
				deja_dup_operation_ask_passphrase (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch45_g_error;
					goto __finally45;
				}
			}
		}
	}
	goto __finally45;
	__catch45_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("Operation.vala:194: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally45:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _deja_dup_operation_found_passphrase_gnome_keyring_operation_get_string_callback (GnomeKeyringResult _result_, const char* str, gpointer self) {
	deja_dup_operation_found_passphrase (self, _result_, str);
}


static void deja_dup_operation_get_passphrase (DejaDupOperation* self) {
	g_return_if_fail (self != NULL);
	gnome_keyring_find_password (PASSPHRASE_SCHEMA, _deja_dup_operation_found_passphrase_gnome_keyring_operation_get_string_callback, g_object_ref (self), g_object_unref, "owner", PACKAGE, "type", "passphrase", NULL);
}


static void deja_dup_operation_save_password_callback (DejaDupOperation* self, GnomeKeyringResult _result_) {
	g_return_if_fail (self != NULL);
}


static char* string_strip (const char* self) {
	char* result;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static void _deja_dup_operation_save_password_callback_gnome_keyring_operation_done_callback (GnomeKeyringResult _result_, gpointer self) {
	deja_dup_operation_save_password_callback (self, _result_);
}


void deja_dup_operation_ask_passphrase (DejaDupOperation* self, GError** error) {
	GError * _inner_error_;
	GnomePasswordDialog* dlg;
	char* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	dlg = g_object_ref_sink ((GnomePasswordDialog*) gnome_password_dialog_new (_ ("Encryption Password"), _ ("Enter the password used to encrypt your backup files."), "", "", FALSE));
	((GtkWindow*) dlg)->transient_parent = self->priv->_toplevel;
	g_object_set (dlg, "show-remember", TRUE, NULL);
	g_object_set (dlg, "show-username", FALSE, NULL);
	if (!gnome_password_dialog_run_and_block (dlg)) {
		g_signal_emit_by_name (self, "done", FALSE);
		_g_object_unref0 (dlg);
		return;
	}
	self->passphrase = (_tmp0_ = g_strdup (gnome_password_dialog_get_password (dlg)), _g_free0 (self->passphrase), _tmp0_);
	self->passphrase = (_tmp1_ = string_strip (self->passphrase), _g_free0 (self->passphrase), _tmp1_);
	if (_vala_strcmp0 (self->passphrase, "") != 0) {
		GnomePasswordDialogRemember remember;
		remember = gnome_password_dialog_get_remember (dlg);
		if (remember != GNOME_PASSWORD_DIALOG_REMEMBER_NOTHING) {
			const char* _tmp2_;
			char* where;
			_tmp2_ = NULL;
			if (remember == GNOME_PASSWORD_DIALOG_REMEMBER_SESSION) {
				_tmp2_ = "session";
			} else {
				_tmp2_ = GNOME_KEYRING_DEFAULT;
			}
			where = g_strdup (_tmp2_);
			gnome_keyring_store_password (PASSPHRASE_SCHEMA, where, _ ("Déjà Dup backup passphrase"), self->passphrase, _deja_dup_operation_save_password_callback_gnome_keyring_operation_done_callback, g_object_ref (self), g_object_unref, "owner", PACKAGE, "type", "passphrase", NULL);
			_g_free0 (where);
		}
	}
	deja_dup_operation_continue_with_passphrase (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (dlg);
		return;
	}
	_g_object_unref0 (dlg);
}


void deja_dup_operation_ask_backend_password (DejaDupOperation* self, GError** error) {
	g_return_if_fail (self != NULL);
	deja_dup_backend_ask_password (self->backend);
}


static gboolean deja_dup_operation_claim_bus (DejaDupOperation* self, gboolean claimed) {
	gboolean result;
	gboolean rv;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	rv = deja_dup_set_bus_claimed ("operation", claimed);
	if (claimed) {
		_tmp0_ = !rv;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_signal_emit_by_name (self, "raise-error", _ ("Another Déjà Dup is already running"), NULL);
	}
	result = rv;
	return result;
}


void _dynamic_Inhibit0 (DBusGProxy* self, const char* param1, guint param2, char* param3, guint param4, guint* param5, GError** error) {
	dbus_g_proxy_call (self, "Inhibit", error, G_TYPE_STRING, param1, G_TYPE_UINT, param2, G_TYPE_STRING, param3, G_TYPE_UINT, param4, G_TYPE_INVALID, G_TYPE_UINT, param5, G_TYPE_INVALID);
	if (*error) {
		return;
	}
}


void _dynamic_Uninhibit1 (DBusGProxy* self, guint param1, GError** error) {
	dbus_g_proxy_call (self, "Uninhibit", error, G_TYPE_UINT, param1, G_TYPE_INVALID, G_TYPE_INVALID);
	if (*error) {
		return;
	}
}


static void deja_dup_operation_set_session_inhibited (DejaDupOperation* self, gboolean inhibit) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	{
		DBusGConnection* conn;
		DBusGProxy* obj;
		conn = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch46_g_error;
			goto __finally46;
		}
		obj = dbus_g_proxy_new_for_name (conn, "org.gnome.SessionManager", "/org/gnome/SessionManager", "org.gnome.SessionManager");
		if (inhibit) {
			guint xid;
			gboolean _tmp0_ = FALSE;
			char* _tmp1_;
			if (self->priv->inhibit_cookie > 0) {
				_dbus_g_connection_unref0 (conn);
				_g_object_unref0 (obj);
				return;
			}
			xid = self->priv->_uppermost_xid;
			if (xid == 0) {
				_tmp0_ = self->priv->_toplevel != NULL;
			} else {
				_tmp0_ = FALSE;
			}
			if (_tmp0_) {
				gtk_widget_realize ((GtkWidget*) self->priv->_toplevel);
				xid = (guint) gdk_x11_drawable_get_xid ((GdkDrawable*) hacks_widget_get_window ((GtkWidget*) self->priv->_toplevel));
			}
			_dynamic_Inhibit0 (obj, PACKAGE, xid, _tmp1_ = deja_dup_operation_mode_to_string (deja_dup_duplicity_get_mode (self->dup)), (guint) (1 | 4), &self->priv->inhibit_cookie, &_inner_error_);
			if (_inner_error_ != NULL) {
				_dbus_g_connection_unref0 (conn);
				_g_object_unref0 (obj);
				goto __catch46_g_error;
				goto __finally46;
			}
			_g_free0 (_tmp1_);
		} else {
			if (self->priv->inhibit_cookie > 0) {
				_dynamic_Uninhibit1 (obj, self->priv->inhibit_cookie, &_inner_error_);
				if (_inner_error_ != NULL) {
					_dbus_g_connection_unref0 (conn);
					_g_object_unref0 (obj);
					goto __catch46_g_error;
					goto __finally46;
				}
				self->priv->inhibit_cookie = (guint) 0;
			}
		}
		_dbus_g_connection_unref0 (conn);
		_g_object_unref0 (obj);
	}
	goto __finally46;
	__catch46_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("Operation.vala:291: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally46:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
}


DejaDupOperation* deja_dup_operation_construct (GType object_type) {
	DejaDupOperation * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


GtkWindow* deja_dup_operation_get_toplevel (DejaDupOperation* self) {
	GtkWindow* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_toplevel;
	return result;
}


static void deja_dup_operation_set_toplevel (DejaDupOperation* self, GtkWindow* value) {
	GtkWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_toplevel = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_toplevel), _tmp0_);
	g_object_notify ((GObject *) self, "toplevel");
}


guint deja_dup_operation_get_uppermost_xid (DejaDupOperation* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_uppermost_xid;
	return result;
}


static void deja_dup_operation_set_uppermost_xid (DejaDupOperation* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_uppermost_xid = value;
	g_object_notify ((GObject *) self, "uppermost-xid");
}


DejaDupOperationMode deja_dup_operation_get_mode (DejaDupOperation* self) {
	DejaDupOperationMode result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_mode;
	return result;
}


static void deja_dup_operation_set_mode (DejaDupOperation* self, DejaDupOperationMode value) {
	g_return_if_fail (self != NULL);
	self->priv->_mode = value;
	g_object_notify ((GObject *) self, "mode");
}


static gboolean _lambda5_ (DejaDupOperation* o, DejaDupOperation* self) {
	gboolean result;
	g_return_val_if_fail (o != NULL, FALSE);
	result = TRUE;
	return result;
}


static gboolean __lambda5__deja_dup_operation_passphrase_required (DejaDupOperation* _sender, gpointer self) {
	return _lambda5_ (_sender, self);
}


static gboolean _lambda6_ (DejaDupOperation* o, DejaDupOperation* self) {
	gboolean result;
	g_return_val_if_fail (o != NULL, FALSE);
	result = TRUE;
	return result;
}


static gboolean __lambda6__deja_dup_operation_backend_password_required (DejaDupOperation* _sender, gpointer self) {
	return _lambda6_ (_sender, self);
}


static GObject * deja_dup_operation_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DejaDupOperation * self;
	GError * _inner_error_;
	parent_class = G_OBJECT_CLASS (deja_dup_operation_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DEJA_DUP_OPERATION (obj);
	_inner_error_ = NULL;
	{
		DejaDupDuplicity* _tmp0_;
		self->dup = (_tmp0_ = deja_dup_duplicity_new (self->priv->_mode, self->priv->_toplevel), _g_object_unref0 (self->dup), _tmp0_);
		{
			DejaDupBackend* _tmp1_;
			DejaDupBackend* _tmp2_;
			_tmp1_ = deja_dup_backend_get_default (self->priv->_toplevel, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch47_g_error;
				goto __finally47;
			}
			self->backend = (_tmp2_ = _tmp1_, _g_object_unref0 (self->backend), _tmp2_);
		}
		goto __finally47;
		__catch47_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("Operation.vala:70: %s\n", e->message);
				_g_error_free0 (e);
			}
		}
		__finally47:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
		}
		g_signal_connect_object (self, "passphrase-required", (GCallback) __lambda5__deja_dup_operation_passphrase_required, self, 0);
		g_signal_connect_object (self, "backend-password-required", (GCallback) __lambda6__deja_dup_operation_backend_password_required, self, 0);
	}
	return obj;
}


static void deja_dup_operation_class_init (DejaDupOperationClass * klass) {
	deja_dup_operation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupOperationPrivate));
	DEJA_DUP_OPERATION_CLASS (klass)->start = deja_dup_operation_real_start;
	DEJA_DUP_OPERATION_CLASS (klass)->connect_to_dup = deja_dup_operation_real_connect_to_dup;
	DEJA_DUP_OPERATION_CLASS (klass)->operation_finished = deja_dup_operation_real_operation_finished;
	DEJA_DUP_OPERATION_CLASS (klass)->make_argv = deja_dup_operation_real_make_argv;
	G_OBJECT_CLASS (klass)->get_property = deja_dup_operation_get_property;
	G_OBJECT_CLASS (klass)->set_property = deja_dup_operation_set_property;
	G_OBJECT_CLASS (klass)->constructor = deja_dup_operation_constructor;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_operation_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_OPERATION_TOPLEVEL, g_param_spec_object ("toplevel", "toplevel", "toplevel", GTK_TYPE_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_OPERATION_UPPERMOST_XID, g_param_spec_uint ("uppermost-xid", "uppermost-xid", "uppermost-xid", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_OPERATION_MODE, g_param_spec_enum ("mode", "mode", "mode", DEJA_DUP_OPERATION_TYPE_MODE, DEJA_DUP_OPERATION_MODE_INVALID, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_signal_new ("done", DEJA_DUP_TYPE_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	g_signal_new ("raise_error", DEJA_DUP_TYPE_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
	g_signal_new ("action_desc_changed", DEJA_DUP_TYPE_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("action_file_changed", DEJA_DUP_TYPE_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, G_TYPE_FILE);
	g_signal_new ("progress", DEJA_DUP_TYPE_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__DOUBLE, G_TYPE_NONE, 1, G_TYPE_DOUBLE);
	g_signal_new ("passphrase_required", DEJA_DUP_TYPE_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__VOID, G_TYPE_BOOLEAN, 0);
	g_signal_new ("backend_password_required", DEJA_DUP_TYPE_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__VOID, G_TYPE_BOOLEAN, 0);
}


static void deja_dup_operation_instance_init (DejaDupOperation * self) {
	self->priv = DEJA_DUP_OPERATION_GET_PRIVATE (self);
	self->priv->_mode = DEJA_DUP_OPERATION_MODE_INVALID;
	self->priv->inhibit_cookie = (guint) 0;
}


static void deja_dup_operation_finalize (GObject* obj) {
	DejaDupOperation * self;
	self = DEJA_DUP_OPERATION (obj);
	_g_object_unref0 (self->priv->_toplevel);
	_g_object_unref0 (self->dup);
	_g_object_unref0 (self->backend);
	_g_free0 (self->passphrase);
	G_OBJECT_CLASS (deja_dup_operation_parent_class)->finalize (obj);
}


GType deja_dup_operation_get_type (void) {
	static GType deja_dup_operation_type_id = 0;
	if (deja_dup_operation_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupOperationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_operation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupOperation), 0, (GInstanceInitFunc) deja_dup_operation_instance_init, NULL };
		deja_dup_operation_type_id = g_type_register_static (G_TYPE_OBJECT, "DejaDupOperation", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return deja_dup_operation_type_id;
}


static void deja_dup_operation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DejaDupOperation * self;
	self = DEJA_DUP_OPERATION (object);
	switch (property_id) {
		case DEJA_DUP_OPERATION_TOPLEVEL:
		g_value_set_object (value, deja_dup_operation_get_toplevel (self));
		break;
		case DEJA_DUP_OPERATION_UPPERMOST_XID:
		g_value_set_uint (value, deja_dup_operation_get_uppermost_xid (self));
		break;
		case DEJA_DUP_OPERATION_MODE:
		g_value_set_enum (value, deja_dup_operation_get_mode (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void deja_dup_operation_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DejaDupOperation * self;
	self = DEJA_DUP_OPERATION (object);
	switch (property_id) {
		case DEJA_DUP_OPERATION_TOPLEVEL:
		deja_dup_operation_set_toplevel (self, g_value_get_object (value));
		break;
		case DEJA_DUP_OPERATION_UPPERMOST_XID:
		deja_dup_operation_set_uppermost_xid (self, g_value_get_uint (value));
		break;
		case DEJA_DUP_OPERATION_MODE:
		deja_dup_operation_set_mode (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}



static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), data2);
}


static void g_cclosure_user_marshal_BOOLEAN__VOID (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__VOID) (gpointer data1, gpointer data2);
	register GMarshalFunc_BOOLEAN__VOID callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 1);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__VOID) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, data2);
	g_value_set_boolean (return_value, v_return);
}



