/* ConfigLocation.c generated by valac 0.10.0, the Vala compiler
 * generated from ConfigLocation.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    © 2008–2010 Michael Terry <mike@mterry.name>

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gconf/gconf-client.h>
#include <stdlib.h>
#include <string.h>
#include <common.h>
#include <glib/gi18n-lib.h>


#define DEJA_DUP_TYPE_CONFIG_WIDGET (deja_dup_config_widget_get_type ())
#define DEJA_DUP_CONFIG_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_CONFIG_WIDGET, DejaDupConfigWidget))
#define DEJA_DUP_CONFIG_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_CONFIG_WIDGET, DejaDupConfigWidgetClass))
#define DEJA_DUP_IS_CONFIG_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_CONFIG_WIDGET))
#define DEJA_DUP_IS_CONFIG_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_CONFIG_WIDGET))
#define DEJA_DUP_CONFIG_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_CONFIG_WIDGET, DejaDupConfigWidgetClass))

typedef struct _DejaDupConfigWidget DejaDupConfigWidget;
typedef struct _DejaDupConfigWidgetClass DejaDupConfigWidgetClass;
typedef struct _DejaDupConfigWidgetPrivate DejaDupConfigWidgetPrivate;

#define DEJA_DUP_TYPE_CONFIG_LOCATION (deja_dup_config_location_get_type ())
#define DEJA_DUP_CONFIG_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_CONFIG_LOCATION, DejaDupConfigLocation))
#define DEJA_DUP_CONFIG_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_CONFIG_LOCATION, DejaDupConfigLocationClass))
#define DEJA_DUP_IS_CONFIG_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_CONFIG_LOCATION))
#define DEJA_DUP_IS_CONFIG_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_CONFIG_LOCATION))
#define DEJA_DUP_CONFIG_LOCATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_CONFIG_LOCATION, DejaDupConfigLocationClass))

typedef struct _DejaDupConfigLocation DejaDupConfigLocation;
typedef struct _DejaDupConfigLocationClass DejaDupConfigLocationClass;
typedef struct _DejaDupConfigLocationPrivate DejaDupConfigLocationPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _DejaDupConfigLocationSetFromConfigData DejaDupConfigLocationSetFromConfigData;
typedef struct _DejaDupConfigLocationSetFileInfoData DejaDupConfigLocationSetFileInfoData;

#define DEJA_DUP_TYPE_BUTTON_CONNECT (deja_dup_button_connect_get_type ())
#define DEJA_DUP_BUTTON_CONNECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BUTTON_CONNECT, DejaDupButtonConnect))
#define DEJA_DUP_BUTTON_CONNECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BUTTON_CONNECT, DejaDupButtonConnectClass))
#define DEJA_DUP_IS_BUTTON_CONNECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BUTTON_CONNECT))
#define DEJA_DUP_IS_BUTTON_CONNECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BUTTON_CONNECT))
#define DEJA_DUP_BUTTON_CONNECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BUTTON_CONNECT, DejaDupButtonConnectClass))

typedef struct _DejaDupButtonConnect DejaDupButtonConnect;
typedef struct _DejaDupButtonConnectClass DejaDupButtonConnectClass;

struct _DejaDupConfigWidget {
	GtkEventBox parent_instance;
	DejaDupConfigWidgetPrivate * priv;
	GConfClient* client;
};

struct _DejaDupConfigWidgetClass {
	GtkEventBoxClass parent_class;
	void (*set_from_config) (DejaDupConfigWidget* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*set_from_config_finish) (DejaDupConfigWidget* self, GAsyncResult* _res_);
};

struct _DejaDupConfigLocation {
	DejaDupConfigWidget parent_instance;
	DejaDupConfigLocationPrivate * priv;
};

struct _DejaDupConfigLocationClass {
	DejaDupConfigWidgetClass parent_class;
};

struct _DejaDupConfigLocationPrivate {
	gboolean _is_s3;
	GtkFileChooserDialog* dialog;
	GtkFileChooserButton* button;
	GFile* top_tmpdir;
	GFile* tmpdir;
	char* s3_name;
};

struct _DejaDupConfigLocationSetFromConfigData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupConfigLocation* self;
	GFile* file;
	char* uri;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* button_file;
	GFile* _tmp3_;
	GFile* _tmp4_;
	gboolean _tmp5_;
	char* _tmp6_;
	gboolean _tmp7_;
	GError * e;
	GError * _inner_error_;
};

struct _DejaDupConfigLocationSetFileInfoData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupConfigLocation* self;
	GFile* gconf_file;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GError * err;
	char* uri;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* file;
	gboolean _tmp5_;
	gboolean _tmp6_;
	char* _tmp7_;
	GError * e;
	GError * _inner_error_;
};


static gpointer deja_dup_config_location_parent_class = NULL;

GType deja_dup_config_widget_get_type (void) G_GNUC_CONST;
GType deja_dup_config_location_get_type (void) G_GNUC_CONST;
#define DEJA_DUP_CONFIG_LOCATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_CONFIG_LOCATION, DejaDupConfigLocationPrivate))
enum  {
	DEJA_DUP_CONFIG_LOCATION_DUMMY_PROPERTY,
	DEJA_DUP_CONFIG_LOCATION_IS_S3
};
#define DEJA_DUP_CONFIG_LOCATION_CONNECT_ID 1
static GFile* deja_dup_config_location_get_file_from_gconf (DejaDupConfigLocation* self, GError** error);
static void deja_dup_config_location_real_set_from_config_data_free (gpointer _data);
static void deja_dup_config_location_real_set_from_config (DejaDupConfigWidget* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void deja_dup_config_location_set_from_config_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean deja_dup_config_location_real_set_from_config_co (DejaDupConfigLocationSetFromConfigData* data);
static void deja_dup_config_location_set_is_s3 (DejaDupConfigLocation* self, gboolean value);
static void deja_dup_config_location_handle_selection_changed (DejaDupConfigLocation* self);
static void deja_dup_config_location_set_file_info (DejaDupConfigLocation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void deja_dup_config_location_set_file_info_finish (DejaDupConfigLocation* self, GAsyncResult* _res_);
static void deja_dup_config_location_set_file_info_data_free (gpointer _data);
static void deja_dup_config_location_set_file_info_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean deja_dup_config_location_set_file_info_co (DejaDupConfigLocationSetFileInfoData* data);
gboolean deja_dup_config_location_get_is_s3 (DejaDupConfigLocation* self);
static void deja_dup_config_location_add_special_location (DejaDupConfigLocation* self);
static void deja_dup_config_location_handle_dialog_show (DejaDupConfigLocation* self, GtkWidget* w);
static void _deja_dup_config_location_handle_dialog_show_gtk_widget_show (GtkWidget* _sender, gpointer self);
static void deja_dup_config_location_handle_dialog_hide (DejaDupConfigLocation* self, GtkWidget* w);
static void _deja_dup_config_location_handle_dialog_hide_gtk_widget_hide (GtkWidget* _sender, gpointer self);
DejaDupConfigLocation* deja_dup_config_location_new (void);
DejaDupConfigLocation* deja_dup_config_location_construct (GType object_type);
DejaDupConfigWidget* deja_dup_config_widget_construct (GType object_type);
DejaDupButtonConnect* deja_dup_button_connect_new (void);
DejaDupButtonConnect* deja_dup_button_connect_construct (GType object_type);
GType deja_dup_button_connect_get_type (void) G_GNUC_CONST;
static gboolean _lambda4_ (GtkWidget* w, gboolean g, DejaDupConfigLocation* self);
static gboolean __lambda4__gtk_widget_mnemonic_activate (GtkWidget* _sender, gboolean group_cycling, gpointer self);
void deja_dup_config_widget_set_from_config (DejaDupConfigWidget* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void deja_dup_config_widget_set_from_config_finish (DejaDupConfigWidget* self, GAsyncResult* _res_);
static void _deja_dup_config_location_handle_selection_changed_gtk_file_chooser_selection_changed (GtkFileChooser* _sender, gpointer self);
void deja_dup_config_widget_watch_key (DejaDupConfigWidget* self, const char* key);
static GObject * deja_dup_config_location_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void deja_dup_config_location_finalize (GObject* obj);
static void deja_dup_config_location_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void deja_dup_config_location_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GFile* deja_dup_config_location_get_file_from_gconf (DejaDupConfigLocation* self, GError** error) {
	GFile* result = NULL;
	GFile* file;
	char* val;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	file = NULL;
	val = gconf_client_get_string (((DejaDupConfigWidget*) self)->client, DEJA_DUP_BACKEND_KEY, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (file);
		return NULL;
	}
	if (_vala_strcmp0 (val, "s3") == 0) {
		_tmp0_ = self->priv->tmpdir != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GFile* _tmp1_;
		file = (_tmp1_ = _g_object_ref0 (self->priv->tmpdir), _g_object_unref0 (file), _tmp1_);
	} else {
		char* _tmp2_;
		char* _tmp3_;
		GFile* _tmp5_;
		_tmp2_ = gconf_client_get_string (((DejaDupConfigWidget*) self)->client, DEJA_DUP_FILE_PATH_KEY, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (val);
			_g_object_unref0 (file);
			return NULL;
		}
		val = (_tmp3_ = _tmp2_, _g_free0 (val), _tmp3_);
		if (val == NULL) {
			char* _tmp4_;
			val = (_tmp4_ = g_strdup (""), _g_free0 (val), _tmp4_);
		}
		file = (_tmp5_ = _g_object_ref0 (g_file_parse_name (val)), _g_object_unref0 (file), _tmp5_);
	}
	result = file;
	_g_free0 (val);
	return result;
}


static void deja_dup_config_location_real_set_from_config_data_free (gpointer _data) {
	DejaDupConfigLocationSetFromConfigData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (DejaDupConfigLocationSetFromConfigData, data);
}


static void deja_dup_config_location_real_set_from_config (DejaDupConfigWidget* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupConfigLocation * self;
	DejaDupConfigLocationSetFromConfigData* _data_;
	self = (DejaDupConfigLocation*) base;
	_data_ = g_slice_new0 (DejaDupConfigLocationSetFromConfigData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_config_location_real_set_from_config);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_config_location_real_set_from_config_data_free);
	_data_->self = g_object_ref (self);
	deja_dup_config_location_real_set_from_config_co (_data_);
}


static void deja_dup_config_location_real_set_from_config_finish (DejaDupConfigWidget* base, GAsyncResult* _res_) {
	DejaDupConfigLocationSetFromConfigData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void deja_dup_config_location_set_from_config_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupConfigLocationSetFromConfigData* data;
	data = _user_data_;
	data->_res_ = _res_;
	deja_dup_config_location_real_set_from_config_co (data);
}


static gboolean deja_dup_config_location_real_set_from_config_co (DejaDupConfigLocationSetFromConfigData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->file = NULL;
	{
		data->uri = gtk_file_chooser_get_uri ((GtkFileChooser*) data->self->priv->button);
		if (data->uri == NULL) {
			data->_tmp0_ = (data->_tmp1_ = NULL, _g_object_unref0 (data->_tmp0_), data->_tmp1_);
		} else {
			data->_tmp0_ = (data->_tmp2_ = g_file_new_for_uri (data->uri), _g_object_unref0 (data->_tmp0_), data->_tmp2_);
		}
		data->button_file = _g_object_ref0 (data->_tmp0_);
		data->_tmp3_ = deja_dup_config_location_get_file_from_gconf (data->self, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			_g_object_unref0 (data->button_file);
			_g_object_unref0 (data->_tmp0_);
			_g_free0 (data->uri);
			goto __catch21_g_error;
		}
		data->file = (data->_tmp4_ = data->_tmp3_, _g_object_unref0 (data->file), data->_tmp4_);
		if (data->button_file == NULL) {
			data->_tmp5_ = TRUE;
		} else {
			data->_tmp5_ = !g_file_equal (data->file, data->button_file);
		}
		if (data->_tmp5_) {
			gtk_file_chooser_set_current_folder_uri ((GtkFileChooser*) data->self->priv->button, data->_tmp6_ = g_file_get_uri (data->file));
			_g_free0 (data->_tmp6_);
			if (data->self->priv->tmpdir != NULL) {
				data->_tmp7_ = g_file_equal (data->file, data->self->priv->tmpdir);
			} else {
				data->_tmp7_ = FALSE;
			}
			deja_dup_config_location_set_is_s3 (data->self, data->_tmp7_);
		}
		_g_object_unref0 (data->button_file);
		_g_object_unref0 (data->_tmp0_);
		_g_free0 (data->uri);
	}
	goto __finally21;
	__catch21_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		{
			g_warning ("ConfigLocation.vala:117: %s\n", data->e->message);
			_g_error_free0 (data->e);
		}
	}
	__finally21:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (data->file);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void deja_dup_config_location_handle_selection_changed (DejaDupConfigLocation* self) {
	g_return_if_fail (self != NULL);
	deja_dup_config_location_set_file_info (self, NULL, NULL);
}


static void deja_dup_config_location_set_file_info_data_free (gpointer _data) {
	DejaDupConfigLocationSetFileInfoData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (DejaDupConfigLocationSetFileInfoData, data);
}


static void deja_dup_config_location_set_file_info (DejaDupConfigLocation* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupConfigLocationSetFileInfoData* _data_;
	_data_ = g_slice_new0 (DejaDupConfigLocationSetFileInfoData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_config_location_set_file_info);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_config_location_set_file_info_data_free);
	_data_->self = g_object_ref (self);
	deja_dup_config_location_set_file_info_co (_data_);
}


static void deja_dup_config_location_set_file_info_finish (DejaDupConfigLocation* self, GAsyncResult* _res_) {
	DejaDupConfigLocationSetFileInfoData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void deja_dup_config_location_set_file_info_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupConfigLocationSetFileInfoData* data;
	data = _user_data_;
	data->_res_ = _res_;
	deja_dup_config_location_set_file_info_co (data);
}


static gboolean deja_dup_config_location_set_file_info_co (DejaDupConfigLocationSetFileInfoData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 2:
		goto _state_2;
	}
	_state_0:
	data->gconf_file = NULL;
	{
		data->_tmp0_ = deja_dup_config_location_get_file_from_gconf (data->self, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			goto __catch22_g_error;
		}
		data->gconf_file = (data->_tmp1_ = data->_tmp0_, _g_object_unref0 (data->gconf_file), data->_tmp1_);
	}
	goto __finally22;
	__catch22_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		{
			_g_error_free0 (data->err);
		}
	}
	__finally22:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->gconf_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->uri = gtk_file_chooser_get_uri ((GtkFileChooser*) data->self->priv->button);
	if (data->uri == NULL) {
		data->_tmp2_ = (data->_tmp3_ = NULL, _g_object_unref0 (data->_tmp2_), data->_tmp3_);
	} else {
		data->_tmp2_ = (data->_tmp4_ = g_file_new_for_uri (data->uri), _g_object_unref0 (data->_tmp2_), data->_tmp4_);
	}
	data->file = _g_object_ref0 (data->_tmp2_);
	if (data->file == NULL) {
		data->_tmp5_ = TRUE;
	} else {
		data->_tmp5_ = g_file_equal (data->file, data->gconf_file);
	}
	if (data->_tmp5_) {
		_g_object_unref0 (data->file);
		_g_object_unref0 (data->_tmp2_);
		_g_free0 (data->uri);
		_g_object_unref0 (data->gconf_file);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	if (data->self->priv->tmpdir != NULL) {
		data->_tmp6_ = g_file_equal (data->file, data->self->priv->tmpdir);
	} else {
		data->_tmp6_ = FALSE;
	}
	deja_dup_config_location_set_is_s3 (data->self, data->_tmp6_);
	{
		if (data->self->priv->_is_s3) {
			gconf_client_set_string (((DejaDupConfigWidget*) data->self)->client, DEJA_DUP_BACKEND_KEY, "s3", &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				goto __catch23_g_error;
			}
		} else {
			gconf_client_set_string (((DejaDupConfigWidget*) data->self)->client, DEJA_DUP_BACKEND_KEY, "file", &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				goto __catch23_g_error;
			}
			gconf_client_set_string (((DejaDupConfigWidget*) data->self)->client, DEJA_DUP_FILE_PATH_KEY, data->_tmp7_ = g_file_get_parse_name (data->file), &data->_inner_error_);
			_g_free0 (data->_tmp7_);
			if (data->_inner_error_ != NULL) {
				goto __catch23_g_error;
			}
			data->_state_ = 2;
			deja_dup_backend_file_check_for_volume_info (data->file, deja_dup_config_location_set_file_info_ready, data);
			return FALSE;
			_state_2:
			deja_dup_backend_file_check_for_volume_info_finish (data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				goto __catch23_g_error;
			}
		}
	}
	goto __finally23;
	__catch23_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		{
			g_warning ("ConfigLocation.vala:151: %s\n", data->e->message);
			_g_error_free0 (data->e);
		}
	}
	__finally23:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->file);
		_g_object_unref0 (data->_tmp2_);
		_g_free0 (data->uri);
		_g_object_unref0 (data->gconf_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	g_signal_emit_by_name ((DejaDupConfigWidget*) data->self, "changed");
	_g_object_unref0 (data->file);
	_g_object_unref0 (data->_tmp2_);
	_g_free0 (data->uri);
	_g_object_unref0 (data->gconf_file);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void _deja_dup_config_location_handle_dialog_show_gtk_widget_show (GtkWidget* _sender, gpointer self) {
	deja_dup_config_location_handle_dialog_show (self, _sender);
}


static void _deja_dup_config_location_handle_dialog_hide_gtk_widget_hide (GtkWidget* _sender, gpointer self) {
	deja_dup_config_location_handle_dialog_hide (self, _sender);
}


static void deja_dup_config_location_add_special_location (DejaDupConfigLocation* self) {
	char* template;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	template = g_build_filename (g_get_tmp_dir (), "deja-dup-XXXXXX", NULL);
	self->priv->top_tmpdir = (_tmp0_ = g_file_new_for_path (mkdtemp (template)), _g_object_unref0 (self->priv->top_tmpdir), _tmp0_);
	self->priv->tmpdir = (_tmp1_ = g_file_get_child (self->priv->top_tmpdir, self->priv->s3_name), _g_object_unref0 (self->priv->tmpdir), _tmp1_);
	{
		char* _tmp2_;
		g_file_make_directory (self->priv->tmpdir, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch24_g_error;
		}
		gtk_file_chooser_add_shortcut_folder_uri ((GtkFileChooser*) self->priv->button, _tmp2_ = g_file_get_uri (self->priv->tmpdir), &_inner_error_);
		_g_free0 (_tmp2_);
		if (_inner_error_ != NULL) {
			goto __catch24_g_error;
		}
		g_signal_connect_object ((GtkWidget*) self->priv->dialog, "show", (GCallback) _deja_dup_config_location_handle_dialog_show_gtk_widget_show, self, 0);
		g_signal_connect_object ((GtkWidget*) self->priv->dialog, "hide", (GCallback) _deja_dup_config_location_handle_dialog_hide_gtk_widget_hide, self, 0);
	}
	goto __finally24;
	__catch24_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("ConfigLocation.vala:172: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally24:
	if (_inner_error_ != NULL) {
		_g_free0 (template);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (template);
}


static void deja_dup_config_location_handle_dialog_show (DejaDupConfigLocation* self, GtkWidget* w) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	if (self->priv->_is_s3) {
		gtk_file_chooser_set_current_folder ((GtkFileChooser*) self->priv->button, g_get_home_dir ());
	}
	{
		char* _tmp0_;
		gtk_file_chooser_remove_shortcut_folder_uri ((GtkFileChooser*) self->priv->button, _tmp0_ = g_file_get_uri (self->priv->tmpdir), &_inner_error_);
		_g_free0 (_tmp0_);
		if (_inner_error_ != NULL) {
			goto __catch25_g_error;
		}
	}
	goto __finally25;
	__catch25_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("ConfigLocation.vala:188: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally25:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void deja_dup_config_location_handle_dialog_hide (DejaDupConfigLocation* self, GtkWidget* w) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	{
		char* _tmp0_;
		gtk_file_chooser_add_shortcut_folder_uri ((GtkFileChooser*) self->priv->button, _tmp0_ = g_file_get_uri (self->priv->tmpdir), &_inner_error_);
		_g_free0 (_tmp0_);
		if (_inner_error_ != NULL) {
			goto __catch26_g_error;
		}
	}
	goto __finally26;
	__catch26_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("ConfigLocation.vala:198: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally26:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


DejaDupConfigLocation* deja_dup_config_location_construct (GType object_type) {
	DejaDupConfigLocation * self;
	self = (DejaDupConfigLocation*) deja_dup_config_widget_construct (object_type);
	return self;
}


DejaDupConfigLocation* deja_dup_config_location_new (void) {
	return deja_dup_config_location_construct (DEJA_DUP_TYPE_CONFIG_LOCATION);
}


gboolean deja_dup_config_location_get_is_s3 (DejaDupConfigLocation* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_s3;
	return result;
}


static void deja_dup_config_location_set_is_s3 (DejaDupConfigLocation* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_s3 = value;
	g_object_notify ((GObject *) self, "is-s3");
}


static gboolean _lambda4_ (GtkWidget* w, gboolean g, DejaDupConfigLocation* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (w != NULL, FALSE);
	result = gtk_widget_mnemonic_activate ((GtkWidget*) self->priv->button, g);
	return result;
}


static gboolean __lambda4__gtk_widget_mnemonic_activate (GtkWidget* _sender, gboolean group_cycling, gpointer self) {
	gboolean result;
	result = _lambda4_ (_sender, group_cycling, self);
	return result;
}


static void _deja_dup_config_location_handle_selection_changed_gtk_file_chooser_selection_changed (GtkFileChooser* _sender, gpointer self) {
	deja_dup_config_location_handle_selection_changed (self);
}


static GObject * deja_dup_config_location_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DejaDupConfigLocation * self;
	parent_class = G_OBJECT_CLASS (deja_dup_config_location_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DEJA_DUP_CONFIG_LOCATION (obj);
	{
		GtkHBox* hbox;
		GtkFileChooserDialog* _tmp0_;
		char* _tmp1_;
		gboolean _tmp2_;
		gboolean has_connect_prog;
		GtkFileChooserButton* _tmp3_;
		char* _tmp4_;
		hbox = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) hbox);
		self->priv->dialog = (_tmp0_ = g_object_ref_sink ((GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_ ("Select Backup Location"), NULL, GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER, NULL, NULL)), _g_object_unref0 (self->priv->dialog), _tmp0_);
		has_connect_prog = (_tmp2_ = (_tmp1_ = g_find_program_in_path ("nautilus-connect-server")) != NULL, _g_free0 (_tmp1_), _tmp2_);
		if (has_connect_prog) {
			DejaDupButtonConnect* button;
			GtkBox* action_area;
			button = g_object_ref_sink (deja_dup_button_connect_new ());
			action_area = _g_object_ref0 (GTK_BOX (gtk_dialog_get_action_area ((GtkDialog*) self->priv->dialog)));
			gtk_box_pack_end (action_area, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
			gtk_widget_show_all ((GtkWidget*) button);
			_g_object_unref0 (action_area);
			_g_object_unref0 (button);
		}
		gtk_dialog_add_buttons ((GtkDialog*) self->priv->dialog, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL);
		gtk_dialog_set_default_response ((GtkDialog*) self->priv->dialog, (gint) GTK_RESPONSE_ACCEPT);
		self->priv->button = (_tmp3_ = g_object_ref_sink ((GtkFileChooserButton*) gtk_file_chooser_button_new_with_dialog ((GtkWidget*) self->priv->dialog)), _g_object_unref0 (self->priv->button), _tmp3_);
		gtk_file_chooser_set_local_only ((GtkFileChooser*) self->priv->button, FALSE);
		gtk_container_add ((GtkContainer*) hbox, (GtkWidget*) self->priv->button);
		if (has_connect_prog) {
			DejaDupButtonConnect* connect_button;
			connect_button = g_object_ref_sink (deja_dup_button_connect_new ());
			gtk_container_add ((GtkContainer*) hbox, (GtkWidget*) connect_button);
			_g_object_unref0 (connect_button);
		}
		g_signal_connect_object ((GtkWidget*) self, "mnemonic-activate", (GCallback) __lambda4__gtk_widget_mnemonic_activate, self, 0);
		self->priv->s3_name = (_tmp4_ = g_strdup (_ ("Amazon S3")), _g_free0 (self->priv->s3_name), _tmp4_);
		deja_dup_config_location_add_special_location (self);
		deja_dup_config_widget_set_from_config ((DejaDupConfigWidget*) self, NULL, NULL);
		g_signal_connect_object ((GtkFileChooser*) self->priv->button, "selection-changed", (GCallback) _deja_dup_config_location_handle_selection_changed_gtk_file_chooser_selection_changed, self, 0);
		deja_dup_config_widget_watch_key ((DejaDupConfigWidget*) self, DEJA_DUP_BACKEND_KEY);
		deja_dup_config_widget_watch_key ((DejaDupConfigWidget*) self, DEJA_DUP_FILE_PATH_KEY);
		_g_object_unref0 (hbox);
	}
	return obj;
}


static void deja_dup_config_location_class_init (DejaDupConfigLocationClass * klass) {
	deja_dup_config_location_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupConfigLocationPrivate));
	DEJA_DUP_CONFIG_WIDGET_CLASS (klass)->set_from_config = deja_dup_config_location_real_set_from_config;
	DEJA_DUP_CONFIG_WIDGET_CLASS (klass)->set_from_config_finish = deja_dup_config_location_real_set_from_config_finish;
	G_OBJECT_CLASS (klass)->get_property = deja_dup_config_location_get_property;
	G_OBJECT_CLASS (klass)->set_property = deja_dup_config_location_set_property;
	G_OBJECT_CLASS (klass)->constructor = deja_dup_config_location_constructor;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_config_location_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_CONFIG_LOCATION_IS_S3, g_param_spec_boolean ("is-s3", "is-s3", "is-s3", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void deja_dup_config_location_instance_init (DejaDupConfigLocation * self) {
	self->priv = DEJA_DUP_CONFIG_LOCATION_GET_PRIVATE (self);
}


static void deja_dup_config_location_finalize (GObject* obj) {
	DejaDupConfigLocation * self;
	GError * _inner_error_;
	self = DEJA_DUP_CONFIG_LOCATION (obj);
	_inner_error_ = NULL;
	{
		{
			g_file_delete (self->priv->tmpdir, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch27_g_error;
			}
			g_file_delete (self->priv->top_tmpdir, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch27_g_error;
			}
		}
		goto __finally27;
		__catch27_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("ConfigLocation.vala:83: %s\n", e->message);
				_g_error_free0 (e);
			}
		}
		__finally27:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
	}
	_g_object_unref0 (self->priv->dialog);
	_g_object_unref0 (self->priv->button);
	_g_object_unref0 (self->priv->top_tmpdir);
	_g_object_unref0 (self->priv->tmpdir);
	_g_free0 (self->priv->s3_name);
	G_OBJECT_CLASS (deja_dup_config_location_parent_class)->finalize (obj);
}


GType deja_dup_config_location_get_type (void) {
	static volatile gsize deja_dup_config_location_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_config_location_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupConfigLocationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_config_location_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupConfigLocation), 0, (GInstanceInitFunc) deja_dup_config_location_instance_init, NULL };
		GType deja_dup_config_location_type_id;
		deja_dup_config_location_type_id = g_type_register_static (DEJA_DUP_TYPE_CONFIG_WIDGET, "DejaDupConfigLocation", &g_define_type_info, 0);
		g_once_init_leave (&deja_dup_config_location_type_id__volatile, deja_dup_config_location_type_id);
	}
	return deja_dup_config_location_type_id__volatile;
}


static void deja_dup_config_location_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DejaDupConfigLocation * self;
	self = DEJA_DUP_CONFIG_LOCATION (object);
	switch (property_id) {
		case DEJA_DUP_CONFIG_LOCATION_IS_S3:
		g_value_set_boolean (value, deja_dup_config_location_get_is_s3 (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void deja_dup_config_location_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DejaDupConfigLocation * self;
	self = DEJA_DUP_CONFIG_LOCATION (object);
	switch (property_id) {
		case DEJA_DUP_CONFIG_LOCATION_IS_S3:
		deja_dup_config_location_set_is_s3 (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




