/* -*- Mode: C; indent-tabs-mode: nil; tab-width: 2 -*- */

#include "StatusIcon.h"
#include <OperationBackup.h>
#include <libnotify/notify.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <Operation.h>
#include <config.h>
#include <libdeja-dup.h>




struct _StatusIconPrivate {
	DejaDupOperationBackup* op;
	NotifyNotification* note;
	gboolean need_passphrase;
	gboolean fatal_error;
	double progress;
	char* action;
};

#define STATUS_ICON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_STATUS_ICON, StatusIconPrivate))
enum  {
	STATUS_ICON_DUMMY_PROPERTY
};
static void status_icon_send_done (StatusIcon* self, DejaDupOperationBackup* op, gboolean success);
static void status_icon_set_action_desc (StatusIcon* self, DejaDupOperationBackup* op, const char* action);
static void status_icon_note_progress (StatusIcon* self, DejaDupOperationBackup* op, double percent);
static void status_icon_update_tooltip (StatusIcon* self);
static gboolean status_icon_start_idle (StatusIcon* self);
static void _status_icon_send_done_deja_dup_operation_done (DejaDupOperationBackup* _sender, gboolean success, gpointer self);
static gboolean _status_icon_notify_passphrase_deja_dup_operation_passphrase_required (DejaDupOperationBackup* _sender, gpointer self);
static gboolean _status_icon_notify_backend_password_deja_dup_operation_backend_password_required (DejaDupOperationBackup* _sender, gpointer self);
static void _status_icon_notify_error_deja_dup_operation_raise_error (DejaDupOperationBackup* _sender, const char* errstr, const char* detail, gpointer self);
static void _status_icon_set_action_desc_deja_dup_operation_action_desc_changed (DejaDupOperationBackup* _sender, const char* action, gpointer self);
static void _status_icon_note_progress_deja_dup_operation_progress (DejaDupOperationBackup* _sender, double percent, gpointer self);
static void status_icon_start (StatusIcon* self, gboolean warn);
static void status_icon_begin_backup (StatusIcon* self);
static void _status_icon_begin_backup_notify_notification_closed (NotifyNotification* _sender, gpointer self);
static void status_icon_notify_start (StatusIcon* self);
static void _status_icon_activate_enter_gtk_status_icon_activate (StatusIcon* _sender, gpointer self);
static gboolean status_icon_notify_passphrase (StatusIcon* self, DejaDupOperationBackup* op);
static gboolean status_icon_notify_backend_password (StatusIcon* self, DejaDupOperationBackup* op);
static void _status_icon_error_closed_notify_notification_closed (NotifyNotification* _sender, gpointer self);
static void status_icon_notify_error (StatusIcon* self, DejaDupOperationBackup* op, const char* errstr, const char* detail);
static void status_icon_end_notify (StatusIcon* self, NotifyNotification* note);
static void status_icon_error_closed (StatusIcon* self, NotifyNotification* note);
static void status_icon_enter (NotifyNotification* note, const char* action, StatusIcon* icon);
static void status_icon_activate_enter (StatusIcon* self);
static void status_icon_rerun (NotifyNotification* note, const char* action, StatusIcon* icon);
static void status_icon_later (NotifyNotification* note, const char* action, StatusIcon* icon);
static void status_icon_skip (NotifyNotification* note, const char* action, StatusIcon* icon);
static void _status_icon_later_clicked_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _status_icon_skip_clicked_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _status_icon_preferences_clicked_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _status_icon_about_clicked_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _gtk_status_icon_position_menu_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self);
static void status_icon_show_menu (StatusIcon* self, StatusIcon* status_icon, guint button, guint activate_time);
static void status_icon_later_clicked (StatusIcon* self, GtkMenuItem* item);
static void status_icon_skip_clicked (StatusIcon* self, GtkMenuItem* item);
static void status_icon_about_clicked (StatusIcon* self, GtkMenuItem* item);
static void status_icon_preferences_clicked (StatusIcon* self, GtkMenuItem* item);
static gboolean _status_icon_start_idle_gsource_func (gpointer self);
static void _status_icon_show_menu_gtk_status_icon_popup_menu (StatusIcon* _sender, guint button, guint activate_time, gpointer self);
static GObject * status_icon_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer status_icon_parent_class = NULL;
static void status_icon_finalize (GObject* obj);



static void status_icon_send_done (StatusIcon* self, DejaDupOperationBackup* op, gboolean success) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	g_signal_emit_by_name (self, "done");
}


static void status_icon_set_action_desc (StatusIcon* self, DejaDupOperationBackup* op, const char* action) {
	char* _tmp1;
	const char* _tmp0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	g_return_if_fail (action != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->action = (_tmp1 = (_tmp0 = action, (_tmp0 == NULL) ? NULL : g_strdup (_tmp0)), self->priv->action = (g_free (self->priv->action), NULL), _tmp1);
	status_icon_update_tooltip (self);
}


static void status_icon_note_progress (StatusIcon* self, DejaDupOperationBackup* op, double percent) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	self->priv->progress = percent;
	status_icon_update_tooltip (self);
}


static void status_icon_update_tooltip (StatusIcon* self) {
	char* tooltip;
	g_return_if_fail (self != NULL);
	tooltip = g_strdup ("");
	if (self->priv->action != NULL) {
		char* _tmp1;
		const char* _tmp0;
		_tmp1 = NULL;
		_tmp0 = NULL;
		tooltip = (_tmp1 = (_tmp0 = self->priv->action, (_tmp0 == NULL) ? NULL : g_strdup (_tmp0)), tooltip = (g_free (tooltip), NULL), _tmp1);
	}
	if (self->priv->progress > 0) {
		char* _tmp4;
		char* _tmp3;
		char* _tmp2;
		_tmp4 = NULL;
		_tmp3 = NULL;
		_tmp2 = NULL;
		tooltip = (_tmp4 = g_strconcat (_tmp2 = g_strconcat (tooltip, "\n", NULL), _tmp3 = g_strdup_printf (_ ("%.1f%% complete"), self->priv->progress * 100), NULL), tooltip = (g_free (tooltip), NULL), _tmp4);
		_tmp3 = (g_free (_tmp3), NULL);
		_tmp2 = (g_free (_tmp2), NULL);
	}
	gtk_status_icon_set_tooltip ((GtkStatusIcon*) self, tooltip);
	tooltip = (g_free (tooltip), NULL);
}


static gboolean status_icon_start_idle (StatusIcon* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	status_icon_start (self, TRUE);
	return FALSE;
}


static void _status_icon_send_done_deja_dup_operation_done (DejaDupOperationBackup* _sender, gboolean success, gpointer self) {
	status_icon_send_done (self, _sender, success);
}


static gboolean _status_icon_notify_passphrase_deja_dup_operation_passphrase_required (DejaDupOperationBackup* _sender, gpointer self) {
	return status_icon_notify_passphrase (self, _sender);
}


static gboolean _status_icon_notify_backend_password_deja_dup_operation_backend_password_required (DejaDupOperationBackup* _sender, gpointer self) {
	return status_icon_notify_backend_password (self, _sender);
}


static void _status_icon_notify_error_deja_dup_operation_raise_error (DejaDupOperationBackup* _sender, const char* errstr, const char* detail, gpointer self) {
	status_icon_notify_error (self, _sender, errstr, detail);
}


static void _status_icon_set_action_desc_deja_dup_operation_action_desc_changed (DejaDupOperationBackup* _sender, const char* action, gpointer self) {
	status_icon_set_action_desc (self, _sender, action);
}


static void _status_icon_note_progress_deja_dup_operation_progress (DejaDupOperationBackup* _sender, double percent, gpointer self) {
	status_icon_note_progress (self, _sender, percent);
}


static void status_icon_start (StatusIcon* self, gboolean warn) {
	DejaDupOperationBackup* _tmp0;
	g_return_if_fail (self != NULL);
	self->priv->need_passphrase = FALSE;
	self->priv->fatal_error = FALSE;
	self->priv->progress = (double) 0;
	_tmp0 = NULL;
	self->priv->op = (_tmp0 = deja_dup_operation_backup_new (NULL, (guint) gtk_status_icon_get_x11_window_id ((GtkStatusIcon*) self)), (self->priv->op == NULL) ? NULL : (self->priv->op = (g_object_unref (self->priv->op), NULL)), _tmp0);
	g_signal_connect_object ((DejaDupOperation*) self->priv->op, "done", (GCallback) _status_icon_send_done_deja_dup_operation_done, self, 0);
	g_signal_connect_object ((DejaDupOperation*) self->priv->op, "passphrase-required", (GCallback) _status_icon_notify_passphrase_deja_dup_operation_passphrase_required, self, 0);
	g_signal_connect_object ((DejaDupOperation*) self->priv->op, "backend-password-required", (GCallback) _status_icon_notify_backend_password_deja_dup_operation_backend_password_required, self, 0);
	g_signal_connect_object ((DejaDupOperation*) self->priv->op, "raise-error", (GCallback) _status_icon_notify_error_deja_dup_operation_raise_error, self, 0);
	g_signal_connect_object ((DejaDupOperation*) self->priv->op, "action-desc-changed", (GCallback) _status_icon_set_action_desc_deja_dup_operation_action_desc_changed, self, 0);
	g_signal_connect_object ((DejaDupOperation*) self->priv->op, "progress", (GCallback) _status_icon_note_progress_deja_dup_operation_progress, self, 0);
	if (warn) {
		status_icon_notify_start (self);
	} else {
		status_icon_begin_backup (self);
	}
}


static void status_icon_begin_backup (StatusIcon* self) {
	GError * inner_error;
	g_return_if_fail (self != NULL);
	inner_error = NULL;
	{
		deja_dup_operation_start ((DejaDupOperation*) self->priv->op, &inner_error);
		if (inner_error != NULL) {
			goto __catch0_g_error;
			goto __finally0;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning ("StatusIcon.vala:108: %s\n", e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally0:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
}


static void _status_icon_begin_backup_notify_notification_closed (NotifyNotification* _sender, gpointer self) {
	status_icon_begin_backup (self);
}


static void status_icon_notify_start (StatusIcon* self) {
	GError * inner_error;
	NotifyNotification* _tmp0;
	g_return_if_fail (self != NULL);
	inner_error = NULL;
	_tmp0 = NULL;
	self->priv->note = (_tmp0 = notify_notification_new_with_status_icon (_ ("Backup about to start"), _ ("A scheduled backup will shortly begin.  You can instead choose to backup later or not at all."), PACKAGE, (GtkStatusIcon*) self), (self->priv->note == NULL) ? NULL : (self->priv->note = (g_object_unref (self->priv->note), NULL)), _tmp0);
	notify_notification_add_action (self->priv->note, "skip", _ ("Skip Backup"), (NotifyActionCallback) status_icon_skip, self, NULL);
	notify_notification_add_action (self->priv->note, "later", _ ("Backup Later"), (NotifyActionCallback) status_icon_later, self, NULL);
	g_signal_connect_object (self->priv->note, "closed", (GCallback) _status_icon_begin_backup_notify_notification_closed, self, 0);
	{
		notify_notification_show (self->priv->note, &inner_error);
		if (inner_error != NULL) {
			goto __catch1_g_error;
			goto __finally1;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning ("StatusIcon.vala:123: %s\n", e->message);
			status_icon_begin_backup (self);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally1:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
}


static void _status_icon_activate_enter_gtk_status_icon_activate (StatusIcon* _sender, gpointer self) {
	status_icon_activate_enter (self);
}


static gboolean status_icon_notify_passphrase (StatusIcon* self, DejaDupOperationBackup* op) {
	GError * inner_error;
	NotifyNotification* _tmp0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (op != NULL, FALSE);
	inner_error = NULL;
	self->priv->need_passphrase = TRUE;
	gtk_status_icon_set_blinking ((GtkStatusIcon*) self, TRUE);
	g_signal_connect_object ((GtkStatusIcon*) self, "activate", (GCallback) _status_icon_activate_enter_gtk_status_icon_activate, self, 0);
	_tmp0 = NULL;
	self->priv->note = (_tmp0 = notify_notification_new_with_status_icon (_ ("Encryption password needed"), _ ("Please enter the encryption password for your backup files."), "dialog-password", (GtkStatusIcon*) self), (self->priv->note == NULL) ? NULL : (self->priv->note = (g_object_unref (self->priv->note), NULL)), _tmp0);
	notify_notification_add_action (self->priv->note, "default", _ ("Enter"), (NotifyActionCallback) status_icon_enter, self, NULL);
	{
		notify_notification_show (self->priv->note, &inner_error);
		if (inner_error != NULL) {
			goto __catch2_g_error;
			goto __finally2;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning ("StatusIcon.vala:141: %s\n", e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally2:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return FALSE;
	}
	return FALSE;
}


/* don't immediately ask user, wait for our response*/
static gboolean status_icon_notify_backend_password (StatusIcon* self, DejaDupOperationBackup* op) {
	GError * inner_error;
	NotifyNotification* _tmp0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (op != NULL, FALSE);
	inner_error = NULL;
	gtk_status_icon_set_blinking ((GtkStatusIcon*) self, TRUE);
	g_signal_connect_object ((GtkStatusIcon*) self, "activate", (GCallback) _status_icon_activate_enter_gtk_status_icon_activate, self, 0);
	_tmp0 = NULL;
	self->priv->note = (_tmp0 = notify_notification_new_with_status_icon (_ ("Server password needed"), _ ("Please enter the server password for your backup."), "dialog-password", (GtkStatusIcon*) self), (self->priv->note == NULL) ? NULL : (self->priv->note = (g_object_unref (self->priv->note), NULL)), _tmp0);
	notify_notification_add_action (self->priv->note, "default", _ ("Enter"), (NotifyActionCallback) status_icon_enter, self, NULL);
	{
		notify_notification_show (self->priv->note, &inner_error);
		if (inner_error != NULL) {
			goto __catch3_g_error;
			goto __finally3;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning ("StatusIcon.vala:158: %s\n", e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally3:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return FALSE;
	}
	return FALSE;
}


static void _status_icon_error_closed_notify_notification_closed (NotifyNotification* _sender, gpointer self) {
	status_icon_error_closed (self, _sender);
}


/* don't immediately ask user, wait for our response*/
static void status_icon_notify_error (StatusIcon* self, DejaDupOperationBackup* op, const char* errstr, const char* detail) {
	GError * inner_error;
	guint _tmp0;
	NotifyNotification* _tmp1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	g_return_if_fail (errstr != NULL);
	inner_error = NULL;
	/* TODO: Do something sane with detail.  Not urgent right now, it's only used for restore
	 We want to stay open until user acknowledges our error/it times out*/
	g_signal_handlers_disconnect_matched ((DejaDupOperation*) op, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, (g_signal_parse_name ("done", DEJA_DUP_TYPE_OPERATION, &_tmp0, NULL, FALSE), _tmp0), 0, NULL, (GCallback) _status_icon_send_done_deja_dup_operation_done, self);
	self->priv->fatal_error = TRUE;
	_tmp1 = NULL;
	self->priv->note = (_tmp1 = notify_notification_new_with_status_icon (_ ("Backup error occurred"), errstr, "dialog-error", (GtkStatusIcon*) self), (self->priv->note == NULL) ? NULL : (self->priv->note = (g_object_unref (self->priv->note), NULL)), _tmp1);
	notify_notification_add_action (self->priv->note, "rerun", _ ("Rerun"), (NotifyActionCallback) status_icon_rerun, self, NULL);
	notify_notification_set_timeout (self->priv->note, NOTIFY_EXPIRES_NEVER);
	g_signal_connect_object (self->priv->note, "closed", (GCallback) _status_icon_error_closed_notify_notification_closed, self, 0);
	{
		notify_notification_show (self->priv->note, &inner_error);
		if (inner_error != NULL) {
			goto __catch4_g_error;
			goto __finally4;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning ("StatusIcon.vala:178: %s\n", e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally4:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
}


static void status_icon_end_notify (StatusIcon* self, NotifyNotification* note) {
	guint _tmp0;
	g_return_if_fail (self != NULL);
	gtk_status_icon_set_blinking ((GtkStatusIcon*) self, FALSE);
	g_signal_handlers_disconnect_matched ((GtkStatusIcon*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, (g_signal_parse_name ("activate", GTK_TYPE_STATUS_ICON, &_tmp0, NULL, FALSE), _tmp0), 0, NULL, (GCallback) _status_icon_activate_enter_gtk_status_icon_activate, self);
}


static void status_icon_error_closed (StatusIcon* self, NotifyNotification* note) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (note != NULL);
	if (self->priv->fatal_error) {
		g_signal_emit_by_name (self, "done");
	}
}


static void status_icon_enter (NotifyNotification* note, const char* action, StatusIcon* icon) {
	GError * inner_error;
	g_return_if_fail (icon != NULL);
	inner_error = NULL;
	{
		if (icon->priv->need_passphrase) {
			deja_dup_operation_ask_passphrase ((DejaDupOperation*) icon->priv->op, &inner_error);
			if (inner_error != NULL) {
				goto __catch5_g_error;
				goto __finally5;
			}
			icon->priv->need_passphrase = FALSE;
		} else {
			deja_dup_operation_ask_backend_password ((DejaDupOperation*) icon->priv->op, &inner_error);
			if (inner_error != NULL) {
				goto __catch5_g_error;
				goto __finally5;
			}
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning ("StatusIcon.vala:204: %s\n", e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally5:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	status_icon_end_notify (icon, note);
}


static void status_icon_activate_enter (StatusIcon* self) {
	g_return_if_fail (self != NULL);
	status_icon_enter (self->priv->note, NULL, self);
}


static void status_icon_rerun (NotifyNotification* note, const char* action, StatusIcon* icon) {
	g_return_if_fail (icon != NULL);
	icon->priv->fatal_error = FALSE;
	status_icon_start (icon, FALSE);
}


static void status_icon_later (NotifyNotification* note, const char* action, StatusIcon* icon) {
	g_return_if_fail (icon != NULL);
	status_icon_end_notify (icon, note);
	deja_dup_operation_cancel ((DejaDupOperation*) icon->priv->op);
}


static void status_icon_skip (NotifyNotification* note, const char* action, StatusIcon* icon) {
	GError * inner_error;
	g_return_if_fail (icon != NULL);
	inner_error = NULL;
	{
		deja_dup_update_last_run_timestamp (&inner_error);
		if (inner_error != NULL) {
			goto __catch6_g_error;
			goto __finally6;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning ("StatusIcon.vala:233: %s\n", e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally6:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	status_icon_end_notify (icon, note);
	deja_dup_operation_cancel ((DejaDupOperation*) icon->priv->op);
}


static void _status_icon_later_clicked_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	status_icon_later_clicked (self, _sender);
}


static void _status_icon_skip_clicked_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	status_icon_skip_clicked (self, _sender);
}


static void _status_icon_preferences_clicked_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	status_icon_preferences_clicked (self, _sender);
}


static void _status_icon_about_clicked_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	status_icon_about_clicked (self, _sender);
}


static void _gtk_status_icon_position_menu_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self) {
	gtk_status_icon_position_menu (menu, x, y, push_in, self);
}


static void status_icon_show_menu (StatusIcon* self, StatusIcon* status_icon, guint button, guint activate_time) {
	GtkMenu* menu;
	GtkMenuItem* item;
	GtkMenuItem* _tmp0;
	GtkMenuItem* _tmp1;
	GtkMenuItem* _tmp2;
	GtkMenuItem* _tmp3;
	GtkMenuItem* _tmp4;
	g_return_if_fail (self != NULL);
	g_return_if_fail (status_icon != NULL);
	menu = g_object_ref_sink ((GtkMenu*) gtk_menu_new ());
	item = NULL;
	_tmp0 = NULL;
	item = (_tmp0 = g_object_ref_sink ((GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("Backup _Later"))), (item == NULL) ? NULL : (item = (g_object_unref (item), NULL)), _tmp0);
	g_signal_connect_object (item, "activate", (GCallback) _status_icon_later_clicked_gtk_menu_item_activate, self, 0);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) item);
	_tmp1 = NULL;
	item = (_tmp1 = g_object_ref_sink ((GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("_Skip Backup"))), (item == NULL) ? NULL : (item = (g_object_unref (item), NULL)), _tmp1);
	g_signal_connect_object (item, "activate", (GCallback) _status_icon_skip_clicked_gtk_menu_item_activate, self, 0);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) item);
	_tmp2 = NULL;
	item = (_tmp2 = (GtkMenuItem*) g_object_ref_sink ((GtkSeparatorMenuItem*) gtk_separator_menu_item_new ()), (item == NULL) ? NULL : (item = (g_object_unref (item), NULL)), _tmp2);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) item);
	_tmp3 = NULL;
	item = (_tmp3 = (GtkMenuItem*) g_object_ref_sink ((GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_PREFERENCES, NULL)), (item == NULL) ? NULL : (item = (g_object_unref (item), NULL)), _tmp3);
	g_signal_connect_object (item, "activate", (GCallback) _status_icon_preferences_clicked_gtk_menu_item_activate, self, 0);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) item);
	_tmp4 = NULL;
	item = (_tmp4 = (GtkMenuItem*) g_object_ref_sink ((GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_ABOUT, NULL)), (item == NULL) ? NULL : (item = (g_object_unref (item), NULL)), _tmp4);
	g_signal_connect_object (item, "activate", (GCallback) _status_icon_about_clicked_gtk_menu_item_activate, self, 0);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) item);
	gtk_widget_show_all ((GtkWidget*) menu);
	gtk_menu_popup (menu, NULL, NULL, _gtk_status_icon_position_menu_gtk_menu_position_func, (GtkStatusIcon*) self, button, (guint32) activate_time);
	(menu == NULL) ? NULL : (menu = (g_object_unref (menu), NULL));
	(item == NULL) ? NULL : (item = (g_object_unref (item), NULL));
}


static void status_icon_later_clicked (StatusIcon* self, GtkMenuItem* item) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	status_icon_later (self->priv->note, NULL, self);
}


static void status_icon_skip_clicked (StatusIcon* self, GtkMenuItem* item) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	status_icon_skip (self->priv->note, NULL, self);
}


static void status_icon_about_clicked (StatusIcon* self, GtkMenuItem* item) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	deja_dup_show_about ((GObject*) self, NULL);
}


static void status_icon_preferences_clicked (StatusIcon* self, GtkMenuItem* item) {
	GError * inner_error;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	inner_error = NULL;
	{
		g_spawn_command_line_async ("deja-dup-preferences", &inner_error);
		if (inner_error != NULL) {
			goto __catch7_g_error;
			goto __finally7;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			GtkMessageDialog* dlg;
			dlg = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _ ("Could not open preferences"), NULL));
			gtk_message_dialog_format_secondary_text (dlg, "%s", e->message, NULL);
			gtk_dialog_run ((GtkDialog*) dlg);
			gtk_object_destroy ((GtkObject*) dlg);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			(dlg == NULL) ? NULL : (dlg = (g_object_unref (dlg), NULL));
		}
	}
	__finally7:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
}


/*
    Déjà Dup Applet
    © 2008—2009 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
StatusIcon* status_icon_construct (GType object_type) {
	StatusIcon * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


StatusIcon* status_icon_new (void) {
	return status_icon_construct (TYPE_STATUS_ICON);
}


static gboolean _status_icon_start_idle_gsource_func (gpointer self) {
	return status_icon_start_idle (self);
}


static void _status_icon_show_menu_gtk_status_icon_popup_menu (StatusIcon* _sender, guint button, guint activate_time, gpointer self) {
	status_icon_show_menu (self, _sender, button, activate_time);
}


static GObject * status_icon_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	StatusIconClass * klass;
	GObjectClass * parent_class;
	StatusIcon * self;
	klass = STATUS_ICON_CLASS (g_type_class_peek (TYPE_STATUS_ICON));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = STATUS_ICON (obj);
	{
		g_object_set ((GtkStatusIcon*) self, "icon-name", PACKAGE, NULL);
		g_idle_add (_status_icon_start_idle_gsource_func, self);
		g_signal_connect_object ((GtkStatusIcon*) self, "popup-menu", (GCallback) _status_icon_show_menu_gtk_status_icon_popup_menu, self, 0);
	}
	return obj;
}


static void status_icon_class_init (StatusIconClass * klass) {
	status_icon_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (StatusIconPrivate));
	G_OBJECT_CLASS (klass)->constructor = status_icon_constructor;
	G_OBJECT_CLASS (klass)->finalize = status_icon_finalize;
	g_signal_new ("done", TYPE_STATUS_ICON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void status_icon_instance_init (StatusIcon * self) {
	self->priv = STATUS_ICON_GET_PRIVATE (self);
}


static void status_icon_finalize (GObject* obj) {
	StatusIcon * self;
	GError * inner_error;
	self = STATUS_ICON (obj);
	inner_error = NULL;
	{
		if (self->priv->note != NULL) {
			{
				notify_notification_close (self->priv->note, &inner_error);
				if (inner_error != NULL) {
					goto __catch8_g_error;
					goto __finally8;
				}
			}
			goto __finally8;
			__catch8_g_error:
			{
				GError * e;
				e = inner_error;
				inner_error = NULL;
				{
					g_warning ("StatusIcon.vala:46: %s\n", e->message);
					(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
				}
			}
			__finally8:
			if (inner_error != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
				g_clear_error (&inner_error);
			}
		}
	}
	(self->priv->op == NULL) ? NULL : (self->priv->op = (g_object_unref (self->priv->op), NULL));
	(self->priv->note == NULL) ? NULL : (self->priv->note = (g_object_unref (self->priv->note), NULL));
	self->priv->action = (g_free (self->priv->action), NULL);
	G_OBJECT_CLASS (status_icon_parent_class)->finalize (obj);
}


GType status_icon_get_type (void) {
	static GType status_icon_type_id = 0;
	if (status_icon_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (StatusIconClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) status_icon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StatusIcon), 0, (GInstanceInitFunc) status_icon_instance_init, NULL };
		status_icon_type_id = g_type_register_static (GTK_TYPE_STATUS_ICON, "StatusIcon", &g_define_type_info, 0);
	}
	return status_icon_type_id;
}




