/* -*- Mode: C; indent-tabs-mode: nil; tab-width: 2 -*- */

#include "applet.h"
#include <glib/gi18n-lib.h>
#include <config.h>
#include <gtk/gtk.h>
#include <libnotify/notify.h>
#include <DuplicityInfo.h>
#include <libdeja-dup.h>
#include "StatusIcon.h"




enum  {
	DEJA_DUP_APPLET_DUMMY_PROPERTY
};
static gboolean deja_dup_applet_show_version = FALSE;
static gboolean deja_dup_applet_handle_console_options (gint* status);
static void _gtk_main_quit_status_icon_done (StatusIcon* _sender, gpointer self);
static gpointer deja_dup_applet_parent_class = NULL;
static void deja_dup_applet_finalize (GObject* obj);

static const GOptionEntry DEJA_DUP_APPLET_options[] = {{"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &deja_dup_applet_show_version, N_ ("Show version"), NULL}, {NULL}};


static gboolean deja_dup_applet_handle_console_options (gint* status) {
	(*status) = 0;
	if (deja_dup_applet_show_version) {
		g_print ("%s %s\n", _ ("Déjà Dup Applet"), VERSION);
		return FALSE;
	}
	return TRUE;
}


static void _gtk_main_quit_status_icon_done (StatusIcon* _sender, gpointer self) {
	gtk_main_quit ();
}


gint deja_dup_applet_main (char** args, int args_length1) {
	GError * inner_error;
	GOptionContext* context;
	gint status;
	DejaDupDuplicityInfo* _tmp3;
	inner_error = NULL;
	textdomain (GETTEXT_PACKAGE);
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	/* Translators: 'Applet' in the sense of a notification area icon*/
	g_set_application_name (_ ("Déjà Dup Applet"));
	context = g_option_context_new ("");
	g_option_context_add_main_entries (context, DEJA_DUP_APPLET_options, GETTEXT_PACKAGE);
	g_option_context_add_group (context, gtk_get_option_group (FALSE));
	{
		g_option_context_parse (context, &args_length1, &args, &inner_error);
		if (inner_error != NULL) {
			goto __catch9_g_error;
			goto __finally9;
		}
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			char* _tmp0;
			gint _tmp1;
			_tmp0 = NULL;
			g_printerr ("%s\n\n%s", e->message, _tmp0 = g_option_context_get_help (context, TRUE, NULL));
			_tmp0 = (g_free (_tmp0), NULL);
			return (_tmp1 = 1, (e == NULL) ? NULL : (e = (g_error_free (e), NULL)), (context == NULL) ? NULL : (context = (g_option_context_free (context), NULL)), _tmp1);
		}
	}
	__finally9:
	if (inner_error != NULL) {
		(context == NULL) ? NULL : (context = (g_option_context_free (context), NULL));
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return 0;
	}
	status = 0;
	if (!deja_dup_applet_handle_console_options (&status)) {
		gint _tmp2;
		return (_tmp2 = status, (context == NULL) ? NULL : (context = (g_option_context_free (context), NULL)), _tmp2);
	}
	gtk_init (&args_length1, &args);
	/* to open display ('cause we passed false above)*/
	notify_init (g_get_application_name ());
	gtk_icon_theme_append_search_path (gtk_icon_theme_get_default (), THEME_DIR);
	gtk_window_set_default_icon_name (PACKAGE);
	_tmp3 = NULL;
	deja_dup_duplicity_info_check_duplicity_version (_tmp3 = deja_dup_duplicity_info_get_default (), NULL);
	(_tmp3 == NULL) ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL));
	/* Try to claim bus, else don't run.  If the regularly scheduled backup
	 occurs while user is doing a manual backup, we don't want to run.
	 We'll try again the next day.*/
	if (deja_dup_set_bus_claimed ("operation", TRUE)) {
		StatusIcon* icon;
		gint _tmp4;
		icon = status_icon_new ();
		g_signal_connect (icon, "done", (GCallback) _gtk_main_quit_status_icon_done, NULL);
		gtk_main ();
		deja_dup_set_bus_claimed ("operation", FALSE);
		return (_tmp4 = 0, (icon == NULL) ? NULL : (icon = (g_object_unref (icon), NULL)), (context == NULL) ? NULL : (context = (g_option_context_free (context), NULL)), _tmp4);
	} else {
		gint _tmp5;
		return (_tmp5 = 1, (context == NULL) ? NULL : (context = (g_option_context_free (context), NULL)), _tmp5);
	}
	(context == NULL) ? NULL : (context = (g_option_context_free (context), NULL));
}


int main (int argc, char ** argv) {
	g_type_init ();
	return deja_dup_applet_main (argv, argc);
}


/*
    Déjà Dup Applet
    © 2008—2009 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
DejaDupApplet* deja_dup_applet_construct (GType object_type) {
	DejaDupApplet * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


DejaDupApplet* deja_dup_applet_new (void) {
	return deja_dup_applet_construct (TYPE_DEJA_DUP_APPLET);
}


static void deja_dup_applet_class_init (DejaDupAppletClass * klass) {
	deja_dup_applet_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = deja_dup_applet_finalize;
}


static void deja_dup_applet_instance_init (DejaDupApplet * self) {
}


static void deja_dup_applet_finalize (GObject* obj) {
	DejaDupApplet * self;
	self = DEJA_DUP_APPLET (obj);
	G_OBJECT_CLASS (deja_dup_applet_parent_class)->finalize (obj);
}


GType deja_dup_applet_get_type (void) {
	static GType deja_dup_applet_type_id = 0;
	if (deja_dup_applet_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupApplet), 0, (GInstanceInitFunc) deja_dup_applet_instance_init, NULL };
		deja_dup_applet_type_id = g_type_register_static (G_TYPE_OBJECT, "DejaDupApplet", &g_define_type_info, 0);
	}
	return deja_dup_applet_type_id;
}




