/* -*- Mode: C; indent-tabs-mode: nil; tab-width: 2 -*- */

#include "AssistantBackup.h"
#include <glib/gi18n-lib.h>
#include <OperationBackup.h>
#include <Backend.h>
#include "MainWindow.h"




struct _AssistantBackupPrivate {
	GtkLabel* confirm_backup;
};

#define ASSISTANT_BACKUP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ASSISTANT_BACKUP, AssistantBackupPrivate))
enum  {
	ASSISTANT_BACKUP_DUMMY_PROPERTY
};
static void assistant_backup_real_add_setup_pages (AssistantOperation* base);
static GtkWidget* assistant_backup_real_make_confirm_page (AssistantOperation* base);
static DejaDupOperation* assistant_backup_real_create_op (AssistantOperation* base);
static char* assistant_backup_real_get_progress_file_prefix (AssistantOperation* base);
static GdkPixbuf* assistant_backup_real_get_op_icon (AssistantOperation* base);
static void assistant_backup_real_do_prepare (AssistantOperation* base, AssistantOperation* assist, GtkWidget* page);
static GObject * assistant_backup_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer assistant_backup_parent_class = NULL;
static void assistant_backup_finalize (GObject* obj);



static void assistant_backup_real_add_setup_pages (AssistantOperation* base) {
	AssistantBackup * self;
	self = (AssistantBackup*) base;
}


static GtkWidget* assistant_backup_real_make_confirm_page (AssistantOperation* base) {
	AssistantBackup * self;
	gint rows;
	GtkLabel* backup_label;
	GtkLabel* _tmp0;
	GtkTable* page;
	GtkWidget* _tmp1;
	self = (AssistantBackup*) base;
	rows = 0;
	backup_label = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Backup location:")));
	g_object_set ((GObject*) backup_label, "xalign", 0.0f, NULL);
	_tmp0 = NULL;
	self->priv->confirm_backup = (_tmp0 = g_object_ref_sink ((GtkLabel*) gtk_label_new ("")), (self->priv->confirm_backup == NULL) ? NULL : (self->priv->confirm_backup = (g_object_unref (self->priv->confirm_backup), NULL)), _tmp0);
	g_object_set ((GObject*) self->priv->confirm_backup, "xalign", 0.0f, NULL);
	rows = rows + 1;
	page = g_object_ref_sink ((GtkTable*) gtk_table_new ((guint) rows, (guint) 2, FALSE));
	g_object_set ((GObject*) page, "row-spacing", 6, "column-spacing", 6, "border-width", 12, NULL);
	rows = 0;
	gtk_table_attach (page, (GtkWidget*) backup_label, (guint) 0, (guint) 1, (guint) rows, (guint) (rows + 1), GTK_FILL, 0, (guint) 0, (guint) 0);
	gtk_table_attach (page, (GtkWidget*) self->priv->confirm_backup, (guint) 1, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL, 0, (guint) 0, (guint) 0);
	_tmp1 = NULL;
	return (_tmp1 = (GtkWidget*) page, (backup_label == NULL) ? NULL : (backup_label = (g_object_unref (backup_label), NULL)), _tmp1);
}


static DejaDupOperation* assistant_backup_real_create_op (AssistantOperation* base) {
	AssistantBackup * self;
	self = (AssistantBackup*) base;
	return (DejaDupOperation*) deja_dup_operation_backup_new ((GtkWindow*) self, 0);
}


static char* assistant_backup_real_get_progress_file_prefix (AssistantOperation* base) {
	AssistantBackup * self;
	const char* _tmp0;
	self = (AssistantBackup*) base;
	/* Translators:  This is the phrase 'Backing up' in the larger phrase
	 "Backing up '%s'".  %s is a filename.*/
	_tmp0 = NULL;
	return (_tmp0 = _ ("Backing up"), (_tmp0 == NULL) ? NULL : g_strdup (_tmp0));
}


static GdkPixbuf* assistant_backup_real_get_op_icon (AssistantOperation* base) {
	AssistantBackup * self;
	GError * inner_error;
	self = (AssistantBackup*) base;
	inner_error = NULL;
	{
		char* filename;
		GdkPixbuf* _tmp0;
		filename = get_backup_icon_filename ();
		_tmp0 = NULL;
		return (_tmp0 = gdk_pixbuf_new_from_file_at_size (filename, 48, 48, &inner_error), filename = (g_free (filename), NULL), _tmp0);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			GdkPixbuf* _tmp1;
			g_warning ("AssistantBackup.vala:75: %s\n", e->message);
			_tmp1 = NULL;
			return (_tmp1 = NULL, (e == NULL) ? NULL : (e = (g_error_free (e), NULL)), _tmp1);
		}
	}
	__finally0:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return NULL;
	}
}


static void assistant_backup_real_do_prepare (AssistantOperation* base, AssistantOperation* assist, GtkWidget* page) {
	AssistantBackup * self;
	GError * inner_error;
	self = (AssistantBackup*) base;
	g_return_if_fail (assist != NULL);
	g_return_if_fail (page != NULL);
	inner_error = NULL;
	ASSISTANT_OPERATION_CLASS (assistant_backup_parent_class)->do_prepare (ASSISTANT_OPERATION (self), assist, page);
	if (page == assistant_operation_get_confirm_page ((AssistantOperation*) self)) {
		char* backup_loc;
		/* Where the backup is*/
		backup_loc = NULL;
		{
			DejaDupBackend* _tmp0;
			DejaDupBackend* _tmp1;
			char* _tmp2;
			char* _tmp3;
			char* _tmp4;
			_tmp0 = deja_dup_backend_get_default ((GtkWindow*) self, &inner_error);
			if (inner_error != NULL) {
				goto __catch1_g_error;
				goto __finally1;
			}
			_tmp1 = NULL;
			_tmp2 = NULL;
			_tmp3 = (_tmp2 = deja_dup_backend_get_location_pretty (_tmp1 = _tmp0, &inner_error), (_tmp1 == NULL) ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)), _tmp2);
			if (inner_error != NULL) {
				goto __catch1_g_error;
				goto __finally1;
			}
			_tmp4 = NULL;
			backup_loc = (_tmp4 = _tmp3, backup_loc = (g_free (backup_loc), NULL), _tmp4);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError * e;
			e = inner_error;
			inner_error = NULL;
			{
				g_warning ("AssistantBackup.vala:91: %s\n", e->message);
				(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			}
		}
		__finally1:
		if (inner_error != NULL) {
			backup_loc = (g_free (backup_loc), NULL);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
			return;
		}
		if (backup_loc == NULL) {
			char* _tmp6;
			const char* _tmp5;
			_tmp6 = NULL;
			_tmp5 = NULL;
			backup_loc = (_tmp6 = (_tmp5 = _ ("Unknown"), (_tmp5 == NULL) ? NULL : g_strdup (_tmp5)), backup_loc = (g_free (backup_loc), NULL), _tmp6);
		}
		gtk_label_set_label (self->priv->confirm_backup, backup_loc);
		backup_loc = (g_free (backup_loc), NULL);
	} else {
		if (page == assistant_operation_get_summary_page ((AssistantOperation*) self)) {
			if (assistant_operation_get_error_occurred ((AssistantOperation*) self)) {
				gtk_container_child_set ((GtkContainer*) assist, page, "title", _ ("Backup Failed"), NULL);
			} else {
				gtk_container_child_set ((GtkContainer*) assist, page, "title", _ ("Backup Finished"), NULL);
				gtk_label_set_label (((AssistantOperation*) self)->summary_label, _ ("Your files were successfully backed up."));
			}
		} else {
			if (page == assistant_operation_get_progress_page ((AssistantOperation*) self)) {
				gtk_container_child_set ((GtkContainer*) assist, page, "title", _ ("Backing up..."), NULL);
			}
		}
	}
}


/*
    Déjà Dup
    © 2008—2009 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
AssistantBackup* assistant_backup_construct (GType object_type) {
	AssistantBackup * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


AssistantBackup* assistant_backup_new (void) {
	return assistant_backup_construct (TYPE_ASSISTANT_BACKUP);
}


static GObject * assistant_backup_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	AssistantBackupClass * klass;
	GObjectClass * parent_class;
	AssistantBackup * self;
	klass = ASSISTANT_BACKUP_CLASS (g_type_class_peek (TYPE_ASSISTANT_BACKUP));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = ASSISTANT_BACKUP (obj);
	{
		gtk_window_set_title ((GtkWindow*) self, _ ("Backup"));
	}
	return obj;
}


static void assistant_backup_class_init (AssistantBackupClass * klass) {
	assistant_backup_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AssistantBackupPrivate));
	G_OBJECT_CLASS (klass)->constructor = assistant_backup_constructor;
	G_OBJECT_CLASS (klass)->finalize = assistant_backup_finalize;
	ASSISTANT_OPERATION_CLASS (klass)->add_setup_pages = assistant_backup_real_add_setup_pages;
	ASSISTANT_OPERATION_CLASS (klass)->make_confirm_page = assistant_backup_real_make_confirm_page;
	ASSISTANT_OPERATION_CLASS (klass)->create_op = assistant_backup_real_create_op;
	ASSISTANT_OPERATION_CLASS (klass)->get_progress_file_prefix = assistant_backup_real_get_progress_file_prefix;
	ASSISTANT_OPERATION_CLASS (klass)->get_op_icon = assistant_backup_real_get_op_icon;
	ASSISTANT_OPERATION_CLASS (klass)->do_prepare = assistant_backup_real_do_prepare;
}


static void assistant_backup_instance_init (AssistantBackup * self) {
	self->priv = ASSISTANT_BACKUP_GET_PRIVATE (self);
}


static void assistant_backup_finalize (GObject* obj) {
	AssistantBackup * self;
	self = ASSISTANT_BACKUP (obj);
	(self->priv->confirm_backup == NULL) ? NULL : (self->priv->confirm_backup = (g_object_unref (self->priv->confirm_backup), NULL));
	G_OBJECT_CLASS (assistant_backup_parent_class)->finalize (obj);
}


GType assistant_backup_get_type (void) {
	static GType assistant_backup_type_id = 0;
	if (assistant_backup_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (AssistantBackupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) assistant_backup_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AssistantBackup), 0, (GInstanceInitFunc) assistant_backup_instance_init, NULL };
		assistant_backup_type_id = g_type_register_static (TYPE_ASSISTANT_OPERATION, "AssistantBackup", &g_define_type_info, 0);
	}
	return assistant_backup_type_id;
}




