/* -*- Mode: C; indent-tabs-mode: nil; tab-width: 2 -*- */

#include "AssistantOperation.h"
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <pango/pango.h>
#include <glib/gi18n-lib.h>




struct _AssistantOperationPrivate {
	GtkWidget* _confirm_page;
	GtkLabel* progress_label;
	GtkLabel* progress_file_label;
	GtkProgressBar* progress_bar;
	GtkWidget* _progress_page;
	GtkWidget* error_widget;
	GtkTextView* error_text_view;
	GtkWidget* _summary_page;
	GdkPixbuf* _icon;
	DejaDupOperation* op;
	guint timeout_id;
	gboolean _error_occurred;
	gboolean gives_progress;
};

#define ASSISTANT_OPERATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ASSISTANT_OPERATION, AssistantOperationPrivate))
enum  {
	ASSISTANT_OPERATION_DUMMY_PROPERTY,
	ASSISTANT_OPERATION_CONFIRM_PAGE,
	ASSISTANT_OPERATION_PROGRESS_PAGE,
	ASSISTANT_OPERATION_SUMMARY_PAGE,
	ASSISTANT_OPERATION_ICON,
	ASSISTANT_OPERATION_ERROR_OCCURRED
};
static GtkWidget* assistant_operation_real_make_confirm_page (AssistantOperation* self);
static void assistant_operation_real_add_setup_pages (AssistantOperation* self);
static DejaDupOperation* assistant_operation_real_create_op (AssistantOperation* self);
static char* assistant_operation_real_get_progress_file_prefix (AssistantOperation* self);
static GdkPixbuf* assistant_operation_real_get_op_icon (AssistantOperation* self);
static gboolean assistant_operation_pulse (AssistantOperation* self);
static void assistant_operation_show_progress (AssistantOperation* self, DejaDupOperation* op, double percent);
static void assistant_operation_set_progress_label (AssistantOperation* self, DejaDupOperation* op, const char* label);
static void assistant_operation_set_progress_label_file (AssistantOperation* self, DejaDupOperation* op, GFile* file);
static GtkWidget* assistant_operation_real_make_progress_page (AssistantOperation* self);
static void assistant_operation_real_show_error (AssistantOperation* self, DejaDupOperation* op, const char* error, const char* detail);
static GtkWidget* assistant_operation_real_make_summary_page (AssistantOperation* self);
static void assistant_operation_add_confirm_page (AssistantOperation* self);
static void assistant_operation_add_progress_page (AssistantOperation* self);
static void assistant_operation_add_summary_page (AssistantOperation* self);
static void assistant_operation_apply_finished (AssistantOperation* self, DejaDupOperation* op, gboolean success);
static void _assistant_operation_apply_finished_deja_dup_operation_done (DejaDupOperation* _sender, gboolean success, gpointer self);
static void _assistant_operation_show_error_deja_dup_operation_raise_error (DejaDupOperation* _sender, const char* errstr, const char* detail, gpointer self);
static void _assistant_operation_set_progress_label_deja_dup_operation_action_desc_changed (DejaDupOperation* _sender, const char* action, gpointer self);
static void _assistant_operation_set_progress_label_file_deja_dup_operation_action_file_changed (DejaDupOperation* _sender, GFile* file, gpointer self);
static void _assistant_operation_show_progress_deja_dup_operation_progress (DejaDupOperation* _sender, double percent, gpointer self);
static void assistant_operation_do_apply (AssistantOperation* self);
static gboolean _assistant_operation_pulse_gsource_func (gpointer self);
static void assistant_operation_real_do_prepare (AssistantOperation* self, AssistantOperation* assist, GtkWidget* page);
static void assistant_operation_do_cancel (AssistantOperation* self);
static void assistant_operation_real_do_close (AssistantOperation* self);
static void assistant_operation_set_confirm_page (AssistantOperation* self, GtkWidget* value);
static void assistant_operation_set_progress_page (AssistantOperation* self, GtkWidget* value);
static void assistant_operation_set_summary_page (AssistantOperation* self, GtkWidget* value);
static void assistant_operation_set_icon (AssistantOperation* self, GdkPixbuf* value);
static void assistant_operation_set_error_occurred (AssistantOperation* self, gboolean value);
static void _assistant_operation_do_apply_gtk_assistant_apply (AssistantOperation* _sender, gpointer self);
static void _assistant_operation_do_cancel_gtk_assistant_cancel (AssistantOperation* _sender, gpointer self);
static void _assistant_operation_do_close_gtk_assistant_close (AssistantOperation* _sender, gpointer self);
static void _assistant_operation_do_prepare_gtk_assistant_prepare (AssistantOperation* _sender, GtkWidget* page, gpointer self);
static GObject * assistant_operation_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer assistant_operation_parent_class = NULL;
static void assistant_operation_finalize (GObject* obj);



static GtkWidget* assistant_operation_real_make_confirm_page (AssistantOperation* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `assistant_operation_make_confirm_page'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GtkWidget* assistant_operation_make_confirm_page (AssistantOperation* self) {
	return ASSISTANT_OPERATION_GET_CLASS (self)->make_confirm_page (self);
}


static void assistant_operation_real_add_setup_pages (AssistantOperation* self) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `assistant_operation_add_setup_pages'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void assistant_operation_add_setup_pages (AssistantOperation* self) {
	ASSISTANT_OPERATION_GET_CLASS (self)->add_setup_pages (self);
}


static DejaDupOperation* assistant_operation_real_create_op (AssistantOperation* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `assistant_operation_create_op'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


DejaDupOperation* assistant_operation_create_op (AssistantOperation* self) {
	return ASSISTANT_OPERATION_GET_CLASS (self)->create_op (self);
}


static char* assistant_operation_real_get_progress_file_prefix (AssistantOperation* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `assistant_operation_get_progress_file_prefix'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


char* assistant_operation_get_progress_file_prefix (AssistantOperation* self) {
	return ASSISTANT_OPERATION_GET_CLASS (self)->get_progress_file_prefix (self);
}


static GdkPixbuf* assistant_operation_real_get_op_icon (AssistantOperation* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `assistant_operation_get_op_icon'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GdkPixbuf* assistant_operation_get_op_icon (AssistantOperation* self) {
	return ASSISTANT_OPERATION_GET_CLASS (self)->get_op_icon (self);
}


static gboolean assistant_operation_pulse (AssistantOperation* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	if (!self->priv->gives_progress) {
		gtk_progress_bar_pulse (self->priv->progress_bar);
	}
	return TRUE;
}


static void assistant_operation_show_progress (AssistantOperation* self, DejaDupOperation* op, double percent) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	gtk_progress_bar_set_fraction (self->priv->progress_bar, percent);
	self->priv->gives_progress = TRUE;
}


static void assistant_operation_set_progress_label (AssistantOperation* self, DejaDupOperation* op, const char* label) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	g_return_if_fail (label != NULL);
	gtk_label_set_label (self->priv->progress_label, label);
}


static void assistant_operation_set_progress_label_file (AssistantOperation* self, DejaDupOperation* op, GFile* file) {
	char* parse_name;
	char* basename;
	char* _tmp1;
	char* _tmp0;
	char* _tmp2;
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	g_return_if_fail (file != NULL);
	parse_name = g_file_get_parse_name (file);
	basename = g_path_get_basename (parse_name);
	_tmp1 = NULL;
	_tmp0 = NULL;
	gtk_label_set_label (self->priv->progress_label, _tmp1 = g_strconcat (_tmp0 = assistant_operation_get_progress_file_prefix (self), " ", NULL));
	_tmp1 = (g_free (_tmp1), NULL);
	_tmp0 = (g_free (_tmp0), NULL);
	_tmp2 = NULL;
	gtk_label_set_label (self->priv->progress_file_label, _tmp2 = g_strdup_printf ("'%s'", basename));
	_tmp2 = (g_free (_tmp2), NULL);
	parse_name = (g_free (parse_name), NULL);
	basename = (g_free (basename), NULL);
}


static GtkWidget* assistant_operation_real_make_progress_page (AssistantOperation* self) {
	GtkLabel* _tmp0;
	GtkLabel* _tmp1;
	GtkHBox* progress_hbox;
	GtkProgressBar* _tmp2;
	GtkVBox* page;
	GtkWidget* _tmp3;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0 = NULL;
	self->priv->progress_label = (_tmp0 = g_object_ref_sink ((GtkLabel*) gtk_label_new ("")), (self->priv->progress_label == NULL) ? NULL : (self->priv->progress_label = (g_object_unref (self->priv->progress_label), NULL)), _tmp0);
	g_object_set ((GObject*) self->priv->progress_label, "xalign", 0.0f, NULL);
	_tmp1 = NULL;
	self->priv->progress_file_label = (_tmp1 = g_object_ref_sink ((GtkLabel*) gtk_label_new ("")), (self->priv->progress_file_label == NULL) ? NULL : (self->priv->progress_file_label = (g_object_unref (self->priv->progress_file_label), NULL)), _tmp1);
	g_object_set ((GObject*) self->priv->progress_file_label, "xalign", 0.0f, "ellipsize", PANGO_ELLIPSIZE_MIDDLE, NULL);
	progress_hbox = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 0));
	g_object_set ((GObject*) progress_hbox, "child", self->priv->progress_label, "child", self->priv->progress_file_label, NULL);
	gtk_container_child_set ((GtkContainer*) progress_hbox, (GtkWidget*) self->priv->progress_label, "expand", FALSE, NULL);
	_tmp2 = NULL;
	self->priv->progress_bar = (_tmp2 = g_object_ref_sink ((GtkProgressBar*) gtk_progress_bar_new ()), (self->priv->progress_bar == NULL) ? NULL : (self->priv->progress_bar = (g_object_unref (self->priv->progress_bar), NULL)), _tmp2);
	page = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 6));
	g_object_set ((GObject*) page, "child", progress_hbox, "child", self->priv->progress_bar, "border-width", 12, NULL);
	gtk_container_child_set ((GtkContainer*) page, (GtkWidget*) progress_hbox, "expand", FALSE, NULL);
	gtk_container_child_set ((GtkContainer*) page, (GtkWidget*) self->priv->progress_bar, "expand", FALSE, NULL);
	_tmp3 = NULL;
	return (_tmp3 = (GtkWidget*) page, (progress_hbox == NULL) ? NULL : (progress_hbox = (g_object_unref (progress_hbox), NULL)), _tmp3);
}


GtkWidget* assistant_operation_make_progress_page (AssistantOperation* self) {
	return ASSISTANT_OPERATION_GET_CLASS (self)->make_progress_page (self);
}


static void assistant_operation_real_show_error (AssistantOperation* self, DejaDupOperation* op, const char* error, const char* detail) {
	GError * inner_error;
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	g_return_if_fail (error != NULL);
	inner_error = NULL;
	assistant_operation_set_error_occurred (self, TRUE);
	{
		GdkPixbuf* _tmp0;
		GdkPixbuf* pixbuf;
		_tmp0 = NULL;
		pixbuf = (_tmp0 = gtk_icon_theme_load_icon (gtk_icon_theme_get_default (), GTK_STOCK_DIALOG_ERROR, 48, GTK_ICON_LOOKUP_FORCE_SIZE, &inner_error), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
		if (inner_error != NULL) {
			goto __catch2_g_error;
			goto __finally2;
		}
		gtk_container_child_set ((GtkContainer*) self, self->priv->_summary_page, "header-image", pixbuf, NULL);
		(pixbuf == NULL) ? NULL : (pixbuf = (g_object_unref (pixbuf), NULL));
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally2:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	/* Eh, don't worry about it*/
	gtk_label_set_label (self->summary_label, error);
	g_object_set (self->summary_label, "wrap", TRUE, NULL);
	gtk_label_set_selectable (self->summary_label, TRUE);
	if (detail != NULL) {
		gtk_widget_set_no_show_all (self->priv->error_widget, FALSE);
		gtk_widget_show_all (self->priv->error_widget);
		gtk_text_buffer_set_text (gtk_text_view_get_buffer (self->priv->error_text_view), detail, -1);
	}
	gtk_assistant_set_current_page ((GtkAssistant*) self, gtk_assistant_get_n_pages ((GtkAssistant*) self) - 1);
}


void assistant_operation_show_error (AssistantOperation* self, DejaDupOperation* op, const char* error, const char* detail) {
	ASSISTANT_OPERATION_GET_CLASS (self)->show_error (self, op, error, detail);
}


/* last, summary page*/
static GtkWidget* assistant_operation_real_make_summary_page (AssistantOperation* self) {
	GtkLabel* _tmp0;
	GtkTextView* _tmp1;
	GtkScrolledWindow* scroll;
	GtkWidget* _tmp3;
	GtkWidget* _tmp2;
	GtkVBox* page;
	GtkWidget* _tmp4;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0 = NULL;
	self->summary_label = (_tmp0 = g_object_ref_sink ((GtkLabel*) gtk_label_new ("")), (self->summary_label == NULL) ? NULL : (self->summary_label = (g_object_unref (self->summary_label), NULL)), _tmp0);
	g_object_set ((GObject*) self->summary_label, "xalign", 0.0f, NULL);
	_tmp1 = NULL;
	self->priv->error_text_view = (_tmp1 = g_object_ref_sink ((GtkTextView*) gtk_text_view_new ()), (self->priv->error_text_view == NULL) ? NULL : (self->priv->error_text_view = (g_object_unref (self->priv->error_text_view), NULL)), _tmp1);
	gtk_text_view_set_editable (self->priv->error_text_view, FALSE);
	gtk_text_view_set_wrap_mode (self->priv->error_text_view, GTK_WRAP_WORD);
	g_object_set ((GtkWidget*) self->priv->error_text_view, "height-request", 150, NULL);
	scroll = g_object_ref_sink ((GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL));
	gtk_container_add ((GtkContainer*) scroll, (GtkWidget*) self->priv->error_text_view);
	gtk_widget_set_no_show_all ((GtkWidget*) scroll, TRUE);
	/* only will be shown if an error occurs*/
	_tmp3 = NULL;
	_tmp2 = NULL;
	self->priv->error_widget = (_tmp3 = (_tmp2 = (GtkWidget*) scroll, (_tmp2 == NULL) ? NULL : g_object_ref (_tmp2)), (self->priv->error_widget == NULL) ? NULL : (self->priv->error_widget = (g_object_unref (self->priv->error_widget), NULL)), _tmp3);
	page = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 6));
	g_object_set ((GObject*) page, "child", self->summary_label, "child", self->priv->error_widget, "border-width", 12, NULL);
	gtk_container_child_set ((GtkContainer*) page, (GtkWidget*) self->summary_label, "expand", FALSE, NULL);
	_tmp4 = NULL;
	return (_tmp4 = (GtkWidget*) page, (scroll == NULL) ? NULL : (scroll = (g_object_unref (scroll), NULL)), _tmp4);
}


GtkWidget* assistant_operation_make_summary_page (AssistantOperation* self) {
	return ASSISTANT_OPERATION_GET_CLASS (self)->make_summary_page (self);
}


static void assistant_operation_add_confirm_page (AssistantOperation* self) {
	GtkWidget* page;
	g_return_if_fail (self != NULL);
	page = assistant_operation_make_confirm_page (self);
	gtk_assistant_append_page ((GtkAssistant*) self, page);
	gtk_container_child_set ((GtkContainer*) self, page, "title", _ ("Summary"), "page-type", GTK_ASSISTANT_PAGE_CONFIRM, "complete", TRUE, "header-image", self->priv->_icon, NULL);
	assistant_operation_set_confirm_page (self, page);
	(page == NULL) ? NULL : (page = (g_object_unref (page), NULL));
}


static void assistant_operation_add_progress_page (AssistantOperation* self) {
	GtkWidget* page;
	g_return_if_fail (self != NULL);
	page = assistant_operation_make_progress_page (self);
	gtk_assistant_append_page ((GtkAssistant*) self, page);
	/* We don't actually use a PROGRESS type for this page, because that
	 doesn't allow for cancelling.*/
	gtk_container_child_set ((GtkContainer*) self, page, "page-type", GTK_ASSISTANT_PAGE_CONTENT, "header-image", self->priv->_icon, NULL);
	assistant_operation_set_progress_page (self, page);
	(page == NULL) ? NULL : (page = (g_object_unref (page), NULL));
}


static void assistant_operation_add_summary_page (AssistantOperation* self) {
	GtkWidget* page;
	g_return_if_fail (self != NULL);
	page = assistant_operation_make_summary_page (self);
	gtk_assistant_append_page ((GtkAssistant*) self, page);
	gtk_container_child_set ((GtkContainer*) self, page, "page-type", GTK_ASSISTANT_PAGE_SUMMARY, "complete", TRUE, "header-image", self->priv->_icon, NULL);
	assistant_operation_set_summary_page (self, page);
	(page == NULL) ? NULL : (page = (g_object_unref (page), NULL));
}


static void assistant_operation_apply_finished (AssistantOperation* self, DejaDupOperation* op, gboolean success) {
	DejaDupOperation* _tmp0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	_tmp0 = NULL;
	self->priv->op = (_tmp0 = NULL, (self->priv->op == NULL) ? NULL : (self->priv->op = (g_object_unref (self->priv->op), NULL)), _tmp0);
	if (success) {
		gtk_assistant_set_current_page ((GtkAssistant*) self, gtk_assistant_get_n_pages ((GtkAssistant*) self) - 1);
	} else {
		if (!self->priv->_error_occurred) {
			/* was cancelled...  Close dialog*/
			assistant_operation_do_close (self);
		}
	}
}


static void _assistant_operation_apply_finished_deja_dup_operation_done (DejaDupOperation* _sender, gboolean success, gpointer self) {
	assistant_operation_apply_finished (self, _sender, success);
}


static void _assistant_operation_show_error_deja_dup_operation_raise_error (DejaDupOperation* _sender, const char* errstr, const char* detail, gpointer self) {
	assistant_operation_show_error (self, _sender, errstr, detail);
}


static void _assistant_operation_set_progress_label_deja_dup_operation_action_desc_changed (DejaDupOperation* _sender, const char* action, gpointer self) {
	assistant_operation_set_progress_label (self, _sender, action);
}


static void _assistant_operation_set_progress_label_file_deja_dup_operation_action_file_changed (DejaDupOperation* _sender, GFile* file, gpointer self) {
	assistant_operation_set_progress_label_file (self, _sender, file);
}


static void _assistant_operation_show_progress_deja_dup_operation_progress (DejaDupOperation* _sender, double percent, gpointer self) {
	assistant_operation_show_progress (self, _sender, percent);
}


static void assistant_operation_do_apply (AssistantOperation* self) {
	GError * inner_error;
	DejaDupOperation* _tmp0;
	g_return_if_fail (self != NULL);
	inner_error = NULL;
	_tmp0 = NULL;
	self->priv->op = (_tmp0 = assistant_operation_create_op (self), (self->priv->op == NULL) ? NULL : (self->priv->op = (g_object_unref (self->priv->op), NULL)), _tmp0);
	g_signal_connect_object (self->priv->op, "done", (GCallback) _assistant_operation_apply_finished_deja_dup_operation_done, self, 0);
	g_signal_connect_object (self->priv->op, "raise-error", (GCallback) _assistant_operation_show_error_deja_dup_operation_raise_error, self, 0);
	g_signal_connect_object (self->priv->op, "action-desc-changed", (GCallback) _assistant_operation_set_progress_label_deja_dup_operation_action_desc_changed, self, 0);
	g_signal_connect_object (self->priv->op, "action-file-changed", (GCallback) _assistant_operation_set_progress_label_file_deja_dup_operation_action_file_changed, self, 0);
	g_signal_connect_object (self->priv->op, "progress", (GCallback) _assistant_operation_show_progress_deja_dup_operation_progress, self, 0);
	{
		deja_dup_operation_start (self->priv->op, &inner_error);
		if (inner_error != NULL) {
			goto __catch3_g_error;
			goto __finally3;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning ("AssistantOperation.vala:229: %s\n", e->message);
			assistant_operation_show_error (self, self->priv->op, e->message, NULL);
			/* not really user-friendly text, but ideally this won't happen*/
			assistant_operation_apply_finished (self, self->priv->op, FALSE);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally3:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
}


static gboolean _assistant_operation_pulse_gsource_func (gpointer self) {
	return assistant_operation_pulse (self);
}


static void assistant_operation_real_do_prepare (AssistantOperation* self, AssistantOperation* assist, GtkWidget* page) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (assist != NULL);
	g_return_if_fail (page != NULL);
	if (self->priv->timeout_id > 0) {
		g_source_remove (self->priv->timeout_id);
		self->priv->timeout_id = (guint) 0;
	}
	if (page == self->priv->_confirm_page) {
		if (self->priv->op != NULL) {
			guint _tmp0;
			g_signal_handlers_disconnect_matched (self->priv->op, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, (g_signal_parse_name ("done", DEJA_DUP_TYPE_OPERATION, &_tmp0, NULL, FALSE), _tmp0), 0, NULL, (GCallback) _assistant_operation_apply_finished_deja_dup_operation_done, self);
			deja_dup_operation_cancel (self->priv->op);
		}
	} else {
		if (page == self->priv->_progress_page) {
			gtk_progress_bar_set_fraction (self->priv->progress_bar, (double) 0);
			self->priv->timeout_id = g_timeout_add ((guint) 250, _assistant_operation_pulse_gsource_func, self);
		}
	}
}


void assistant_operation_do_prepare (AssistantOperation* self, AssistantOperation* assist, GtkWidget* page) {
	ASSISTANT_OPERATION_GET_CLASS (self)->do_prepare (self, assist, page);
}


static void assistant_operation_do_cancel (AssistantOperation* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->op != NULL) {
		deja_dup_operation_cancel (self->priv->op);
	} else {
		assistant_operation_do_close (self);
	}
}


static void assistant_operation_real_do_close (AssistantOperation* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->timeout_id > 0) {
		g_source_remove (self->priv->timeout_id);
		self->priv->timeout_id = (guint) 0;
	}
	gtk_object_destroy ((GtkObject*) self);
}


void assistant_operation_do_close (AssistantOperation* self) {
	ASSISTANT_OPERATION_GET_CLASS (self)->do_close (self);
}


GtkWidget* assistant_operation_get_confirm_page (AssistantOperation* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_confirm_page;
}


static void assistant_operation_set_confirm_page (AssistantOperation* self, GtkWidget* value) {
	GtkWidget* _tmp2;
	GtkWidget* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_confirm_page = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (self->priv->_confirm_page == NULL) ? NULL : (self->priv->_confirm_page = (g_object_unref (self->priv->_confirm_page), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "confirm-page");
}


GtkWidget* assistant_operation_get_progress_page (AssistantOperation* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_progress_page;
}


static void assistant_operation_set_progress_page (AssistantOperation* self, GtkWidget* value) {
	GtkWidget* _tmp2;
	GtkWidget* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_progress_page = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (self->priv->_progress_page == NULL) ? NULL : (self->priv->_progress_page = (g_object_unref (self->priv->_progress_page), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "progress-page");
}


GtkWidget* assistant_operation_get_summary_page (AssistantOperation* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_summary_page;
}


static void assistant_operation_set_summary_page (AssistantOperation* self, GtkWidget* value) {
	GtkWidget* _tmp2;
	GtkWidget* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_summary_page = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (self->priv->_summary_page == NULL) ? NULL : (self->priv->_summary_page = (g_object_unref (self->priv->_summary_page), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "summary-page");
}


GdkPixbuf* assistant_operation_get_icon (AssistantOperation* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_icon;
}


static void assistant_operation_set_icon (AssistantOperation* self, GdkPixbuf* value) {
	GdkPixbuf* _tmp2;
	GdkPixbuf* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_icon = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (self->priv->_icon == NULL) ? NULL : (self->priv->_icon = (g_object_unref (self->priv->_icon), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "icon");
}


gboolean assistant_operation_get_error_occurred (AssistantOperation* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return self->priv->_error_occurred;
}


static void assistant_operation_set_error_occurred (AssistantOperation* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_error_occurred = value;
	g_object_notify ((GObject *) self, "error-occurred");
}


static void _assistant_operation_do_apply_gtk_assistant_apply (AssistantOperation* _sender, gpointer self) {
	assistant_operation_do_apply (self);
}


static void _assistant_operation_do_cancel_gtk_assistant_cancel (AssistantOperation* _sender, gpointer self) {
	assistant_operation_do_cancel (self);
}


static void _assistant_operation_do_close_gtk_assistant_close (AssistantOperation* _sender, gpointer self) {
	assistant_operation_do_close (self);
}


static void _assistant_operation_do_prepare_gtk_assistant_prepare (AssistantOperation* _sender, GtkWidget* page, gpointer self) {
	assistant_operation_do_prepare (self, _sender, page);
}


static GObject * assistant_operation_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	AssistantOperationClass * klass;
	GObjectClass * parent_class;
	AssistantOperation * self;
	klass = ASSISTANT_OPERATION_CLASS (g_type_class_peek (TYPE_ASSISTANT_OPERATION));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = ASSISTANT_OPERATION (obj);
	{
		GdkPixbuf* _tmp0;
		_tmp0 = NULL;
		assistant_operation_set_icon (self, _tmp0 = assistant_operation_get_op_icon (self));
		(_tmp0 == NULL) ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL));
		assistant_operation_add_setup_pages (self);
		assistant_operation_add_confirm_page (self);
		assistant_operation_add_progress_page (self);
		assistant_operation_add_summary_page (self);
		g_signal_connect_object ((GtkAssistant*) self, "apply", (GCallback) _assistant_operation_do_apply_gtk_assistant_apply, self, 0);
		g_signal_connect_object ((GtkAssistant*) self, "cancel", (GCallback) _assistant_operation_do_cancel_gtk_assistant_cancel, self, 0);
		g_signal_connect_object ((GtkAssistant*) self, "close", (GCallback) _assistant_operation_do_close_gtk_assistant_close, self, 0);
		g_signal_connect_object ((GtkAssistant*) self, "prepare", (GCallback) _assistant_operation_do_prepare_gtk_assistant_prepare, self, 0);
	}
	return obj;
}


static void assistant_operation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	AssistantOperation * self;
	gpointer boxed;
	self = ASSISTANT_OPERATION (object);
	switch (property_id) {
		case ASSISTANT_OPERATION_CONFIRM_PAGE:
		g_value_set_object (value, assistant_operation_get_confirm_page (self));
		break;
		case ASSISTANT_OPERATION_PROGRESS_PAGE:
		g_value_set_object (value, assistant_operation_get_progress_page (self));
		break;
		case ASSISTANT_OPERATION_SUMMARY_PAGE:
		g_value_set_object (value, assistant_operation_get_summary_page (self));
		break;
		case ASSISTANT_OPERATION_ICON:
		g_value_set_object (value, assistant_operation_get_icon (self));
		break;
		case ASSISTANT_OPERATION_ERROR_OCCURRED:
		g_value_set_boolean (value, assistant_operation_get_error_occurred (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void assistant_operation_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	AssistantOperation * self;
	self = ASSISTANT_OPERATION (object);
	switch (property_id) {
		case ASSISTANT_OPERATION_CONFIRM_PAGE:
		assistant_operation_set_confirm_page (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_PROGRESS_PAGE:
		assistant_operation_set_progress_page (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_SUMMARY_PAGE:
		assistant_operation_set_summary_page (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_ICON:
		assistant_operation_set_icon (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_ERROR_OCCURRED:
		assistant_operation_set_error_occurred (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void assistant_operation_class_init (AssistantOperationClass * klass) {
	assistant_operation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AssistantOperationPrivate));
	G_OBJECT_CLASS (klass)->get_property = assistant_operation_get_property;
	G_OBJECT_CLASS (klass)->set_property = assistant_operation_set_property;
	G_OBJECT_CLASS (klass)->constructor = assistant_operation_constructor;
	G_OBJECT_CLASS (klass)->finalize = assistant_operation_finalize;
	ASSISTANT_OPERATION_CLASS (klass)->make_confirm_page = assistant_operation_real_make_confirm_page;
	ASSISTANT_OPERATION_CLASS (klass)->add_setup_pages = assistant_operation_real_add_setup_pages;
	ASSISTANT_OPERATION_CLASS (klass)->create_op = assistant_operation_real_create_op;
	ASSISTANT_OPERATION_CLASS (klass)->get_progress_file_prefix = assistant_operation_real_get_progress_file_prefix;
	ASSISTANT_OPERATION_CLASS (klass)->get_op_icon = assistant_operation_real_get_op_icon;
	ASSISTANT_OPERATION_CLASS (klass)->make_progress_page = assistant_operation_real_make_progress_page;
	ASSISTANT_OPERATION_CLASS (klass)->show_error = assistant_operation_real_show_error;
	ASSISTANT_OPERATION_CLASS (klass)->make_summary_page = assistant_operation_real_make_summary_page;
	ASSISTANT_OPERATION_CLASS (klass)->do_prepare = assistant_operation_real_do_prepare;
	ASSISTANT_OPERATION_CLASS (klass)->do_close = assistant_operation_real_do_close;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_CONFIRM_PAGE, g_param_spec_object ("confirm-page", "confirm-page", "confirm-page", GTK_TYPE_WIDGET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_PROGRESS_PAGE, g_param_spec_object ("progress-page", "progress-page", "progress-page", GTK_TYPE_WIDGET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_SUMMARY_PAGE, g_param_spec_object ("summary-page", "summary-page", "summary-page", GTK_TYPE_WIDGET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_ICON, g_param_spec_object ("icon", "icon", "icon", GDK_TYPE_PIXBUF, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_ERROR_OCCURRED, g_param_spec_boolean ("error-occurred", "error-occurred", "error-occurred", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void assistant_operation_instance_init (AssistantOperation * self) {
	self->priv = ASSISTANT_OPERATION_GET_PRIVATE (self);
}


static void assistant_operation_finalize (GObject* obj) {
	AssistantOperation * self;
	self = ASSISTANT_OPERATION (obj);
	(self->priv->_confirm_page == NULL) ? NULL : (self->priv->_confirm_page = (g_object_unref (self->priv->_confirm_page), NULL));
	(self->priv->progress_label == NULL) ? NULL : (self->priv->progress_label = (g_object_unref (self->priv->progress_label), NULL));
	(self->priv->progress_file_label == NULL) ? NULL : (self->priv->progress_file_label = (g_object_unref (self->priv->progress_file_label), NULL));
	(self->priv->progress_bar == NULL) ? NULL : (self->priv->progress_bar = (g_object_unref (self->priv->progress_bar), NULL));
	(self->priv->_progress_page == NULL) ? NULL : (self->priv->_progress_page = (g_object_unref (self->priv->_progress_page), NULL));
	(self->summary_label == NULL) ? NULL : (self->summary_label = (g_object_unref (self->summary_label), NULL));
	(self->priv->error_widget == NULL) ? NULL : (self->priv->error_widget = (g_object_unref (self->priv->error_widget), NULL));
	(self->priv->error_text_view == NULL) ? NULL : (self->priv->error_text_view = (g_object_unref (self->priv->error_text_view), NULL));
	(self->priv->_summary_page == NULL) ? NULL : (self->priv->_summary_page = (g_object_unref (self->priv->_summary_page), NULL));
	(self->priv->_icon == NULL) ? NULL : (self->priv->_icon = (g_object_unref (self->priv->_icon), NULL));
	(self->priv->op == NULL) ? NULL : (self->priv->op = (g_object_unref (self->priv->op), NULL));
	G_OBJECT_CLASS (assistant_operation_parent_class)->finalize (obj);
}


GType assistant_operation_get_type (void) {
	static GType assistant_operation_type_id = 0;
	if (assistant_operation_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (AssistantOperationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) assistant_operation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AssistantOperation), 0, (GInstanceInitFunc) assistant_operation_instance_init, NULL };
		assistant_operation_type_id = g_type_register_static (GTK_TYPE_ASSISTANT, "AssistantOperation", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return assistant_operation_type_id;
}




