/* -*- Mode: C; indent-tabs-mode: nil; tab-width: 2 -*- */

#ifndef __ASSISTANTOPERATION_H__
#define __ASSISTANTOPERATION_H__

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <Operation.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixdata.h>

G_BEGIN_DECLS


#define TYPE_ASSISTANT_OPERATION (assistant_operation_get_type ())
#define ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperation))
#define ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))
#define IS_ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT_OPERATION))
#define IS_ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT_OPERATION))
#define ASSISTANT_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))

typedef struct _AssistantOperation AssistantOperation;
typedef struct _AssistantOperationClass AssistantOperationClass;
typedef struct _AssistantOperationPrivate AssistantOperationPrivate;

/*
    Déjà Dup
    © 2008—2009 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
struct _AssistantOperation {
	GtkAssistant parent_instance;
	AssistantOperationPrivate * priv;
	GtkLabel* summary_label;
};

struct _AssistantOperationClass {
	GtkAssistantClass parent_class;
	GtkWidget* (*make_confirm_page) (AssistantOperation* self);
	void (*add_setup_pages) (AssistantOperation* self);
	DejaDupOperation* (*create_op) (AssistantOperation* self);
	char* (*get_progress_file_prefix) (AssistantOperation* self);
	GdkPixbuf* (*get_op_icon) (AssistantOperation* self);
	GtkWidget* (*make_progress_page) (AssistantOperation* self);
	void (*show_error) (AssistantOperation* self, DejaDupOperation* op, const char* error, const char* detail);
	GtkWidget* (*make_summary_page) (AssistantOperation* self);
	void (*do_prepare) (AssistantOperation* self, AssistantOperation* assist, GtkWidget* page);
	void (*do_close) (AssistantOperation* self);
};


GtkWidget* assistant_operation_make_confirm_page (AssistantOperation* self);
void assistant_operation_add_setup_pages (AssistantOperation* self);
DejaDupOperation* assistant_operation_create_op (AssistantOperation* self);
char* assistant_operation_get_progress_file_prefix (AssistantOperation* self);
GdkPixbuf* assistant_operation_get_op_icon (AssistantOperation* self);
GtkWidget* assistant_operation_make_progress_page (AssistantOperation* self);
void assistant_operation_show_error (AssistantOperation* self, DejaDupOperation* op, const char* error, const char* detail);
GtkWidget* assistant_operation_make_summary_page (AssistantOperation* self);
void assistant_operation_do_prepare (AssistantOperation* self, AssistantOperation* assist, GtkWidget* page);
void assistant_operation_do_close (AssistantOperation* self);
GtkWidget* assistant_operation_get_confirm_page (AssistantOperation* self);
GtkWidget* assistant_operation_get_progress_page (AssistantOperation* self);
GtkWidget* assistant_operation_get_summary_page (AssistantOperation* self);
GdkPixbuf* assistant_operation_get_icon (AssistantOperation* self);
gboolean assistant_operation_get_error_occurred (AssistantOperation* self);
GType assistant_operation_get_type (void);


G_END_DECLS

#endif
