/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */

#include <BackendS3.h>
#include <gconf/gconf-client.h>
#include <glib/gi18n-lib.h>
#include <gnome-keyring.h>
#include <libgnomeui/libgnomeui.h>




struct _DejaDupBackendS3Private {
	char* gconf_id;
	char* id;
	char* secret_key;
};

#define DEJA_DUP_BACKEND_S3_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_BACKEND_S3, DejaDupBackendS3Private))
enum  {
	DEJA_DUP_BACKEND_S3_DUMMY_PROPERTY
};
static DejaDupBackend* deja_dup_backend_s3_real_clone (DejaDupBackend* base);
static void deja_dup_backend_s3_real_add_argv (DejaDupBackend* base, GList** argv);
static char* deja_dup_backend_s3_get_default_bucket (DejaDupBackendS3* self);
static char* deja_dup_backend_s3_real_get_location (DejaDupBackend* base, GError** error);
static char* deja_dup_backend_s3_real_get_location_pretty (DejaDupBackend* base, GError** error);
static void _deja_dup_backend_s3_found_password_gnome_keyring_operation_get_list_callback (GnomeKeyringResult result, GList* list, gpointer self);
static void deja_dup_backend_s3_real_get_envp (DejaDupBackend* base, GError** error);
static void deja_dup_backend_s3_found_password (DejaDupBackendS3* self, GnomeKeyringResult result, GList* list);
static void deja_dup_backend_s3_save_password_callback (DejaDupBackendS3* self, GnomeKeyringResult result, guint32 val);
static void _g_list_free_g_free (GList* self);
static void _deja_dup_backend_s3_save_password_callback_gnome_keyring_operation_get_int_callback (GnomeKeyringResult result, guint32 val, gpointer self);
static void deja_dup_backend_s3_real_ask_password (DejaDupBackend* base);
static void deja_dup_backend_s3_got_secret_key (DejaDupBackendS3* self);
static gpointer deja_dup_backend_s3_parent_class = NULL;
static void deja_dup_backend_s3_finalize (GObject* obj);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



DejaDupBackendS3* deja_dup_backend_s3_construct (GType object_type, GtkWindow* win) {
	GParameter * __params;
	GParameter * __params_it;
	DejaDupBackendS3 * self;
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "toplevel";
	g_value_init (&__params_it->value, GTK_TYPE_WINDOW);
	g_value_set_object (&__params_it->value, win);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


DejaDupBackendS3* deja_dup_backend_s3_new (GtkWindow* win) {
	return deja_dup_backend_s3_construct (DEJA_DUP_TYPE_BACKEND_S3, win);
}


static DejaDupBackend* deja_dup_backend_s3_real_clone (DejaDupBackend* base) {
	DejaDupBackendS3 * self;
	self = (DejaDupBackendS3*) base;
	return (DejaDupBackend*) deja_dup_backend_s3_new (deja_dup_backend_get_toplevel ((DejaDupBackend*) self));
}


static void deja_dup_backend_s3_real_add_argv (DejaDupBackend* base, GList** argv) {
	DejaDupBackendS3 * self;
	self = (DejaDupBackendS3*) base;
	g_return_if_fail (argv != NULL);
	(*argv) = g_list_append ((*argv), g_strdup ("--s3-use-new-style"));
}


static char* deja_dup_backend_s3_get_default_bucket (DejaDupBackendS3* self) {
	char* _tmp0;
	char* _tmp1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	return (_tmp1 = g_strdup_printf ("deja-dup-auto-%s", _tmp0 = g_utf8_strdown (self->priv->id, -1)), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
}


static char* deja_dup_backend_s3_real_get_location (DejaDupBackend* base, GError** error) {
	DejaDupBackendS3 * self;
	GError * inner_error;
	GConfClient* _tmp0;
	GConfClient* client;
	const char* _tmp1;
	char* bucket;
	char* default_bucket;
	gboolean _tmp2;
	gboolean _tmp3;
	const char* _tmp7;
	char* folder;
	gboolean _tmp8;
	char* _tmp11;
	self = (DejaDupBackendS3*) base;
	inner_error = NULL;
	_tmp0 = NULL;
	client = (_tmp0 = gconf_client_get_default (), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	_tmp1 = NULL;
	bucket = (_tmp1 = gconf_client_get_string (client, DEJA_DUP_S3_BUCKET_KEY, &inner_error), (_tmp1 == NULL) ? NULL : g_strdup (_tmp1));
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
		return NULL;
	}
	default_bucket = deja_dup_backend_s3_get_default_bucket (self);
	_tmp2 = FALSE;
	_tmp3 = FALSE;
	if (bucket == NULL) {
		_tmp3 = TRUE;
	} else {
		_tmp3 = _vala_strcmp0 (bucket, "") == 0;
	}
	if (_tmp3) {
		_tmp2 = TRUE;
	} else {
		gboolean _tmp4;
		_tmp4 = FALSE;
		if (g_str_has_prefix (bucket, "deja-dup-auto-")) {
			_tmp4 = !g_str_has_prefix (bucket, default_bucket);
		} else {
			_tmp4 = FALSE;
		}
		_tmp2 = (_tmp4);
	}
	if (_tmp2) {
		char* _tmp6;
		const char* _tmp5;
		_tmp6 = NULL;
		_tmp5 = NULL;
		bucket = (_tmp6 = (_tmp5 = default_bucket, (_tmp5 == NULL) ? NULL : g_strdup (_tmp5)), bucket = (g_free (bucket), NULL), _tmp6);
		gconf_client_set_string (client, DEJA_DUP_S3_BUCKET_KEY, bucket, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
			bucket = (g_free (bucket), NULL);
			default_bucket = (g_free (default_bucket), NULL);
			return NULL;
		}
	}
	_tmp7 = NULL;
	folder = (_tmp7 = gconf_client_get_string (client, DEJA_DUP_S3_FOLDER_KEY, &inner_error), (_tmp7 == NULL) ? NULL : g_strdup (_tmp7));
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
		bucket = (g_free (bucket), NULL);
		default_bucket = (g_free (default_bucket), NULL);
		return NULL;
	}
	_tmp8 = FALSE;
	if (folder != NULL) {
		_tmp8 = _vala_strcmp0 (folder, "") != 0;
	} else {
		_tmp8 = FALSE;
	}
	if (_tmp8) {
		if (g_utf8_get_char (g_utf8_offset_to_pointer (folder, 0)) != '/') {
			char* _tmp9;
			_tmp9 = NULL;
			bucket = (_tmp9 = g_strdup_printf ("%s/%s", bucket, folder), bucket = (g_free (bucket), NULL), _tmp9);
		} else {
			char* _tmp10;
			_tmp10 = NULL;
			bucket = (_tmp10 = g_strdup_printf ("%s%s", bucket, folder), bucket = (g_free (bucket), NULL), _tmp10);
		}
	}
	_tmp11 = NULL;
	return (_tmp11 = g_strdup_printf ("s3+http://%s", bucket), (client == NULL) ? NULL : (client = (g_object_unref (client), NULL)), bucket = (g_free (bucket), NULL), default_bucket = (g_free (default_bucket), NULL), folder = (g_free (folder), NULL), _tmp11);
}


gboolean deja_dup_backend_s3_bump_bucket (DejaDupBackendS3* self) {
	GError * inner_error;
	g_return_val_if_fail (self != NULL, FALSE);
	inner_error = NULL;
	{
		GConfClient* _tmp0;
		GConfClient* client;
		const char* _tmp1;
		char* bucket;
		char** _tmp6;
		gint bits_size;
		gint bits_length1;
		char** _tmp5;
		char** bits;
		gboolean _tmp7;
		gboolean _tmp8;
		gboolean _tmp9;
		gboolean _tmp10;
		gboolean _tmp15;
		_tmp0 = NULL;
		client = (_tmp0 = gconf_client_get_default (), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
		_tmp1 = NULL;
		bucket = (_tmp1 = gconf_client_get_string (client, DEJA_DUP_S3_BUCKET_KEY, &inner_error), (_tmp1 == NULL) ? NULL : g_strdup (_tmp1));
		if (inner_error != NULL) {
			(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
			goto __catch0_g_error;
			goto __finally0;
		}
		if (_vala_strcmp0 (bucket, "deja-dup") == 0) {
			char* _tmp2;
			gboolean _tmp3;
			/* Until 7.4, we exposed the bucket name and defaulted to deja-dup.
			 Since buckets are S3-global, everyone was unable to use that bucket,
			 since I (Mike Terry) owned that bucket.  If we see this setting,
			 we should default to the generic bucket name rather than assume the
			 user chose this bucket and error out.*/
			_tmp2 = NULL;
			bucket = (_tmp2 = deja_dup_backend_s3_get_default_bucket (self), bucket = (g_free (bucket), NULL), _tmp2);
			gconf_client_set_string (client, DEJA_DUP_S3_BUCKET_KEY, bucket, &inner_error);
			if (inner_error != NULL) {
				(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
				bucket = (g_free (bucket), NULL);
				goto __catch0_g_error;
				goto __finally0;
			}
			return (_tmp3 = TRUE, (client == NULL) ? NULL : (client = (g_object_unref (client), NULL)), bucket = (g_free (bucket), NULL), _tmp3);
		}
		if (!g_str_has_prefix (bucket, "deja-dup-auto-")) {
			gboolean _tmp4;
			return (_tmp4 = FALSE, (client == NULL) ? NULL : (client = (g_object_unref (client), NULL)), bucket = (g_free (bucket), NULL), _tmp4);
		}
		_tmp6 = NULL;
		_tmp5 = NULL;
		bits = (_tmp6 = _tmp5 = g_strsplit (bucket, "-", 0), bits_length1 = _vala_array_length (_tmp5), bits_size = bits_length1, _tmp6);
		_tmp7 = FALSE;
		_tmp8 = FALSE;
		_tmp9 = FALSE;
		_tmp10 = FALSE;
		if (bits == NULL) {
			_tmp10 = TRUE;
		} else {
			_tmp10 = bits[0] == NULL;
		}
		if (_tmp10) {
			_tmp9 = TRUE;
		} else {
			_tmp9 = bits[1] == NULL;
		}
		if (_tmp9) {
			_tmp8 = TRUE;
		} else {
			_tmp8 = bits[2] == NULL;
		}
		if (_tmp8) {
			_tmp7 = TRUE;
		} else {
			_tmp7 = bits[3] == NULL;
		}
		if (_tmp7) {
			gboolean _tmp11;
			return (_tmp11 = FALSE, (client == NULL) ? NULL : (client = (g_object_unref (client), NULL)), bucket = (g_free (bucket), NULL), bits = (_vala_array_free (bits, bits_length1, (GDestroyNotify) g_free), NULL), _tmp11);
		}
		if (bits[4] == NULL) {
			char* _tmp12;
			_tmp12 = NULL;
			bucket = (_tmp12 = g_strconcat (bucket, ("-2"), NULL), bucket = (g_free (bucket), NULL), _tmp12);
		} else {
			glong num;
			char* _tmp13;
			char* _tmp14;
			num = atol (bits[4]);
			_tmp13 = NULL;
			bits[4] = (_tmp13 = g_strdup_printf ("%li", (num + 1)), bits[4] = (g_free (bits[4]), NULL), _tmp13);
			_tmp14 = NULL;
			bucket = (_tmp14 = g_strjoinv ("-", bits), bucket = (g_free (bucket), NULL), _tmp14);
		}
		gconf_client_set_string (client, DEJA_DUP_S3_BUCKET_KEY, bucket, &inner_error);
		if (inner_error != NULL) {
			(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
			bucket = (g_free (bucket), NULL);
			bits = (_vala_array_free (bits, bits_length1, (GDestroyNotify) g_free), NULL);
			goto __catch0_g_error;
			goto __finally0;
		}
		return (_tmp15 = TRUE, (client == NULL) ? NULL : (client = (g_object_unref (client), NULL)), bucket = (g_free (bucket), NULL), bits = (_vala_array_free (bits, bits_length1, (GDestroyNotify) g_free), NULL), _tmp15);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			gboolean _tmp16;
			return (_tmp16 = FALSE, (e == NULL) ? NULL : (e = (g_error_free (e), NULL)), _tmp16);
		}
	}
	__finally0:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return FALSE;
	}
}


static char* deja_dup_backend_s3_real_get_location_pretty (DejaDupBackend* base, GError** error) {
	DejaDupBackendS3 * self;
	GError * inner_error;
	GConfClient* _tmp0;
	GConfClient* client;
	const char* _tmp1;
	char* folder;
	gboolean _tmp2;
	char* _tmp4;
	self = (DejaDupBackendS3*) base;
	inner_error = NULL;
	_tmp0 = NULL;
	client = (_tmp0 = gconf_client_get_default (), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	_tmp1 = NULL;
	folder = (_tmp1 = gconf_client_get_string (client, DEJA_DUP_S3_FOLDER_KEY, &inner_error), (_tmp1 == NULL) ? NULL : g_strdup (_tmp1));
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
		return NULL;
	}
	_tmp2 = FALSE;
	if (folder == NULL) {
		_tmp2 = TRUE;
	} else {
		_tmp2 = _vala_strcmp0 (folder, "") == 0;
	}
	if (_tmp2) {
		char* _tmp3;
		_tmp3 = NULL;
		folder = (_tmp3 = g_strdup ("/"), folder = (g_free (folder), NULL), _tmp3);
	}
	_tmp4 = NULL;
	return (_tmp4 = g_strdup_printf (_ ("Folder %s on Amazon S3"), folder), (client == NULL) ? NULL : (client = (g_object_unref (client), NULL)), folder = (g_free (folder), NULL), _tmp4);
}


static void _deja_dup_backend_s3_found_password_gnome_keyring_operation_get_list_callback (GnomeKeyringResult result, GList* list, gpointer self) {
	deja_dup_backend_s3_found_password (self, result, list);
}


static void deja_dup_backend_s3_real_get_envp (DejaDupBackend* base, GError** error) {
	DejaDupBackendS3 * self;
	GError * inner_error;
	GConfClient* _tmp0;
	GConfClient* client;
	const char* _tmp1;
	char* _tmp3;
	const char* _tmp2;
	const char* _tmp4;
	char* _tmp6;
	const char* _tmp5;
	gboolean _tmp7;
	self = (DejaDupBackendS3*) base;
	inner_error = NULL;
	_tmp0 = NULL;
	client = (_tmp0 = gconf_client_get_default (), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	_tmp1 = gconf_client_get_string (client, DEJA_DUP_S3_ID_KEY, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
		return;
	}
	_tmp3 = NULL;
	_tmp2 = NULL;
	self->priv->gconf_id = (_tmp3 = (_tmp2 = _tmp1, (_tmp2 == NULL) ? NULL : g_strdup (_tmp2)), self->priv->gconf_id = (g_free (self->priv->gconf_id), NULL), _tmp3);
	_tmp4 = NULL;
	if (self->priv->gconf_id == NULL) {
		_tmp4 = "";
	} else {
		_tmp4 = self->priv->gconf_id;
	}
	_tmp6 = NULL;
	_tmp5 = NULL;
	self->priv->id = (_tmp6 = (_tmp5 = _tmp4, (_tmp5 == NULL) ? NULL : g_strdup (_tmp5)), self->priv->id = (g_free (self->priv->id), NULL), _tmp6);
	_tmp7 = FALSE;
	if (_vala_strcmp0 (self->priv->id, "") != 0) {
		_tmp7 = self->priv->secret_key != NULL;
	} else {
		_tmp7 = FALSE;
	}
	if (_tmp7) {
		/* We've already been run before and got the key*/
		deja_dup_backend_s3_got_secret_key (self);
		(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
		return;
	}
	if (_vala_strcmp0 (self->priv->id, "") != 0) {
		char* _tmp8;
		/* First, try user's keyring*/
		_tmp8 = NULL;
		self->priv->secret_key = (_tmp8 = NULL, self->priv->secret_key = (g_free (self->priv->secret_key), NULL), _tmp8);
		gnome_keyring_find_network_password (self->priv->id, NULL, DEJA_DUP_S3_SERVER, NULL, "https", NULL, (guint32) 0, _deja_dup_backend_s3_found_password_gnome_keyring_operation_get_list_callback, g_object_ref (self), g_object_unref);
	} else {
		g_signal_emit_by_name ((DejaDupBackend*) self, "need-password");
	}
	(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
}


static void deja_dup_backend_s3_found_password (DejaDupBackendS3* self, GnomeKeyringResult result, GList* list) {
	gboolean _tmp0;
	g_return_if_fail (self != NULL);
	_tmp0 = FALSE;
	if (result == GNOME_KEYRING_RESULT_OK) {
		_tmp0 = list != NULL;
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		char* _tmp2;
		const char* _tmp1;
		_tmp2 = NULL;
		_tmp1 = NULL;
		self->priv->secret_key = (_tmp2 = (_tmp1 = ((GnomeKeyringNetworkPasswordData*) list->data)->password, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->secret_key = (g_free (self->priv->secret_key), NULL), _tmp2);
		deja_dup_backend_s3_got_secret_key (self);
	} else {
		g_signal_emit_by_name ((DejaDupBackend*) self, "need-password");
	}
}


static void deja_dup_backend_s3_save_password_callback (DejaDupBackendS3* self, GnomeKeyringResult result, guint32 val) {
	g_return_if_fail (self != NULL);
}


static void _g_list_free_g_free (GList* self) {
	g_list_foreach (self, (GFunc) g_free, NULL);
	g_list_free (self);
}


static void _deja_dup_backend_s3_save_password_callback_gnome_keyring_operation_get_int_callback (GnomeKeyringResult result, guint32 val, gpointer self) {
	deja_dup_backend_s3_save_password_callback (self, result, val);
}


static void deja_dup_backend_s3_real_ask_password (DejaDupBackend* base) {
	DejaDupBackendS3 * self;
	GnomePasswordDialog* dlg;
	char* _tmp2;
	const char* _tmp1;
	char* _tmp4;
	const char* _tmp3;
	GnomePasswordDialogRemember remember;
	self = (DejaDupBackendS3*) base;
	/* Ask user*/
	dlg = g_object_ref_sink ((GnomePasswordDialog*) gnome_password_dialog_new (_ ("Amazon S3 Password"), _ ("Enter your Amazon Web Services user ID and secret key.  This is not the same as your amazon.com username and password."), self->priv->id, "", FALSE));
	((GtkWindow*) dlg)->transient_parent = deja_dup_backend_get_toplevel ((DejaDupBackend*) self);
	g_object_set (dlg, "show-remember", TRUE, NULL);
	if (!gnome_password_dialog_run_and_block (dlg)) {
		GList* _tmp0;
		_tmp0 = NULL;
		g_signal_emit_by_name ((DejaDupBackend*) self, "envp-ready", FALSE, _tmp0 = NULL);
		(_tmp0 == NULL) ? NULL : (_tmp0 = (_g_list_free_g_free (_tmp0), NULL));
		(dlg == NULL) ? NULL : (dlg = (g_object_unref (dlg), NULL));
		return;
	}
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->id = (_tmp2 = (_tmp1 = gnome_password_dialog_get_username (dlg), (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->id = (g_free (self->priv->id), NULL), _tmp2);
	_tmp4 = NULL;
	_tmp3 = NULL;
	self->priv->secret_key = (_tmp4 = (_tmp3 = gnome_password_dialog_get_password (dlg), (_tmp3 == NULL) ? NULL : g_strdup (_tmp3)), self->priv->secret_key = (g_free (self->priv->secret_key), NULL), _tmp4);
	/* Save it*/
	remember = gnome_password_dialog_get_remember (dlg);
	if (remember != GNOME_PASSWORD_DIALOG_REMEMBER_NOTHING) {
		const char* _tmp5;
		const char* _tmp6;
		char* where;
		_tmp5 = NULL;
		if (remember == GNOME_PASSWORD_DIALOG_REMEMBER_SESSION) {
			_tmp5 = "session";
		} else {
			_tmp5 = GNOME_KEYRING_DEFAULT;
		}
		_tmp6 = NULL;
		where = (_tmp6 = _tmp5, (_tmp6 == NULL) ? NULL : g_strdup (_tmp6));
		gnome_keyring_set_network_password (where, self->priv->id, NULL, DEJA_DUP_S3_SERVER, NULL, "https", NULL, (guint32) 0, self->priv->secret_key, _deja_dup_backend_s3_save_password_callback_gnome_keyring_operation_get_int_callback, g_object_ref (self), g_object_unref);
		where = (g_free (where), NULL);
	}
	deja_dup_backend_s3_got_secret_key (self);
	(dlg == NULL) ? NULL : (dlg = (g_object_unref (dlg), NULL));
}


static void deja_dup_backend_s3_got_secret_key (DejaDupBackendS3* self) {
	GError * inner_error;
	GConfClient* _tmp0;
	GConfClient* client;
	GList* envp;
	g_return_if_fail (self != NULL);
	inner_error = NULL;
	_tmp0 = NULL;
	client = (_tmp0 = gconf_client_get_default (), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	if (_vala_strcmp0 (self->priv->id, self->priv->gconf_id) != 0) {
		{
			gconf_client_set_string (client, DEJA_DUP_S3_ID_KEY, self->priv->id, &inner_error);
			if (inner_error != NULL) {
				goto __catch1_g_error;
				goto __finally1;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError * e;
			e = inner_error;
			inner_error = NULL;
			{
				g_warning ("BackendS3.vala:198: %s\n", e->message);
				(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			}
		}
		__finally1:
		if (inner_error != NULL) {
			(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
			return;
		}
	}
	envp = NULL;
	envp = g_list_append (envp, g_strdup_printf ("AWS_ACCESS_KEY_ID=%s", self->priv->id));
	envp = g_list_append (envp, g_strdup_printf ("AWS_SECRET_ACCESS_KEY=%s", self->priv->secret_key));
	g_signal_emit_by_name ((DejaDupBackend*) self, "envp-ready", TRUE, envp);
	(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
	(envp == NULL) ? NULL : (envp = (_g_list_free_g_free (envp), NULL));
}


static void deja_dup_backend_s3_class_init (DejaDupBackendS3Class * klass) {
	deja_dup_backend_s3_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupBackendS3Private));
	G_OBJECT_CLASS (klass)->finalize = deja_dup_backend_s3_finalize;
	DEJA_DUP_BACKEND_CLASS (klass)->clone = deja_dup_backend_s3_real_clone;
	DEJA_DUP_BACKEND_CLASS (klass)->add_argv = deja_dup_backend_s3_real_add_argv;
	DEJA_DUP_BACKEND_CLASS (klass)->get_location = deja_dup_backend_s3_real_get_location;
	DEJA_DUP_BACKEND_CLASS (klass)->get_location_pretty = deja_dup_backend_s3_real_get_location_pretty;
	DEJA_DUP_BACKEND_CLASS (klass)->get_envp = deja_dup_backend_s3_real_get_envp;
	DEJA_DUP_BACKEND_CLASS (klass)->ask_password = deja_dup_backend_s3_real_ask_password;
}


static void deja_dup_backend_s3_instance_init (DejaDupBackendS3 * self) {
	self->priv = DEJA_DUP_BACKEND_S3_GET_PRIVATE (self);
}


static void deja_dup_backend_s3_finalize (GObject* obj) {
	DejaDupBackendS3 * self;
	self = DEJA_DUP_BACKEND_S3 (obj);
	self->priv->gconf_id = (g_free (self->priv->gconf_id), NULL);
	self->priv->id = (g_free (self->priv->id), NULL);
	self->priv->secret_key = (g_free (self->priv->secret_key), NULL);
	G_OBJECT_CLASS (deja_dup_backend_s3_parent_class)->finalize (obj);
}


GType deja_dup_backend_s3_get_type (void) {
	static GType deja_dup_backend_s3_type_id = 0;
	if (deja_dup_backend_s3_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupBackendS3Class), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_backend_s3_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupBackendS3), 0, (GInstanceInitFunc) deja_dup_backend_s3_instance_init, NULL };
		deja_dup_backend_s3_type_id = g_type_register_static (DEJA_DUP_TYPE_BACKEND, "DejaDupBackendS3", &g_define_type_info, 0);
	}
	return deja_dup_backend_s3_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




