/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */

#ifndef __DUPLICITY_H__
#define __DUPLICITY_H__

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <Operation.h>
#include <Backend.h>

G_BEGIN_DECLS


#define DEJA_DUP_TYPE_DUPLICITY (deja_dup_duplicity_get_type ())
#define DEJA_DUP_DUPLICITY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_DUPLICITY, DejaDupDuplicity))
#define DEJA_DUP_DUPLICITY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_DUPLICITY, DejaDupDuplicityClass))
#define DEJA_DUP_IS_DUPLICITY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_DUPLICITY))
#define DEJA_DUP_IS_DUPLICITY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_DUPLICITY))
#define DEJA_DUP_DUPLICITY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_DUPLICITY, DejaDupDuplicityClass))

typedef struct _DejaDupDuplicityPrivate DejaDupDuplicityPrivate;

#define DEJA_DUP_DUPLICITY_TYPE_STATE (deja_dup_duplicity_state_get_type ())

struct _DejaDupDuplicity {
	GObject parent_instance;
	DejaDupDuplicityPrivate * priv;
};

struct _DejaDupDuplicityClass {
	GObjectClass parent_class;
	void (*start) (DejaDupDuplicity* self, DejaDupBackend* backend, const char* remote, gboolean encrypted, GList* argv, GList* envp);
	void (*process_error) (DejaDupDuplicity* self, char** firstline, int firstline_length1, GList* data, const char* text_in);
	void (*process_info) (DejaDupDuplicity* self, char** firstline, int firstline_length1, GList* data, const char* text);
	void (*process_warning) (DejaDupDuplicity* self, char** firstline, int firstline_length1, GList* data, const char* text);
};

typedef enum  {
	DEJA_DUP_DUPLICITY_STATE_NORMAL,
	DEJA_DUP_DUPLICITY_STATE_DRY_RUN,
	DEJA_DUP_DUPLICITY_STATE_CLEANUP
} DejaDupDuplicityState;


GType deja_dup_duplicity_state_get_type (void);
#define DEJA_DUP_DUPLICITY_ERROR_RESTORE_DIR_NOT_FOUND 19
#define DEJA_DUP_DUPLICITY_ERROR_EXCEPTION 30
#define DEJA_DUP_DUPLICITY_INFO_PROGRESS 2
#define DEJA_DUP_DUPLICITY_INFO_COLLECTION_STATUS 3
#define DEJA_DUP_DUPLICITY_INFO_DIFF_FILE_NEW 4
#define DEJA_DUP_DUPLICITY_INFO_DIFF_FILE_CHANGED 5
#define DEJA_DUP_DUPLICITY_INFO_DIFF_FILE_DELETED 6
#define DEJA_DUP_DUPLICITY_INFO_PATCH_FILE_WRITING 7
#define DEJA_DUP_DUPLICITY_INFO_PATCH_FILE_PATCHING 8
#define DEJA_DUP_DUPLICITY_WARNING_ORPHANED_SIG 2
#define DEJA_DUP_DUPLICITY_WARNING_UNNECESSARY_SIG 3
#define DEJA_DUP_DUPLICITY_WARNING_UNMATCHED_SIG 4
#define DEJA_DUP_DUPLICITY_WARNING_INCOMPLETE_BACKUP 5
#define DEJA_DUP_DUPLICITY_WARNING_ORPHANED_BACKUP 6
DejaDupDuplicity* deja_dup_duplicity_construct (GType object_type, DejaDupOperationMode mode, GtkWindow* win);
DejaDupDuplicity* deja_dup_duplicity_new (DejaDupOperationMode mode, GtkWindow* win);
void deja_dup_duplicity_start (DejaDupDuplicity* self, DejaDupBackend* backend, const char* remote, gboolean encrypted, GList* argv, GList* envp);
void deja_dup_duplicity_cancel (DejaDupDuplicity* self);
void deja_dup_duplicity_process_error (DejaDupDuplicity* self, char** firstline, int firstline_length1, GList* data, const char* text_in);
void deja_dup_duplicity_process_info (DejaDupDuplicity* self, char** firstline, int firstline_length1, GList* data, const char* text);
void deja_dup_duplicity_process_warning (DejaDupDuplicity* self, char** firstline, int firstline_length1, GList* data, const char* text);
GtkWindow* deja_dup_duplicity_get_toplevel (DejaDupDuplicity* self);
DejaDupOperationMode deja_dup_duplicity_get_mode (DejaDupDuplicity* self);
gboolean deja_dup_duplicity_get_error_issued (DejaDupDuplicity* self);
const char* deja_dup_duplicity_get_local (DejaDupDuplicity* self);
void deja_dup_duplicity_set_local (DejaDupDuplicity* self, const char* value);
DejaDupBackend* deja_dup_duplicity_get_backend (DejaDupDuplicity* self);
void deja_dup_duplicity_set_backend (DejaDupDuplicity* self, DejaDupBackend* value);
GList* deja_dup_duplicity_get_restore_files (DejaDupDuplicity* self);
void deja_dup_duplicity_set_restore_files (DejaDupDuplicity* self, GList* value);
DejaDupDuplicityState deja_dup_duplicity_get_state (DejaDupDuplicity* self);
void deja_dup_duplicity_set_state (DejaDupDuplicity* self, DejaDupDuplicityState value);
GType deja_dup_duplicity_get_type (void);


G_END_DECLS

#endif
