/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */

#include <DuplicityInfo.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>




struct _DejaDupDuplicityInfoPrivate {
	gboolean _has_broken_cleanup;
	gboolean _has_backup_progress;
	gboolean _has_restore_progress;
	char* version_string;
	gint major;
	gint minor;
	gint micro;
};

#define DEJA_DUP_DUPLICITY_INFO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_DUPLICITY_INFO, DejaDupDuplicityInfoPrivate))
enum  {
	DEJA_DUP_DUPLICITY_INFO_DUMMY_PROPERTY,
	DEJA_DUP_DUPLICITY_INFO_HAS_BROKEN_CLEANUP,
	DEJA_DUP_DUPLICITY_INFO_HAS_BACKUP_PROGRESS,
	DEJA_DUP_DUPLICITY_INFO_HAS_RESTORE_PROGRESS
};
static DejaDupDuplicityInfo* deja_dup_duplicity_info_info = NULL;
static gboolean deja_dup_duplicity_info_meets_version (DejaDupDuplicityInfo* self, gint vmaj, gint vmin, gint vmic);
static gboolean deja_dup_duplicity_info_equals_version (DejaDupDuplicityInfo* self, gint vmaj, gint vmin, gint vmic);
static gboolean deja_dup_duplicity_info_meets_requirements (DejaDupDuplicityInfo* self);
static void deja_dup_duplicity_info_show_missing_duplicity_error (DejaDupDuplicityInfo* self, GtkWindow* parent, const char* msg_in);
static void deja_dup_duplicity_info_show_bad_version_error (DejaDupDuplicityInfo* self, GtkWindow* parent);
static void deja_dup_duplicity_info_set_has_broken_cleanup (DejaDupDuplicityInfo* self, gboolean value);
static void deja_dup_duplicity_info_set_has_backup_progress (DejaDupDuplicityInfo* self, gboolean value);
static void deja_dup_duplicity_info_set_has_restore_progress (DejaDupDuplicityInfo* self, gboolean value);
static gpointer deja_dup_duplicity_info_parent_class = NULL;
static void deja_dup_duplicity_info_finalize (GObject* obj);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);



DejaDupDuplicityInfo* deja_dup_duplicity_info_get_default (void) {
	DejaDupDuplicityInfo* _tmp1;
	if (deja_dup_duplicity_info_info == NULL) {
		DejaDupDuplicityInfo* _tmp0;
		_tmp0 = NULL;
		deja_dup_duplicity_info_info = (_tmp0 = deja_dup_duplicity_info_new (), (deja_dup_duplicity_info_info == NULL) ? NULL : (deja_dup_duplicity_info_info = (g_object_unref (deja_dup_duplicity_info_info), NULL)), _tmp0);
	}
	_tmp1 = NULL;
	return (_tmp1 = deja_dup_duplicity_info_info, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1));
}


/* Returns true if everything is OK.  If false, program will close.  A dialog
 will already have been thrown up.*/
gboolean deja_dup_duplicity_info_check_duplicity_version (DejaDupDuplicityInfo* self, GtkWindow* parent) {
	GError * inner_error;
	char* output;
	char** _tmp5;
	gint tokens_size;
	gint tokens_length1;
	char** _tmp4;
	char** tokens;
	gboolean _tmp6;
	gboolean _tmp7;
	char* _tmp10;
	const char* _tmp9;
	char** _tmp12;
	gint ver_tokens_size;
	gint ver_tokens_length1;
	char** _tmp11;
	char** ver_tokens;
	gboolean _tmp13;
	gboolean good_enough;
	gboolean _tmp17;
	gboolean _tmp18;
	g_return_val_if_fail (self != NULL, FALSE);
	inner_error = NULL;
	output = NULL;
	{
		char* _tmp2;
		gboolean _tmp1;
		char* _tmp0;
		_tmp2 = NULL;
		_tmp0 = NULL;
		_tmp1 = g_spawn_command_line_sync ("duplicity --version", &_tmp0, NULL, NULL, &inner_error);
		output = (_tmp2 = _tmp0, output = (g_free (output), NULL), _tmp2);
		_tmp1;
		if (inner_error != NULL) {
			goto __catch5_g_error;
			goto __finally5;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			gboolean _tmp3;
			deja_dup_duplicity_info_show_missing_duplicity_error (self, parent, e->message);
			return (_tmp3 = FALSE, (e == NULL) ? NULL : (e = (g_error_free (e), NULL)), output = (g_free (output), NULL), _tmp3);
		}
	}
	__finally5:
	if (inner_error != NULL) {
		output = (g_free (output), NULL);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return FALSE;
	}
	_tmp5 = NULL;
	_tmp4 = NULL;
	tokens = (_tmp5 = _tmp4 = g_strsplit (output, " ", 2), tokens_length1 = _vala_array_length (_tmp4), tokens_size = tokens_length1, _tmp5);
	_tmp6 = FALSE;
	_tmp7 = FALSE;
	if (tokens == NULL) {
		_tmp7 = TRUE;
	} else {
		_tmp7 = tokens[0] == NULL;
	}
	if (_tmp7) {
		_tmp6 = TRUE;
	} else {
		_tmp6 = tokens[1] == NULL;
	}
	if (_tmp6) {
		gboolean _tmp8;
		deja_dup_duplicity_info_show_missing_duplicity_error (self, parent, NULL);
		return (_tmp8 = FALSE, output = (g_free (output), NULL), tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL), _tmp8);
	}
	/* First token is 'duplicity' and is ignorable.  Second looks like '0.5.03'*/
	_tmp10 = NULL;
	_tmp9 = NULL;
	self->priv->version_string = (_tmp10 = (_tmp9 = g_strstrip (tokens[1]), (_tmp9 == NULL) ? NULL : g_strdup (_tmp9)), self->priv->version_string = (g_free (self->priv->version_string), NULL), _tmp10);
	_tmp12 = NULL;
	_tmp11 = NULL;
	ver_tokens = (_tmp12 = _tmp11 = g_strsplit (self->priv->version_string, ".", 0), ver_tokens_length1 = _vala_array_length (_tmp11), ver_tokens_size = ver_tokens_length1, _tmp12);
	_tmp13 = FALSE;
	if (ver_tokens == NULL) {
		_tmp13 = TRUE;
	} else {
		_tmp13 = ver_tokens[0] == NULL;
	}
	if (_tmp13) {
		gboolean _tmp14;
		deja_dup_duplicity_info_show_missing_duplicity_error (self, parent, NULL);
		return (_tmp14 = FALSE, output = (g_free (output), NULL), tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL), ver_tokens = (_vala_array_free (ver_tokens, ver_tokens_length1, (GDestroyNotify) g_free), NULL), _tmp14);
	}
	self->priv->major = atoi (ver_tokens[0]);
	if (ver_tokens[1] == NULL) {
		gboolean _tmp15;
		deja_dup_duplicity_info_show_missing_duplicity_error (self, parent, NULL);
		return (_tmp15 = FALSE, output = (g_free (output), NULL), tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL), ver_tokens = (_vala_array_free (ver_tokens, ver_tokens_length1, (GDestroyNotify) g_free), NULL), _tmp15);
	}
	self->priv->minor = atoi (ver_tokens[1]);
	if (ver_tokens[2] != NULL) {
		self->priv->micro = atoi (ver_tokens[2]);
	}
	good_enough = deja_dup_duplicity_info_meets_requirements (self);
	if (!good_enough) {
		gboolean _tmp16;
		deja_dup_duplicity_info_show_bad_version_error (self, parent);
		return (_tmp16 = FALSE, output = (g_free (output), NULL), tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL), ver_tokens = (_vala_array_free (ver_tokens, ver_tokens_length1, (GDestroyNotify) g_free), NULL), _tmp16);
	}
	if (deja_dup_duplicity_info_meets_version (self, 0, 5, 4)) {
		deja_dup_duplicity_info_set_has_backup_progress (self, TRUE);
	}
	_tmp17 = FALSE;
	if (deja_dup_duplicity_info_equals_version (self, 0, 5, 4)) {
		_tmp17 = TRUE;
	} else {
		_tmp17 = deja_dup_duplicity_info_equals_version (self, 0, 5, 5);
	}
	if (_tmp17) {
		deja_dup_duplicity_info_set_has_broken_cleanup (self, TRUE);
	}
	if (deja_dup_duplicity_info_meets_version (self, 0, 5, 6)) {
		deja_dup_duplicity_info_set_has_restore_progress (self, TRUE);
	}
	return (_tmp18 = TRUE, output = (g_free (output), NULL), tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL), ver_tokens = (_vala_array_free (ver_tokens, ver_tokens_length1, (GDestroyNotify) g_free), NULL), _tmp18);
}


static gboolean deja_dup_duplicity_info_meets_version (DejaDupDuplicityInfo* self, gint vmaj, gint vmin, gint vmic) {
	gboolean _tmp0;
	gboolean _tmp1;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0 = FALSE;
	_tmp1 = FALSE;
	if ((self->priv->major > vmaj)) {
		_tmp1 = TRUE;
	} else {
		gboolean _tmp2;
		_tmp2 = FALSE;
		if (self->priv->major == vmaj) {
			_tmp2 = self->priv->minor > vmin;
		} else {
			_tmp2 = FALSE;
		}
		_tmp1 = (_tmp2);
	}
	if (_tmp1) {
		_tmp0 = TRUE;
	} else {
		gboolean _tmp3;
		gboolean _tmp4;
		_tmp3 = FALSE;
		_tmp4 = FALSE;
		if (self->priv->major == vmaj) {
			_tmp4 = self->priv->minor == vmin;
		} else {
			_tmp4 = FALSE;
		}
		if (_tmp4) {
			_tmp3 = self->priv->micro >= vmic;
		} else {
			_tmp3 = FALSE;
		}
		_tmp0 = (_tmp3);
	}
	return _tmp0;
}


static gboolean deja_dup_duplicity_info_equals_version (DejaDupDuplicityInfo* self, gint vmaj, gint vmin, gint vmic) {
	gboolean _tmp0;
	gboolean _tmp1;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0 = FALSE;
	_tmp1 = FALSE;
	if (self->priv->major == vmaj) {
		_tmp1 = self->priv->minor == vmin;
	} else {
		_tmp1 = FALSE;
	}
	if (_tmp1) {
		_tmp0 = self->priv->micro == vmic;
	} else {
		_tmp0 = FALSE;
	}
	return _tmp0;
}


/* Doesn't yet handle a blacklist of versions.  We'll cross that bridge when we come to it*/
static gboolean deja_dup_duplicity_info_meets_requirements (DejaDupDuplicityInfo* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return deja_dup_duplicity_info_meets_version (self, DEJA_DUP_DUPLICITY_INFO_REQUIRED_MAJOR, DEJA_DUP_DUPLICITY_INFO_REQUIRED_MINOR, DEJA_DUP_DUPLICITY_INFO_REQUIRED_MICRO);
}


static void deja_dup_duplicity_info_show_missing_duplicity_error (DejaDupDuplicityInfo* self, GtkWindow* parent, const char* msg_in) {
	GtkMessageDialog* dlg;
	const char* _tmp0;
	char* msg;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	dlg = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (parent, GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _ ("Could not run duplicity"), NULL));
	_tmp0 = NULL;
	msg = (_tmp0 = msg_in, (_tmp0 == NULL) ? NULL : g_strdup (_tmp0));
	if (msg != NULL) {
		char* _tmp1;
		_tmp1 = NULL;
		msg = (_tmp1 = g_strconcat (g_strchomp (msg), "\n\n", NULL), msg = (g_free (msg), NULL), _tmp1);
	} else {
		if (self->priv->version_string == NULL) {
			char* _tmp3;
			const char* _tmp2;
			_tmp3 = NULL;
			_tmp2 = NULL;
			msg = (_tmp3 = (_tmp2 = _ ("Could not understand duplicity version.\n\n"), (_tmp2 == NULL) ? NULL : g_strdup (_tmp2)), msg = (g_free (msg), NULL), _tmp3);
		} else {
			char* _tmp4;
			_tmp4 = NULL;
			msg = (_tmp4 = g_strdup_printf (_ ("Could not understand duplicity version '%s'.\n\n"), self->priv->version_string), msg = (g_free (msg), NULL), _tmp4);
		}
	}
	gtk_message_dialog_format_secondary_text (dlg, "%s%s", msg, _ ("Without duplicity, Déjà Dup cannot function.  It will close now."), NULL);
	gtk_dialog_run ((GtkDialog*) dlg);
	gtk_object_destroy ((GtkObject*) dlg);
	gtk_main_quit ();
	(dlg == NULL) ? NULL : (dlg = (g_object_unref (dlg), NULL));
	msg = (g_free (msg), NULL);
}


static void deja_dup_duplicity_info_show_bad_version_error (DejaDupDuplicityInfo* self, GtkWindow* parent) {
	GtkMessageDialog* dlg;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	dlg = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (parent, GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _ ("Duplicity's version is too old"), NULL));
	gtk_message_dialog_format_secondary_text (dlg, _ ("Déjà Dup requires at least version %d.%d.%.2d of duplicity, but only found version %d.%d.%.2d"), DEJA_DUP_DUPLICITY_INFO_REQUIRED_MAJOR, DEJA_DUP_DUPLICITY_INFO_REQUIRED_MINOR, DEJA_DUP_DUPLICITY_INFO_REQUIRED_MICRO, self->priv->major, self->priv->minor, self->priv->micro, NULL);
	gtk_dialog_run ((GtkDialog*) dlg);
	gtk_object_destroy ((GtkObject*) dlg);
	gtk_main_quit ();
	(dlg == NULL) ? NULL : (dlg = (g_object_unref (dlg), NULL));
}


DejaDupDuplicityInfo* deja_dup_duplicity_info_construct (GType object_type) {
	DejaDupDuplicityInfo * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


DejaDupDuplicityInfo* deja_dup_duplicity_info_new (void) {
	return deja_dup_duplicity_info_construct (DEJA_DUP_TYPE_DUPLICITY_INFO);
}


gboolean deja_dup_duplicity_info_get_has_broken_cleanup (DejaDupDuplicityInfo* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return self->priv->_has_broken_cleanup;
}


static void deja_dup_duplicity_info_set_has_broken_cleanup (DejaDupDuplicityInfo* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_has_broken_cleanup = value;
	g_object_notify ((GObject *) self, "has-broken-cleanup");
}


gboolean deja_dup_duplicity_info_get_has_backup_progress (DejaDupDuplicityInfo* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return self->priv->_has_backup_progress;
}


static void deja_dup_duplicity_info_set_has_backup_progress (DejaDupDuplicityInfo* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_has_backup_progress = value;
	g_object_notify ((GObject *) self, "has-backup-progress");
}


gboolean deja_dup_duplicity_info_get_has_restore_progress (DejaDupDuplicityInfo* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return self->priv->_has_restore_progress;
}


static void deja_dup_duplicity_info_set_has_restore_progress (DejaDupDuplicityInfo* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_has_restore_progress = value;
	g_object_notify ((GObject *) self, "has-restore-progress");
}


static void deja_dup_duplicity_info_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DejaDupDuplicityInfo * self;
	gpointer boxed;
	self = DEJA_DUP_DUPLICITY_INFO (object);
	switch (property_id) {
		case DEJA_DUP_DUPLICITY_INFO_HAS_BROKEN_CLEANUP:
		g_value_set_boolean (value, deja_dup_duplicity_info_get_has_broken_cleanup (self));
		break;
		case DEJA_DUP_DUPLICITY_INFO_HAS_BACKUP_PROGRESS:
		g_value_set_boolean (value, deja_dup_duplicity_info_get_has_backup_progress (self));
		break;
		case DEJA_DUP_DUPLICITY_INFO_HAS_RESTORE_PROGRESS:
		g_value_set_boolean (value, deja_dup_duplicity_info_get_has_restore_progress (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void deja_dup_duplicity_info_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DejaDupDuplicityInfo * self;
	self = DEJA_DUP_DUPLICITY_INFO (object);
	switch (property_id) {
		case DEJA_DUP_DUPLICITY_INFO_HAS_BROKEN_CLEANUP:
		deja_dup_duplicity_info_set_has_broken_cleanup (self, g_value_get_boolean (value));
		break;
		case DEJA_DUP_DUPLICITY_INFO_HAS_BACKUP_PROGRESS:
		deja_dup_duplicity_info_set_has_backup_progress (self, g_value_get_boolean (value));
		break;
		case DEJA_DUP_DUPLICITY_INFO_HAS_RESTORE_PROGRESS:
		deja_dup_duplicity_info_set_has_restore_progress (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void deja_dup_duplicity_info_class_init (DejaDupDuplicityInfoClass * klass) {
	deja_dup_duplicity_info_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupDuplicityInfoPrivate));
	G_OBJECT_CLASS (klass)->get_property = deja_dup_duplicity_info_get_property;
	G_OBJECT_CLASS (klass)->set_property = deja_dup_duplicity_info_set_property;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_duplicity_info_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_INFO_HAS_BROKEN_CLEANUP, g_param_spec_boolean ("has-broken-cleanup", "has-broken-cleanup", "has-broken-cleanup", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_INFO_HAS_BACKUP_PROGRESS, g_param_spec_boolean ("has-backup-progress", "has-backup-progress", "has-backup-progress", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_INFO_HAS_RESTORE_PROGRESS, g_param_spec_boolean ("has-restore-progress", "has-restore-progress", "has-restore-progress", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void deja_dup_duplicity_info_instance_init (DejaDupDuplicityInfo * self) {
	self->priv = DEJA_DUP_DUPLICITY_INFO_GET_PRIVATE (self);
	self->priv->_has_broken_cleanup = FALSE;
	self->priv->_has_backup_progress = FALSE;
	self->priv->_has_restore_progress = FALSE;
	self->priv->version_string = NULL;
	self->priv->major = 0;
	self->priv->minor = 0;
	self->priv->micro = 0;
}


static void deja_dup_duplicity_info_finalize (GObject* obj) {
	DejaDupDuplicityInfo * self;
	self = DEJA_DUP_DUPLICITY_INFO (obj);
	self->priv->version_string = (g_free (self->priv->version_string), NULL);
	G_OBJECT_CLASS (deja_dup_duplicity_info_parent_class)->finalize (obj);
}


GType deja_dup_duplicity_info_get_type (void) {
	static GType deja_dup_duplicity_info_type_id = 0;
	if (deja_dup_duplicity_info_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupDuplicityInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_duplicity_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupDuplicityInfo), 0, (GInstanceInitFunc) deja_dup_duplicity_info_instance_init, NULL };
		deja_dup_duplicity_info_type_id = g_type_register_static (G_TYPE_OBJECT, "DejaDupDuplicityInfo", &g_define_type_info, 0);
	}
	return deja_dup_duplicity_info_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}




