/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */

#include <Operation.h>
#include <glib/gi18n-lib.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <gdk/gdkx.h>
#include <gdk/gdk.h>
#include <config.h>
#include <gconf/gconf-client.h>
#include <gnome-keyring.h>
#include <PassphraseSchema.h>
#include <libgnomeui/libgnomeui.h>
#include <Duplicity.h>
#include <libdeja-dup.h>




struct _DejaDupOperationPrivate {
	GtkWindow* _toplevel;
	guint _uppermost_xid;
	DejaDupOperationMode _mode;
	guint inhibit_cookie;
};

#define DEJA_DUP_OPERATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_OPERATION, DejaDupOperationPrivate))
enum  {
	DEJA_DUP_OPERATION_DUMMY_PROPERTY,
	DEJA_DUP_OPERATION_TOPLEVEL,
	DEJA_DUP_OPERATION_UPPERMOST_XID,
	DEJA_DUP_OPERATION_MODE
};
static void deja_dup_operation_real_start (DejaDupOperation* self, GError** error);
static void _deja_dup_operation_operation_finished_deja_dup_duplicity_done (DejaDupDuplicity* _sender, gboolean success, gboolean cancelled, gpointer self);
static void __lambda0 (DejaDupDuplicity* d, const char* s, const char* detail, DejaDupOperation* self);
static void ___lambda0_deja_dup_duplicity_raise_error (DejaDupDuplicity* _sender, const char* errstr, const char* detail, gpointer self);
static void __lambda1 (DejaDupDuplicity* d, const char* s, DejaDupOperation* self);
static void ___lambda1_deja_dup_duplicity_action_desc_changed (DejaDupDuplicity* _sender, const char* action, gpointer self);
static void __lambda2 (DejaDupDuplicity* d, GFile* f, DejaDupOperation* self);
static void ___lambda2_deja_dup_duplicity_action_file_changed (DejaDupDuplicity* _sender, GFile* file, gpointer self);
static void __lambda3 (DejaDupDuplicity* d, double p, DejaDupOperation* self);
static void ___lambda3_deja_dup_duplicity_progress (DejaDupDuplicity* _sender, double percent, gpointer self);
static void _deja_dup_operation_continue_with_envp_deja_dup_backend_envp_ready (DejaDupBackend* _sender, gboolean success, GList* envp, gpointer self);
static void __lambda4 (DejaDupBackend* b, DejaDupOperation* self);
static void ___lambda4_deja_dup_backend_need_password (DejaDupBackend* _sender, gpointer self);
static void deja_dup_operation_real_connect_to_dup (DejaDupOperation* self);
static void deja_dup_operation_continue_with_passphrase (DejaDupOperation* self, GError** error);
static void _g_list_free_g_free (GList* self);
static void deja_dup_operation_continue_with_envp (DejaDupOperation* self, DejaDupBackend* b, gboolean success, GList* envp);
static void deja_dup_operation_real_operation_finished (DejaDupOperation* self, DejaDupDuplicity* dup, gboolean success, gboolean cancelled);
static GList* deja_dup_operation_real_make_argv (DejaDupOperation* self, GError** error);
static void deja_dup_operation_found_passphrase (DejaDupOperation* self, GnomeKeyringResult result, const char* str);
static void _deja_dup_operation_found_passphrase_gnome_keyring_operation_get_string_callback (GnomeKeyringResult result, const char* str, gpointer self);
static void deja_dup_operation_get_passphrase (DejaDupOperation* self);
static void deja_dup_operation_save_password_callback (DejaDupOperation* self, GnomeKeyringResult result);
static void _deja_dup_operation_save_password_callback_gnome_keyring_operation_done_callback (GnomeKeyringResult result, gpointer self);
static gboolean deja_dup_operation_claim_bus (DejaDupOperation* self, gboolean claimed);
void _dynamic_Inhibit0 (DBusGProxy* self, const char* param1, guint param2, char* param3, guint param4, guint* param5, GError** error);
void _dynamic_Uninhibit1 (DBusGProxy* self, guint param1, GError** error);
static void deja_dup_operation_set_session_inhibited (DejaDupOperation* self, gboolean inhibit);
static void deja_dup_operation_set_toplevel (DejaDupOperation* self, GtkWindow* value);
static void deja_dup_operation_set_uppermost_xid (DejaDupOperation* self, guint value);
static void deja_dup_operation_set_mode (DejaDupOperation* self, DejaDupOperationMode value);
static gboolean __lambda5 (DejaDupOperation* o, DejaDupOperation* self);
static gboolean ___lambda5_deja_dup_operation_passphrase_required (DejaDupOperation* _sender, gpointer self);
static gboolean __lambda6 (DejaDupOperation* o, DejaDupOperation* self);
static gboolean ___lambda6_deja_dup_operation_backend_password_required (DejaDupOperation* _sender, gpointer self);
static GObject * deja_dup_operation_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer deja_dup_operation_parent_class = NULL;
static void deja_dup_operation_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);


static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__VOID (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);


GType deja_dup_operation_mode_get_type (void) {
	static GType deja_dup_operation_mode_type_id = 0;
	if (G_UNLIKELY (deja_dup_operation_mode_type_id == 0)) {
		static const GEnumValue values[] = {{DEJA_DUP_OPERATION_MODE_INVALID, "DEJA_DUP_OPERATION_MODE_INVALID", "invalid"}, {DEJA_DUP_OPERATION_MODE_BACKUP, "DEJA_DUP_OPERATION_MODE_BACKUP", "backup"}, {DEJA_DUP_OPERATION_MODE_RESTORE, "DEJA_DUP_OPERATION_MODE_RESTORE", "restore"}, {DEJA_DUP_OPERATION_MODE_STATUS, "DEJA_DUP_OPERATION_MODE_STATUS", "status"}, {0, NULL, NULL}};
		deja_dup_operation_mode_type_id = g_enum_register_static ("DejaDupOperationMode", values);
	}
	return deja_dup_operation_mode_type_id;
}


char* deja_dup_operation_mode_to_string (DejaDupOperationMode mode) {
	switch (mode) {
		case DEJA_DUP_OPERATION_MODE_BACKUP:
		{
			const char* _tmp0;
			_tmp0 = NULL;
			return (_tmp0 = _ ("Backing up..."), (_tmp0 == NULL) ? NULL : g_strdup (_tmp0));
		}
		case DEJA_DUP_OPERATION_MODE_RESTORE:
		{
			const char* _tmp2;
			_tmp2 = NULL;
			return (_tmp2 = _ ("Restoring..."), (_tmp2 == NULL) ? NULL : g_strdup (_tmp2));
		}
		case DEJA_DUP_OPERATION_MODE_STATUS:
		{
			const char* _tmp4;
			_tmp4 = NULL;
			return (_tmp4 = _ ("Checking for backups..."), (_tmp4 == NULL) ? NULL : g_strdup (_tmp4));
		}
		default:
		{
			return g_strdup ("");
		}
	}
}


static void deja_dup_operation_real_start (DejaDupOperation* self, GError** error) {
	GError * inner_error;
	GConfClient* _tmp0;
	GConfClient* client;
	gboolean _tmp1;
	gboolean _tmp2;
	g_return_if_fail (self != NULL);
	inner_error = NULL;
	if (self->backend == NULL) {
		g_signal_emit_by_name (self, "done", FALSE);
		return;
	}
	deja_dup_operation_connect_to_dup (self);
	if (!deja_dup_operation_claim_bus (self, TRUE)) {
		g_signal_emit_by_name (self, "done", FALSE);
		return;
	}
	deja_dup_operation_set_session_inhibited (self, TRUE);
	/* Get encryption passphrase if needed*/
	_tmp0 = NULL;
	client = (_tmp0 = gconf_client_get_default (), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	_tmp1 = FALSE;
	_tmp2 = gconf_client_get_bool (client, DEJA_DUP_ENCRYPT_KEY, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
		return;
	}
	if (_tmp2) {
		_tmp1 = self->passphrase == NULL;
	} else {
		_tmp1 = FALSE;
	}
	if (_tmp1) {
		deja_dup_operation_get_passphrase (self);
	} else {
		deja_dup_operation_continue_with_passphrase (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
			return;
		}
	}
	(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
}


void deja_dup_operation_start (DejaDupOperation* self, GError** error) {
	DEJA_DUP_OPERATION_GET_CLASS (self)->start (self, error);
}


void deja_dup_operation_cancel (DejaDupOperation* self) {
	g_return_if_fail (self != NULL);
	deja_dup_duplicity_cancel (self->dup);
}


static void _deja_dup_operation_operation_finished_deja_dup_duplicity_done (DejaDupDuplicity* _sender, gboolean success, gboolean cancelled, gpointer self) {
	deja_dup_operation_operation_finished (self, _sender, success, cancelled);
}


static void __lambda0 (DejaDupDuplicity* d, const char* s, const char* detail, DejaDupOperation* self) {
	g_return_if_fail (d != NULL);
	g_return_if_fail (s != NULL);
	g_signal_emit_by_name (self, "raise-error", s, detail);
}


static void ___lambda0_deja_dup_duplicity_raise_error (DejaDupDuplicity* _sender, const char* errstr, const char* detail, gpointer self) {
	__lambda0 (_sender, errstr, detail, self);
}


static void __lambda1 (DejaDupDuplicity* d, const char* s, DejaDupOperation* self) {
	g_return_if_fail (d != NULL);
	g_return_if_fail (s != NULL);
	g_signal_emit_by_name (self, "action-desc-changed", s);
}


static void ___lambda1_deja_dup_duplicity_action_desc_changed (DejaDupDuplicity* _sender, const char* action, gpointer self) {
	__lambda1 (_sender, action, self);
}


static void __lambda2 (DejaDupDuplicity* d, GFile* f, DejaDupOperation* self) {
	g_return_if_fail (d != NULL);
	g_return_if_fail (f != NULL);
	g_signal_emit_by_name (self, "action-file-changed", f);
}


static void ___lambda2_deja_dup_duplicity_action_file_changed (DejaDupDuplicity* _sender, GFile* file, gpointer self) {
	__lambda2 (_sender, file, self);
}


static void __lambda3 (DejaDupDuplicity* d, double p, DejaDupOperation* self) {
	g_return_if_fail (d != NULL);
	g_signal_emit_by_name (self, "progress", p);
}


static void ___lambda3_deja_dup_duplicity_progress (DejaDupDuplicity* _sender, double percent, gpointer self) {
	__lambda3 (_sender, percent, self);
}


static void _deja_dup_operation_continue_with_envp_deja_dup_backend_envp_ready (DejaDupBackend* _sender, gboolean success, GList* envp, gpointer self) {
	deja_dup_operation_continue_with_envp (self, _sender, success, envp);
}


static void __lambda4 (DejaDupBackend* b, DejaDupOperation* self) {
	gboolean _tmp0;
	gboolean can_ask_now;
	g_return_if_fail (b != NULL);
	can_ask_now = (g_signal_emit_by_name (self, "backend-password-required", &_tmp0), _tmp0);
	if (can_ask_now) {
		deja_dup_backend_ask_password (self->backend);
	}
}


static void ___lambda4_deja_dup_backend_need_password (DejaDupBackend* _sender, gpointer self) {
	__lambda4 (_sender, self);
}


static void deja_dup_operation_real_connect_to_dup (DejaDupOperation* self) {
	g_return_if_fail (self != NULL);
	g_signal_connect_object (self->dup, "done", (GCallback) _deja_dup_operation_operation_finished_deja_dup_duplicity_done, self, 0);
	g_signal_connect (self->dup, "raise-error", (GCallback) ___lambda0_deja_dup_duplicity_raise_error, self);
	g_signal_connect (self->dup, "action-desc-changed", (GCallback) ___lambda1_deja_dup_duplicity_action_desc_changed, self);
	g_signal_connect (self->dup, "action-file-changed", (GCallback) ___lambda2_deja_dup_duplicity_action_file_changed, self);
	g_signal_connect (self->dup, "progress", (GCallback) ___lambda3_deja_dup_duplicity_progress, self);
	g_signal_connect_object (self->backend, "envp-ready", (GCallback) _deja_dup_operation_continue_with_envp_deja_dup_backend_envp_ready, self, 0);
	g_signal_connect (self->backend, "need-password", (GCallback) ___lambda4_deja_dup_backend_need_password, self);
}


void deja_dup_operation_connect_to_dup (DejaDupOperation* self) {
	DEJA_DUP_OPERATION_GET_CLASS (self)->connect_to_dup (self);
}


static void deja_dup_operation_continue_with_passphrase (DejaDupOperation* self, GError** error) {
	GError * inner_error;
	g_return_if_fail (self != NULL);
	inner_error = NULL;
	deja_dup_backend_get_envp (self->backend, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return;
	}
}


static void _g_list_free_g_free (GList* self) {
	g_list_foreach (self, (GFunc) g_free, NULL);
	g_list_free (self);
}


static void deja_dup_operation_continue_with_envp (DejaDupOperation* self, DejaDupBackend* b, gboolean success, GList* envp) {
	GError * inner_error;
	gboolean _tmp0;
	gboolean encrypted;
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	inner_error = NULL;
	if (!success) {
		g_signal_emit_by_name (self, "done", FALSE);
		return;
	}
	_tmp0 = FALSE;
	if (self->passphrase != NULL) {
		_tmp0 = _vala_strcmp0 (self->passphrase, "") != 0;
	} else {
		_tmp0 = FALSE;
	}
	encrypted = (_tmp0);
	if (encrypted) {
		envp = g_list_append (envp, g_strdup_printf ("PASSPHRASE=%s", self->passphrase));
	} else {
		envp = g_list_append (envp, g_strdup ("PASSPHRASE="));
	}
	{
		GList* argv;
		char* target;
		argv = deja_dup_operation_make_argv (self, &inner_error);
		if (inner_error != NULL) {
			goto __catch9_g_error;
			goto __finally9;
		}
		target = deja_dup_backend_get_location (self->backend, &inner_error);
		if (inner_error != NULL) {
			(argv == NULL) ? NULL : (argv = (_g_list_free_g_free (argv), NULL));
			goto __catch9_g_error;
			goto __finally9;
		}
		deja_dup_duplicity_start (self->dup, self->backend, target, encrypted, argv, envp);
		(argv == NULL) ? NULL : (argv = (_g_list_free_g_free (argv), NULL));
		target = (g_free (target), NULL);
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_signal_emit_by_name (self, "raise-error", e->message, NULL);
			g_signal_emit_by_name (self, "done", FALSE);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			return;
		}
	}
	__finally9:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
}


static void deja_dup_operation_real_operation_finished (DejaDupOperation* self, DejaDupDuplicity* dup, gboolean success, gboolean cancelled) {
	GError * inner_error;
	gboolean _tmp0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dup != NULL);
	inner_error = NULL;
	deja_dup_operation_set_session_inhibited (self, FALSE);
	deja_dup_operation_claim_bus (self, FALSE);
	_tmp0 = FALSE;
	if (success) {
		_tmp0 = _vala_strcmp0 (self->passphrase, "") == 0;
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		{
			GConfClient* _tmp1;
			GConfClient* client;
			_tmp1 = NULL;
			client = (_tmp1 = gconf_client_get_default (), (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1));
			gconf_client_set_bool (client, DEJA_DUP_ENCRYPT_KEY, FALSE, &inner_error);
			if (inner_error != NULL) {
				(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
				goto __catch10_g_error;
				goto __finally10;
			}
			(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
		}
		goto __finally10;
		__catch10_g_error:
		{
			GError * e;
			e = inner_error;
			inner_error = NULL;
			{
				g_warning ("Operation.vala:165: %s\n", e->message);
				(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			}
		}
		__finally10:
		if (inner_error != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
			return;
		}
	}
	g_signal_emit_by_name (self, "done", success);
}


void deja_dup_operation_operation_finished (DejaDupOperation* self, DejaDupDuplicity* dup, gboolean success, gboolean cancelled) {
	DEJA_DUP_OPERATION_GET_CLASS (self)->operation_finished (self, dup, success, cancelled);
}


static GList* deja_dup_operation_real_make_argv (DejaDupOperation* self, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return NULL;
}


GList* deja_dup_operation_make_argv (DejaDupOperation* self, GError** error) {
	return DEJA_DUP_OPERATION_GET_CLASS (self)->make_argv (self, error);
}


static void deja_dup_operation_found_passphrase (DejaDupOperation* self, GnomeKeyringResult result, const char* str) {
	GError * inner_error;
	g_return_if_fail (self != NULL);
	inner_error = NULL;
	if (result == GNOME_KEYRING_RESULT_OK) {
		char* _tmp1;
		const char* _tmp0;
		_tmp1 = NULL;
		_tmp0 = NULL;
		self->passphrase = (_tmp1 = (_tmp0 = str, (_tmp0 == NULL) ? NULL : g_strdup (_tmp0)), self->passphrase = (g_free (self->passphrase), NULL), _tmp1);
	}
	{
		if (self->passphrase != NULL) {
			deja_dup_operation_continue_with_passphrase (self, &inner_error);
			if (inner_error != NULL) {
				goto __catch11_g_error;
				goto __finally11;
			}
		} else {
			gboolean _tmp2;
			gboolean can_ask_now;
			can_ask_now = (g_signal_emit_by_name (self, "passphrase-required", &_tmp2), _tmp2);
			if (can_ask_now) {
				deja_dup_operation_ask_passphrase (self, &inner_error);
				if (inner_error != NULL) {
					goto __catch11_g_error;
					goto __finally11;
				}
			}
		}
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			/* else wait for consumer of Operation to call ask_passphrase*/
			g_warning ("Operation.vala:193: %s\n", e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally11:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
}


static void _deja_dup_operation_found_passphrase_gnome_keyring_operation_get_string_callback (GnomeKeyringResult result, const char* str, gpointer self) {
	deja_dup_operation_found_passphrase (self, result, str);
}


static void deja_dup_operation_get_passphrase (DejaDupOperation* self) {
	g_return_if_fail (self != NULL);
	/* First, try user's keyring*/
	gnome_keyring_find_password (PASSPHRASE_SCHEMA, _deja_dup_operation_found_passphrase_gnome_keyring_operation_get_string_callback, g_object_ref (self), g_object_unref, "owner", PACKAGE, "type", "passphrase", NULL);
}


static void deja_dup_operation_save_password_callback (DejaDupOperation* self, GnomeKeyringResult result) {
	g_return_if_fail (self != NULL);
}


static void _deja_dup_operation_save_password_callback_gnome_keyring_operation_done_callback (GnomeKeyringResult result, gpointer self) {
	deja_dup_operation_save_password_callback (self, result);
}


void deja_dup_operation_ask_passphrase (DejaDupOperation* self, GError** error) {
	GError * inner_error;
	GnomePasswordDialog* dlg;
	char* _tmp1;
	const char* _tmp0;
	g_return_if_fail (self != NULL);
	inner_error = NULL;
	/* Ask user*/
	dlg = g_object_ref_sink ((GnomePasswordDialog*) gnome_password_dialog_new (_ ("Encryption Password"), _ ("Enter the password used to encrypt your backup files."), "", "", FALSE));
	((GtkWindow*) dlg)->transient_parent = self->priv->_toplevel;
	g_object_set (dlg, "show-remember", TRUE, NULL);
	g_object_set (dlg, "show-username", FALSE, NULL);
	if (!gnome_password_dialog_run_and_block (dlg)) {
		g_signal_emit_by_name (self, "done", FALSE);
		(dlg == NULL) ? NULL : (dlg = (g_object_unref (dlg), NULL));
		return;
	}
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->passphrase = (_tmp1 = (_tmp0 = gnome_password_dialog_get_password (dlg), (_tmp0 == NULL) ? NULL : g_strdup (_tmp0)), self->passphrase = (g_free (self->passphrase), NULL), _tmp1);
	if (_vala_strcmp0 (self->passphrase, "") != 0) {
		GnomePasswordDialogRemember remember;
		/* Save it*/
		remember = gnome_password_dialog_get_remember (dlg);
		if (remember != GNOME_PASSWORD_DIALOG_REMEMBER_NOTHING) {
			const char* _tmp2;
			const char* _tmp3;
			char* where;
			_tmp2 = NULL;
			if (remember == GNOME_PASSWORD_DIALOG_REMEMBER_SESSION) {
				_tmp2 = "session";
			} else {
				_tmp2 = GNOME_KEYRING_DEFAULT;
			}
			_tmp3 = NULL;
			where = (_tmp3 = _tmp2, (_tmp3 == NULL) ? NULL : g_strdup (_tmp3));
			gnome_keyring_store_password (PASSPHRASE_SCHEMA, where, _ ("Déjà Dup backup passphrase"), self->passphrase, _deja_dup_operation_save_password_callback_gnome_keyring_operation_done_callback, g_object_ref (self), g_object_unref, "owner", PACKAGE, "type", "passphrase", NULL);
			where = (g_free (where), NULL);
		}
	}
	deja_dup_operation_continue_with_passphrase (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		(dlg == NULL) ? NULL : (dlg = (g_object_unref (dlg), NULL));
		return;
	}
	(dlg == NULL) ? NULL : (dlg = (g_object_unref (dlg), NULL));
}


void deja_dup_operation_ask_backend_password (DejaDupOperation* self, GError** error) {
	g_return_if_fail (self != NULL);
	deja_dup_backend_ask_password (self->backend);
}


static gboolean deja_dup_operation_claim_bus (DejaDupOperation* self, gboolean claimed) {
	gboolean rv;
	gboolean _tmp0;
	g_return_val_if_fail (self != NULL, FALSE);
	rv = deja_dup_set_bus_claimed ("operation", claimed);
	_tmp0 = FALSE;
	if (claimed) {
		_tmp0 = !rv;
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		g_signal_emit_by_name (self, "raise-error", _ ("Another Déjà Dup is already running"), NULL);
	}
	return rv;
}


void _dynamic_Inhibit0 (DBusGProxy* self, const char* param1, guint param2, char* param3, guint param4, guint* param5, GError** error) {
	dbus_g_proxy_call (self, "Inhibit", error, G_TYPE_STRING, param1, G_TYPE_UINT, param2, G_TYPE_STRING, param3, G_TYPE_UINT, param4, G_TYPE_INVALID, G_TYPE_UINT, param5, G_TYPE_INVALID);
	if (*error) {
		return;
	}
}


void _dynamic_Uninhibit1 (DBusGProxy* self, guint param1, GError** error) {
	dbus_g_proxy_call_no_reply (self, "Uninhibit", G_TYPE_UINT, param1, G_TYPE_INVALID);
	if (*error) {
		return;
	}
}


static void deja_dup_operation_set_session_inhibited (DejaDupOperation* self, gboolean inhibit) {
	GError * inner_error;
	g_return_if_fail (self != NULL);
	inner_error = NULL;
	{
		DBusGConnection* conn;
		DBusGProxy* obj;
		conn = dbus_g_bus_get (DBUS_BUS_SESSION, &inner_error);
		if (inner_error != NULL) {
			goto __catch12_g_error;
			goto __finally12;
		}
		obj = dbus_g_proxy_new_for_name (conn, "org.gnome.SessionManager", "/org/gnome/SessionManager", "org.gnome.SessionManager");
		if (inhibit) {
			guint xid;
			gboolean _tmp0;
			char* _tmp1;
			if (self->priv->inhibit_cookie > 0) {
				(conn == NULL) ? NULL : (conn = (dbus_g_connection_unref (conn), NULL));
				(obj == NULL) ? NULL : (obj = (g_object_unref (obj), NULL));
				return;
			}
			/* already inhibited*/
			xid = self->priv->_uppermost_xid;
			_tmp0 = FALSE;
			if (xid == 0) {
				_tmp0 = self->priv->_toplevel != NULL;
			} else {
				_tmp0 = FALSE;
			}
			if (_tmp0) {
				gtk_widget_realize ((GtkWidget*) self->priv->_toplevel);
				xid = (guint) gdk_x11_drawable_get_xid ((GdkDrawable*) ((GtkWidget*) self->priv->_toplevel)->window);
			}
			_tmp1 = NULL;
			_dynamic_Inhibit0 (obj, PACKAGE, xid, _tmp1 = deja_dup_operation_mode_to_string (deja_dup_duplicity_get_mode (self->dup)), (guint) (1 | 4), &self->priv->inhibit_cookie, &inner_error);
			if (inner_error != NULL) {
				(conn == NULL) ? NULL : (conn = (dbus_g_connection_unref (conn), NULL));
				(obj == NULL) ? NULL : (obj = (g_object_unref (obj), NULL));
				goto __catch12_g_error;
				goto __finally12;
			}
			_tmp1 = (g_free (_tmp1), NULL);
		} else {
			if (self->priv->inhibit_cookie > 0) {
				_dynamic_Uninhibit1 (obj, self->priv->inhibit_cookie, &inner_error);
				if (inner_error != NULL) {
					(conn == NULL) ? NULL : (conn = (dbus_g_connection_unref (conn), NULL));
					(obj == NULL) ? NULL : (obj = (g_object_unref (obj), NULL));
					goto __catch12_g_error;
					goto __finally12;
				}
				self->priv->inhibit_cookie = (guint) 0;
			}
		}
		(conn == NULL) ? NULL : (conn = (dbus_g_connection_unref (conn), NULL));
		(obj == NULL) ? NULL : (obj = (g_object_unref (obj), NULL));
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning ("Operation.vala:289: %s\n", e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally12:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
}


GtkWindow* deja_dup_operation_get_toplevel (DejaDupOperation* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_toplevel;
}


static void deja_dup_operation_set_toplevel (DejaDupOperation* self, GtkWindow* value) {
	GtkWindow* _tmp2;
	GtkWindow* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_toplevel = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (self->priv->_toplevel == NULL) ? NULL : (self->priv->_toplevel = (g_object_unref (self->priv->_toplevel), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "toplevel");
}


guint deja_dup_operation_get_uppermost_xid (DejaDupOperation* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return self->priv->_uppermost_xid;
}


static void deja_dup_operation_set_uppermost_xid (DejaDupOperation* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_uppermost_xid = value;
	g_object_notify ((GObject *) self, "uppermost-xid");
}


DejaDupOperationMode deja_dup_operation_get_mode (DejaDupOperation* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_mode;
}


static void deja_dup_operation_set_mode (DejaDupOperation* self, DejaDupOperationMode value) {
	g_return_if_fail (self != NULL);
	self->priv->_mode = value;
	g_object_notify ((GObject *) self, "mode");
}


static gboolean __lambda5 (DejaDupOperation* o, DejaDupOperation* self) {
	g_return_val_if_fail (o != NULL, FALSE);
	return TRUE;
}


static gboolean ___lambda5_deja_dup_operation_passphrase_required (DejaDupOperation* _sender, gpointer self) {
	return __lambda5 (_sender, self);
}


static gboolean __lambda6 (DejaDupOperation* o, DejaDupOperation* self) {
	g_return_val_if_fail (o != NULL, FALSE);
	return TRUE;
}


static gboolean ___lambda6_deja_dup_operation_backend_password_required (DejaDupOperation* _sender, gpointer self) {
	return __lambda6 (_sender, self);
}


static GObject * deja_dup_operation_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	DejaDupOperationClass * klass;
	GObjectClass * parent_class;
	DejaDupOperation * self;
	GError * inner_error;
	klass = DEJA_DUP_OPERATION_CLASS (g_type_class_peek (DEJA_DUP_TYPE_OPERATION));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DEJA_DUP_OPERATION (obj);
	inner_error = NULL;
	{
		DejaDupDuplicity* _tmp0;
		_tmp0 = NULL;
		self->dup = (_tmp0 = deja_dup_duplicity_new (self->priv->_mode, self->priv->_toplevel), (self->dup == NULL) ? NULL : (self->dup = (g_object_unref (self->dup), NULL)), _tmp0);
		{
			DejaDupBackend* _tmp1;
			DejaDupBackend* _tmp2;
			_tmp1 = deja_dup_backend_get_default (self->priv->_toplevel, &inner_error);
			if (inner_error != NULL) {
				goto __catch13_g_error;
				goto __finally13;
			}
			_tmp2 = NULL;
			self->backend = (_tmp2 = _tmp1, (self->backend == NULL) ? NULL : (self->backend = (g_object_unref (self->backend), NULL)), _tmp2);
		}
		goto __finally13;
		__catch13_g_error:
		{
			GError * e;
			e = inner_error;
			inner_error = NULL;
			{
				g_warning ("Operation.vala:70: %s\n", e->message);
				(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			}
		}
		__finally13:
		if (inner_error != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
		}
		g_signal_connect (self, "passphrase-required", (GCallback) ___lambda5_deja_dup_operation_passphrase_required, self);
		g_signal_connect (self, "backend-password-required", (GCallback) ___lambda6_deja_dup_operation_backend_password_required, self);
	}
	return obj;
}


static void deja_dup_operation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DejaDupOperation * self;
	gpointer boxed;
	self = DEJA_DUP_OPERATION (object);
	switch (property_id) {
		case DEJA_DUP_OPERATION_TOPLEVEL:
		g_value_set_object (value, deja_dup_operation_get_toplevel (self));
		break;
		case DEJA_DUP_OPERATION_UPPERMOST_XID:
		g_value_set_uint (value, deja_dup_operation_get_uppermost_xid (self));
		break;
		case DEJA_DUP_OPERATION_MODE:
		g_value_set_enum (value, deja_dup_operation_get_mode (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void deja_dup_operation_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DejaDupOperation * self;
	self = DEJA_DUP_OPERATION (object);
	switch (property_id) {
		case DEJA_DUP_OPERATION_TOPLEVEL:
		deja_dup_operation_set_toplevel (self, g_value_get_object (value));
		break;
		case DEJA_DUP_OPERATION_UPPERMOST_XID:
		deja_dup_operation_set_uppermost_xid (self, g_value_get_uint (value));
		break;
		case DEJA_DUP_OPERATION_MODE:
		deja_dup_operation_set_mode (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void deja_dup_operation_class_init (DejaDupOperationClass * klass) {
	deja_dup_operation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupOperationPrivate));
	G_OBJECT_CLASS (klass)->get_property = deja_dup_operation_get_property;
	G_OBJECT_CLASS (klass)->set_property = deja_dup_operation_set_property;
	G_OBJECT_CLASS (klass)->constructor = deja_dup_operation_constructor;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_operation_finalize;
	DEJA_DUP_OPERATION_CLASS (klass)->start = deja_dup_operation_real_start;
	DEJA_DUP_OPERATION_CLASS (klass)->connect_to_dup = deja_dup_operation_real_connect_to_dup;
	DEJA_DUP_OPERATION_CLASS (klass)->operation_finished = deja_dup_operation_real_operation_finished;
	DEJA_DUP_OPERATION_CLASS (klass)->make_argv = deja_dup_operation_real_make_argv;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_OPERATION_TOPLEVEL, g_param_spec_object ("toplevel", "toplevel", "toplevel", GTK_TYPE_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_OPERATION_UPPERMOST_XID, g_param_spec_uint ("uppermost-xid", "uppermost-xid", "uppermost-xid", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_OPERATION_MODE, g_param_spec_enum ("mode", "mode", "mode", DEJA_DUP_OPERATION_TYPE_MODE, DEJA_DUP_OPERATION_MODE_INVALID, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_signal_new ("done", DEJA_DUP_TYPE_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	g_signal_new ("raise_error", DEJA_DUP_TYPE_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
	g_signal_new ("action_desc_changed", DEJA_DUP_TYPE_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("action_file_changed", DEJA_DUP_TYPE_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, G_TYPE_FILE);
	g_signal_new ("progress", DEJA_DUP_TYPE_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__DOUBLE, G_TYPE_NONE, 1, G_TYPE_DOUBLE);
	g_signal_new ("passphrase_required", DEJA_DUP_TYPE_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__VOID, G_TYPE_BOOLEAN, 0);
	g_signal_new ("backend_password_required", DEJA_DUP_TYPE_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__VOID, G_TYPE_BOOLEAN, 0);
}


static void deja_dup_operation_instance_init (DejaDupOperation * self) {
	self->priv = DEJA_DUP_OPERATION_GET_PRIVATE (self);
	self->priv->_mode = DEJA_DUP_OPERATION_MODE_INVALID;
	self->priv->inhibit_cookie = (guint) 0;
}


static void deja_dup_operation_finalize (GObject* obj) {
	DejaDupOperation * self;
	self = DEJA_DUP_OPERATION (obj);
	(self->priv->_toplevel == NULL) ? NULL : (self->priv->_toplevel = (g_object_unref (self->priv->_toplevel), NULL));
	(self->dup == NULL) ? NULL : (self->dup = (g_object_unref (self->dup), NULL));
	(self->backend == NULL) ? NULL : (self->backend = (g_object_unref (self->backend), NULL));
	self->passphrase = (g_free (self->passphrase), NULL);
	G_OBJECT_CLASS (deja_dup_operation_parent_class)->finalize (obj);
}


GType deja_dup_operation_get_type (void) {
	static GType deja_dup_operation_type_id = 0;
	if (deja_dup_operation_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupOperationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_operation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupOperation), 0, (GInstanceInitFunc) deja_dup_operation_instance_init, NULL };
		deja_dup_operation_type_id = g_type_register_static (G_TYPE_OBJECT, "DejaDupOperation", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return deja_dup_operation_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}



static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), data2);
}


static void g_cclosure_user_marshal_BOOLEAN__VOID (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__VOID) (gpointer data1, gpointer data2);
	register GMarshalFunc_BOOLEAN__VOID callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 1);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__VOID) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, data2);
	g_value_set_boolean (return_value, v_return);
}



