/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */

#include <OperationBackup.h>
#include <stdlib.h>
#include <string.h>
#include <gconf/gconf-client.h>
#include <gconf/gconf.h>
#include <gio/gio.h>
#include <libdeja-dup.h>




enum  {
	DEJA_DUP_OPERATION_BACKUP_DUMMY_PROPERTY
};
static void deja_dup_operation_backup_real_operation_finished (DejaDupOperation* base, DejaDupDuplicity* dup, gboolean success, gboolean cancelled);
static void _g_list_free_g_free (GList* self);
static GList* deja_dup_operation_backup_real_make_argv (DejaDupOperation* base, GError** error);
static GList* deja_dup_operation_backup_get_always_excluded_dirs (DejaDupOperationBackup* self);
static gpointer deja_dup_operation_backup_parent_class = NULL;
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



GQuark deja_dup_backup_error_quark (void) {
	return g_quark_from_static_string ("deja_dup_backup_error-quark");
}


DejaDupOperationBackup* deja_dup_operation_backup_construct (GType object_type, GtkWindow* win, guint xid) {
	GParameter * __params;
	GParameter * __params_it;
	DejaDupOperationBackup * self;
	__params = g_new0 (GParameter, 3);
	__params_it = __params;
	__params_it->name = "toplevel";
	g_value_init (&__params_it->value, GTK_TYPE_WINDOW);
	g_value_set_object (&__params_it->value, win);
	__params_it++;
	__params_it->name = "uppermost-xid";
	g_value_init (&__params_it->value, G_TYPE_UINT);
	g_value_set_uint (&__params_it->value, xid);
	__params_it++;
	__params_it->name = "mode";
	g_value_init (&__params_it->value, DEJA_DUP_OPERATION_TYPE_MODE);
	g_value_set_enum (&__params_it->value, DEJA_DUP_OPERATION_MODE_BACKUP);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


DejaDupOperationBackup* deja_dup_operation_backup_new (GtkWindow* win, guint xid) {
	return deja_dup_operation_backup_construct (DEJA_DUP_TYPE_OPERATION_BACKUP, win, xid);
}


static void deja_dup_operation_backup_real_operation_finished (DejaDupOperation* base, DejaDupDuplicity* dup, gboolean success, gboolean cancelled) {
	DejaDupOperationBackup * self;
	GError * inner_error;
	self = (DejaDupOperationBackup*) base;
	g_return_if_fail (dup != NULL);
	inner_error = NULL;
	if (success) {
		{
			deja_dup_update_last_run_timestamp (&inner_error);
			if (inner_error != NULL) {
				goto __catch14_g_error;
				goto __finally14;
			}
		}
		goto __finally14;
		__catch14_g_error:
		{
			GError * e;
			e = inner_error;
			inner_error = NULL;
			{
				g_warning ("OperationBackup.vala:40: %s\n", e->message);
				(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			}
		}
		__finally14:
		if (inner_error != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
			return;
		}
	}
	DEJA_DUP_OPERATION_CLASS (deja_dup_operation_backup_parent_class)->operation_finished (DEJA_DUP_OPERATION (self), dup, success, cancelled);
}


static void _g_list_free_g_free (GList* self) {
	g_list_foreach (self, (GFunc) g_free, NULL);
	g_list_free (self);
}


static GList* deja_dup_operation_backup_real_make_argv (DejaDupOperation* base, GError** error) {
	DejaDupOperationBackup * self;
	GError * inner_error;
	GConfClient* _tmp0;
	GConfClient* client;
	GSList* _tmp1;
	GFile** _tmp3;
	gint include_list_size;
	gint include_list_length1;
	gint _tmp2;
	GFile** include_list;
	GSList* _tmp4;
	GFile** _tmp6;
	gint exclude_list_size;
	gint exclude_list_length1;
	gint _tmp5;
	GFile** exclude_list;
	GList* rv;
	GList* always_excluded;
	GList* _tmp12;
	self = (DejaDupOperationBackup*) base;
	inner_error = NULL;
	_tmp0 = NULL;
	client = (_tmp0 = gconf_client_get_default (), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	_tmp1 = gconf_client_get_list (client, DEJA_DUP_INCLUDE_LIST_KEY, GCONF_VALUE_STRING, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
		return NULL;
	}
	_tmp3 = NULL;
	include_list = (_tmp3 = deja_dup_parse_dir_list (_tmp1, &_tmp2), include_list_length1 = _tmp2, include_list_size = include_list_length1, _tmp3);
	_tmp4 = gconf_client_get_list (client, DEJA_DUP_EXCLUDE_LIST_KEY, GCONF_VALUE_STRING, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
		include_list = (_vala_array_free (include_list, include_list_length1, (GDestroyNotify) g_object_unref), NULL);
		return NULL;
	}
	_tmp6 = NULL;
	exclude_list = (_tmp6 = deja_dup_parse_dir_list (_tmp4, &_tmp5), exclude_list_length1 = _tmp5, exclude_list_size = exclude_list_length1, _tmp6);
	rv = NULL;
	/* Exclude directories no one wants to backup*/
	always_excluded = deja_dup_operation_backup_get_always_excluded_dirs (self);
	{
		GList* dir_collection;
		GList* dir_it;
		dir_collection = always_excluded;
		for (dir_it = dir_collection; dir_it != NULL; dir_it = dir_it->next) {
			const char* _tmp7;
			char* dir;
			_tmp7 = NULL;
			dir = (_tmp7 = (const char*) dir_it->data, (_tmp7 == NULL) ? NULL : g_strdup (_tmp7));
			{
				rv = g_list_append (rv, g_strdup_printf ("--exclude=%s", dir));
				dir = (g_free (dir), NULL);
			}
		}
	}
	{
		GFile** s_collection;
		int s_collection_length1;
		int s_it;
		s_collection = exclude_list;
		s_collection_length1 = exclude_list_length1;
		for (s_it = 0; s_it < exclude_list_length1; s_it = s_it + 1) {
			GFile* _tmp9;
			GFile* s;
			_tmp9 = NULL;
			s = (_tmp9 = s_collection[s_it], (_tmp9 == NULL) ? NULL : g_object_ref (_tmp9));
			{
				char* _tmp8;
				_tmp8 = NULL;
				rv = g_list_append (rv, g_strdup_printf ("--exclude=%s", _tmp8 = g_file_get_path (s)));
				_tmp8 = (g_free (_tmp8), NULL);
				(s == NULL) ? NULL : (s = (g_object_unref (s), NULL));
			}
		}
	}
	{
		GFile** s_collection;
		int s_collection_length1;
		int s_it;
		s_collection = include_list;
		s_collection_length1 = include_list_length1;
		for (s_it = 0; s_it < include_list_length1; s_it = s_it + 1) {
			GFile* _tmp11;
			GFile* s;
			_tmp11 = NULL;
			s = (_tmp11 = s_collection[s_it], (_tmp11 == NULL) ? NULL : g_object_ref (_tmp11));
			{
				char* _tmp10;
				_tmp10 = NULL;
				rv = g_list_append (rv, g_strdup_printf ("--include=%s", _tmp10 = g_file_get_path (s)));
				_tmp10 = (g_free (_tmp10), NULL);
				(s == NULL) ? NULL : (s = (g_object_unref (s), NULL));
			}
		}
	}
	rv = g_list_append (rv, g_strdup ("--exclude=**"));
	deja_dup_duplicity_set_local (((DejaDupOperation*) self)->dup, "/");
	_tmp12 = NULL;
	return (_tmp12 = rv, (client == NULL) ? NULL : (client = (g_object_unref (client), NULL)), include_list = (_vala_array_free (include_list, include_list_length1, (GDestroyNotify) g_object_unref), NULL), exclude_list = (_vala_array_free (exclude_list, exclude_list_length1, (GDestroyNotify) g_object_unref), NULL), (always_excluded == NULL) ? NULL : (always_excluded = (_g_list_free_g_free (always_excluded), NULL)), _tmp12);
}


static GList* deja_dup_operation_backup_get_always_excluded_dirs (DejaDupOperationBackup* self) {
	GList* rv;
	const char* _tmp0;
	char* dir;
	char* _tmp3;
	const char* _tmp2;
	char* _tmp5;
	const char* _tmp4;
	GList* _tmp7;
	g_return_val_if_fail (self != NULL, NULL);
	rv = NULL;
	/* User doesn't care about cache*/
	_tmp0 = NULL;
	dir = (_tmp0 = g_get_user_cache_dir (), (_tmp0 == NULL) ? NULL : g_strdup (_tmp0));
	if (dir != NULL) {
		const char* _tmp1;
		_tmp1 = NULL;
		rv = g_list_append (rv, (_tmp1 = dir, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)));
	}
	/* Likewise, user doesn't care about cache-like thumbnail directory*/
	_tmp3 = NULL;
	_tmp2 = NULL;
	dir = (_tmp3 = (_tmp2 = g_get_home_dir (), (_tmp2 == NULL) ? NULL : g_strdup (_tmp2)), dir = (g_free (dir), NULL), _tmp3);
	if (dir != NULL) {
		rv = g_list_append (rv, g_build_filename (dir, ".thumbnails", NULL));
		rv = g_list_append (rv, g_build_filename (dir, ".gvfs", NULL));
	}
	/* Some problematic directories like /tmp and /proc should be left alone*/
	_tmp5 = NULL;
	_tmp4 = NULL;
	dir = (_tmp5 = (_tmp4 = g_get_tmp_dir (), (_tmp4 == NULL) ? NULL : g_strdup (_tmp4)), dir = (g_free (dir), NULL), _tmp5);
	if (dir != NULL) {
		const char* _tmp6;
		_tmp6 = NULL;
		rv = g_list_append (rv, (_tmp6 = dir, (_tmp6 == NULL) ? NULL : g_strdup (_tmp6)));
	}
	rv = g_list_append (rv, g_strdup ("/proc"));
	rv = g_list_append (rv, g_strdup ("/sys"));
	_tmp7 = NULL;
	return (_tmp7 = rv, dir = (g_free (dir), NULL), _tmp7);
}


static void deja_dup_operation_backup_class_init (DejaDupOperationBackupClass * klass) {
	deja_dup_operation_backup_parent_class = g_type_class_peek_parent (klass);
	DEJA_DUP_OPERATION_CLASS (klass)->operation_finished = deja_dup_operation_backup_real_operation_finished;
	DEJA_DUP_OPERATION_CLASS (klass)->make_argv = deja_dup_operation_backup_real_make_argv;
}


static void deja_dup_operation_backup_instance_init (DejaDupOperationBackup * self) {
}


GType deja_dup_operation_backup_get_type (void) {
	static GType deja_dup_operation_backup_type_id = 0;
	if (deja_dup_operation_backup_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupOperationBackupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_operation_backup_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupOperationBackup), 0, (GInstanceInitFunc) deja_dup_operation_backup_instance_init, NULL };
		deja_dup_operation_backup_type_id = g_type_register_static (DEJA_DUP_TYPE_OPERATION, "DejaDupOperationBackup", &g_define_type_info, 0);
	}
	return deja_dup_operation_backup_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
	g_free (array);
}




