/* -*- Mode: C; indent-tabs-mode: nil; tab-width: 2 -*- */

#ifndef __RECURSIVEMOVE_H__
#define __RECURSIVEMOVE_H__

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <RecursiveOp.h>

G_BEGIN_DECLS


#define DEJA_DUP_TYPE_RECURSIVE_MOVE (deja_dup_recursive_move_get_type ())
#define DEJA_DUP_RECURSIVE_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_RECURSIVE_MOVE, DejaDupRecursiveMove))
#define DEJA_DUP_RECURSIVE_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_RECURSIVE_MOVE, DejaDupRecursiveMoveClass))
#define DEJA_DUP_IS_RECURSIVE_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_RECURSIVE_MOVE))
#define DEJA_DUP_IS_RECURSIVE_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_RECURSIVE_MOVE))
#define DEJA_DUP_RECURSIVE_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_RECURSIVE_MOVE, DejaDupRecursiveMoveClass))

typedef struct _DejaDupRecursiveMove DejaDupRecursiveMove;
typedef struct _DejaDupRecursiveMoveClass DejaDupRecursiveMoveClass;
typedef struct _DejaDupRecursiveMovePrivate DejaDupRecursiveMovePrivate;

/**
 * Recursively moves one directory into another, merging files.  And by merge,
 * I mean it overwrites.  It skips any files it can't move and reports an
 * error, but keeps going.
 *
 * This is not optimized for remote files.  It's mostly async, but it does the
 * occasional sync operation.
 */
struct _DejaDupRecursiveMove {
	DejaDupRecursiveOp parent_instance;
	DejaDupRecursiveMovePrivate * priv;
};

struct _DejaDupRecursiveMoveClass {
	DejaDupRecursiveOpClass parent_class;
};


DejaDupRecursiveMove* deja_dup_recursive_move_construct (GType object_type, GFile* source, GFile* dest);
DejaDupRecursiveMove* deja_dup_recursive_move_new (GFile* source, GFile* dest);
GType deja_dup_recursive_move_get_type (void);


G_END_DECLS

#endif
