/* -*- Mode: C; indent-tabs-mode: nil; tab-width: 2 -*- */

#include "monitor.h"
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include <gconf/gconf-client.h>
#include <time.h>
#include <gconf/gconf.h>
#include <string.h>




enum  {
	MONITOR_DUMMY_PROPERTY
};
static GMainLoop* monitor_loop = NULL;
static guint monitor_timeout_id = 0U;
static GPid monitor_pid = 0;
static gboolean monitor_show_version = FALSE;
#define MONITOR_GCONF_DIR "/apps/deja-dup"
#define MONITOR_LAST_RUN_KEY "/apps/deja-dup/last-run"
#define MONITOR_PERIODIC_KEY "/apps/deja-dup/periodic"
#define MONITOR_PERIODIC_PERIOD_KEY "/apps/deja-dup/periodic-period"
static gboolean monitor_handle_options (gint* status);
static GDate monitor_today (void);
static GDate monitor_most_recent_scheduled_date (gint period);
static GDate monitor_next_run_date (void);
static GTimeVal monitor_date_to_timeval (const GDate* date);
static glong monitor_seconds_until (const GDate* date);
static void monitor_close_pid (GPid child_pid, gint status);
static void _monitor_close_pid_gchild_watch_func (GPid pid, gint status, gpointer self);
static gboolean monitor_kickoff (void);
static gboolean monitor_seconds_until_next_run (glong* secs);
static gboolean _monitor_kickoff_gsource_func (gpointer self);
static void monitor_prepare_run (glong wait_time);
static void monitor_prepare_tomorrow (void);
static void monitor_prepare_next_run (void);
static void _monitor_prepare_next_run_gconf_client_notify_func (GConfClient* client, guint cnxn_id, GConfEntry* entry, gpointer self);
static void monitor_watch_gconf (void);
static gint monitor_main (char** args, int args_length1);
static gpointer monitor_parent_class = NULL;
static void monitor_finalize (GObject* obj);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GOptionEntry MONITOR_options[] = {{"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &monitor_show_version, N_ ("Show version"), NULL}, {NULL}};


static gboolean monitor_handle_options (gint* status) {
	(*status) = 0;
	if (monitor_show_version) {
		g_print ("%s %s\n", _ ("Déjà Dup Monitor"), VERSION);
		return FALSE;
	}
	return TRUE;
}


static GDate monitor_today (void) {
	GTimeVal _tmp0 = {0};
	GTimeVal cur_time;
	GDate _tmp1 = {0};
	GDate cur_date;
	cur_time = (g_get_current_time (&_tmp0), _tmp0);
	g_get_current_time (&cur_time);
	cur_date = (memset (&_tmp1, 0, sizeof (GDate)), _tmp1);
	g_date_set_time_val (&cur_date, &cur_time);
	return cur_date;
}


static GDate monitor_most_recent_scheduled_date (gint period) {
	GDate _tmp0 = {0};
	GDate epoch;
	GDate cur_date;
	gint between;
	gint mod;
	/* Compare days between epoch and current days.  Mod by period to find
	 scheduled dates.*/
	epoch = (memset (&_tmp0, 0, sizeof (GDate)), _tmp0);
	g_date_set_dmy (&epoch, (GDateDay) 1, 1, (GDateYear) 1970);
	cur_date = monitor_today ();
	between = g_date_days_between (&epoch, &cur_date);
	mod = between % period;
	g_date_subtract_days (&cur_date, (guint) mod);
	return cur_date;
}


static GDate monitor_next_run_date (void) {
	GError * inner_error;
	GConfClient* _tmp0;
	GConfClient* client;
	gboolean periodic;
	char* last_run_string;
	gint period_days;
	GDate _tmp11 = {0};
	GDate last_run;
	GTimeVal _tmp12 = {0};
	GTimeVal last_run_tval;
	GDate last_scheduled;
	GDate _tmp15 = {0};
	inner_error = NULL;
	_tmp0 = NULL;
	client = (_tmp0 = gconf_client_get_default (), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	periodic = FALSE;
	last_run_string = NULL;
	period_days = 0;
	{
		gboolean _tmp1;
		const char* _tmp2;
		char* _tmp4;
		const char* _tmp3;
		gint _tmp5;
		_tmp1 = gconf_client_get_bool (client, MONITOR_PERIODIC_KEY, &inner_error);
		if (inner_error != NULL) {
			goto __catch0_g_error;
			goto __finally0;
		}
		periodic = _tmp1;
		_tmp2 = gconf_client_get_string (client, MONITOR_LAST_RUN_KEY, &inner_error);
		if (inner_error != NULL) {
			goto __catch0_g_error;
			goto __finally0;
		}
		_tmp4 = NULL;
		_tmp3 = NULL;
		last_run_string = (_tmp4 = (_tmp3 = _tmp2, (_tmp3 == NULL) ? NULL : g_strdup (_tmp3)), last_run_string = (g_free (last_run_string), NULL), _tmp4);
		_tmp5 = gconf_client_get_int (client, MONITOR_PERIODIC_PERIOD_KEY, &inner_error);
		if (inner_error != NULL) {
			goto __catch0_g_error;
			goto __finally0;
		}
		period_days = _tmp5;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			GDate _tmp6 = {0};
			GDate _tmp7 = {0};
			g_error ("monitor.vala:91: %s", e->message);
			return (_tmp7 = (memset (&_tmp6, 0, sizeof (GDate)), _tmp6), (e == NULL) ? NULL : (e = (g_error_free (e), NULL)), (client == NULL) ? NULL : (client = (g_object_unref (client), NULL)), last_run_string = (g_free (last_run_string), NULL), _tmp7);
		}
	}
	__finally0:
	if (inner_error != NULL) {
		(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
		last_run_string = (g_free (last_run_string), NULL);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	if (!periodic) {
		GDate _tmp8 = {0};
		GDate _tmp9 = {0};
		return (_tmp9 = (memset (&_tmp8, 0, sizeof (GDate)), _tmp8), (client == NULL) ? NULL : (client = (g_object_unref (client), NULL)), last_run_string = (g_free (last_run_string), NULL), _tmp9);
	}
	if (last_run_string == NULL) {
		GDate _tmp10 = {0};
		return (_tmp10 = monitor_today (), (client == NULL) ? NULL : (client = (g_object_unref (client), NULL)), last_run_string = (g_free (last_run_string), NULL), _tmp10);
	}
	if (period_days <= 0) {
		period_days = 1;
	}
	last_run = (memset (&_tmp11, 0, sizeof (GDate)), _tmp11);
	last_run_tval = (g_get_current_time (&_tmp12), _tmp12);
	if (!g_time_val_from_iso8601 (last_run_string, &last_run_tval)) {
		GDate _tmp13 = {0};
		return (_tmp13 = monitor_today (), (client == NULL) ? NULL : (client = (g_object_unref (client), NULL)), last_run_string = (g_free (last_run_string), NULL), _tmp13);
	}
	g_date_set_time_val (&last_run, &last_run_tval);
	if (!g_date_valid (&last_run)) {
		GDate _tmp14 = {0};
		return (_tmp14 = monitor_today (), (client == NULL) ? NULL : (client = (g_object_unref (client), NULL)), last_run_string = (g_free (last_run_string), NULL), _tmp14);
	}
	last_scheduled = monitor_most_recent_scheduled_date (period_days);
	if (g_date_compare (&last_scheduled, &last_run) <= 0) {
		g_date_add_days (&last_scheduled, (guint) period_days);
	}
	return (_tmp15 = last_scheduled, (client == NULL) ? NULL : (client = (g_object_unref (client), NULL)), last_run_string = (g_free (last_run_string), NULL), _tmp15);
}


/* This is slightly more tortuous than I'd like.  API allows us to convert Date
 to Time.  We can then convert Time to seconds-since-epoch and stuffs that
 into a TimeVal.*/
static GTimeVal monitor_date_to_timeval (const GDate* date) {
	struct tm time = {0};
	time_t timet;
	GTimeVal _tmp0 = {0};
	GTimeVal tval;
	g_date_to_struct_tm (&(*date), &time);
	/* to_time says that sub-day values are sensible, but meaningless.  This
	 presumably means 0, but we technically can't rely on that.*/
	time.tm_hour = 0;
	time.tm_min = 0;
	time.tm_sec = 0;
	timet = mktime (&time);
	tval = (g_get_current_time (&_tmp0), _tmp0);
	tval.tv_sec = (glong) timet;
	tval.tv_usec = (glong) 0;
	return tval;
}


static glong monitor_seconds_until (const GDate* date) {
	GTimeVal _tmp0 = {0};
	GTimeVal cur_time;
	GTimeVal next_time;
	cur_time = (g_get_current_time (&_tmp0), _tmp0);
	g_get_current_time (&cur_time);
	next_time = monitor_date_to_timeval (&(*date));
	return next_time.tv_sec - cur_time.tv_sec;
}


static void monitor_close_pid (GPid child_pid, gint status) {
	g_spawn_close_pid (child_pid);
	monitor_pid = (GPid) 0;
}


static void _monitor_close_pid_gchild_watch_func (GPid pid, gint status, gpointer self) {
	monitor_close_pid (pid, status);
}


static gboolean monitor_kickoff (void) {
	GError * inner_error;
	glong wait_time;
	inner_error = NULL;
	wait_time = 0L;
	if (!monitor_seconds_until_next_run (&wait_time)) {
		return FALSE;
	}
	if (wait_time > 0) {
		/* Huh?  Shouldn't have been called now.*/
		monitor_prepare_next_run ();
		return FALSE;
	}
	/* Now we secretly schedule another kickoff tomorrow, in case something
	 goes wrong with this run (or user chooses to ignore for now)
	 If this run is successful, it will change 'last-run' key and this will
	 get rescheduled anyway.*/
	monitor_prepare_tomorrow ();
	/* Don't run right now if an applet is already running*/
	if (monitor_pid == ((GPid) 0)) {
		{
			char** _tmp2;
			gint argv_size;
			gint argv_length1;
			char** argv;
			char* _tmp3;
			char* _tmp4;
			_tmp2 = NULL;
			argv = (_tmp2 = g_new0 (char*, 2 + 1), argv_length1 = 2, argv_size = argv_length1, _tmp2);
			_tmp3 = NULL;
			argv[0] = (_tmp3 = g_strdup ("deja-dup-applet"), argv[0] = (g_free (argv[0]), NULL), _tmp3);
			_tmp4 = NULL;
			argv[1] = (_tmp4 = NULL, argv[1] = (g_free (argv[1]), NULL), _tmp4);
			g_spawn_async (NULL, argv, NULL, ((G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD) | G_SPAWN_STDOUT_TO_DEV_NULL) | G_SPAWN_STDERR_TO_DEV_NULL, NULL, NULL, &monitor_pid, &inner_error);
			if (inner_error != NULL) {
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				goto __catch1_g_error;
				goto __finally1;
			}
			g_child_watch_add (monitor_pid, _monitor_close_pid_gchild_watch_func, NULL);
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError * e;
			e = inner_error;
			inner_error = NULL;
			{
				g_warning ("monitor.vala:191: %s\n", e->message);
				(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			}
		}
		__finally1:
		if (inner_error != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
			return FALSE;
		}
	} else {
		g_debug ("monitor.vala:195: Not rerunning deja-dup-applet, already doing so.");
	}
	return FALSE;
}


static gboolean monitor_seconds_until_next_run (glong* secs) {
	GDate next_date;
	next_date = monitor_next_run_date ();
	if (!g_date_valid (&next_date)) {
		g_debug ("monitor.vala:204: Invalid next run date.  Not scheduling a backup.");
		return FALSE;
	}
	(*secs) = monitor_seconds_until (&next_date);
	return TRUE;
}


static gboolean _monitor_kickoff_gsource_func (gpointer self) {
	return monitor_kickoff ();
}


static void monitor_prepare_run (glong wait_time) {
	/* Stop previous run timeout*/
	if (monitor_timeout_id != 0) {
		g_source_remove (monitor_timeout_id);
	}
	if (wait_time > 0) {
		g_debug ("monitor.vala:219: Waiting %ld seconds until next backup.", wait_time);
		monitor_timeout_id = g_timeout_add_seconds ((guint) wait_time, _monitor_kickoff_gsource_func, NULL);
	} else {
		g_debug ("monitor.vala:223: Late by %ld seconds.  Backing up now.", wait_time * (-1));
		monitor_kickoff ();
	}
}


static void monitor_prepare_tomorrow (void) {
	GDate tomorrow;
	glong secs;
	tomorrow = monitor_today ();
	g_date_add_days (&tomorrow, (guint) 1);
	secs = monitor_seconds_until (&tomorrow);
	monitor_prepare_run (secs);
}


static void monitor_prepare_next_run (void) {
	glong wait_time;
	wait_time = 0L;
	if (!monitor_seconds_until_next_run (&wait_time)) {
		return;
	}
	monitor_prepare_run (wait_time);
}


static void _monitor_prepare_next_run_gconf_client_notify_func (GConfClient* client, guint cnxn_id, GConfEntry* entry, gpointer self) {
	monitor_prepare_next_run ();
}


static void monitor_watch_gconf (void) {
	GError * inner_error;
	GConfClient* _tmp0;
	GConfClient* client;
	inner_error = NULL;
	_tmp0 = NULL;
	client = (_tmp0 = gconf_client_get_default (), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	{
		gconf_client_add_dir (client, MONITOR_GCONF_DIR, GCONF_CLIENT_PRELOAD_NONE, &inner_error);
		if (inner_error != NULL) {
			goto __catch2_g_error;
			goto __finally2;
		}
		gconf_client_notify_add (client, MONITOR_LAST_RUN_KEY, _monitor_prepare_next_run_gconf_client_notify_func, NULL, NULL, &inner_error);
		if (inner_error != NULL) {
			goto __catch2_g_error;
			goto __finally2;
		}
		gconf_client_notify_add (client, MONITOR_PERIODIC_KEY, _monitor_prepare_next_run_gconf_client_notify_func, NULL, NULL, &inner_error);
		if (inner_error != NULL) {
			goto __catch2_g_error;
			goto __finally2;
		}
		gconf_client_notify_add (client, MONITOR_PERIODIC_PERIOD_KEY, _monitor_prepare_next_run_gconf_client_notify_func, NULL, NULL, &inner_error);
		if (inner_error != NULL) {
			goto __catch2_g_error;
			goto __finally2;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning ("monitor.vala:256: %s\n", e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally2:
	if (inner_error != NULL) {
		(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
}


static gint monitor_main (char** args, int args_length1) {
	GError * inner_error;
	GOptionContext* context;
	gint status;
	GMainLoop* _tmp3;
	gint _tmp4;
	inner_error = NULL;
	textdomain (GETTEXT_PACKAGE);
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	/* Translators: Monitor in this sense means something akin to 'watcher', not
	 a computer monitor.  This program acts like a daemon that kicks off
	 backups at scheduled times.*/
	g_set_application_name (_ ("Déjà Dup Monitor"));
	context = g_option_context_new ("");
	g_option_context_add_main_entries (context, MONITOR_options, GETTEXT_PACKAGE);
	{
		g_option_context_parse (context, &args_length1, &args, &inner_error);
		if (inner_error != NULL) {
			goto __catch3_g_error;
			goto __finally3;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			char* _tmp0;
			gint _tmp1;
			_tmp0 = NULL;
			g_printerr ("%s\n\n%s", e->message, _tmp0 = g_option_context_get_help (context, TRUE, NULL));
			_tmp0 = (g_free (_tmp0), NULL);
			return (_tmp1 = 1, (e == NULL) ? NULL : (e = (g_error_free (e), NULL)), (context == NULL) ? NULL : (context = (g_option_context_free (context), NULL)), _tmp1);
		}
	}
	__finally3:
	if (inner_error != NULL) {
		(context == NULL) ? NULL : (context = (g_option_context_free (context), NULL));
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return 0;
	}
	status = 0;
	if (!monitor_handle_options (&status)) {
		gint _tmp2;
		return (_tmp2 = status, (context == NULL) ? NULL : (context = (g_option_context_free (context), NULL)), _tmp2);
	}
	_tmp3 = NULL;
	monitor_loop = (_tmp3 = g_main_loop_new (NULL, FALSE), (monitor_loop == NULL) ? NULL : (monitor_loop = (g_main_loop_unref (monitor_loop), NULL)), _tmp3);
	monitor_prepare_next_run ();
	monitor_watch_gconf ();
	g_main_loop_run (monitor_loop);
	return (_tmp4 = 0, (context == NULL) ? NULL : (context = (g_option_context_free (context), NULL)), _tmp4);
}


int main (int argc, char ** argv) {
	g_type_init ();
	return monitor_main (argv, argc);
}


/*
    Déjà Dup Monitor
    © 2008—2009 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
Monitor* monitor_construct (GType object_type) {
	Monitor * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


Monitor* monitor_new (void) {
	return monitor_construct (TYPE_MONITOR);
}


static void monitor_class_init (MonitorClass * klass) {
	monitor_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = monitor_finalize;
}


static void monitor_instance_init (Monitor * self) {
}


static void monitor_finalize (GObject* obj) {
	Monitor * self;
	self = MONITOR (obj);
	G_OBJECT_CLASS (monitor_parent_class)->finalize (obj);
}


GType monitor_get_type (void) {
	static GType monitor_type_id = 0;
	if (monitor_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (MonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Monitor), 0, (GInstanceInitFunc) monitor_instance_init, NULL };
		monitor_type_id = g_type_register_static (G_TYPE_OBJECT, "Monitor", &g_define_type_info, 0);
	}
	return monitor_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
	g_free (array);
}




