/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */

#include "ConfigChoice.h"
#include <gconf/gconf-client.h>




enum  {
	CONFIG_CHOICE_DUMMY_PROPERTY
};
static void _config_choice_handle_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static GValue* _g_value_dup (GValue* self);
static void config_choice_real_handle_changed (ConfigChoice* self);
static void config_choice_real_set_from_config (ConfigWidget* base);
static GObject * config_choice_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer config_choice_parent_class = NULL;
static void config_choice_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void _config_choice_handle_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	config_choice_handle_changed (self);
}


void config_choice_init (ConfigChoice* self, GtkTreeModel* model, gint gconf_col) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	gtk_combo_box_set_model (self->combo, model);
	self->gconf_col = gconf_col;
	g_signal_connect_object (self->combo, "changed", (GCallback) _config_choice_handle_changed_gtk_combo_box_changed, self, 0);
	config_widget_set_from_config ((ConfigWidget*) self);
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


GValue* config_choice_get_current_value (ConfigChoice* self) {
	GtkTreeIter iter = {0};
	if (gtk_combo_box_get_active_iter (self->combo, &iter)) {
		GValue val = {0};
		GValue _tmp1 = {0};
		GValue _tmp0 = {0};
		GValue* _tmp4 = {0};
		GValue _tmp3 = {0};
		GValue _tmp2 = {0};
		GValue* _tmp5 = {0};
		gtk_tree_model_get_value (gtk_combo_box_get_model (self->combo), &iter, self->gconf_col, &_tmp0);
		val = (_tmp1 = _tmp0, G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL, _tmp1);
		return (_tmp5 = (_tmp4 = (_tmp3 = _tmp2 = val, &_tmp3), (_tmp4 == NULL) ? NULL : _g_value_dup (_tmp4)), G_IS_VALUE (&_tmp2) ? (g_value_unset (&_tmp2), NULL) : NULL, _tmp5);
	}
	return NULL;
}


static void config_choice_real_handle_changed (ConfigChoice* self) {
	GError * inner_error;
	GValue* val;
	const char* _tmp0;
	const char* _tmp1;
	char* strval;
	g_return_if_fail (self != NULL);
	inner_error = NULL;
	val = config_choice_get_current_value (self);
	_tmp0 = NULL;
	if (val == NULL) {
		_tmp0 = "";
	} else {
		_tmp0 = g_value_get_string (val);
	}
	_tmp1 = NULL;
	strval = (_tmp1 = _tmp0, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1));
	{
		gconf_client_set_string (((ConfigWidget*) self)->client, config_widget_get_key ((ConfigWidget*) self), strval, &inner_error);
		if (inner_error != NULL) {
			goto __catch2_g_error;
			goto __finally2;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning ("ConfigChoice.vala:64: %s\n", e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally2:
	if (inner_error != NULL) {
		(val == NULL) ? NULL : (val = (g_free (val), NULL));
		strval = (g_free (strval), NULL);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	g_signal_emit_by_name (self, "changed", strval);
	(val == NULL) ? NULL : (val = (g_free (val), NULL));
	strval = (g_free (strval), NULL);
}


void config_choice_handle_changed (ConfigChoice* self) {
	CONFIG_CHOICE_GET_CLASS (self)->handle_changed (self);
}


static void config_choice_real_set_from_config (ConfigWidget* base) {
	ConfigChoice * self;
	GError * inner_error;
	char* confval;
	gboolean valid;
	GtkTreeIter iter = {0};
	self = (ConfigChoice*) base;
	inner_error = NULL;
	confval = NULL;
	{
		const char* _tmp0;
		char* _tmp2;
		const char* _tmp1;
		_tmp0 = gconf_client_get_string (((ConfigWidget*) self)->client, config_widget_get_key ((ConfigWidget*) self), &inner_error);
		if (inner_error != NULL) {
			goto __catch3_g_error;
			goto __finally3;
		}
		_tmp2 = NULL;
		_tmp1 = NULL;
		confval = (_tmp2 = (_tmp1 = _tmp0, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), confval = (g_free (confval), NULL), _tmp2);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning ("ConfigChoice.vala:77: %s\n", e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			confval = (g_free (confval), NULL);
			return;
		}
	}
	__finally3:
	if (inner_error != NULL) {
		confval = (g_free (confval), NULL);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	valid = FALSE;
	valid = gtk_tree_model_get_iter_first (gtk_combo_box_get_model (self->combo), &iter);
	while (valid) {
		GValue val = {0};
		GValue _tmp4 = {0};
		GValue _tmp3 = {0};
		const char* _tmp5;
		char* strval;
		gtk_tree_model_get_value (gtk_combo_box_get_model (self->combo), &iter, self->gconf_col, &_tmp3);
		val = (_tmp4 = _tmp3, G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL, _tmp4);
		_tmp5 = NULL;
		strval = (_tmp5 = g_value_get_string (&val), (_tmp5 == NULL) ? NULL : g_strdup (_tmp5));
		if (_vala_strcmp0 (strval, confval) == 0) {
			gtk_combo_box_set_active_iter (self->combo, &iter);
			G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
			strval = (g_free (strval), NULL);
			break;
		}
		valid = gtk_tree_model_iter_next (gtk_combo_box_get_model (self->combo), &iter);
		G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
		strval = (g_free (strval), NULL);
	}
	confval = (g_free (confval), NULL);
}


/*
    Déjà Dup
    © 2008—2009 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
ConfigChoice* config_choice_construct (GType object_type) {
	ConfigChoice * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


ConfigChoice* config_choice_new (void) {
	return config_choice_construct (TYPE_CONFIG_CHOICE);
}


static GObject * config_choice_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	ConfigChoiceClass * klass;
	GObjectClass * parent_class;
	ConfigChoice * self;
	klass = CONFIG_CHOICE_CLASS (g_type_class_peek (TYPE_CONFIG_CHOICE));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = CONFIG_CHOICE (obj);
	{
		GtkComboBox* _tmp0;
		_tmp0 = NULL;
		self->combo = (_tmp0 = g_object_ref_sink ((GtkComboBox*) gtk_combo_box_new_text ()), (self->combo == NULL) ? NULL : (self->combo = (g_object_unref (self->combo), NULL)), _tmp0);
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->combo);
	}
	return obj;
}


static void config_choice_class_init (ConfigChoiceClass * klass) {
	config_choice_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = config_choice_constructor;
	G_OBJECT_CLASS (klass)->finalize = config_choice_finalize;
	CONFIG_CHOICE_CLASS (klass)->handle_changed = config_choice_real_handle_changed;
	CONFIG_WIDGET_CLASS (klass)->set_from_config = config_choice_real_set_from_config;
	g_signal_new ("changed", TYPE_CONFIG_CHOICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void config_choice_instance_init (ConfigChoice * self) {
}


static void config_choice_finalize (GObject* obj) {
	ConfigChoice * self;
	self = CONFIG_CHOICE (obj);
	(self->combo == NULL) ? NULL : (self->combo = (g_object_unref (self->combo), NULL));
	G_OBJECT_CLASS (config_choice_parent_class)->finalize (obj);
}


GType config_choice_get_type (void) {
	static GType config_choice_type_id = 0;
	if (config_choice_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ConfigChoiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) config_choice_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConfigChoice), 0, (GInstanceInitFunc) config_choice_instance_init, NULL };
		config_choice_type_id = g_type_register_static (TYPE_CONFIG_WIDGET, "ConfigChoice", &g_define_type_info, 0);
	}
	return config_choice_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




