/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */

#include "ConfigNumber.h"
#include <gtk/gtk.h>
#include <gconf/gconf-client.h>
#include <float.h>
#include <math.h>




struct _ConfigNumberPrivate {
	gint _lower_bound;
	gint _upper_bound;
	GtkSpinButton* spin;
};

#define CONFIG_NUMBER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CONFIG_NUMBER, ConfigNumberPrivate))
enum  {
	CONFIG_NUMBER_DUMMY_PROPERTY,
	CONFIG_NUMBER_LOWER_BOUND,
	CONFIG_NUMBER_UPPER_BOUND
};
static void config_number_real_set_from_config (ConfigWidget* base);
static void config_number_handle_value_changed (ConfigNumber* self);
static void config_number_set_lower_bound (ConfigNumber* self, gint value);
static void config_number_set_upper_bound (ConfigNumber* self, gint value);
static void _config_number_handle_value_changed_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self);
static GObject * config_number_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer config_number_parent_class = NULL;
static void config_number_finalize (GObject* obj);



ConfigNumber* config_number_construct (GType object_type, const char* key, gint lower_bound, gint upper_bound) {
	GParameter * __params;
	GParameter * __params_it;
	ConfigNumber * self;
	g_return_val_if_fail (key != NULL, NULL);
	__params = g_new0 (GParameter, 3);
	__params_it = __params;
	__params_it->name = "key";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, key);
	__params_it++;
	__params_it->name = "lower-bound";
	g_value_init (&__params_it->value, G_TYPE_INT);
	g_value_set_int (&__params_it->value, lower_bound);
	__params_it++;
	__params_it->name = "upper-bound";
	g_value_init (&__params_it->value, G_TYPE_INT);
	g_value_set_int (&__params_it->value, upper_bound);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


ConfigNumber* config_number_new (const char* key, gint lower_bound, gint upper_bound) {
	return config_number_construct (TYPE_CONFIG_NUMBER, key, lower_bound, upper_bound);
}


static void config_number_real_set_from_config (ConfigWidget* base) {
	ConfigNumber * self;
	GError * inner_error;
	self = (ConfigNumber*) base;
	inner_error = NULL;
	{
		gint val;
		val = gconf_client_get_int (((ConfigWidget*) self)->client, config_widget_get_key ((ConfigWidget*) self), &inner_error);
		if (inner_error != NULL) {
			goto __catch13_g_error;
			goto __finally13;
		}
		gtk_spin_button_set_value (self->priv->spin, (double) val);
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning ("ConfigNumber.vala:50: %s\n", e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally13:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
}


static void config_number_handle_value_changed (ConfigNumber* self) {
	GError * inner_error;
	g_return_if_fail (self != NULL);
	inner_error = NULL;
	{
		gconf_client_set_int (((ConfigWidget*) self)->client, config_widget_get_key ((ConfigWidget*) self), (gint) gtk_spin_button_get_value (self->priv->spin), &inner_error);
		if (inner_error != NULL) {
			goto __catch14_g_error;
			goto __finally14;
		}
	}
	goto __finally14;
	__catch14_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning ("ConfigNumber.vala:60: %s\n", e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally14:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
}


gint config_number_get_lower_bound (ConfigNumber* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_lower_bound;
}


static void config_number_set_lower_bound (ConfigNumber* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_lower_bound = value;
	g_object_notify ((GObject *) self, "lower-bound");
}


gint config_number_get_upper_bound (ConfigNumber* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_upper_bound;
}


static void config_number_set_upper_bound (ConfigNumber* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_upper_bound = value;
	g_object_notify ((GObject *) self, "upper-bound");
}


static void _config_number_handle_value_changed_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self) {
	config_number_handle_value_changed (self);
}


static GObject * config_number_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	ConfigNumberClass * klass;
	GObjectClass * parent_class;
	ConfigNumber * self;
	klass = CONFIG_NUMBER_CLASS (g_type_class_peek (TYPE_CONFIG_NUMBER));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = CONFIG_NUMBER (obj);
	{
		GtkSpinButton* _tmp0;
		_tmp0 = NULL;
		self->priv->spin = (_tmp0 = g_object_ref_sink ((GtkSpinButton*) gtk_spin_button_new_with_range ((double) self->priv->_lower_bound, (double) self->priv->_upper_bound, (double) 1)), (self->priv->spin == NULL) ? NULL : (self->priv->spin = (g_object_unref (self->priv->spin), NULL)), _tmp0);
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->priv->spin);
		config_widget_set_from_config ((ConfigWidget*) self);
		g_signal_connect_object (self->priv->spin, "value-changed", (GCallback) _config_number_handle_value_changed_gtk_spin_button_value_changed, self, 0);
	}
	return obj;
}


static void config_number_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ConfigNumber * self;
	gpointer boxed;
	self = CONFIG_NUMBER (object);
	switch (property_id) {
		case CONFIG_NUMBER_LOWER_BOUND:
		g_value_set_int (value, config_number_get_lower_bound (self));
		break;
		case CONFIG_NUMBER_UPPER_BOUND:
		g_value_set_int (value, config_number_get_upper_bound (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void config_number_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ConfigNumber * self;
	self = CONFIG_NUMBER (object);
	switch (property_id) {
		case CONFIG_NUMBER_LOWER_BOUND:
		config_number_set_lower_bound (self, g_value_get_int (value));
		break;
		case CONFIG_NUMBER_UPPER_BOUND:
		config_number_set_upper_bound (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void config_number_class_init (ConfigNumberClass * klass) {
	config_number_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ConfigNumberPrivate));
	G_OBJECT_CLASS (klass)->get_property = config_number_get_property;
	G_OBJECT_CLASS (klass)->set_property = config_number_set_property;
	G_OBJECT_CLASS (klass)->constructor = config_number_constructor;
	G_OBJECT_CLASS (klass)->finalize = config_number_finalize;
	CONFIG_WIDGET_CLASS (klass)->set_from_config = config_number_real_set_from_config;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONFIG_NUMBER_LOWER_BOUND, g_param_spec_int ("lower-bound", "lower-bound", "lower-bound", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONFIG_NUMBER_UPPER_BOUND, g_param_spec_int ("upper-bound", "upper-bound", "upper-bound", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void config_number_instance_init (ConfigNumber * self) {
	self->priv = CONFIG_NUMBER_GET_PRIVATE (self);
}


static void config_number_finalize (GObject* obj) {
	ConfigNumber * self;
	self = CONFIG_NUMBER (obj);
	(self->priv->spin == NULL) ? NULL : (self->priv->spin = (g_object_unref (self->priv->spin), NULL));
	G_OBJECT_CLASS (config_number_parent_class)->finalize (obj);
}


GType config_number_get_type (void) {
	static GType config_number_type_id = 0;
	if (config_number_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ConfigNumberClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) config_number_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConfigNumber), 0, (GInstanceInitFunc) config_number_instance_init, NULL };
		config_number_type_id = g_type_register_static (TYPE_CONFIG_WIDGET, "ConfigNumber", &g_define_type_info, 0);
	}
	return config_number_type_id;
}




