/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */

#include "ConfigPeriod.h"
#include <gconf/gconf-client.h>
#include <gtk/gtk.h>
#include <libintl.h>
#include <glib/gi18n-lib.h>
#include "ConfigWidget.h"




enum  {
	CONFIG_PERIOD_DUMMY_PROPERTY
};
static void config_period_real_handle_changed (ConfigChoice* base);
static void config_period_real_set_from_config (ConfigWidget* base);
static GObject * config_period_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer config_period_parent_class = NULL;



ConfigPeriod* config_period_construct (GType object_type, const char* key) {
	GParameter * __params;
	GParameter * __params_it;
	ConfigPeriod * self;
	g_return_val_if_fail (key != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "key";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, key);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


ConfigPeriod* config_period_new (const char* key) {
	return config_period_construct (TYPE_CONFIG_PERIOD, key);
}


static void config_period_real_handle_changed (ConfigChoice* base) {
	ConfigPeriod * self;
	GError * inner_error;
	GValue* val;
	gint _tmp0;
	gint intval;
	char* _tmp1;
	self = (ConfigPeriod*) base;
	inner_error = NULL;
	val = config_choice_get_current_value ((ConfigChoice*) self);
	_tmp0 = 0;
	if (val == NULL) {
		_tmp0 = 1;
	} else {
		_tmp0 = g_value_get_int (val);
	}
	intval = _tmp0;
	{
		gconf_client_set_int (((ConfigWidget*) self)->client, config_widget_get_key ((ConfigWidget*) self), intval, &inner_error);
		if (inner_error != NULL) {
			goto __catch15_g_error;
			goto __finally15;
		}
	}
	goto __finally15;
	__catch15_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning ("ConfigPeriod.vala:54: %s\n", e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally15:
	if (inner_error != NULL) {
		(val == NULL) ? NULL : (val = (g_free (val), NULL));
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	_tmp1 = NULL;
	g_signal_emit_by_name ((ConfigChoice*) self, "changed", _tmp1 = g_strdup_printf ("%i", intval));
	_tmp1 = (g_free (_tmp1), NULL);
	(val == NULL) ? NULL : (val = (g_free (val), NULL));
}


static void config_period_real_set_from_config (ConfigWidget* base) {
	ConfigPeriod * self;
	GError * inner_error;
	gint confval;
	gboolean valid;
	GtkTreeIter iter = {0};
	self = (ConfigPeriod*) base;
	inner_error = NULL;
	confval = 0;
	{
		gint _tmp0;
		_tmp0 = gconf_client_get_int (((ConfigWidget*) self)->client, config_widget_get_key ((ConfigWidget*) self), &inner_error);
		if (inner_error != NULL) {
			goto __catch16_g_error;
			goto __finally16;
		}
		confval = _tmp0;
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning ("ConfigPeriod.vala:67: %s\n", e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			return;
		}
	}
	__finally16:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	if (confval < 1) {
		confval = 1;
	}
	valid = FALSE;
	valid = gtk_tree_model_get_iter_first (gtk_combo_box_get_model (((ConfigChoice*) self)->combo), &iter);
	while (valid) {
		GValue val = {0};
		GValue _tmp2 = {0};
		GValue _tmp1 = {0};
		gint intval;
		gtk_tree_model_get_value (gtk_combo_box_get_model (((ConfigChoice*) self)->combo), &iter, ((ConfigChoice*) self)->gconf_col, &_tmp1);
		val = (_tmp2 = _tmp1, G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL, _tmp2);
		intval = g_value_get_int (&val);
		if (intval == confval) {
			gtk_combo_box_set_active_iter (((ConfigChoice*) self)->combo, &iter);
			G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
			break;
		}
		valid = gtk_tree_model_iter_next (gtk_combo_box_get_model (((ConfigChoice*) self)->combo), &iter);
		G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	}
	/* If we didn't find the period, user must have set it to something non
	 standard.  Let's add an entry to the combo.*/
	if (!valid) {
		GtkListStore* _tmp3;
		GtkListStore* store;
		char* _tmp4;
		_tmp3 = NULL;
		store = (_tmp3 = GTK_LIST_STORE (gtk_combo_box_get_model (((ConfigChoice*) self)->combo)), (_tmp3 == NULL) ? NULL : g_object_ref (_tmp3));
		_tmp4 = NULL;
		gtk_list_store_insert_with_values (store, &iter, 0, 0, _tmp4 = g_strdup_printf (ngettext ("Every %d day", "Every %d days", (gulong) confval), confval), 1, confval, -1);
		_tmp4 = (g_free (_tmp4), NULL);
		gtk_combo_box_set_active_iter (((ConfigChoice*) self)->combo, &iter);
		(store == NULL) ? NULL : (store = (g_object_unref (store), NULL));
	}
}


static GObject * config_period_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	ConfigPeriodClass * klass;
	GObjectClass * parent_class;
	ConfigPeriod * self;
	klass = CONFIG_PERIOD_CLASS (g_type_class_peek (TYPE_CONFIG_PERIOD));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = CONFIG_PERIOD (obj);
	{
		GtkListStore* store;
		GtkTreeIter iter = {0};
		gint i;
		store = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_INT, NULL);
		i = 0;
		gtk_list_store_insert_with_values (store, &iter, i++, 0, _ ("Daily"), 1, 1, -1);
		gtk_list_store_insert_with_values (store, &iter, i++, 0, _ ("Weekly"), 1, 7, -1);
		/* Translators: Biweekly is every two weeks*/
		gtk_list_store_insert_with_values (store, &iter, i++, 0, _ ("Biweekly"), 1, 14, -1);
		gtk_list_store_insert_with_values (store, &iter, i++, 0, _ ("Monthly"), 1, 28, -1);
		gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) store, 1, GTK_SORT_ASCENDING);
		config_choice_init ((ConfigChoice*) self, (GtkTreeModel*) store, 1);
		(store == NULL) ? NULL : (store = (g_object_unref (store), NULL));
	}
	return obj;
}


static void config_period_class_init (ConfigPeriodClass * klass) {
	config_period_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = config_period_constructor;
	CONFIG_CHOICE_CLASS (klass)->handle_changed = config_period_real_handle_changed;
	CONFIG_WIDGET_CLASS (klass)->set_from_config = config_period_real_set_from_config;
}


static void config_period_instance_init (ConfigPeriod * self) {
}


GType config_period_get_type (void) {
	static GType config_period_type_id = 0;
	if (config_period_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ConfigPeriodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) config_period_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConfigPeriod), 0, (GInstanceInitFunc) config_period_instance_init, NULL };
		config_period_type_id = g_type_register_static (TYPE_CONFIG_CHOICE, "ConfigPeriod", &g_define_type_info, 0);
	}
	return config_period_type_id;
}




