/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */

#include "ConfigWidget.h"
#include <gconf/gconf.h>




static char* string_substring (const char* self, glong offset, glong len);
static glong string_get_length (const char* self);
struct _ConfigWidgetPrivate {
	char* _key;
	char* dir;
};

#define CONFIG_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CONFIG_WIDGET, ConfigWidgetPrivate))
enum  {
	CONFIG_WIDGET_DUMMY_PROPERTY,
	CONFIG_WIDGET_KEY
};
static void config_widget_real_set_from_config (ConfigWidget* self);
static void config_widget_set_key (ConfigWidget* self, const char* value);
static void _config_widget_set_from_config_gconf_client_notify_func (GConfClient* client, guint cnxn_id, GConfEntry* entry, gpointer self);
static GObject * config_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer config_widget_parent_class = NULL;
static void config_widget_finalize (GObject* obj);



static char* string_substring (const char* self, glong offset, glong len) {
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = g_utf8_strlen (self, -1);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	return g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
}


static glong string_get_length (const char* self) {
	g_return_val_if_fail (self != NULL, 0L);
	return g_utf8_strlen (self, -1);
}


static void config_widget_real_set_from_config (ConfigWidget* self) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `config_widget_set_from_config'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void config_widget_set_from_config (ConfigWidget* self) {
	CONFIG_WIDGET_GET_CLASS (self)->set_from_config (self);
}


const char* config_widget_get_key (ConfigWidget* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_key;
}


static void config_widget_set_key (ConfigWidget* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_key = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_key = (g_free (self->priv->_key), NULL), _tmp2);
	g_object_notify ((GObject *) self, "key");
}


static void _config_widget_set_from_config_gconf_client_notify_func (GConfClient* client, guint cnxn_id, GConfEntry* entry, gpointer self) {
	config_widget_set_from_config (self);
}


static GObject * config_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	ConfigWidgetClass * klass;
	GObjectClass * parent_class;
	ConfigWidget * self;
	GError * inner_error;
	klass = CONFIG_WIDGET_CLASS (g_type_class_peek (TYPE_CONFIG_WIDGET));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = CONFIG_WIDGET (obj);
	inner_error = NULL;
	{
		GConfClient* _tmp1;
		GConfClient* _tmp0;
		_tmp1 = NULL;
		_tmp0 = NULL;
		self->client = (_tmp1 = (_tmp0 = gconf_client_get_default (), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0)), (self->client == NULL) ? NULL : (self->client = (g_object_unref (self->client), NULL)), _tmp1);
		if (self->priv->_key != NULL) {
			char* _tmp3;
			const char* _tmp2;
			const char* end;
			_tmp3 = NULL;
			_tmp2 = NULL;
			self->priv->dir = (_tmp3 = (_tmp2 = self->priv->_key, (_tmp2 == NULL) ? NULL : g_strdup (_tmp2)), self->priv->dir = (g_free (self->priv->dir), NULL), _tmp3);
			end = g_utf8_strrchr (self->priv->dir, (glong) (-1), (gunichar) '/');
			if (end != NULL) {
				char* _tmp4;
				_tmp4 = NULL;
				self->priv->dir = (_tmp4 = string_substring (self->priv->dir, (glong) 0, string_get_length (self->priv->dir) - string_get_length (end)), self->priv->dir = (g_free (self->priv->dir), NULL), _tmp4);
			}
			{
				gconf_client_add_dir (self->client, self->priv->dir, GCONF_CLIENT_PRELOAD_NONE, &inner_error);
				if (inner_error != NULL) {
					goto __catch17_g_error;
					goto __finally17;
				}
				gconf_client_notify_add (self->client, self->priv->_key, _config_widget_set_from_config_gconf_client_notify_func, g_object_ref (self), g_object_unref, &inner_error);
				if (inner_error != NULL) {
					goto __catch17_g_error;
					goto __finally17;
				}
			}
			goto __finally17;
			__catch17_g_error:
			{
				GError * e;
				e = inner_error;
				inner_error = NULL;
				{
					g_warning ("ConfigWidget.vala:41: %s\n", e->message);
					(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
				}
			}
			__finally17:
			if (inner_error != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
				g_clear_error (&inner_error);
			}
		}
	}
	return obj;
}


static void config_widget_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ConfigWidget * self;
	gpointer boxed;
	self = CONFIG_WIDGET (object);
	switch (property_id) {
		case CONFIG_WIDGET_KEY:
		g_value_set_string (value, config_widget_get_key (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void config_widget_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ConfigWidget * self;
	self = CONFIG_WIDGET (object);
	switch (property_id) {
		case CONFIG_WIDGET_KEY:
		config_widget_set_key (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void config_widget_class_init (ConfigWidgetClass * klass) {
	config_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ConfigWidgetPrivate));
	G_OBJECT_CLASS (klass)->get_property = config_widget_get_property;
	G_OBJECT_CLASS (klass)->set_property = config_widget_set_property;
	G_OBJECT_CLASS (klass)->constructor = config_widget_constructor;
	G_OBJECT_CLASS (klass)->finalize = config_widget_finalize;
	CONFIG_WIDGET_CLASS (klass)->set_from_config = config_widget_real_set_from_config;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONFIG_WIDGET_KEY, g_param_spec_string ("key", "key", "key", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void config_widget_instance_init (ConfigWidget * self) {
	self->priv = CONFIG_WIDGET_GET_PRIVATE (self);
}


static void config_widget_finalize (GObject* obj) {
	ConfigWidget * self;
	GError * inner_error;
	self = CONFIG_WIDGET (obj);
	inner_error = NULL;
	{
		{
			gconf_client_remove_dir (self->client, self->priv->dir, &inner_error);
			if (inner_error != NULL) {
				goto __catch18_g_error;
				goto __finally18;
			}
		}
		goto __finally18;
		__catch18_g_error:
		{
			GError * e;
			e = inner_error;
			inner_error = NULL;
			{
				g_warning ("ConfigWidget.vala:52: %s\n", e->message);
				(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			}
		}
		__finally18:
		if (inner_error != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
		}
	}
	self->priv->_key = (g_free (self->priv->_key), NULL);
	self->priv->dir = (g_free (self->priv->dir), NULL);
	(self->client == NULL) ? NULL : (self->client = (g_object_unref (self->client), NULL));
	G_OBJECT_CLASS (config_widget_parent_class)->finalize (obj);
}


GType config_widget_get_type (void) {
	static GType config_widget_type_id = 0;
	if (config_widget_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ConfigWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) config_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConfigWidget), 0, (GInstanceInitFunc) config_widget_instance_init, NULL };
		config_widget_type_id = g_type_register_static (GTK_TYPE_EVENT_BOX, "ConfigWidget", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return config_widget_type_id;
}




