/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */

#ifndef __TOGGLEGROUP_H__
#define __TOGGLEGROUP_H__

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>

G_BEGIN_DECLS


#define TYPE_TOGGLABLE (togglable_get_type ())
#define TOGGLABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TOGGLABLE, Togglable))
#define IS_TOGGLABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TOGGLABLE))
#define TOGGLABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_TOGGLABLE, TogglableIface))

typedef struct _Togglable Togglable;
typedef struct _TogglableIface TogglableIface;

#define TYPE_TOGGLE_GROUP (toggle_group_get_type ())
#define TOGGLE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TOGGLE_GROUP, ToggleGroup))
#define TOGGLE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TOGGLE_GROUP, ToggleGroupClass))
#define IS_TOGGLE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TOGGLE_GROUP))
#define IS_TOGGLE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TOGGLE_GROUP))
#define TOGGLE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TOGGLE_GROUP, ToggleGroupClass))

typedef struct _ToggleGroup ToggleGroup;
typedef struct _ToggleGroupClass ToggleGroupClass;
typedef struct _ToggleGroupPrivate ToggleGroupPrivate;

/*
    Déjà Dup
    © 2008—2009 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
struct _TogglableIface {
	GTypeInterface parent_iface;
	gboolean (*get_active) (Togglable* self);
};

struct _ToggleGroup {
	GObject parent_instance;
	ToggleGroupPrivate * priv;
};

struct _ToggleGroupClass {
	GObjectClass parent_class;
};


gboolean togglable_get_active (Togglable* self);
GType togglable_get_type (void);
ToggleGroup* toggle_group_construct (GType object_type, Togglable* toggle);
ToggleGroup* toggle_group_new (Togglable* toggle);
void toggle_group_add_dependent (ToggleGroup* self, GtkWidget* w);
void toggle_group_check (ToggleGroup* self);
Togglable* toggle_group_get_toggle (ToggleGroup* self);
GType toggle_group_get_type (void);


G_END_DECLS

#endif
