//////////////////////////////////////////////////////////////////////////////
// deKoratorconfig.cc
// -------------------
// DeKorator window decoration for KDE
// -------------------
// Autor: moty rahamim
// Email: moty.rahamim@gmail.com
// Based on Example-0.8 by David Johnson <david@usermode.org>
// some ideas and code have been taken from plastik and KCMicons
/////////////////////////////////////////////////////////////////////////////////////

#ifndef DEKORATORCLIENT_H
#define DEKORATORCLIENT_H

#include <qbutton.h>
#include <qbitmap.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpainter.h>
#include <qtooltip.h>
#include <qpixmap.h>
#include <qapplication.h>
#include <qtimer.h>
#include <qcursor.h>

#include <kdecoration.h>
#include <kdecorationfactory.h>
#include <kconfig.h>
#include <kdeversion.h>
#include <kglobal.h>
#include <kglobalsettings.h>
#include <klocale.h>
#include <kiconeffect.h>
#include <kimageeffect.h>

#include "shadow.h"

class QSpacerItem;
class QPoint;

namespace DeKorator
{

    class DeKoratorClient;

    enum ButtonType {
        ButtonHelp = 0,
        ButtonMax,
        ButtonMin,
        ButtonClose,
        ButtonMenu,
        ButtonSticky,
        ButtonAbove,
        ButtonBelow,
        ButtonShade,
        ButtonTypeCount
    };

    // DeKoratorFactory /////////////////////////////////////////////////////////////

    class DeKoratorFactory: public KDecorationFactory
    {
    public:
        DeKoratorFactory();
        virtual ~DeKoratorFactory();
        virtual KDecoration *createDecoration( KDecorationBridge *b );
        virtual bool reset( unsigned long changed );
        static void colorizePixmap( QPixmap *pix, QColor col, QString colorizeMethod );
        static bool initialized();
        QPixmap topLeftCornerBg_, leftButtonsBg_, leftTitleBg_, midTitleBg_, rightTitleBg_, rightButtonsBg_, topRightCornerBg_,
        topLeftFrameBg_, midLeftFrameBg_, buttomLeftFrameBg_,
        leftButtomFrameBg_, midButtomFrameBg_, rightButtomFrameBg_,
        topRightFrameBg_, midRightFrameBg_, buttomRightFrameBg_;

        QPixmap topLeftCornerBgInAct_, leftButtonsBgInAct_, leftTitleBgInAct_, midTitleBgInAct_, rightTitleBgInAct_, rightButtonsBgInAct_, topRightCornerBgInAct_,
        topLeftFrameBgInAct_, midLeftFrameBgInAct_, buttomLeftFrameBgInAct_,
        leftButtomFrameBgInAct_, midButtomFrameBgInAct_, rightButtomFrameBgInAct_,
        topRightFrameBgInAct_, rightFrameBgInAct_, buttomRightFrameBgInAct_;

        QPixmap buttonRestorePix_, buttonRestorePressPix_, buttonRestoreHoverPix_, buttonRestorePixInAct_,
        buttonHelpPix_, buttonHelpPressPix_, buttonHelpHoverPix_, buttonHelpPixInAct_,
        buttonMaxPix_, buttonMaxPressPix_, buttonMaxHoverPix_, buttonMaxPixInAct_,
        buttonMinPix_, buttonMinPressPix_, buttonMinHoverPix_, buttonMinPixInAct_,
        buttonClosePix_, buttonClosePressPix_, buttonCloseHoverPix_, buttonClosePixInAct_,
        buttonStickyPix_, buttonStickyPressPix_, buttonStickyHoverPix_, buttonStickyPixInAct_,
        buttonStickyDownPix_, buttonStickyDownPressPix_, buttonStickyDownHoverPix_, buttonStickyDownPixInAct_,
        buttonAbovePix_, buttonAbovePressPix_, buttonAboveHoverPix_, buttonAbovePixInAct_,
        buttonAboveDownPix_, buttonAboveDownPressPix_, buttonAboveDownHoverPix_, buttonAboveDownPixInAct_,
        buttonBelowPix_, buttonBelowPressPix_, buttonBelowHoverPix_, buttonBelowPixInAct_,
        buttonBelowDownPix_, buttonBelowDownPressPix_, buttonBelowDownHoverPix_, buttonBelowDownPixInAct_,
        buttonShadePix_, buttonShadePressPix_, buttonShadeHoverPix_, buttonShadePixInAct_,
        buttonMenuPix_, buttonMenuPressPix_, buttonMenuHoverPix_, buttonMenuPixInAct_,
        buttonShadeDownPix_, buttonShadeDownPressPix_, buttonShadeDownHoverPix_, buttonShadeDownPixInAct_;

        QBitmap topLeftCornerBitmap_, topRightCornerBitmap_, buttomLeftCornerBitmap_, buttomRightCornerBitmap_;
    private:
        bool readConfig();
        void loadPixmaps();
        void colorizeDecoPixmaps( bool isActive );
        void colorizeButtonsPixmaps(bool isActive);

        void determineSizes();

    private:

        static bool colorizeFrames_;
        static bool needInit_;
        static QString framesPath_;
        static QString buttonsPath_;
        static QString masksPath_;
    public:
        static bool initialized_;
        static bool colorizeButtons_;
    };

    inline bool DeKoratorFactory::initialized()
    { return initialized_; }












    // DeKoratorButton //////////////////////////////////////////////////////////////

    class DeKoratorButton : public QButton
    {
        Q_OBJECT
    public:
        DeKoratorButton( bool isLeft, int buttonWidth, int buttonHeight, DeKoratorClient *parent = 0, const char *name = 0,
                         const QString &tip = NULL,
                         ButtonType type = ButtonHelp,
                         QPixmap *buttonPix = NULL, QPixmap *buttonPixPress = NULL, QPixmap *buttonPixHover = NULL, QPixmap *buttonPixInAct = NULL );
        ~DeKoratorButton();

        void setPixmap( QPixmap *buttonPix = NULL, QPixmap *buttonPixPress = NULL, QPixmap *buttonPixHover = NULL, QPixmap *buttonPixInAct = NULL );
        QSize sizeHint() const;
        ButtonState lastMousePress() const;
        void reset();

    protected slots:
        void animate();

    private:
        void enterEvent( QEvent *e );
        void leaveEvent( QEvent *e );
        void mousePressEvent( QMouseEvent *e );
        void mouseReleaseEvent( QMouseEvent *e );
        void drawButton( QPainter *painter );
        QImage* chooseRightHoverEffect(QImage *img, bool isAnimate, QString res);

    private:
        bool isLeft_;
        int buttonWidth_;
        int decoPixHeight_;
        DeKoratorClient *client_;
        ButtonType type_;
        QPixmap *decoPix_, *decoPixPress_, *decoPixHover_, *decoPixInAct_;
        ButtonState lastmouse_;
        bool hover_;
        QTimer *animTmr;
        uint animProgress;
    };

    inline Qt::ButtonState DeKoratorButton::lastMousePress() const
        { return lastmouse_; }

    inline void DeKoratorButton::reset()
    { repaint( FALSE ); }












    // DeKoratorClient //////////////////////////////////////////////////////////////

    class DeKoratorClient : public KDecoration
    {
        Q_OBJECT
    public:
        DeKoratorClient( KDecorationBridge *b, KDecorationFactory *f );
        virtual ~DeKoratorClient();

        virtual void init();

        virtual void activeChange();
        virtual void desktopChange();
        virtual void captionChange();
        virtual void iconChange();
        virtual void maximizeChange();
        virtual void shadeChange();

        virtual void borders( int &l, int &r, int &t, int &b ) const;
        virtual void resize( const QSize &size );
        virtual QSize minimumSize() const;
        virtual Position mousePosition( const QPoint &point ) const;

    private:
        void addButtons( QBoxLayout* layout, const QString& buttons, bool isLeft );

        bool eventFilter( QObject *obj, QEvent *e );
        void mouseDoubleClickEvent( QMouseEvent *e );
        void paintEvent( QPaintEvent *e );
        void resizeEvent( QResizeEvent * );
        void showEvent( QShowEvent * );
        void doShape();
        void updateCaptionBuffer();


    private slots:
        void maxButtonPressed();
        void menuButtonPressed();
        void aboveButtonPressed();
        void belowButtonPressed();
        void shadeButtonPressed();
        void keepAboveChange( bool );
        void keepBelowChange( bool );
        void menuButtonReleased();

    private:
        DeKoratorButton *button[ ButtonTypeCount ];
        QVBoxLayout *mainLayout_;
        QHBoxLayout *titleLayout_ ;
        QHBoxLayout *midLayout_;
        QSpacerItem *leftTitleBarSpacer_, *titleBarSpacer_, *rightTitleBarSpacer_, *leftSpacer_, *rightSpacer_, *bottomSpacer_;
        bool closing_;
        QPixmap *captionBufferPix_;
        bool captionBufferDirty_;
        QImage activeShadowImg_, inActiveShadowImg_;
    public:
        DeKoratorFactory *decoFactory_;
    };


} // namespace DeKorator

#endif // DEKORATORCLIENT_H
