/*
 * This file is licensed under the terms of the GNU General Public License,
 * version 2. See the file COPYING in the main directory for details.
 * 
 *  Copyright (C) 2002,2003  Thiemo Seufer <seufer@csv.ica.uni-stuttgart.de>
 */

#include <elf.h>

#include "delo.h"
#include "stringops.h"

static void *loadelf32(Elf32_Ehdr *ehdr)
{
	int i;

	if (!(ehdr->e_type == ET_EXEC
	      && ehdr->e_machine == EM_MIPS
	      && ehdr->e_version == EV_CURRENT))
		return NULL;

	for(i = 0; i < ehdr->e_phnum; i++) {
		Elf32_Phdr phdr;

		if (delo_read(&phdr, ehdr->e_phoff + i * sizeof(phdr),
			      sizeof(phdr), 0))
			return NULL;

		if (phdr.p_type == PT_LOAD) {
			if (delo_read((void *)phdr.p_vaddr, phdr.p_offset,
				      phdr.p_filesz, 1))
				return NULL;
		}
	}

	return (void *)ehdr->e_entry;
}

static void *loadelf64(Elf64_Ehdr *ehdr)
{
	int i;

	if (!(ehdr->e_type == ET_EXEC
	      && ehdr->e_machine == EM_MIPS
	      && ehdr->e_version == EV_CURRENT))
		return NULL;

	for(i = 0; i < ehdr->e_phnum; i++) {
		Elf64_Phdr phdr;

		if (delo_read(&phdr, ehdr->e_phoff + i * sizeof(phdr),
			      sizeof(phdr), 0))
			return NULL;

		if (phdr.p_type == PT_LOAD) {
			if (delo_read((void *)(unsigned int)phdr.p_vaddr,
				      phdr.p_offset, phdr.p_filesz, 1))
				return NULL;
		}
	}

	return (void *)(unsigned int)ehdr->e_entry;
}

void *loadelf(void)
{
	union {
		Elf32_Ehdr s;
		Elf64_Ehdr b;
	} ehdr;

	if (delo_read(&ehdr, 0, sizeof(ehdr), 0))
		return NULL;

	if (!(ehdr.s.e_ident[EI_MAG0] == ELFMAG0
	      && ehdr.s.e_ident[EI_MAG1] == ELFMAG1
	      && ehdr.s.e_ident[EI_MAG2] == ELFMAG2
	      && ehdr.s.e_ident[EI_MAG3] == ELFMAG3
	      && (ehdr.s.e_ident[EI_CLASS] == ELFCLASS32
		  || ehdr.s.e_ident[EI_CLASS] == ELFCLASS64)
	      && ehdr.s.e_ident[EI_DATA] == ELFDATA2LSB
	      && ehdr.s.e_ident[EI_VERSION] == EV_CURRENT))
		return NULL;

	if (ehdr.s.e_ident[EI_CLASS] == ELFCLASS32)
		return loadelf32(&ehdr.s);
	else if (ehdr.s.e_ident[EI_CLASS] == ELFCLASS64)
		return loadelf64(&ehdr.b);
	else
		return NULL;
}
