#!/usr/bin/python
#
# deluge.py
# Copyright (C) Zach Tibbitts 2006 <zach@collegegeek.org>
# Copyright (C) Alon Zakai    2006 <kripkensteiner@gmail.com>
# 
# Deluge is free software.
# 
# You may redistribute it and/or modify it under the terms of the
# GNU General Public License, as published by the Free Software
# Foundation; either version 2 of the License, or (at your option)
# any later version.
# 
# main.py is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with main.py.  If not, write to:
# 	The Free Software Foundation, Inc.,
# 	51 Franklin Street, Fifth Floor
# 	Boston, MA  02110-1301, USA.

import sys, os, shutil, gettext, urllib
import gobject
##import dbus
##import dbus.service
##if getattr(dbus, 'version', (0,0,0)) >= (0,41,0):
##    import dbus.glib
try:
 	import pygtk
  	pygtk.require("2.0")
except:
  	pass
try:
	import gtk
  	import gtk.glade
except:
	sys.exit(1)
##import egg.trayicon
import time
import threading
import torrent
import delugecommon, dpref, dabout
import dtray, dpluginmanager
from delugecommon import *
import delugecommon
from torrenthandler import TorrentHandler
dc = delugecommon

class Deluge:

	def __init__(self):
		# Init directories, if needed
		if not "torrentfiles" in os.listdir(dc.CONFIG_DIR):
			os.mkdir(dc.CONFIG_DIR + "/torrentfiles")

		self.preferences = dpref.DelugePreferences(dc.CONFIG_XML)

		#Set the Glade file
		self.gladefile = dc.get_glade("mainwindow.glade")
		self.wTree = gtk.glade.XML(self.gladefile) 
		
		#Main Window
		self.window = self.wTree.get_widget("MainWindow")

		oldWidth  = self.preferences.get('window_width')
		oldHeight = self.preferences.get('window_height')

		if oldWidth is not None and oldHeight is not None:
			self.window.resize(int(oldWidth), int(oldHeight))

		oldPositionX = self.preferences.get('window_position_x')
		oldPositionY = self.preferences.get('window_position_y')

		if oldPositionX is not None and oldPositionY is not None:
			self.window.move(int(oldPositionX), int(oldPositionY))

		self.window.connect("destroy", self.SafeDestroy)
		self.window.drag_dest_set(gtk.DEST_DEFAULT_ALL,[('text/uri-list', 0, 80)], gtk.gdk.ACTION_COPY)
		
		self.window.connect("drag_data_received", self.on_dragdata)
		self.window.set_icon_from_file(dc.get_icon("deluge-32.png"))
		self.sidebar = self.wTree.get_widget("torrentInfo")
		
		self.tb_left = self.wTree.get_widget("tb_left")
		self.tb_middle = self.wTree.get_widget("tb_middle")
		self.tb_right = self.wTree.get_widget("tb_right")
		
		self.se = None

		dic = { "add_torrent" 		: self.interactive_open_torrent,
			"add_torrent_url"	: self.add_torrent_from_url,
			"remove_torrent" 	: self.RemoveTorrent,
			"clear_finished" 	: self.ClearFinished,
			"show_hide_sidebar" 	: self.ShowHideSidebar,
			"show_hide_window" 	: self.ShowHideWindow,
			"pref_clicked"		: self.ShowPrefDialog,
			"manageplugins_clicked"	: self.ManagePluginsDialog,
			"about" 		: self.About,
			"open_forums"		: self.Forum,
			"translate"		: self.translate,
			"quit" 			: self.Quit,
			"menu_quit" 		: self.MenuQuit,
			"update_tracker"	: self.UpdateTracker,
			"pause_torrent"		: self.PauseTorrent,
			"torrent_up"		: self.QueueTorrentUp,
			"torrent_down"		: self.QueueTorrentDown,
			"torrent_bottom"	: self.QueueTorrentAllDown,
			"delete"		: self.delete_event}

		self.wTree.signal_autoconnect(dic)

		##dic = { "menu_quit" 			: self.MenuQuit }

		##self.tTree.signal_autoconnect(dic)
		
		self.tooltips = gtk.Tooltips()
		
		#Torrent Summary tab
		self.text_summary_title                   = self.wTree.get_widget("summary_title")
		self.text_summary_total_size              = self.wTree.get_widget("summary_total_size")
		self.text_summary_pieces                  = self.wTree.get_widget("summary_pieces")
		self.text_summary_total_downloaded        = self.wTree.get_widget("summary_total_downloaded")
		self.text_summary_total_uploaded          = self.wTree.get_widget("summary_total_uploaded")
		self.text_summary_percentage_done         = self.wTree.get_widget("summary_percentage_done")
		self.text_summary_share_ratio             = self.wTree.get_widget("summary_share_ratio")
		self.text_summary_downloaded_this_session = self.wTree.get_widget("summary_downloaded_this_session")
		self.text_summary_uplodaded_this_session  = self.wTree.get_widget("summary_uploaded_this_session")
		self.text_summary_tracker                 = self.wTree.get_widget("summary_tracker")
		self.text_summary_tracker_response        = self.wTree.get_widget("summary_tracker_response")
		self.text_summary_tacker_status           = self.wTree.get_widget("summary_tracker_status")
		self.text_summary_next_announce           = self.wTree.get_widget("summary_next_announce")
		self.text_summary_compact_allocation      = self.wTree.get_widget("summary_compact_allocation")
		
		##
		##
		## Beginning of columns code
		##
		##

		#Torrent View
		self.torrentView = self.wTree.get_widget("torrentView")

		##
		## New Columns Code
		##
		self.number_column = dc.TextColumn()
		self.name_column = dc.TextColumn()
		self.size_column = dc.TextColumn()
		self.status_column = dc.ProgressColumn()
		self.message_column = dc.TextColumn()
		self.seed_column = dc.TextColumn()
		self.peer_column = dc.TextColumn()
		self.download_column = dc.TextColumn()
		self.upload_column = dc.TextColumn()
		self.eta_column = dc.TextColumn()
		self.share_column = dc.TextColumn()		
		
		
		
		##
		##
		##


		columns = ["#", _("Name"),  _("Size"),]
		
		cindex = 2
		backgroundIndex = [-1,-1,-1,-1,-1,-1,-1,-1,-1,13,14,-1,-1,-1]
		hide = [False,False,False,False,False,False,False,False,False,False,False,False,False]
		for x in columns:
			dc.AddTextColumn(self.torrentView, x, cindex, backgroundIndex[cindex], hide[cindex])
			cindex = cindex + 1
		dc.AddProgressColumn(self.torrentView, "Status", cindex)
		cindex = cindex + 1
		dc.AddTextColumn(self.torrentView, "Message", cindex, backgroundIndex[cindex], True)
		cindex = cindex + 1
		columns = [_("Seeders"), _("Peers"), _("D/L"), _("U/L"), _("ETA"), _("Share %")]
		for x in columns:
			dc.AddTextColumn(self.torrentView, x, cindex, backgroundIndex[cindex], hide[cindex])
			cindex = cindex + 1
		dc.debugmsg("********************:"+ str(cindex))

		self.torrentList = gtk.ListStore(int, str, int, str, str, float, str, str, str, str, str, str, str, 'gboolean', 'gboolean')
		self.torrentView.set_model(self.torrentList)

		self.torrentView.connect("key-press-event", self.TorrentViewKeyPress)

		# Torrent View popup menu
		self.torrentViewwTree = gtk.glade.XML(dc.get_glade("torrentpopupmenu.glade"))
		self.torrentViewMenu  = self.torrentViewwTree.get_widget("torrent_popup_menu")
		torrentViewdic = {"start_pause"		: self.PauseTorrent,
								"remove_torrent"	: self.RemoveTorrent,
								"update_tracker"	: self.UpdateTracker  }
		self.torrentViewwTree.signal_autoconnect(torrentViewdic)

		self.torrentView.connect("button-press-event", self.TorrentViewMouseButton)
		
		##
		##
		## End columns code for torrent view
		##
		##

#		self.torrentView.set_reorderable(False)

		# Allow multiple torrents to be selected
#		self.torrentView.get_selection().set_mode(gtk.SELECTION_MULTIPLE)

#		for c in self.torrentView.get_columns():
#			c.set_clickable(False)



		#File View
		self.fileView = self.wTree.get_widget("fileView")
		self.fileView.get_selection().set_mode(gtk.SELECTION_MULTIPLE)
		columns = [_("path"), _("size"), _("offset"), "%"]
		cindex = 0
		for x in columns:
			dc.AddTextColumn(self.fileView, x, cindex)
			cindex = cindex + 1

		columns = [_("download?")]
		for x in columns:
			dc.AddToggleColumn(self.fileView, x, cindex, self.toggledSignal)
			cindex = cindex + 1

		#File View menu
		self.fileViewwTree = gtk.glade.XML(dc.get_glade("filelistmenu.glade"))
		self.fileViewMenu  = self.fileViewwTree.get_widget("FileListMenu")
		fileViewdic = {"mark_download"			: self.MarkFileDownload,
							"mark_do_not_download"	: self.MarkFileDoNotDownload  }
		self.fileViewwTree.signal_autoconnect(fileViewdic)

		self.fileView.connect("button-press-event", self.FileViewMouseButton)

		#Peer View
		self.peerView = self.wTree.get_widget("peerView")
		columns     = [_("IP"), _("Client"), "%", _("D/L"), _("U/L")]
		sortColumns = [-1,   	-1,       	 7,   5,     	 6]
		cindex = 0
		for x in columns:
			dc.AddTextColumn(self.peerView, x, cindex, sortColumn=sortColumns[cindex])
			cindex = cindex + 1

		#Torrent Messages tab
		self.torrentMessages = self.wTree.get_widget("torrentMessages")
		self.messageList  = gtk.TextBuffer()
		self.torrentMessages.set_buffer(self.messageList)

		self.systray = dtray.get_new_tray_icon(self)

		#Status Bar
		self.statusbar = self.wTree.get_widget("statusbar1")

		# Create the TorrentHandler object, which
		# will connect the the python wrappers for libtorrent and
		# handle any ongoing bittorrent downloads
		self.handler = None

		# Main pane
		self.mainPane = self.wTree.get_widget("vpaned1")
		
		# Final initialization preparation
		self.finalInitDone = False		

		# So we know if we have been destroyed in the middle of a tick cycle
		self.stillAlive = True

	def TorrentViewKeyPress(self, widget, event):
		if event.keyval == 65535:
			self.RemoveTorrent(None)

	def TorrentViewMouseButton(self, widget, event):
		if event.button == 3:
			self.ShowTorrentViewMenu(event)
			return True
		else:
			return False

	def ShowTorrentViewMenu(self, event):
		x = int(event.x)
		y = int(event.y)
		data = self.torrentView.get_path_at_pos(x, y)
		if data is None:
			return

		path, col, cellx, celly = data

		self.torrentView.grab_focus()
		self.torrentView.set_cursor(path, col, 0)

		currTorrent = self.getSelectedTorrent()

		btn_resume = self.torrentViewwTree.get_widget("force_resume")
		btn_pause = self.torrentViewwTree.get_widget("force_pause")
		btn_tracker = self.torrentViewwTree.get_widget("update_tracker")

		if currTorrent is not None:
			self.torrentViewwTree.get_widget("remove_torrent").set_sensitive(True)
			if currTorrent.isPaused():
				btn_tracker.set_sensitive(False)
				if currTorrent.isForcePaused():
					btn_resume.set_sensitive(True)
					btn_pause.set_sensitive(False)
				else:
					btn_resume.set_sensitive(False)
					btn_pause.set_sensitive(True)
			else:
				btn_tracker.set_sensitive(True)
				btn_resume.set_sensitive(False)
				btn_pause.set_sensitive(True)
		else:
			self.torrentViewwTree.get_widget("remove_torrent").set_sensitive(False)
			btn_tracker.set_sensitive(False)
			btn_resume.set_sensitive(False)
			btn_pause.set_sensitive(False)

		self.torrentViewMenu.popup(None, None, None, event.button, event.time)

	def FileViewMouseButton(self, widget, event):
		if event.button == 3:
			self.ShowFileViewMenu(event)
#			self.fileViewMenu.popup(None, None, None, event.button, event.time)
			return True
		else:
			return False

	def ShowFileViewMenu(self, event):
		(temp, selections) = self.fileView.get_selection().get_selected_rows()

		# Check if selection is among the selected. If not, select it
		x = int(event.x)
		y = int(event.y)
		data = self.fileView.get_path_at_pos(x, y)

		if data is None:
			return

		path, col, cellx, celly = data

		if not path in selections:
			self.fileView.grab_focus()
			self.fileView.set_cursor(path, col, 0)

		self.fileViewMenu.popup(None, None, None, event.button, event.time)

	def internalUpdateFileFiltersFromVisual(self):
		(temp, selection) = self.torrentView.get_selection().get_selected()
		assert(selection is not None)
		uniqueID = self.torrentList.get_value(selection,0)
		selected_torrent = self.handler.get_torrent_from_uniqueID(uniqueID)
		selected_torrent.applyVisualFilterOuts()

	def internalMarkFiles(self, how):
		model = self.fileView.get_model()
		(temp, selections) = self.fileView.get_selection().get_selected_rows()

		for selection in selections:
			the_iter = model.get_iter(selection)
			model.set_value(the_iter, 4, how)

		self.internalUpdateFileFiltersFromVisual()

	def MarkFileDownload(self, args):
		self.internalMarkFiles(True)

	def MarkFileDoNotDownload(self, args):
		self.internalMarkFiles(False)

	def on_dragdata(self, treeview, drag_context, x, y, selection, info, eventtime):
		print "dragdata"
		uri = selection.data.strip()
		print 'uri', uri
		uri_splitted = uri.split()
		for uri in uri_splitted:
			path = self.get_file_path_from_dnd_dropped_uri(uri)
			print 'path to open', path
			if os.path.isfile(path):
				self.open_file_dropped(path)
				
	def open_file_dropped(self, path):
		print 'opening file:', path
		if path.endswith(".torrent"):
			print "it's a torrent, yay"
			self.interactive_open_torrent(torrent_file=path)
		
		
			
	def get_file_path_from_dnd_dropped_uri(self, uri):
		path = urllib.url2pathname(uri) # escape special chars
		path = path.strip('\r\n\x00') # remove \r\n and NULL

		# get the path to file
		if path.startswith('file:\\\\\\'): # windows
			path = path[8:] # 8 is len('file:///')
		elif path.startswith('file://'): # nautilus, rox
			path = path[7:] # 7 is len('file://')
		elif path.startswith('file:'): # xffm
			path = path[5:] # 5 is len('file:')
		return path
		
	def connect_handler(self, h):
		self.handler = h

		# Initialize torrent engine
		dc.debugmsg("")
		dc.debugmsg("INITIALIZING TORRENT ENGINE")
		dc.debugmsg("")
		v1 = dc.V1
		v2 = dc.V2
		v3 = dc.V3
		v4 = dc.V4
		torrent.init("DE",v1,v2,v3,v4,"Deluge " + APP_VERSION)

		# Immediately apply preferences after starting torrent engine
		self.apply_pref()

		# Additional setup issues, in particular DHT, all of which are done right after prefs
		if self.preferences.get("dht") == "1":
			debugmsg("Starting DHT")
			torrent.startDHT(dc.DHTfile)
			self.DHTstarted = True
		else:
			debugmsg("No DHT")
			self.DHTstarted = False

		# Plugins. We do this here, very soon after the torrent engine is started,
		# because things like IP filtering need to work BEFORE we load&start torrents
		self.pluginManager = dpluginmanager.PluginManager(self)

		# Autoload any torrents already existing in the system
		self.AutoLoadTorrents()

		self.UpdateButtons()

		# Sort the main view by queue
		col = self.torrentView.get_column(0)
		col.emit("clicked")

	def toggledSignal(self, cell, path, column):
		model = self.fileView.get_model()

		(temp, selections) = self.fileView.get_selection().get_selected_rows()

#		if len(selections) > 1:
#			# Multiple files are selected, so we pop up the menu to ask what to do
#			event        = gtk.gdk.Event(gtk.gdk.BUTTON_PRESS)
#			event.button = 3
#			event.time   = -1
#
#			print "Emitting"
#			self.fileView.emit("button-press-event", event)
#			#self.ShowFileViewMenu(None, event)
#		else:
		the_iter = model.get_iter(path)
		old_value = model.get_value(the_iter, column)
		model.set_value(the_iter, column, not old_value)

		self.internalUpdateFileFiltersFromVisual()

	def delete_event(self, widget, event, data=None):
		activeTorrents = self.handler.getNumActiveTorrents()

		indeedQuit = False
		if activeTorrents == 0:
			indeedQuit = True
		else:
			asker = gtk.MessageDialog(
									 parent = self.window,
									 flags  = gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
									 buttons= gtk.BUTTONS_YES_NO,
									 message_format=_("Are you sure you want to quit Deluge?"),
									 type   = gtk.MESSAGE_QUESTION)

			text = _("You have ") + str(activeTorrents) + _(" active torrent")
			if activeTorrents > 1:
				text = text + _("s")
			text = text + _(". Pressing 'Yes' will close Deluge and stop all torrent activity.")
			asker.format_secondary_text(text)

			response = asker.run()
			asker.destroy()

			if response == gtk.RESPONSE_YES:
				indeedQuit = True

		if indeedQuit:
			self.handler.stop()
			self.ShutDown() # Send shutdown signals to whatever needs such a signal
			return False
		else:
			return True

	# An orderly shutdown for things that need it, like plugins
	def ShutDown(self):
		self.pluginManager.shutDown()

		if self.DHTstarted:
			torrent.stopDHT(dc.DHTfile)

	def update_all(self, arg=None):
		self.handler.update_all()	
#		try:
#			currTorrent = self.getSelectedTorrent()
#			if currTorrent is not None:
#				currTorrent.updateTracker()
#		except:
#			pass
		

	def SafeDestroy(self, args):
		# Note to self that all is over with
		self.stillAlive = False

		# This must be done here, so we save these values while the Window yet exists
		self.preferences.set('window_width',  self.savedSize[0])
		self.preferences.set('window_height', self.savedSize[1])
		self.preferences.set('window_position_x', self.savedPosition[0])
		self.preferences.set('window_position_y', self.savedPosition[1])

		self.preferences.set('main_pane_pos', self.mainPane.get_position())

		self.handler.stop() # To ensure it is stopped before we destroy any widgets

		self.window.destroy()

		
	def Forum(self, args=None):
		dc.debugmsg("linking to support forums")
		open_url_in_browser("http://ubuntuforums.org/forumdisplay.php?f=172")

	def translate(self, arg=None):
		dc.debugmsg("translating")
		open_url_in_browser("http://launchpad.net/products/deluge/+translations")
		

	def AutoLoadTorrents(self):
		dc.debugmsg("Auto Loading Torrents")
		i = 1;
		while True:
			existingTorrent = self.preferences.get('existing' + str(i))
			dc.debugmsg(str(i) + str(existingTorrent))
			if existingTorrent is None:
				break
			
			if existingTorrent not in os.listdir(CONFIG_DIR + "/torrentfiles"):
				dc.debugmsg("Missing torrent file: " + existingTorrent)
			else:
				existingTorrentSaveDir = self.preferences.get('existing' + str(i) + 'saveDir')
				compact_allocation = self.preferences.get('existing' + str(i) + 'compactAllocation')
				if compact_allocation is None:
					compact_allocation = int(self.preferences.get('compact_allocation')) == 1
				else:
					compact_allocation = int(compact_allocation) == 1

				newTorrent = self.AddTorrent(CONFIG_DIR + "/torrentfiles/" + existingTorrent,
												 existingTorrentSaveDir, compact_allocation)
				if newTorrent is not None:
					if self.preferences.get('existing' + str(i) + 'paused') == "1":
						newTorrent.forcePause()

					filterOutsString = self.preferences.get('existing' + str(i) + 'filterOuts')
					if filterOutsString is not None:
						filterOuts = filterOutsString.split(",")
						boolFilterOuts = []
						for filterOut in filterOuts:
							boolFilterOuts.append(filterOut is "1")
						newTorrent.applyFilterOuts(boolFilterOuts)

					newTorrent.setUploadedMemory(self.preferences.get('existing' + str(i) + 'uploaded'))
#					dc.debugmsg(i + " memory" + self.preferences.get('existing' + str(i) + 'uploaded'))

			i = i + 1

		if i > 1:
			self.addMessage(_("Loaded torrents from previous session"), "I")

	def AutoSaveTorrents(self):
		dc.debugmsg("AutoSaveTorrents")
		# Delete all existing torrent keys
		i = 1;
		while True:
			existingTorrent = self.preferences.get('existing' + str(i))
			if existingTorrent is None:
				break

			self.preferences.delete('existing' + str(i))
			self.preferences.delete('existing' + str(i) + 'saveDir')
			self.preferences.delete('existing' + str(i) + 'paused')
			self.preferences.delete('existing' + str(i) + 'filterOuts')
			self.preferences.delete('existing' + str(i) + 'uploaded')
			self.preferences.delete('existing' + str(i) + 'compactAllocation')

			i = i + 1

		# Create new torrent keys
		my_iter = self.torrentList.get_iter_first()
		while my_iter is not None:
			uniqueID = self.torrentList.get_value(my_iter,0)
			queuePos = self.torrentList.get_value(my_iter,2)
			currTorrent = self.handler.get_torrent_from_uniqueID(uniqueID)
			self.preferences.set('existing' + str(queuePos),  currTorrent.getFileName())
			self.preferences.set('existing' + str(queuePos) + 'saveDir', currTorrent.getSaveDir())
			self.preferences.set('existing' + str(queuePos) + 'compactAllocation', int(currTorrent.useCompactAllocation()))
			if currTorrent.isForcePaused():
				self.preferences.set('existing' + str(queuePos) + 'paused', "1")
			else:
				self.preferences.set('existing' + str(queuePos) + 'paused', "0")
			filterOuts = str(currTorrent.getFilterOuts())
			filterOuts = filterOuts.replace(" ", "")
			filterOuts = filterOuts.replace("[", "")
			filterOuts = filterOuts.replace("]", "")
			filterOuts = filterOuts.replace("False", "0")
			filterOuts = filterOuts.replace("True", "1")
			self.preferences.set('existing' + str(queuePos) + 'filterOuts', filterOuts)

#			dc.debugmsg(queuePos," memory ", currTorrent.getUploadedMemory() + currTorrent.getSessionUpload())

			self.preferences.set('existing' + str(queuePos) + 'uploaded',
										currTorrent.getUploadedMemory() + currTorrent.getSessionUpload())

			my_iter = self.torrentList.iter_next(my_iter)

		self.preferences.save_to_file(CONFIG_XML)

	def getSelectedTorrent(self):
		(temp, selection) = self.torrentView.get_selection().get_selected()
		if selection is not None:
			uniqueID = self.torrentList.get_value(selection,0)
			return self.handler.get_torrent_from_uniqueID(uniqueID)

	def getSelectedTorrents(self):
		(temp, selections) = self.torrentView.get_selection().get_selected()
		torrents = []
		for selection in selections:
			uniqueID = self.torrentList.get_value(selection,0)
			torrents.append(self.handler.get_torrent_from_uniqueID(uniqueID))
		return torrents

	def UpdateTracker(self, args):
		try:
			currTorrent = self.getSelectedTorrent()
			if currTorrent is not None:
				if not currTorrent.isPaused():
					currTorrent.updateTracker()
		except: # Why?
			pass

	def PauseTorrent(self, args):
		currTorrent = self.getSelectedTorrent()
		if currTorrent is not None:
			if currTorrent.isForcePaused():
				currTorrent.forceStart()
			else:
				currTorrent.forcePause()
#				self.queueTorrentToBottom(currTorrent.getUniqueID())

		self.UpdateButtons()

	def internalQueueTorrentUp(self, selection):
		currQueuePos 		= self.torrentList.get_value(selection,2)

		my_iter = self.torrentList.get_iter_first()
		while my_iter is not None:
			queuePos = self.torrentList.get_value(my_iter,2)
			if queuePos == currQueuePos - 1:
				self.torrentList.set_value(my_iter,  2,currQueuePos)
				self.torrentList.set_value(selection,2,queuePos)
				return

			my_iter = self.torrentList.iter_next(my_iter)

	def QueueTorrentUp(self, args):
		(temp,selection) = self.torrentView.get_selection().get_selected()
		if selection is not None:
			self.internalQueueTorrentUp(selection)

	def internalQueueTorrentDown(self, selection):
		currQueuePos 		= self.torrentList.get_value(selection,2)

		my_iter = self.torrentList.get_iter_first()
		while my_iter is not None:
			queuePos = self.torrentList.get_value(my_iter,2)
			if queuePos == currQueuePos + 1:
				self.torrentList.set_value(my_iter,  2,currQueuePos)
				self.torrentList.set_value(selection,2,queuePos)
				return

			my_iter = self.torrentList.iter_next(my_iter)

	def QueueTorrentDown(self, args):
		(temp,selection) = self.torrentView.get_selection().get_selected()
		if selection is not None:
			self.internalQueueTorrentDown(selection)

	def getTorrentIter(self, uniqueID):
		my_iter = self.torrentList.get_iter_first()
		while my_iter is not None:
			currID = self.torrentList.get_value(my_iter,0)
			if currID == uniqueID:
				return my_iter

			my_iter = self.torrentList.iter_next(my_iter)

		return None

	def internalQueueTorrentAllDown(self, uniqueID):
		# This isn't an elegant way to do it, but it does work...
		numTorrents = self.torrentList.iter_n_children(None)

		for i in range(numTorrents):
			the_iter = self.getTorrentIter(uniqueID)
			self.internalQueueTorrentDown(the_iter)

	def QueueTorrentAllDown(self, args):
		(temp,selection) = self.torrentView.get_selection().get_selected()

		if selection is not None:
			uniqueID = self.torrentList.get_value(selection,0)
			self.internalQueueTorrentAllDown(uniqueID)

	def updateTorrentDetails(self, the_iter):
		assert(the_iter is not None)

		uniqueID = self.torrentList.get_value(the_iter, 0)
		selected_torrent = self.handler.get_torrent_from_uniqueID(uniqueID)
		currentPage = self.sidebar.get_current_page()

		if currentPage == 0:
			selected_torrent.updateSummary(self)
		if currentPage == 1:
			selected_torrent.updateFileList(self.fileView)
		if currentPage == 2:
			selected_torrent.updatePeerList(self.peerView)

	# Severities: Fatal, Critical, Warning, Info
	def addMessage(self, text, severity="W"):
		theIter = self.messageList.get_iter_at_line(self.messageList.get_line_count())
		currTime = time.strftime("%H:%M:%S")
		self.messageList.insert(theIter, severity + '-[' + currTime + '] ' + text + '\n')

	def UpdateButtons(self):
		currTorrent = self.getSelectedTorrent()

		if currTorrent is not None:
			self.wTree.get_widget("menu_removetorrent").set_sensitive(True)
			self.wTree.get_widget("toolbutton_remove").set_sensitive(True)
			btn_tracker  = self.wTree.get_widget("toolbutton_update")
			menu_tracker = self.wTree.get_widget("menu_update_tracker")
			btn_pause    = self.wTree.get_widget("toolbutton_pause")
			if currTorrent.isPaused():
				btn_tracker.set_sensitive(False)
				menu_tracker.set_sensitive(False)
				btn_pause.set_stock_id(gtk.STOCK_MEDIA_PLAY)
				if currTorrent.isForcePaused():
					btn_pause.set_sensitive(True)
				else:
					btn_pause.set_sensitive(False)
			else:
				btn_tracker.set_sensitive(True)
				menu_tracker.set_sensitive(True)
				btn_pause.set_stock_id(gtk.STOCK_MEDIA_PAUSE)
				btn_pause.set_sensitive(True)
			self.wTree.get_widget("toolbutton_up").set_sensitive(True)
			self.wTree.get_widget("toolbutton_down").set_sensitive(True)
			self.wTree.get_widget("toolbutton_bottom").set_sensitive(True)
		else:
			self.wTree.get_widget("menu_removetorrent").set_sensitive(False)
			self.wTree.get_widget("toolbutton_remove").set_sensitive(False)
			self.wTree.get_widget("toolbutton_update").set_sensitive(False)
			self.wTree.get_widget("menu_update_tracker").set_sensitive(False)
			self.wTree.get_widget("toolbutton_pause").set_sensitive(False)
			self.wTree.get_widget("toolbutton_up").set_sensitive(False)
			self.wTree.get_widget("toolbutton_down").set_sensitive(False)
			self.wTree.get_widget("toolbutton_bottom").set_sensitive(False)

	def AddTorrent(self, torrent_file, save_dir, compact_allocation):
#		print "Compact: ", compact_allocation
		# Find next location in the queue to add to
		queuePos = 0

		my_iter = self.torrentList.get_iter_first()
		while my_iter is not None:
			queuePos = max(queuePos, int(self.torrentList.get_value(my_iter,2)))
			my_iter = self.torrentList.iter_next(my_iter)

		queuePos = queuePos + 1
		dc.debugmsg("Queuing at " + str(queuePos))

		newTorrent = self.handler.add_torrent(queuePos, torrent_file, save_dir, compact_allocation)
		if newTorrent is not None:
			self.UpdateButtons()

			# Select a torrent, if none is selected
			(temp, selection) = self.torrentView.get_selection().get_selected()
			if selection is None:
				self.torrentView.get_selection().select_path("0")

		return newTorrent

	def RemoveTorrentToggleWarning(self, args, warning):
		if not args.get_active():
#			warning.hide()
			warning.set_text(" ")
		else:
#			warning.show()
			warning.set_markup("<i>" + _("Warning - all downloaded files for this torrent will be deleted!") + "</i>")
		return False

	def RemoveTorrent(self, args):
		(temp, selection) = self.torrentView.get_selection().get_selected()

		if selection is not None:
			gladefile = dc.get_glade("removetorrent.glade")
			wTree     = gtk.glade.XML(gladefile, "RemoveTorrentDialog")
			asker     = wTree.get_widget("RemoveTorrentDialog")

			warning   =  wTree.get_widget("warning")
#			warning.hide()
			warning.set_text(" ")

			dataAlso  =  wTree.get_widget("data_also")
			dataAlso.connect("toggled", self.RemoveTorrentToggleWarning, warning)

			response = asker.run()
			asker.destroy()

			if response != 1:
				return

			# Ok, we are removing

			uniqueID 	= self.torrentList.get_value(selection,0)
			theTorrent  = self.handler.get_torrent_from_uniqueID(uniqueID)

			oldQueuePos = self.torrentList.get_value(selection,2)

			self.torrentList.remove(selection)
			fileName = theTorrent.getFileName()
			os.remove(CONFIG_DIR + "/torrentfiles/" + fileName)

			self.handler.remove_torrent(uniqueID)

			# Delete file data, if we need to. Must be done AFTER the torrent is removed
			if dataAlso.get_active() == True:
				# Delete all downloaded data. Can this be to the trash?
				saveDir = theTorrent.getSaveDir()
				filenames = theTorrent.getFileNames()
				for filename in filenames:
					try:
						os.remove(saveDir + "/" + filename)
					except OSError:
						pass # No file just means it wasn't downloaded, we can continue

			try:
				# Must be after removal of the torrent, because that saves a new .fastresume
				os.remove(CONFIG_DIR + "/torrentfiles/" + fileName + ".fastresume")
			except OSError:
				dc.debugmsg("No .fastresume file to delete")

			self.UpdateButtons()

			# Clear torrent's data from the bottom pane
			self.text_summary_title.set_text("")
			self.text_summary_total_size.set_text("")
			self.text_summary_pieces.set_text("")
			self.text_summary_total_downloaded.set_text("")
			self.text_summary_total_uploaded.set_text("")
			self.text_summary_percentage_done.set_text("")
			self.text_summary_share_ratio.set_text("")
			self.text_summary_downloaded_this_session.set_text("")
			self.text_summary_uplodaded_this_session.set_text("")
			self.text_summary_tracker.set_text("")
			self.text_summary_tracker_response.set_text("")
			self.text_summary_tacker_status.set_text("")
			self.text_summary_next_announce.set_text("")
			self.text_summary_compact_allocation.set_text("")

			self.fileView.set_model(None)
			self.peerView.set_model(None)

			# Update queue positions for other torrents
			my_iter = self.torrentList.get_iter_first()
			while my_iter is not None:
				queuePos = self.torrentList.get_value(my_iter,2)
				if queuePos > oldQueuePos:
					self.torrentList.set_value(my_iter,2,queuePos-1)
				
				my_iter = self.torrentList.iter_next(my_iter)
		else:
			dc.ShowPopupWarning(self.window, _("No torrent is selected"))
				
##	def safe_remove_torrent(self, uniqueID):
##		qpos = self.handler.get_torrent_from_uniqueID(uniqueID)

	def ClearFinished(self, args):
		dc.debugmsg("clearing finished")
		self.handler.clear_completed()

	def ShowHideSidebar(self, args):
		if self.sidebar.get_property("visible"):
			self.sidebar.hide()
			self.preferences.set("sbvis", 0)
		else:
			self.sidebar.show()
			self.preferences.set("sbvis", 1)

	def ShowHideWindow(self):
		if self.window.get_property("visible"):
			self.window.hide()
		else:
			self.window.show()

	def TrayClicked(self, widget, event):
		if event.button == 1:
			self.ShowHideWindow()
		elif event.button == 3:
			self.popup.popup(None, None, None, event.button, event.time)

	def ShowPrefDialog(self, args):
		if (self.preferences.show_dlg() == 1):
			self.apply_pref()

	def ManagePluginsDialog(self, args):
		self.pluginManager.Dialog()

	def About(self, args):
		dabout.AboutDialog().run()
			
	def Quit(self, args):
		self.AutoSaveTorrents()
		dc.debugmsg("Shutting down GUI...")
		## The window is already destroyed; destroy the tray icon now also
		##self.tray.destroy()
		self.systray.destroy()
		gtk.main_quit()

	def MenuQuit(self, args):
		if not self.window.emit("delete_event", gtk.gdk.Event(gtk.gdk.NOTHING)):
			self.window.destroy()

	def UpdateSessionInfo(self):
		self.sessionInfo = torrent.getSessionInfo()

	def PrepareStatusBar(self):
		connections = str(self.sessionInfo['numPeers'])
		dlrate = getDataRate(self.sessionInfo['downloadRate'])
		ulrate = getDataRate(self.sessionInfo['uploadRate'])

		self.statusBarTempMessage = _("Connections:") + " " + connections	+ dc.STATUSBAR_DIVIDER + _("Download:") + " " + dlrate + dc.STATUSBAR_DIVIDER + _("Upload:") + " " + ulrate

		self.systray.update_tooltip(connections, dlrate, ulrate)

		if self.DHTstarted:
			numDHTpeers = torrent.getDHTinfo()
			if numDHTpeers == -1:
				numDHTpeers = "?"
			else:
				numDHTpeers = str(numDHTpeers)

			self.statusBarTempMessage = self.statusBarTempMessage + "  [DHT: " + numDHTpeers + "]"

	def UpdateStatusBar(self):
		if self.stillAlive:
			self.statusbar.pop(1)
			self.statusbar.push(1, self.statusBarTempMessage)

	def add_torrent_from_url(self, args=""):
		print "opening torrent from URL"
		dialog_buttons = (gtk.STOCK_CANCEL
				, 0
				, gtk.STOCK_OK
				, 1)
		dlg = gtk.Dialog(title="Open torrent from URL", parent=None, buttons=dialog_buttons)
		dlg.set_icon_from_file(dc.get_icon("deluge-32.png"))
		
		label = gtk.Label(_("Enter the URL of the .torrent file to open:"))
		entry = gtk.Entry()
		
		dlg.vbox.pack_start(label)
		dlg.vbox.pack_start(entry)
		
		dlg.show_all()
		r = dlg.run()
		
		url = entry.get_text()
		
		dlg.hide()
		
		dlg.destroy()
		
		if r == 1:
			opener = urllib.URLopener()
			print 'ok clicked:', url
			filename, headers = opener.retrieve(url)
			print 'filename:', filename
			if filename.endswith(".torrent") or headers["content-type"]=="application/x-bittorrent":
				print "file is a torrent"
				self.interactive_open_torrent(torrent_file=filename)
		
	def open_torrent(self, torrent_file=""):
		pass

	def interactive_open_torrent(self, args="", torrent_file=None):
		if torrent_file is None:
			torrent_file = dc.file_browse(gtk.FILE_CHOOSER_ACTION_OPEN)
		dc.debugmsg("Torrent file:"+torrent_file)
		if torrent_file == "" or torrent_file is None:
			return

		if (self.preferences.get_global_save()):
			dc.debugmsg("Using global save dir")
			save_dir = self.preferences.get_global_loc()
		else:
			dc.debugmsg("Asking for save dir")
			save_dir = dc.directory_browse("Pick Save Directory")
		dc.debugmsg("Save Directory: " + save_dir)
		if save_dir == "":
			return

		# Cache torrent file, if not already there
		(temp, torrent_file_short) = os.path.split(torrent_file)

		time.sleep(0.01) # Ensure we use a unique time for the new filename
		newName     = str(time.time()) + ".torrent"
		fullNewName = CONFIG_DIR + "/torrentfiles/" + newName

		if newName in os.listdir(CONFIG_DIR + "/torrentfiles"):
			dc.debugmsg("Internal error: could not create the torrent file name: " + newName)
			self.addMessage("Could not cache torrent file locally, failed to create: " + newName, "C")
		else:
			shutil.copy(torrent_file, fullNewName)
			# Use default compact allocation or not, for now
			compact_allocation = (int(self.preferences.get("compact_allocation")) == 1)

			self.AddTorrent(fullNewName, save_dir, compact_allocation)
			self.AutoSaveTorrents()

	def select_save_location(self, args=""):
		save_file = self.file_browse(gtk.FILE_CHOOSER_ACTION_SAVE)
		
	def apply_pref(self):
		dc.debugmsg("Now applying settings")
		if (self.preferences.get_max_dl_rate() != 0):
			torrent.setDownloadRateLimit(self.preferences.get_max_dl_rate() * 1024)
			dc.debugmsg("Limiting DL to" + str(self.preferences.get_max_dl_rate()) + "KB/s")
		else:
			torrent.setDownloadRateLimit(-1)
			dc.debugmsg("Unlimited DL")
		if (self.preferences.get_max_ul_rate() != 0):
			torrent.setUploadRateLimit(self.preferences.get_max_ul_rate() * 1024)
			dc.debugmsg("Limiting UL to"+ str(self.preferences.get_max_ul_rate())+ "KB/s")
		else:
			torrent.setUploadRateLimit(-1)
			dc.debugmsg("Unlimited UL")
		torrent.setListenOn(self.preferences.get_tcp_port_min(),
			 self.preferences.get_tcp_port_max())
		dc.debugmsg("port range"+str(self.preferences.get_tcp_port_min())+"-"+str(self.preferences.get_tcp_port_max()))
		dc.debugmsg(self.preferences.get("sbvis"))
		try:
			if (int(self.preferences.get("sbvis")) == 0):
				self.sidebar.hide()
		except:
			dc.debugmsg("Error: sbvis does not exist")
			self.preferences.set("sbvis", 1)
		if (self.preferences.get_stop_seeding()):
			self.handler.setAutoSeedRatio(self.preferences.get_seed_cap_ratio())
			dc.debugmsg("setting autoseed ratio to"+ str(self.preferences.get_seed_cap_ratio()))
		else:
			self.handler.setAutoSeedRatio(-1)
			dc.debugmsg("disabling autoseeding")

		maxcon = int(self.preferences.get("max_connections"))
		torrent.setMaxConnections(maxcon)
		dc.debugmsg("set max connections to " + str(maxcon))

	def finalInitialization(self):
		#Fix main vpaned into right position. Must be done here, after the panes are filled
		oldPanePos = self.preferences.get('main_pane_pos')
		if oldPanePos is not None:
			self.mainPane.set_position(int(oldPanePos))

		self.finalInitDone = True

if __name__ == "__main__":
	##bus = dbus.SessionBus()
	##proxy_obj = bus.get_object('org.freedesktop.DBus', '/org/freedesktop/DBus')
	##dbus_iface = dbus.Interface(proxy_obj, 'org.freedesktop.DBus')

	##namelist = dbus_iface.ListNames()
		
	##if "org.freedesktop.Deluge" in namelist:
	##	print "Deluge already running, sending torrents then leaving"
	##	obj = bus.get_object('org.freedesktop.Deluge', '/org/freedesktop/DelugeObject')
	##	iface = dbus.Interface(obj, 'org.freedesktop.DelugeIFace')
	##	print "made stuff"
	##	for x in sys.argv:
	##		iface.add_torrent(x)
	##	sys.exit(0)	
		
	##No Deluge instance exists
	# Localize Python
	import locale ## Here, because we really shouldn't be using it, see later
	locality = locale.getlocale()[0]
#	locality = 'fr' ### For testing purposes
	if (locality == None): # For some reason some users seem to lack a locale...
		locality = "en_US"  # So we assume they are from the US, for lack of a better idea
#	print "Locality: ", locality
	gettextName = 'deluge'
	localeDir = APP_PATH + '/po'
	dc.debugmsg("localeDir: " + localeDir)
	gettext.bindtextdomain(gettextName, localeDir)
	gettext.textdomain(gettextName)
#	gettext.install(gettextName, localeDir, unicode = 1) # This is how it should be, methinks
	lang2 = gettext.translation(gettextName,
							 localedir=localeDir,
							 languages=[locality],
							 fallback=True)
	lang2.install()
		# Localize Glade
	gtk.glade.bindtextdomain(gettextName, localeDir)
	gtk.glade.textdomain(gettextName)
		# Main
	dc.debugmsg(APP_PATH)
	os.chdir(HOME_DIR)

	# Deluge object
	g = Deluge()
	h = TorrentHandler(g)
	g.connect_handler(h)
	##for x in sys.argv:
	##	if x.endswith(".torrent"):
	##		g.interactive_open_torrent(x)

	h.startUpdateTick() # Only after torrents are all loaded nicely

	## Register with dbus
	##session_bus = dbus.SessionBus()
	##bus_name = dbus.service.BusName('org.freedesktop.Deluge', bus=session_bus)
	##dbus_object = delugedbus.DelugeObject(bus_name=bus_name, deluge_interface=g)
	
	##
	gtk.gdk.threads_init()
	gtk.main()
	h.stop() # Stop updating stuff
	dc.debugmsg("Shutting down torrent engine (may take time to notify trackers we are leaving)...")
	torrent.quit()
