#!/usr/bin/python
#
# deluge.py
# Copyright (C) Zach Tibbitts 2006 <zach@collegegeek.org>
# Copyright (C) Alon Zakai    2006 <kripkensteiner@gmail.com>
# 
# Deluge is free software.
# 
# You may redistribute this file and/or modify it under the terms of the
# GNU General Public License, as published by the Free Software
# Foundation; either version 2 of the License, or (at your option)
# any later version.
# 
# This file is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this file.  If not, write to:
# 	The Free Software Foundation, Inc.,
# 	51 Franklin Street, Fifth Floor
# 	Boston, MA  02110-1301, USA.

# dpluginmanager.py

import delugecommon
dc = delugecommon

try:
 	import pygtk
  	pygtk.require("2.0")
except:
  	pass
try:
	import gtk
  	import gtk.glade
except:
	sys.exit(1)

import os, string

class PluginManager:
	def __init__(self, mainInstance):
		self.parent = mainInstance
		self.registeredPlugins = {}
		self.plugins = {}

		# Register Plugins
		self.scanDir(dc.APP_PATH + '/plugins')

		if not "localplugins" in os.listdir(dc.CONFIG_DIR):
			os.mkdir(dc.CONFIG_DIR + "/localplugins")

		self.scanDir(dc.CONFIG_DIR + "/localplugins")

		# Init list

		self.pluginsList = gtk.ListStore(str, bool)

		for key in self.registeredPlugins.keys():
			active = self.parent.preferences.get('plugin_active ' + key)
			if active is None:
				active = self.registeredPlugins[key][3]
			else:
				active = (active == "1")

			self.pluginsList.append((key, active))

			if active:
				self.plugins[key] = self.registeredPlugins[key][0](self.parent,
																					self.registeredPlugins[key][2])
			else:
				self.plugins[key] = None

	def scanDir(self, path):
		PLUGINregister = self.registerPlugin
		self.tempPluginLocation = path

		dc.debugmsg("Scanning for plugins in " + path)
		for plugin in os.listdir(path):
			if string.lower(plugin[-3:]) == ".py":
				dc.debugmsg("Importing Plugin '" + plugin + "'")
				execfile(path + "/" + plugin)
				dc.debugmsg("Finished Importing Plugin '" + plugin + "'")

	def registerPlugin(self, pluginName, pluginClass, hasPreferences, activatedByDefault, comment=""):
		dc.debugmsg("Registering: " + str(pluginName) + " " + str(pluginClass))
		self.registeredPlugins[pluginName] = \
				(pluginClass,
				 hasPreferences,
				 self.tempPluginLocation,
				 activatedByDefault,
				 comment)

	def Dialog(self):
		theDialog = self.PluginManagerDialog(self)
		theDialog.run()

	class PluginManagerDialog:
		def toggledSignal(self, cell, path, column):
			model = self.pluginsView.get_model()
			the_iter = model.get_iter(path)
			key = model.get_value(the_iter, 0)
			old_value = model.get_value(the_iter, column)

			# Toggle list value
			model.set_value(	the_iter,
									column,
									not old_value	)

		def select_function(self, info):
			the_iter = self.parent.pluginsList.get_iter(info[0])
			plugin = self.parent.pluginsList.get_value(the_iter, 0)
			if self.parent.registeredPlugins[plugin][1]:
				self.wTree.get_widget("pref_button").set_sensitive(True)
			else:
				self.wTree.get_widget("pref_button").set_sensitive(False)

			return True

		def __init__(self, parent):
			self.parent = parent

			dc.debugmsg("Showing Plugin Dialog")
			self.gladefile = dc.get_glade("pluginmanager.glade")
			self.wTree = gtk.glade.XML(self.gladefile, "PluginManagerDialog")
			self.dlg = self.wTree.get_widget("PluginManagerDialog")

			self.pluginsView = self.wTree.get_widget("pluginsView")

			dc.AddTextColumn(self.pluginsView, "Plugin", 0, -1, False)
			dc.AddToggleColumn(self.pluginsView, "Active", 1, self.toggledSignal)

			self.pluginsView.set_model(self.parent.pluginsList)

			col = self.pluginsView.get_column(0)
			col.emit("clicked") # Sort by name

			# Prepare to show preferences button correctly (sensitive or not)
			self.wTree.get_widget("pref_button").set_sensitive(False)
			self.pluginsView.get_selection().set_select_function(self.select_function)
			self.pluginsView.get_selection().select_path("0")

		def run(self):
			self.dlg.show_all()

			while True:
				response = self.dlg.run()
				if response == 865:
					(temp, selection) = self.pluginsView.get_selection().get_selected()
					if selection is None:
						dc.ShowPopupWarning(self.parent.parent.window,
												  _("No plugin is selected"))
					else:
						if not self.parent.pluginsList.get_value(selection,1):
							dc.ShowPopupWarning(self.parent.parent.window,
													  _("You must activate a plugin before configuring it"))
						else:
							plugin = self.parent.pluginsList.get_value(selection,0)
							self.parent.plugins[plugin].configure()
				elif response == 111:
					(temp, selection) = self.pluginsView.get_selection().get_selected()
					if selection is None:
						dc.ShowPopupWarning(self.parent.parent.window,
												  _("No plugin is selected"))
					else:
						plugin = self.parent.pluginsList.get_value(selection,0)
						comment = self.parent.registeredPlugins[plugin][4]
						if comment == "":
							comment = "[" + _("no information is listed for this plugin") + "]"
						dc.ShowPopupInfo(self.parent.parent.window, comment)
				else:
					break

			# Save list of active plugins

			my_iter = self.parent.pluginsList.get_iter_first()
			while my_iter is not None:
				key    = self.parent.pluginsList.get_value(my_iter,0)
				active = int(self.parent.pluginsList.get_value(my_iter,1))
				self.parent.parent.preferences.set('plugin_active ' + key, active)

				my_iter = self.parent.pluginsList.iter_next(my_iter)

			self.parent.parent.preferences.save_to_file(dc.CONFIG_XML)

			# Finish up

			col = self.pluginsView.get_column(0)
			col.emit("clicked") # Sort by name

			self.dlg.destroy()

	def update(self):
		my_iter = self.pluginsList.get_iter_first()
		while my_iter is not None:
			key    = self.pluginsList.get_value(my_iter,0)
			active = int(self.pluginsList.get_value(my_iter,1))
			if active:
				if self.plugins[key] is None:
					self.plugins[key] = self.registeredPlugins[key][0](self.parent,
																						self.registeredPlugins[key][2])
				else:
					self.plugins[key].update()
			else:
				if not self.plugins[key] is None:
					self.plugins[key].shutdown()
					self.plugins[key] = None

			my_iter = self.pluginsList.iter_next(my_iter)

	def shutDown(self):
#		print "Plugin Manager shutting down"
		my_iter = self.pluginsList.get_iter_first()
		while my_iter is not None:
			key    = self.pluginsList.get_value(my_iter,0)
			active = int(self.pluginsList.get_value(my_iter,1))
			if active and self.plugins[key] is not None:
				self.plugins[key].shutdown()

			my_iter = self.pluginsList.iter_next(my_iter)
