#!/usr/bin/python
#
# deluge.py
# Copyright (C) Zach Tibbitts 2006 <zach@collegegeek.org>
# Copyright (C) Alon Zakai    2006 <kripkensteiner@gmail.com>
# 
# Deluge is free software.
# 
# You may redistribute this file and/or modify it under the terms of the
# GNU General Public License, as published by the Free Software
# Foundation; either version 2 of the License, or (at your option)
# any later version.
# 
# This file is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this file.  If not, write to:
# 	The Free Software Foundation, Inc.,
# 	51 Franklin Street, Fifth Floor
# 	Boston, MA  02110-1301, USA.

class plugin_Example:

	# __init is called when the plugin is actually activated, i.e. checked in
	# the plugin manager dialog, which may occur on startup if the plugin was
	# previously activated. Registration of a plugin does NOT call __init__;
	# see below
	def __init__(self, parent, location):
		print "Example Plugin being activated now"

		# Using this, you can access the Deluge client
		self.parent = parent

		# The directory where the plugin resides. Other files
		# belonging to the plugin should be there as well (glade,
		# icons, etc. etc.)
		self.location = location 

		# We must import and then save all imported modules locally,
		# because of the plugin architecture
		try:
			import time
			self.time = time
		except:
			# Note that we have dc as shorthand for 'delugecommon', by default; no need
			# to import it (we also have all other modules loaded by the PluginManager
			# class, but it is NOT a good idea to rely on them)
			dc.ShowPopupWarning(self. parent.window, "Example Plugin: cannot import module 'time'")

	# Shutdown is called when the plugin is deactivated, i.e. unchecked from the
	# plugin manager dialog, or when Deluge is closed
	def shutdown(self):
		print "Example Plugin being shut down now"

	# Update is called one per 'tick' (usually once per second,
	# this tick timescale value is stored in dc.UPDATE_INTERVAL in
	# milliseconds)
	def update(self):
		print "Example Plugin Updating..."

	# Called when the user asks to configure the plugin. This should show a
	# configuration dialog window, etc. You only need to define this for
	# configurable plugins, of course (see below)
	def configure(self):
		pass


# Register plugin with Deluge. Registration only adds the plugin to the list
# of plugins that appear in the plugin manager window. It does NOT activate
# the plugin. However, if a plugin is set to be activated (i.e. the user's
# preference was to activate it, last time Deluge was run), then the
# plugin will indeed be activated by the plugin manager (some time after
# registration).

PLUGINregister("An Example Plugin", # Name to appear on plugin in plugin manager
               plugin_Example,		# The plugin class defined before
               False, # whether this plugin has a 'configuration' option, i.e.
                      # whether the 'configure' button can be pressed in the
                      # plugin manager
               False, # whether this plugin should be activated by default, for
                      # users with no preference for this plugin as of yet. This
                      # is only of effect the FIRST time a user loads a plugin,
                      # afterwards the user's preferences are the default. Thus,
                      # this is of use in the scenario where you roll out a new
                      # plugin, and want users to have it activated automatically
               "An example plugin\n\nThat doesn't do anything") # Comment shown when
                                                                # 'about' is clicked
