#!/usr/bin/python
#
# deluge.py
# Copyright (C) Zach Tibbitts 2006 <zach@collegegeek.org>
# Copyright (C) Alon Zakai    2006 <kripkensteiner@gmail.com>
# 
# Deluge is free software.
# 
# You may redistribute this file and/or modify it under the terms of the
# GNU General Public License, as published by the Free Software
# Foundation; either version 2 of the License, or (at your option)
# any later version.
# 
# This file is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this file.  If not, write to:
# 	The Free Software Foundation, Inc.,
# 	51 Franklin Street, Fifth Floor
# 	Boston, MA  02110-1301, USA.

class plugin_NetworkHealth:
	def __init__(self, parent, location):
		self.parent = parent # Using this, you can access the Deluge client
		self.location = location

		self.counter = (30*1000)/dc.UPDATE_INTERVAL
		self.maxCount = self.counter
	def shutdown(self):
		pass
	def update(self):
		if not self.parent.sessionInfo['hasIncomingConnections'] and \
				 self.parent.sessionInfo['numPeers'] > 1:
			message = "[" + _("No incoming connections") + "]"
			self.counter = self.counter - 1
			if self.counter < 0:
				self.parent.addMessage(_("No incoming connections: you may be behind a firewall or router. Perhaps you need to forward the relevant ports."), "W")
				self.counter  = self.maxCount*2
				self.maxCount = self.counter
		else:
			message = "[" + _("Health: OK") + "]"
			self.counter = self.maxCount

		self.parent.statusBarTempMessage = self.parent.statusBarTempMessage + dc.STATUSBAR_DIVIDER + message

### Register plugin with Deluge
PLUGINregister("Network Health Monitor", plugin_NetworkHealth, False, True,
					"Network Health Monitor plugin v0.1\n\nWritten by Kripkenstein")
